#include <assert.h>
#include <semaphore.h>
#include <sys/prctl.h>

typedef struct {
        sem_t   *m_sp;
        int     m_flags;        
        int     m_lock;         
	char	buf[128];
} mutex_t;

mutex_t	a, b;

#define	N	50000

int
main(int ac, char **av)
{
	int	i;
	void	lockstep(), floating();

	mutex_lock(&a);
	mutex_lock(&b);
	start(0);
	for (i = 0; i < N; ++i) {
		mutex_unlock(&a);
		mutex_lock(&a);
	}
	stop(0,0);
	micro("uncontested mutex", N);
	if (sproc(floating, PR_NOLIBC|PR_SALL, 0) == -1) {
		perror("sproc");
	}
	start(0);
	for (i = 0; i < N; ++i) {
		mutex_unlock(&a);
		mutex_lock(&b);
	}
	stop(0,0);
	micro("floating mutex", N);
	if (sproc(lockstep, PR_NOLIBC|PR_SALL, 0) == -1) {
		perror("sproc");
	}
	start(0);
	for (i = 0; i < N; ++i) {
		mutex_unlock(&a);
		mutex_lock(&b);
	}
	stop(0,0);
	micro("lockstep mutex", N);
}

void
lockstep()
{
	int	i;

	for (i = 0; i < N; ++i) {
		mutex_lock(&a);
		mutex_unlock(&b);
	}
	exit(0);
}

void
floating()
{
	int	i;

	for (i = 0; i < N; ++i) {
		mutex_unlock(&b);
		mutex_lock(&a);
	}
	exit(0);
}
