#include <assert.h>
#include <err.h>
#include "../src/Rthreads.h"
#include <stdio.h>
#include <stdlib.h>

void *threadfunc(void *arg);

xmutex_rec mutex = XMUTEX_INITIALIZER;
int x;

int
main(int argc, char *argv[])
{
	int count, count2, ret;
	pthread_t new;
	void *joinval;

	printf("1: Mutex-test relies on pthreads or pthread.h header file for pth\n");

	x = 0;
	count = count2 = 10000000;
	ret = xmutex_lock(&mutex);
	if (ret != 0)
		err(1, "xmutex_lock (1)");
	ret = pthread_create(&new, NULL, threadfunc, &count2);
	if (ret != 0)
		err(1, "pthread_create");

	printf("1: Thread %p\n", pthread_self());
	ret = xmutex_unlock(&mutex);
	if (ret != 0)
		err(1, "xmutex_unlock(1)");


	while (count--) {
		ret = xmutex_lock(&mutex);
		if (ret != 0)
			err(1, "xmutex_lock(2)");
		x++;
		ret = xmutex_unlock(&mutex);
		if (ret != 0)
			err(1, "xmutex_unlock(2)");
	}

	ret = pthread_join(new, &joinval);
	if (ret != 0)
		err(1, "pthread_join");

	xmutex_lock(&mutex);
	printf("1: Thread joined. X was %d. Return value (long) was %ld\n", 
	    x, (long)joinval);
	assert(x == 20000000);
	return 0;
}

void *
threadfunc(void *arg)
{
	long count = *(int *)arg;
	int ret;

	printf("2: Second thread (%p). Count is %ld\n", pthread_self(), count);

	while (count--) {
		ret = xmutex_lock(&mutex);
		if (ret != 0)
			err(1, "xmutex_lock(3)");
		x++;
		ret = xmutex_unlock(&mutex);
		if (ret != 0)
			err(1, "xmutex_unlock(3)");
	}

	return (void *)count;
}
