#include <stdlib.h>
#include <assert.h>
#include <errno.h>
#include <config.h>
#include <string.h>
#if !HAVE_THREADSAFE_GETENV
#ifdef MULTITHREAD
#include "./Rthreads.h"
#endif

#ifdef XMUTEX_INITIALIZER
static xmutex_rec envlock = XMUTEX_INITIALIZER;
#endif
#endif


/*
     The getenv_r() function searches the environment list for a
     string of the form "name=value", and returns the string
     containing the value for the specified name in the buffer pointed
     to by getenvbuf, with length buflen.
*/
int getenv_r(const char *name, char *getenvbuf, size_t buflen)
{
    char* envList;
    int retVal = 0;
#if !HAVE_THREADSAFE_GETENV
#ifdef XMUTEX_INITIALIZER
    xmutex_lock(&envlock);
#endif
#endif
    envList = getenv(name);
    /*
     The getenv() function searches the environment list for a string
     of the form "name=value", and returns a pointer to a string
     containing the value for the specified name. If the specified
     name cannot be found, a null pointer is returned.
    */
    if (envList == NULL)
    {
        /* The string name was not found in the environment. */
        retVal = ENOENT;
    }
    else
    {
        /* Copy envList into caller provided buffer */
        if (strlen(envList) > buflen - 1)
        {
            /*
             Insufficient storage was supplied via getenvbuf and buflen to 
             contain the value for the specified name.
            */ 
            retVal = ERANGE;
        }
        else
        {
            strcpy(getenvbuf, envList);
        }
    }
#if !HAVE_THREADSAFE_GETENV
#ifdef XMUTEX_INITIALIZER
    xmutex_unlock(&envlock);
#endif
#endif
    return (retVal);
}
