/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.LZ4CompressionCodec$;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.SnappyCompressionCodec$;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.xerial.snappy.SnappyError;
import org.xerial.snappy.SnappyOutputStream;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001\u000f\t1R*Z:tC\u001e,7i\\7qe\u0016\u001c8/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u00059Q.Z:tC\u001e,'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001\"\u0002\u000b\u0001\t\u0003)\u0012\u0001\b;fgR\u001c\u0016.\u001c9mK\u000e{W\u000e\u001d:fgN$UmY8naJ,7o\u001d\u000b\u0002-A\u0011\u0011bF\u0005\u00031)\u0011A!\u00168ji\"\u00121C\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\tQA[;oSRT\u0011aH\u0001\u0004_J<\u0017BA\u0011\u001d\u0005\u0011!Vm\u001d;\t\u000b\r\u0002A\u0011A\u000b\u0002!Q,7\u000f^\"p[B\u0014Xm]:TSj,\u0007F\u0001\u0012\u001b\u0011\u0015!\u0002\u0001\"\u0001')\t1r\u0005C\u0003)K\u0001\u0007\u0011&\u0001\td_6\u0004(/Z:tS>t7i\u001c3fGB\u0011!CK\u0005\u0003W\t\u0011\u0001cQ8naJ,7o]5p]\u000e{G-Z2\t\u000b\r\u0002A\u0011A\u0017\u0015\tYqs\u0006\u0011\u0005\u0006Q1\u0002\r!\u000b\u0005\u0006a1\u0002\r!M\u0001\t[\u0016\u001c8/Y4fgB\u0019!GO\u001f\u000f\u0005MBdB\u0001\u001b8\u001b\u0005)$B\u0001\u001c\u0007\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002:\u0015\u00059\u0001/Y2lC\u001e,\u0017BA\u001e=\u0005\u0011a\u0015n\u001d;\u000b\u0005eR\u0001C\u0001\n?\u0013\ty$AA\u0004NKN\u001c\u0018mZ3\t\u000b\u0005c\u0003\u0019\u0001\"\u0002\u0019\u0015D\b/Z2uK\u0012\u001c\u0016N_3\u0011\u0005%\u0019\u0015B\u0001#\u000b\u0005\rIe\u000e\u001e\u0005\u0006\r\u0002!\taR\u0001\u0012SN\u001cf.\u00199qs\u00063\u0018-\u001b7bE2,W#\u0001%\u0011\u0005%I\u0015B\u0001&\u000b\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u0014\u0001\u0005\u0002\u001d\u000ba\"[:M5R\ne/Y5mC\ndW\r")
public class MessageCompressionTest {
    @Test
    public void testSimpleCompressDecompress() {
        ArrayBuffer codecs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CompressionCodec[]{GZIPCompressionCodec$.MODULE$}));
        Object object = this.isSnappyAvailable() ? codecs.$plus$eq((Object)SnappyCompressionCodec$.MODULE$) : BoxedUnit.UNIT;
        Object object2 = this.isLZ4Available() ? codecs.$plus$eq((Object)LZ4CompressionCodec$.MODULE$) : BoxedUnit.UNIT;
        codecs.foreach((Function1 & Serializable & scala.Serializable)codec -> {
            this.testSimpleCompressDecompress(codec);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCompressSize() {
        block1: {
            byte[] bytes1k = (byte[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToByte((byte)MessageCompressionTest.$anonfun$testCompressSize$1(BoxesRunTime.unboxToInt((Object)x$1))), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte());
            byte[] bytes2k = (byte[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1000), 2000).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToByte((byte)MessageCompressionTest.$anonfun$testCompressSize$2(BoxesRunTime.unboxToInt((Object)x$2))), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte());
            byte[] bytes3k = (byte[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3000), 4000).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToByte((byte)MessageCompressionTest.$anonfun$testCompressSize$3(BoxesRunTime.unboxToInt((Object)x$3))), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte());
            List messages = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(bytes1k, Message$.MODULE$.NoTimestamp(), Message$.MODULE$.MagicValue_V1()), new Message(bytes2k, Message$.MODULE$.NoTimestamp(), Message$.MODULE$.MagicValue_V1()), new Message(bytes3k, Message$.MODULE$.NoTimestamp(), Message$.MODULE$.MagicValue_V1())}));
            this.testCompressSize((CompressionCodec)GZIPCompressionCodec$.MODULE$, (List<Message>)messages, 396);
            if (this.isSnappyAvailable()) {
                this.testCompressSize((CompressionCodec)SnappyCompressionCodec$.MODULE$, (List<Message>)messages, 503);
            }
            if (!this.isLZ4Available()) break block1;
            this.testCompressSize((CompressionCodec)LZ4CompressionCodec$.MODULE$, (List<Message>)messages, 387);
        }
    }

    public void testSimpleCompressDecompress(CompressionCodec compressionCodec) {
        List messages = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hi there".getBytes()), new Message("I am fine".getBytes()), new Message("I am not so well today".getBytes())}));
        ByteBufferMessageSet messageSet = new ByteBufferMessageSet(compressionCodec, (Seq)messages);
        Assert.assertEquals((Object)compressionCodec, (Object)((MessageAndOffset)messageSet.shallowIterator().next()).message().compressionCodec());
        List decompressed = messageSet.iterator().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.message()).toList();
        Assert.assertEquals((Object)messages, (Object)decompressed);
    }

    public void testCompressSize(CompressionCodec compressionCodec, List<Message> messages, int expectedSize) {
        ByteBufferMessageSet messageSet = new ByteBufferMessageSet(compressionCodec, messages);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " size has changed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compressionCodec})), (long)expectedSize, (long)messageSet.sizeInBytes());
    }

    public boolean isSnappyAvailable() {
        boolean bl;
        try {
            new SnappyOutputStream((OutputStream)new ByteArrayOutputStream());
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl2 = throwable2 instanceof UnsatisfiedLinkError ? true : throwable2 instanceof SnappyError;
            if (!bl2) {
                throw throwable;
            }
            boolean bl3 = false;
            bl = bl3;
        }
        return bl;
    }

    public boolean isLZ4Available() {
        boolean bl;
        try {
            new LZ4BlockOutputStream((OutputStream)new ByteArrayOutputStream());
            bl = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ byte $anonfun$testCompressSize$1(int x$1) {
        return (byte)x$1;
    }

    public static final /* synthetic */ byte $anonfun$testCompressSize$2(int x$2) {
        return (byte)x$2;
    }

    public static final /* synthetic */ byte $anonfun$testCompressSize$3(int x$3) {
        return (byte)x$3;
    }
}

