/* -*- Mode: C; c-file-style: "gnu" -*-
   agent.c -- native methods for sun.tools.debug.Agent.
   Created: Chris Toshok <toshok@hungry.com>, 6-Mar-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#include "jni.h"

JNIEXPORT jboolean JNICALL
Java_sun_tools_debug_Agent_systemThread(JNIEnv *env,
					jclass cls,
					jobject thread)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.systemThread not implemented");
  return JNI_FALSE;
}


JNIEXPORT void JNICALL
Java_sun_tools_debug_Agent_addSystemThread(JNIEnv *env,
					   jclass cls,
					   jobject thread)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.addSystemThread not implemented");
}


JNIEXPORT void JNICALL
Java_sun_tools_debug_Agent_removeSystemThread(JNIEnv *env,
					      jclass cls,
					      jobject thread)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.removeSystemThread not implemented");
}


JNIEXPORT jint JNICALL
Java_sun_tools_debug_Agent_getThreadStatus(JNIEnv *env,
					   jobject obj,
					   jobject thread)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getThreadStatus not implemented");
  return 0;
}


JNIEXPORT jobject JNICALL
Java_sun_tools_debug_Agent_getStackFrame(JNIEnv *env,
					 jobject obj,
					 jobject thread,
					 jint depth)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getStackFrame not implemented");
  return NULL;
}


JNIEXPORT jobjectArray JNICALL
Java_sun_tools_debug_Agent_getMethods(JNIEnv *env,
				      jobject obj,
				      jobject clazz)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getMethods not implemented");
  return NULL;
}


JNIEXPORT jobjectArray JNICALL
Java_sun_tools_debug_Agent_getFields(JNIEnv *env,
				     jobject obj,
				     jobject clazz)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getFields not implemented");
  return NULL;
}


JNIEXPORT jobjectArray JNICALL
Java_sun_tools_debug_Agent_getClasses(JNIEnv *env,
				      jobject obj)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getMethods not implemented");
  return NULL;
}


JNIEXPORT jobject JNICALL
Java_sun_tools_debug_Agent_getSlotObject(JNIEnv *env,
					 jobject obj,
					 jobject object,
					 jint slot_num)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getSlotObject not implemented");
  return NULL;
}


JNIEXPORT jintArray JNICALL
Java_sun_tools_debug_Agent_getSlotSignature(JNIEnv *env,
					    jobject obj,
					    jobject object,
					    jint slot_num)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getSlotSignature not implemented");
  return NULL;
}


JNIEXPORT jboolean JNICALL
Java_sun_tools_debug_Agent_getSlotBoolean(JNIEnv *env,
					  jobject obj,
					  jobject object,
					  jint slot_num)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getSlotBoolean not implemented");
  return JNI_FALSE;
}


JNIEXPORT jint JNICALL
Java_sun_tools_debug_Agent_getSlotInt(JNIEnv *env,
				      jobject obj,
				      jobject object,
				      jint slot_num)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getSlotInt not implemented");
  return 0;
}


JNIEXPORT jlong JNICALL
Java_sun_tools_debug_Agent_getSlotLong(JNIEnv *env,
				       jobject obj,
				       jobject object,
				       jint slot_num)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getSlotLong not implemented");
  return 0;
}


JNIEXPORT jfloat JNICALL
Java_sun_tools_debug_Agent_getSlotFloat(JNIEnv *env,
					jobject obj,
					jobject object,
					jint slot_num)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getSlotFloat not implemented");
  return 0;
}


JNIEXPORT jobjectArray JNICALL
Java_sun_tools_debug_Agent_getSlotArray(JNIEnv *env,
					jobject obj,
					jobject object,
					jint slot_num)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getSlotArray not implemented");
  return NULL;
}


JNIEXPORT jobject JNICALL
Java_sun_tools_debug_Agent_getStackObject(JNIEnv *env,
					  jobject obj,
					  jobject thread,
					  jint i1,
					  jint i2)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getStackObject not implemented");
  return NULL;
}


JNIEXPORT jboolean JNICALL
Java_sun_tools_debug_Agent_getStackBoolean(JNIEnv *env,
					   jobject obj,
					   jobject thread,
					   jint i1,
					   jint i2)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getStackBoolean not implemented");
  return JNI_FALSE;
}


JNIEXPORT jint JNICALL
Java_sun_tools_debug_Agent_getStackInt(JNIEnv *env,
				       jobject obj,
				       jobject thread,
				       jint i1,
				       jint i2)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getStackInt not implemented");
  return 0;
}


JNIEXPORT jlong JNICALL
Java_sun_tools_debug_Agent_getStackLong(JNIEnv *env,
					jobject obj,
					jobject thread,
					jint i1,
					jint i2)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getStackLong not implemented");
  return 0;
}


JNIEXPORT jfloat JNICALL
Java_sun_tools_debug_Agent_getStackFloat(JNIEnv *env,
					 jobject obj,
					 jobject thread,
					 jint i1,
					 jint i2)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getStackFloat not implemented");
  return 0;
}


JNIEXPORT jdouble JNICALL
Java_sun_tools_debug_Agent_getStackDouble(JNIEnv *env,
					  jobject obj,
					  jobject thread,
					  jint i1,
					  jint i2)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getStackDouble not implemented");
  return 0;
}


JNIEXPORT jobjectArray JNICALL
Java_sun_tools_debug_Agent_getStackArray(JNIEnv *env,
					 jobject obj,
					 jobject thread,
					 jint i1,
					 jint i2)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getStackArray not implemented");
  return NULL;
}


JNIEXPORT jobject JNICALL
Java_sun_tools_debug_Agent_lineno2pc(JNIEnv *env,
				     jobject obj,
				     jobject clazz,
				     jint line)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.lineno2pc not implemented");
  return NULL;
}


JNIEXPORT jint JNICALL
Java_sun_tools_debug_Agent_pc2lineno(JNIEnv *env,
				     jobject obj,
				     jobject clazz,
				     jint pc)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.pc2lineno not implemented");
  return 0;
}


JNIEXPORT jint JNICALL
Java_sun_tools_debug_Agent_method2pc(JNIEnv *env,
				     jobject obj,
				     jobject clazz,
				     jint method_num)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.method2pc not implemented");
  return 0;
}


JNIEXPORT jstring JNICALL
Java_sun_tools_debug_Agent_exceptionStackTrace(JNIEnv *env,
					       jobject obj,
					       jobject throwable)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.exceptionStackTrace not implemented");
  return NULL;
}


JNIEXPORT void JNICALL
Java_sun_tools_debug_Agent_setSingleStep(JNIEnv *env,
					 jobject obj,
					 jobject thread,
					 jboolean flag)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.setSingleStep not implemented");
}


JNIEXPORT void JNICALL
Java_sun_tools_debug_Agent_initAgent(JNIEnv *env,
				     jobject obj)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.initAgent not implemented");
}


JNIEXPORT jstring JNICALL
Java_sun_tools_debug_Agent_getClassSourceName(JNIEnv *env,
					      jobject obj,
					      jobject clazz)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getClassSourceName not implemented");
  return NULL;
}


JNIEXPORT jintArray JNICALL
Java_sun_tools_debug_Agent_getLinenumbers(JNIEnv *env,
					  jobject obj,
					  jobject clazz)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getLinenumbers not implemented");
  return NULL;
}


JNIEXPORT jint JNICALL
Java_sun_tools_debug_Agent_getMethodLinenumber(JNIEnv *env,
					       jobject obj,
					       jobject clazz,
					       jint method_num)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.getMethodLinenumber not implemented");
  return 0;
}


JNIEXPORT void JNICALL
Java_sun_tools_debug_Agent_setSlotBoolean(JNIEnv *env,
					  jobject obj,
					  jobject clazz,
					  jint slot_num,
					  jboolean value)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.setSlotBoolean not implemented");
}


JNIEXPORT void JNICALL
Java_sun_tools_debug_Agent_setSlotInt(JNIEnv *env,
				      jobject obj,
				      jobject clazz,
				      jint slot_num,
				      jint value)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.setSlotInt not implemented");
}


JNIEXPORT void JNICALL
Java_sun_tools_debug_Agent_setSlotLong(JNIEnv *env,
				       jobject obj,
				       jobject clazz,
				       jint slot_num,
				       jlong value)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.setSlotLong not implemented");
}


JNIEXPORT void JNICALL
Java_sun_tools_debug_Agent_setSlotDouble(JNIEnv *env,
					 jobject obj,
					 jobject clazz,
					 jint slot_num,
					 jdouble value)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.setSlotDouble not implemented");
}


JNIEXPORT void JNICALL
Java_sun_tools_debug_Agent_setStackBoolean(JNIEnv *env,
					   jobject obj,
					   jobject thread,
					   jint i1,
					   jint i2,
					   jboolean value)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.setSlotBoolean not implemented");
}


JNIEXPORT void JNICALL
Java_sun_tools_debug_Agent_setStackInt(JNIEnv *env,
				       jobject obj,
				       jobject thread,
				       jint i1,
				       jint i2,
				       jint value)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.setStackInt not implemented");
}


JNIEXPORT void JNICALL
Java_sun_tools_debug_Agent_setStackLong(JNIEnv *env,
					jobject obj,
					jobject thread,
					jint i1,
					jint i2,
					jlong value)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.setStackLong not implemented");
}


JNIEXPORT void JNICALL
Java_sun_tools_debug_Agent_setStackDouble(JNIEnv *env,
					  jobject obj,
					  jobject thread,
					  jint i1,
					  jint i2,
					  jdouble value)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.setStackDouble not implemented");
}


JNIEXPORT jint JNICALL
Java_sun_tools_debug_Agent_objectId(JNIEnv *env,
				    jobject obj,
				    jobject object)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.objectId not implemented");
  return 0;
}


JNIEXPORT void JNICALL
Java_sun_tools_debug_Agent_runMain(JNIEnv *env,
				   jobject obj,
				   jobject clazz,
				   jobjectArray args)
{
  (*env)->FatalError(env, "sun.tools.debug.Agent.runMain not implemented");
}


