/* -*- Mode: C; c-file-style: "gnu" -*-
   zipentry.c -- native methods for java/util/zip/ZipEntry
   Created: Chris Toshok <toshok@hungry.com>, 17-Nov-1998
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "jni.h"
#include "zipfile.h"

#include <stdlib.h>
#include <string.h>

static jfieldID name_field;
static jfieldID time_field;
static jfieldID crc_field;
static jfieldID size_field;
static jfieldID csize_field;
static jfieldID method_field;
static jfieldID extra_field;
static jfieldID comment_field;

JNIEXPORT void JNICALL
Java_java_util_zip_ZipEntry_initFields(JNIEnv *env,
				       jobject obj,
				       jlong jzentry)
{
  ZipDirectory *dir = (ZipDirectory*)jzentry;

  /* name */
  (*env)->SetObjectField(env, obj, name_field,
			 (*env)->NewStringUTF(env, ZIPDIR_FILENAME(dir)));

  /* time XXXX */
  (*env)->SetLongField(env, obj, time_field,
		       0);
  /* crc XXXX */
  (*env)->SetLongField(env, obj, crc_field,
		       0);

  /* size */
  (*env)->SetLongField(env, obj, size_field,
		       dir->uncompressed_size);

  /* csize */
  (*env)->SetLongField(env, obj, csize_field,
		       dir->compressed_size);

  /* method */
  (*env)->SetIntField(env, obj, method_field,
		      dir->compression_method);

  /* extra */
  (*env)->SetObjectField(env, obj, extra_field,
			 NULL);
  
  /* comment */
  (*env)->SetObjectField(env, obj, comment_field,
			 NULL);
  
}

JNIEXPORT void JNICALL
Java_java_util_zip_ZipEntry_initIDs(JNIEnv *env,
				    jclass cls)
{
  name_field = (*env)->GetFieldID(env, cls, "name", "Ljava/lang/String;");
  time_field = (*env)->GetFieldID(env, cls, "time", "J");
  crc_field = (*env)->GetFieldID(env, cls, "crc", "J");
  size_field = (*env)->GetFieldID(env, cls, "size", "J");
  csize_field = (*env)->GetFieldID(env, cls, "csize", "J");
  method_field = (*env)->GetFieldID(env, cls, "method", "I");
  extra_field = (*env)->GetFieldID(env, cls, "extra", "[B");;
  comment_field = (*env)->GetFieldID(env, cls, "comment", "Ljava/lang/String;");;
}
