/* -*- Mode: C; c-file-style: "gnu" -*-
   throwable.c -- native methods for java/lang/Throwable.
   Created: Chris Toshok <toshok@hungry.com>, 28-Jul-1997
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "jni.h"
#include "exceptions.h"

#include <stdlib.h>

JNIEXPORT void JNICALL
Java_java_lang_Throwable_printStackTrace0(JNIEnv *env,
					  jobject throwable,
					  jobject printwriter_stream)
{
  print_exception_backtrace(env, throwable);
}

JNIEXPORT jobject JNICALL
Java_java_lang_Throwable_fillInStackTrace(JNIEnv *env,
					  jobject throwable)
{
  ExceptionInfo *exc_info;

  if (NSA_GetNativeState(throwable))
    cleanup_exception(env, throwable);

  exc_info = (ExceptionInfo*)calloc(1, sizeof(ExceptionInfo));
  NSA_SetNativeState(throwable, exc_info);

  fill_in_backtrace_from_stack(env, throwable);

  return throwable;
}
