/* Copyright 1990 by Carrick Sean Casey. */
/* For copying and distribution information, see the file COPYING. */

/* primitive to hush abusive users */

#include <stdlib.h>
#include <string.h>
#include "icb.h"
#include "externs.h"

int	c_hush (TARGLIST);
int	ishushed (char *nick);
static int	hushadd (Tcl_Interp *interp, char *nick);
static int	hushdelete (Tcl_Interp *interp, char *nick);
static void	hushlist (void);

STRLIST *hushhead = NULL, *hushtail = NULL;

int
c_hush (TARGLIST)
{
	if (argc == 1 || !*argv[1])
		hushlist();
	else
		if (!ishushed(argv[1])) {
			if (hushadd(interp, argv[1]) < 0)
				return(TCL_ERROR);
		} else 
			if (hushdelete(interp, argv[1]) < 0)
				return(TCL_ERROR);
	return(TCL_OK);
}

static int
hushadd (Tcl_Interp *interp, char *nick)
{
	STRLIST *hp;

	/* skip whitespace */
	while (*nick == ' ' || *nick == '\t') nick++;

	if (*nick == '\0') {
		Tcl_SetResult(interp, "c_hush: can't hush a null nickname", TCL_VOLATILE);
		return(-1);
	}

	if (strlen(nick) > MAX_NICKLEN)
		*(nick + MAX_NICKLEN) = '\0';

	if ((hp = strmakenode(strlen(nick))) == NULL) {
		Tcl_SetResult(interp, "c_hush: out of memory", TCL_VOLATILE);
		return(-1);
	}
	strcpy(hp->str, nick);
	strlinkalpha(hp, &hushhead, &hushtail, 1);
	sprintf(mbuf, "[=Hush=] %s added to hush list.", hp->str);
	putl(mbuf, PL_SL);
	return(0);
}

static int
hushdelete (Tcl_Interp *interp, char *nick)
{
	STRLIST *s;

	if ((s = strgetnode(nick, hushhead, 1)) == NULL) {
		Tcl_ResetResult(interp);
		Tcl_AppendResult(interp, "c_hush: ", nick, " is not being hushed", (char *)NULL);
		return(-1);
	}
	sprintf(mbuf, "[=Hush=] %s deleted from hush list.", nick);
	putl(mbuf, PL_SL);
	strunlink(s, &hushhead, &hushtail);
	free(s);
	return(0);
}

static void
hushlist(void)
{
	STRLIST *p;
	char *s, *t;

	if (hushhead)
		putl("Hushed nicknames:", PL_SCR);
	else {
		putl("[=Hush=] You are not currently hushing anyone.", PL_SCR);
		return;
	}

	s = mbuf;
	for (p = hushhead; p; p = p->next) {
		if (s != mbuf)
			*s++ = ' ';
		for (t = p->str; *t != '\0'; t++)
			*s++ = *t;
		if (s-mbuf > 60) {
			*s = '\0';
			putl(mbuf, PL_SCR);
			s = mbuf;
		}
	}
	if (s != mbuf) {
		*s = '\0';
		putl(mbuf, PL_SCR);
	}
}

int
ishushed(char *nick)
{
	STRLIST *p;

	for (p = hushhead; p; p = p->next)
		if (!strcasecmp(p->str, nick))
			return(1);
	return(0);
}
