/* ޸  ƿƼ Լ.
   Copyright (C) 2002, 2003, 2004 HRE  ׷

This file is part of Hangul Regular Expression Library (aka HRE).

HRE is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

HRE is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "debug.h"

extern struct memory m_stat;

void *
xmalloc(size) 
     unsigned size; 
{
  void *value = (void *)malloc(size);

  if (value == 0) {
    fprintf(stderr, "Virtual memory exceeded\n");
    abort ();
  }

  /* ޸  */
  m_stat.n_malloc++;

  return value;
}

void *
xtmalloc(size) 
     unsigned size; 
{
  void *value = (void *)malloc(size);

  if (value == 0) {
    fprintf(stderr, "Virtual memory exceeded\n");
    abort ();
  }

  /* ޸  */
  m_stat.n_tmalloc++;

  return value;
}

void *
xrealloc(p, size)
     void *p;
     unsigned size; 
{
  void *value = (void *) realloc (p, size);

  if (value == 0) {
    fprintf(stderr, "Virtual memory exceeded\n");
    abort ();
  }

  /* ޸  */
  //fprintf (stderr, "old : 0x%x\tnew : 0x%x\n", p, value);
  m_stat.n_realloc++;

  return value;
}

void
xfree (void *p)
{
  free (p);

  m_stat.n_free++;
}

char *
xstrdup (s)
  const char *s;
{
  register size_t len = strlen (s) + 1;
  register char *ret = (void *) malloc (len);
  memcpy (ret, s, len);
  return ret;
}
