#include "visioExporter.h"


visioExporter::visioExporter(char *what_file, nodes *what_nodes) {
  filename = strdup(what_file);
  my_nodes = what_nodes;
}


visioExporter::~visioExporter() {
  free(filename);
}


void visioExporter::do_export() {
  FILE *outfile = fopen(filename, "w");
  write_headers(outfile);
  write_nodes(outfile);
  write_edges(outfile);
  fclose(outfile);
}


void visioExporter::write_headers(FILE *outfile) {
   //   char *headers = "; visio csv\nTemplate,\"Basic Diagram.vst\"\n\n";
   char *headers = "; visio csv\nTemplate,\"Block Diagram.vst\"\n\n";
  fwrite(headers, strlen(headers), 1, outfile);
}


void visioExporter::write_nodes(FILE *outfile) {
  smallest_x = 100000;
  smallest_y = 100000;
  node *temp_node;
  for (int temp = 0; temp < my_nodes->number_of_nodes(); temp++) {
    temp_node = my_nodes->get_node(temp);
    if (temp_node->x_pos < smallest_x)
      smallest_x = (int) temp_node->x_pos;
    if (temp_node->y_pos < smallest_y)
      smallest_y = (int) temp_node->y_pos;
  }
  for (int temp = 0; temp < my_nodes->number_of_nodes(); temp++) {
    temp_node = my_nodes->get_node(temp);
    write_node(temp_node, outfile);
  }
}


void visioExporter::write_node(node *this_node, FILE *outfile) {
   char *MASTER_NAME = "";
   char *WIDTH = "";
   char *HEIGHT = "";
   char *line = new char[200];
   //   sprintf(line, "Shape,\"%s\",\"%s\",\"%s\",%d,%d,%s,%s\n",
   sprintf(line, "Shape,\"%s\",\"%s\",\"%s\",%0.2f,%0.2f\n",
           this_node->name, MASTER_NAME, this_node->name,
           ((this_node->x_pos - smallest_x + 1) / 10.0),
           ((this_node->y_pos - smallest_y + 1) / 10.0));
           //           WIDTH, HEIGHT);
  fwrite(line, strlen(line), 1, outfile);
  delete line;
}


void visioExporter::write_edges(FILE *outfile) {
  node *temp_node;
  node *temp_node2;
  for (int temp = 0; temp < my_nodes->number_of_nodes(); temp++) {
    temp_node = my_nodes->get_node(temp);
    for (int temp2 = 0; temp2 < temp_node->number_of_connections; temp2++) {
       temp_node2 = temp_node->connecting_nodes[temp2];
       write_edge(temp_node, temp_node2, outfile);
    }
  }
}


void visioExporter::write_edge(node *from_node, node *to_node, FILE *outfile) {
   //   char *MASTER_NAME = "Line-curve connector";
   char *MASTER_NAME = "Single arrowhead";
   char *line = new char[200];
   sprintf(line, "Link,\"\",\"%s\",\"\",\"%s\",\"%s\"\n",
           MASTER_NAME, from_node->name, to_node->name);
  fwrite(line, strlen(line), 1, outfile);
  delete line;
}



// Utility methods

char *visioExporter::itoa(int value) {
  char *string_value = 0;
  if (value > 0)  return digit(value, string_value);
  if (value == 0) return "0";

  value = -value;
  string_value = digit(value, string_value);
  char *temp = new char[strlen(string_value) + 2];
  temp[0] = (char) 45;  
  temp[1] = 0;
  return strcat(temp, string_value);
}


char *visioExporter::digit(int value, char *string_val) {
  if (value == 0) 
    return string_val;

  int digitval;
  int charval;
  switch(value % 10) {
  case 0: charval = 48; digitval = 0; break;
  case 1: charval = 49; digitval = 1; break;
  case 2: charval = 50; digitval = 2; break;
  case 3: charval = 51; digitval = 3; break;
  case 4: charval = 52; digitval = 4; break;
  case 5: charval = 53; digitval = 5; break;
  case 6: charval = 54; digitval = 6; break;
  case 7: charval = 55; digitval = 7; break;
  case 8: charval = 56; digitval = 8; break;
  case 9: charval = 57; digitval = 9; break;
  }

  char *temp;
  if (string_val != 0)
    temp = new char[strlen(string_val) + 2];
  else
    temp = new char[2];
  temp[0] = (char) charval;
  temp[1] = 0;
  if (string_val != 0) {
    strcat(temp, string_val);
    delete string_val;
  }

  value = (value - digitval) / 10;
  return digit(value, temp);
}

char *visioExporter::kill_quotes(char *line) {
  char *tick = "'";
  char *quote_pos;
  while (strstr(line, "\"") != 0) {
    quote_pos = strstr(line, "\"");
    *quote_pos = *tick;
  }
  return line;
}
