#include "dotImporter.h"
#include <string.h>
#include <gtk/gtk.h>
#include "../interface.h"

extern GtkWidget *notice_popup_window;


dotImporter::dotImporter(char *what_file, nodes *what_nodes) {
   filename = strdup(what_file);
   my_nodes = what_nodes;
}

dotImporter::~dotImporter() {
   free(filename);
}

int dotImporter::import() {
   FILE *infile = fopen(filename, "r");
   char *line;
   char *pointer;
   char *pointer2;
   char *fromName;
   char *toName;
   bool seen_graph_decl = false;
  
   while (feof(infile) == 0) {
      line = read_line(infile);
     
      if (strlen(line) > 1) {
         if (seen_graph_decl) {
            if (strstr(line, "->") != NULL ||
                strstr(line, "--") != NULL) {
               // get the first name
               fromName = strdup(get_name(line, pointer));
               
               // see if there are any more nodes on this line
               while (strstr(pointer, "->") != NULL || 
                      strstr(pointer, "--") != NULL ||
                      pointer[0] == '>' || pointer[0] == '-') {
                  // get the next name
                  if (pointer[0] == '>' || pointer[0] == '-')
                     pointer2 = pointer + 1;
                  else {
                     pointer2 = strstr(pointer, "->");
                     if (pointer2 == NULL) {
                        pointer2 = strstr(pointer, "--");
                        if (pointer2 == NULL)
                           break;
                     }
                     pointer2 += 2;
                  }
                  toName = strdup(get_name(pointer2, pointer));
                  
                  // create the nodes
                  create_nodes(fromName, toName);
                  free(fromName);
                  fromName = toName;
               }
               free(fromName);
            }
         }
         else if (strstr(line, "graph") != NULL)
            seen_graph_decl = true;
      }
      free(line);
   }
   fclose(infile);
   if (!seen_graph_decl) {
      notice_popup_window = 
         create_notice_popup_window("This file does not appear to be a dot file");
      gtk_widget_show(notice_popup_window);
      return 0;
   }
   return 1;
}

char *dotImporter::read_line(FILE *infile) {
   char *line = new char[256];
   for (int x = 0; x < 256; x++)
      line[x] = 0;

   int counter = 0;
   int done = 0;
   while (done == 0 && counter < 256) {
      if (feof(infile) !=0)
         return line;
      fread(&line[counter], 1, 1, infile);
      if (strcmp(&line[counter], "\n") == 0)
         return line;
      counter++;
   }
   return 0;
}

char *dotImporter::get_name(char *start, char *&end){
   int walker = 0;
   int is_quoted = 0;

   if (start[0] == '>' || start[0] == '-')
      walker++;
   while (start[walker] == ' ' || start[walker] == '\t')
      walker++;
   if (start[walker] == '"') {
      is_quoted = 1;
      walker++;
   }
   
   char *pointer = start + walker;
   walker = 0;
   if (is_quoted) 
      while (pointer[walker] != '"' && pointer[walker] != '\n' &&
             pointer[walker] != '\0')
         walker++;
   else
      while (pointer[walker] != ' '  && pointer[walker] != '\t' &&
             pointer[walker] != ';'  && pointer[walker] != '\n' &&
             pointer[walker] != '\r' && pointer[walker] != '\0' &&
             pointer[walker] != '[') {
         walker++;
         if (pointer[walker] == '-')
            if (pointer[walker+1] == '-' || pointer[walker+1] == '>')
               break;
      }
   end = pointer + walker;
   *end = '\0';
   end++;

   // go to the end of the [] section if applicable
   char *openProperties, *closeProperties = NULL;
   closeProperties = strstr(end, "]");
   if (closeProperties != NULL) {
      openProperties = strstr(end, "[");
      if (openProperties == NULL || closeProperties < openProperties)
         end = closeProperties + 1;
   }

   return pointer;
}

void dotImporter::create_nodes(char *fromName, char *toName) {
   node *from_node = my_nodes->add_node(fromName);
   from_node->x_pos = ((float) random() * 1000) / RAND_MAX;
   from_node->y_pos = ((float) random() * 1000) / RAND_MAX;
   
   node *to_node = my_nodes->add_node(toName);
   to_node->x_pos = ((float) random() * 1000) / RAND_MAX;
   to_node->y_pos = ((float) random() * 1000) / RAND_MAX;
   
   from_node->add_connection(to_node);
}
