/* glickomania.c -- a puzzle game.

   Copyright (C) 2002 Kenneth Oksanen
   Copyright (C) 1992, 1995, 1996, 1997 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* AIX requires this to be the first thing in the file.  */
#if defined (_AIX) && !defined (__GNUC__)
 #pragma alloca
#endif


#ifndef INCL_GAME_LOGIC
#define INCL_GAME_LOGIC  1


/* The current number of rows, columns and different tile colors. 
 */

extern int height, width, n_tiles;

/* A compile-time maximum number of rows, columns and different tile
   colors.  */

#define MAX_HEIGHT   7
#define MAX_WIDTH    7
#define MAX_N_TILES  7

/* An enum representing tile colors.
 */
typedef enum {
  TILE_0 = 0,
  N_TILES = MAX_N_TILES,
  EMPTY = 0xFF
} tile_t;


typedef tile_t column_t[MAX_HEIGHT];

typedef column_t board_t[MAX_WIDTH];

/* This is the current board position shown on the screen.  Updated
   automatically by routines in `game_logic.c'. */
extern column_t *board;


/* Make a move by removing the group at the given coordinates.
   Returns non-zero on success (i.e. that board position is non-empty
   and belongs to a group.)  Returns 2 if the reached position is an
   empty board, and 3 if all positions have now been solved. */
int make_move(int x, int y);

/* Undo and redo moves.  These too return non-zero on success. */
int unmake_move(void);
int remake_move(void);

/* Start a new game from the next, previous or first initial position. */

int next_problem(void);
int prev_problem(void);
int next_unsolved_problem(void);
int prev_unsolved_problem(void);
void first_problem(void);

/* Save and load the information of known initial */

void save_problems(FILE *fp);
int load_problems(FILE *fp);

/* Mark all initial positions unsolved. */

void reset_problems(void);

/* Write at most `n_bytes' of statistical information of the problems
   and current problem into `buf'. */
void problem_stats(char *buf, size_t n_bytes);


#endif /* INCL_GAME_LOGIC */
