package ikev2

import (
	"math/big"
	"net"
)

// I hate go idioms for enums, so we're doing string maps.
// The primary reason is that I want the context to be evident, much like a namespace when using the structures here.

var PayloadType = map[string]int{
	"NONE":                       0,
	"TRANSFORM":                  3,
	"SECURITY_ASSOCIATION":       33,
	"KEY_EXCHANGE":               34,
	"IDENTIFIER_INITIATOR":       35,
	"IDENTIFIER_RESPONDER":       36,
	"CERTIFICATE":                37,
	"CERTIFICATE_REQUEST":        38,
	"AUTHENTICATION":             39,
	"NONCE":                      40,
	"NOTIFY":                     41,
	"DELETE":                     42,
	"VENDOR_ID":                  43,
	"TRAFFIC_SELECTOR_INITIATOR": 44,
	"TRAFFIC_SELECTOR_RESPONDER": 45,
	"ENCRYPTED":                  46,
	"CONFIGURATION":              47,
	"EXTENSIBLE_AUTHENTICATION":  48,
}

var ExchangeType = map[string]int{
	"IKE_SA_INIT":     34,
	"IKE_AUTH":        35,
	"CREATE_CHILD_SA": 36,
	"INFORMATIONAL":   37,
}

var TransformType = map[string]int{
	"ENCRYPTION_ALGORITHM":   1,
	"PSEUDO_RANDOM_FUNCTION": 2,
	"INTEGRITY_ALGORITHM":    3,
	"DIFFIE_HELLMAN_GROUP":   4,
}

var NotifyType = map[string]int{
	"UNSUPPORTED_CRITICAL_PAYLOAD":  1,
	"INVALID_IKE_SPI":               4,
	"INVALID_MAJOR_VERSION":         5,
	"INVALID_SYNTAX":                7,
	"INVALID_MESSAGE_ID":            9,
	"INVALID_SPI":                   11,
	"NO_PROPOSAL_CHOSEN":            14,
	"INVALID_KE_PAYLOAD":            17,
	"AUTHENTICATION_FAILED":         24,
	"SINGLE_PAIR_REQUIRED":          34,
	"NO_ADDITIONAL_SAS":             35,
	"INTERNAL_ADDRESS_FAILURE":      36,
	"FAILED_CP_REQUIRED":            37,
	"TS_UNACCEPTABLE":               38,
	"INVALID_SELECTORS":             39,
	"INITIAL_CONTACT":               16384,
	"SET_WINDOW_SIZE":               16385,
	"ADDITIONAL_TS_POSSIBLE":        16386,
	"IPCOMP_SUPPORTED":              16387,
	"NAT_DETECTION_SOURCE_IP":       16388,
	"NAT_DETECTION_DESTINATION_IP":  16389,
	"COOKIE":                        16390,
	"USE_TRANSPORT_MODE":            16391,
	"HTTP_CERT_LOOKUP_SUPPORTED":    16392,
	"REKEY_SA":                      16393,
	"ESP_TFC_PADDING_NOT_SUPPORTED": 16394,
	"NON_FIRST_FRAGMENTS_ALSO":      16395,
	"MOBIKE_SUPPORTED":              16396,
	"MULTIPLE_AUTH_SUPPORTED":       16404,
	"REDIRECT_SUPPORTED":            16406,
	"IKEV2_FRAGMENTATION_SUPPORTED": 16430,
	"SIGNATURE_HASH_ALGORITHMS":     16431,
}

var ConfigurationAttribute = map[string]int{
	"INTERNAL_IP4_ADDRESS": 1,
	"INTERNAL_IP4_NETMASK": 2,
	"INTERNAL_IP4_DNS":     3,
	"INTERNAL_IP4_MBNS":    4,
	"APPLICATION_VERSION":  7,
	"INTERNAL_IP6_ADDRESS": 8,
	"INTERNAL_IP6_DNS":     10,
}

var EncryptionAlgorithm = map[string]int{
	"ENCR_DES_IV64":                 1,
	"ENCR_DES":                      2,
	"ENCR_3DES":                     3,
	"ENCR_RC5":                      4,
	"ENCR_IDEA":                     5,
	"ENCR_CAST":                     6,
	"ENCR_BLOWFISH":                 7,
	"ENCR_3IDEA":                    8,
	"ENCR_DES_IV32":                 9,
	"RESERVED":                      10,
	"ENCR_NULL":                     11,
	"ENCR_AES_CBC":                  12,
	"ENCR_AES_CTR":                  13,
	"ENCR_AES_CCM_8":                14,
	"ENCR_AES_CCM_12":               15,
	"ENCR_AES_CCM_16":               16,
	"ENCR_AES_GCM_8":                18,
	"ENCR_AES_GCM_12":               19,
	"ENCR_AES_GCM_16":               20,
	"ENCR_NULL_AUTH_AES_GMAC":       21,
	"P1619_XTS_AES":                 22,
	"ENCR_CAMELLIA_CBC":             23,
	"ENCR_CAMELLIA_CTR":             24,
	"ENCR_CAMELLIA_CCM_8":           25,
	"ENCR_CAMELLIA_CCM_12":          26,
	"ENCR_CAMELLIA_CCM_16":          27,
	"ENCR_CHACHA20_POLY1305":        28,
	"ENCR_AES_CCM_8_IIV":            29,
	"ENCR_AES_GCM_16_IIV":           30,
	"ENCR_CHACHA20_POLY1305_IIV":    31,
	"ENCR_KUZNYECHIK_MGM_KTREE":     32,
	"ENCR_MAGMA_MGM_KTREE":          33,
	"ENCR_KUZNYECHIK_MGM_MAC_KTREE": 34,
	"ENCR_MAGMA_MGM_MAC_KTREE":      35,
}

var PseudoRandomFunction = map[string]int{
	"PRF_HMAC_MD5":          1,
	"PRF_HMAC_SHA1":         2,
	"PRF_HMAC_TIGER":        3,
	"PRF_AES128_XCBC":       4,
	"PRF_HMAC_SHA2_256":     5,
	"PRF_HMAC_SHA2_384":     6,
	"PRF_HMAC_SHA2_512":     7,
	"PRF_AES128_CMAC":       8,
	"PRF_HMAC_STREEBOG_512": 9,
}

var IntegrityAlgorithm = map[string]int{
	"AUTH_HMAC_MD5_96":       1,
	"AUTH_HMAC_SHA1_96":      2,
	"AUTH_DES_MAC":           3,
	"AUTH_KPDK_MD5":          4,
	"AUTH_AES_XCBC_96":       5,
	"AUTH_HMAC_MD5_128":      6,
	"AUTH_HMAC_SHA1_160":     7,
	"AUTH_AES_CMAC_96":       8,
	"AUTH_AES_128_GMAC":      9,
	"AUTH_AES_192_GMAC":      10,
	"AUTH_AES_256_GMAC":      11,
	"AUTH_HMAC_SHA2_256_128": 12,
	"AUTH_HMAC_SHA2_384_192": 13,
	"AUTH_HMAC_SHA2_512_256": 14,
}

var DiffieHellmanGroup = map[string]int{
	"DH_GROUP_2048_BIT_MODP":                                   14,
	"DH_GROUP_768_BIT_MODP":                                    1,
	"DH_GROUP_1024_BIT_MODP":                                   2,
	"DH_GROUP_1536_BIT_MODP":                                   5,
	"DH_GROUP_3072_BIT_MODP":                                   15,
	"DH_GROUP_4096_BIT_MODP":                                   16,
	"DH_GROUP_6144_BIT_MODP":                                   17,
	"DH_GROUP_8192_BIT_MODP":                                   18,
	"RANDOM_ECP_GROUP_256_BIT":                                 19,
	"RANDOM_ECP_GROUP_384_BIT":                                 20,
	"RANDOM_ECP_GROUP_521_BIT":                                 21,
	"DH_GROUP_1024_BIT_MODP_WITH_160_BIT_PRIME_ORDER_SUBGROUP": 22,
	"DH_GROUP_2048_BIT_MODP_WITH_224_BIT_PRIME_ORDER_SUBGROUP": 23,
	"DH_GROUP_2048_BIT_MODP_WITH_256_BIT_PRIME_ORDER_SUBGROUP": 24,
	"RANDOM_ECP_GROUP_192_BIT":                                 25,
	"RANDOM_ECP_GROUP_224_BIT":                                 26,
	"BRAINPOOLP224R1":                                          27,
	"BRAINPOOLP256R1":                                          28,
	"BRAINPOOLP384R1":                                          29,
	"BRAINPOOLP512R1":                                          30,
	"CURVE25519":                                               31,
	"CURVE448":                                                 32,
	"GOST3410_2012_256":                                        33,
	"GOST3410_2012_512":                                        34,
	"ML_KEM_512":                                               35,
	"ML_KEM_768":                                               36,
	"ML_KEM_1024":                                              37,
}

type IkeClient struct {
	Conn      net.Conn
	IkeCrypto IkeCrypto
}

type IkeCrypto struct {
	Prime *big.Int

	InitNonce []byte
	RespNonce []byte
	InitSPI   uint64
	RespSPI   uint64

	ClientPrivKey *big.Int
	ClientPubKey  *big.Int
	ServerPubKey  *big.Int

	SharedSecret *big.Int
	SKeySeed     string
	SKd          string
	SKai         string
	SKar         string
	SKei         string
	SKer         string
}

type IkeProposal struct {
	ProposalNumber int
	ProtocolID     int
	SPI            int
	Transforms     []IkeTransform
}

type IkeTransform struct {
	NextPayload         int
	TransformType       int
	TransformID         int
	TransformAttributes int // a bit lazy perhaps, but it gets used infrequently enough that providing an int instead of a list of maps + enums should suffice
	// Reserved int = 0
}
