// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListHostVulnerabilityImpactedHostsRequest wrapper for the ListHostVulnerabilityImpactedHosts operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListHostVulnerabilityImpactedHosts.go.html to see an example of how to use ListHostVulnerabilityImpactedHostsRequest.
type ListHostVulnerabilityImpactedHostsRequest struct {

	// unique host scan vulnerability identifier
	HostVulnerabilityId *string `mandatory:"true" contributesTo:"path" name:"hostVulnerabilityId"`

	// The sort order to use, either 'ASC' or 'DESC'.
	SortOrder ListHostVulnerabilityImpactedHostsSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. Only one sort order may be provided. Default order is Ascending. If no value is specified instanceId is default.
	SortBy ListHostVulnerabilityImpactedHostsSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListHostVulnerabilityImpactedHostsRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListHostVulnerabilityImpactedHostsRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListHostVulnerabilityImpactedHostsRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListHostVulnerabilityImpactedHostsRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListHostVulnerabilityImpactedHostsRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListHostVulnerabilityImpactedHostsSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListHostVulnerabilityImpactedHostsSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListHostVulnerabilityImpactedHostsSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListHostVulnerabilityImpactedHostsSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListHostVulnerabilityImpactedHostsResponse wrapper for the ListHostVulnerabilityImpactedHosts operation
type ListHostVulnerabilityImpactedHostsResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of HostVulnerabilityImpactedHostSummaryCollection instances
	HostVulnerabilityImpactedHostSummaryCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListHostVulnerabilityImpactedHostsResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListHostVulnerabilityImpactedHostsResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListHostVulnerabilityImpactedHostsSortOrderEnum Enum with underlying type: string
type ListHostVulnerabilityImpactedHostsSortOrderEnum string

// Set of constants representing the allowable values for ListHostVulnerabilityImpactedHostsSortOrderEnum
const (
	ListHostVulnerabilityImpactedHostsSortOrderAsc  ListHostVulnerabilityImpactedHostsSortOrderEnum = "ASC"
	ListHostVulnerabilityImpactedHostsSortOrderDesc ListHostVulnerabilityImpactedHostsSortOrderEnum = "DESC"
)

var mappingListHostVulnerabilityImpactedHostsSortOrderEnum = map[string]ListHostVulnerabilityImpactedHostsSortOrderEnum{
	"ASC":  ListHostVulnerabilityImpactedHostsSortOrderAsc,
	"DESC": ListHostVulnerabilityImpactedHostsSortOrderDesc,
}

var mappingListHostVulnerabilityImpactedHostsSortOrderEnumLowerCase = map[string]ListHostVulnerabilityImpactedHostsSortOrderEnum{
	"asc":  ListHostVulnerabilityImpactedHostsSortOrderAsc,
	"desc": ListHostVulnerabilityImpactedHostsSortOrderDesc,
}

// GetListHostVulnerabilityImpactedHostsSortOrderEnumValues Enumerates the set of values for ListHostVulnerabilityImpactedHostsSortOrderEnum
func GetListHostVulnerabilityImpactedHostsSortOrderEnumValues() []ListHostVulnerabilityImpactedHostsSortOrderEnum {
	values := make([]ListHostVulnerabilityImpactedHostsSortOrderEnum, 0)
	for _, v := range mappingListHostVulnerabilityImpactedHostsSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostVulnerabilityImpactedHostsSortOrderEnumStringValues Enumerates the set of values in String for ListHostVulnerabilityImpactedHostsSortOrderEnum
func GetListHostVulnerabilityImpactedHostsSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListHostVulnerabilityImpactedHostsSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostVulnerabilityImpactedHostsSortOrderEnum(val string) (ListHostVulnerabilityImpactedHostsSortOrderEnum, bool) {
	enum, ok := mappingListHostVulnerabilityImpactedHostsSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListHostVulnerabilityImpactedHostsSortByEnum Enum with underlying type: string
type ListHostVulnerabilityImpactedHostsSortByEnum string

// Set of constants representing the allowable values for ListHostVulnerabilityImpactedHostsSortByEnum
const (
	ListHostVulnerabilityImpactedHostsSortByInstanceid ListHostVulnerabilityImpactedHostsSortByEnum = "instanceId"
)

var mappingListHostVulnerabilityImpactedHostsSortByEnum = map[string]ListHostVulnerabilityImpactedHostsSortByEnum{
	"instanceId": ListHostVulnerabilityImpactedHostsSortByInstanceid,
}

var mappingListHostVulnerabilityImpactedHostsSortByEnumLowerCase = map[string]ListHostVulnerabilityImpactedHostsSortByEnum{
	"instanceid": ListHostVulnerabilityImpactedHostsSortByInstanceid,
}

// GetListHostVulnerabilityImpactedHostsSortByEnumValues Enumerates the set of values for ListHostVulnerabilityImpactedHostsSortByEnum
func GetListHostVulnerabilityImpactedHostsSortByEnumValues() []ListHostVulnerabilityImpactedHostsSortByEnum {
	values := make([]ListHostVulnerabilityImpactedHostsSortByEnum, 0)
	for _, v := range mappingListHostVulnerabilityImpactedHostsSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostVulnerabilityImpactedHostsSortByEnumStringValues Enumerates the set of values in String for ListHostVulnerabilityImpactedHostsSortByEnum
func GetListHostVulnerabilityImpactedHostsSortByEnumStringValues() []string {
	return []string{
		"instanceId",
	}
}

// GetMappingListHostVulnerabilityImpactedHostsSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostVulnerabilityImpactedHostsSortByEnum(val string) (ListHostVulnerabilityImpactedHostsSortByEnum, bool) {
	enum, ok := mappingListHostVulnerabilityImpactedHostsSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
