// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// PGSQL Control Plane API
//
// Use the OCI Database with PostgreSQL API to manage resources such as database systems, database nodes, backups, and configurations.
// For information, see the user guide documentation for the service (https://docs.oracle.com/iaas/Content/postgresql/home.htm).
//

package psql

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// CreateDbInstanceDetails Information about the new database instance node.
type CreateDbInstanceDetails struct {

	// Display name of the database instance node. Avoid entering confidential information.
	DisplayName *string `mandatory:"false" json:"displayName"`

	// A user-provided description of the database instance node.
	Description *string `mandatory:"false" json:"description"`

	// Private IP in customer subnet that will be assigned to the database instance node. This value is optional.
	// If the IP is not provided, the IP will be chosen from the available IP addresses in the specified subnet.
	PrivateIp *string `mandatory:"false" json:"privateIp"`
}

func (m CreateDbInstanceDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m CreateDbInstanceDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
