// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
)

type ServiceTransportProtocol string

const (
	ServiceTransportProtocolUnknown ServiceTransportProtocol = ""
	ServiceTransportProtocolTCP     ServiceTransportProtocol = "tcp"
	ServiceTransportProtocolUDP     ServiceTransportProtocol = "udp"
	ServiceTransportProtocolIcmp    ServiceTransportProtocol = "icmp"
	ServiceTransportProtocolQuic    ServiceTransportProtocol = "quic"
)

func (e ServiceTransportProtocol) ToPointer() *ServiceTransportProtocol {
	return &e
}
func (e *ServiceTransportProtocol) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "tcp":
		fallthrough
	case "udp":
		fallthrough
	case "icmp":
		fallthrough
	case "quic":
		*e = ServiceTransportProtocol(v)
		return nil
	default:
		return fmt.Errorf("invalid value for ServiceTransportProtocol: %v", v)
	}
}

type Service struct {
	Activemq           *Activemq                 `json:"activemq,omitempty"`
	Amqp               *Amqp                     `json:"amqp,omitempty"`
	AnyConnect         *AnyConnect               `json:"any_connect,omitempty"`
	Bacnet             *Bacnet                   `json:"bacnet,omitempty"`
	Banner             *string                   `json:"banner,omitempty"`
	BannerHashSha256   *string                   `json:"banner_hash_sha256,omitempty"`
	BannerHex          *string                   `json:"banner_hex,omitempty"`
	Cert               *Certificate              `json:"cert,omitempty"`
	CheckpointTopology *CheckpointTopology       `json:"checkpoint_topology,omitempty"`
	Chromecast         *Chromecast               `json:"chromecast,omitempty"`
	CiscoIpsla         *CiscoIpsla               `json:"cisco_ipsla,omitempty"`
	Cmore              *Cmore                    `json:"cmore,omitempty"`
	Coap               *Coap                     `json:"coap,omitempty"`
	CrestronCp3        *CrestronCp3              `json:"crestron_cp3,omitempty"`
	CrestronDinAp2     *CrestronDinAp2           `json:"crestron_din_ap2,omitempty"`
	Cwmp               *Cwmp                     `json:"cwmp,omitempty"`
	Darkcomet          *Darkcomet                `json:"darkcomet,omitempty"`
	Darkgate           *Darkgate                 `json:"darkgate,omitempty"`
	Dcerpc             *Dcerpc                   `json:"dcerpc,omitempty"`
	Dhcpdiscover       *Dhcpdiscover             `json:"dhcpdiscover,omitempty"`
	Dnp3               *Dnp3                     `json:"dnp3,omitempty"`
	DNS                *DNS                      `json:"dns,omitempty"`
	Dtls               *Dtls                     `json:"dtls,omitempty"`
	DvrIP              *DvrIP                    `json:"dvr_ip,omitempty"`
	Eip                *Eip                      `json:"eip,omitempty"`
	ElfFile            *ElfFile                  `json:"elf_file,omitempty"`
	Endpoints          []EndpointScanState       `json:"endpoints,omitempty"`
	Epmd               *Epmd                     `json:"epmd,omitempty"`
	Etcd               *Etcd                     `json:"etcd,omitempty"`
	Ethereum           *Ethereum                 `json:"ethereum,omitempty"`
	Exposures          []Risk                    `json:"exposures,omitempty"`
	Fox                *Fox                      `json:"fox,omitempty"`
	Ftp                *Ftp                      `json:"ftp,omitempty"`
	Gearman            *Gearman                  `json:"gearman,omitempty"`
	Hardware           []Attribute               `json:"hardware,omitempty"`
	HidVertx           *HidVertx                 `json:"hid_vertx,omitempty"`
	Hikvision          *Hikvision                `json:"hikvision,omitempty"`
	Ibmnje             *Ibmnje                   `json:"ibmnje,omitempty"`
	Ike                *Ike                      `json:"ike,omitempty"`
	Imap               *Imap                     `json:"imap,omitempty"`
	Iota               *Iota                     `json:"iota,omitempty"`
	IP                 *string                   `json:"ip,omitempty"`
	Ipmi               *Ipmi                     `json:"ipmi,omitempty"`
	Ipp                *Ipp                      `json:"ipp,omitempty"`
	Iscsi              *Iscsi                    `json:"iscsi,omitempty"`
	Ja4tscan           *Ja4TScanScan             `json:"ja4tscan,omitempty"`
	Jarm               *JarmScan                 `json:"jarm,omitempty"`
	Krpc               *Krpc                     `json:"krpc,omitempty"`
	L2tp               *L2Tp                     `json:"l2tp,omitempty"`
	Labels             []Label                   `json:"labels,omitempty"`
	Ldap               *Ldap                     `json:"ldap,omitempty"`
	Lpd                *Lpd                      `json:"lpd,omitempty"`
	Mdns               *Mdns                     `json:"mdns,omitempty"`
	Memcached          *Memcached                `json:"memcached,omitempty"`
	Minecraft          *Minecraft                `json:"minecraft,omitempty"`
	Misconfigs         []Risk                    `json:"misconfigs,omitempty"`
	Mms                *Mms                      `json:"mms,omitempty"`
	Modbus             *Modbus                   `json:"modbus,omitempty"`
	MoneroP2p          *MoneroP2P                `json:"monero_p2p,omitempty"`
	Mongodb            *Mongodb                  `json:"mongodb,omitempty"`
	Mqtt               *Mqtt                     `json:"mqtt,omitempty"`
	Mssql              *Mssql                    `json:"mssql,omitempty"`
	Murmur             *Murmur                   `json:"murmur,omitempty"`
	Mysql              *Mysql                    `json:"mysql,omitempty"`
	NatsIo             *NatsIo                   `json:"nats_io,omitempty"`
	Nbd                *Nbd                      `json:"nbd,omitempty"`
	NfsMountd          *NfsMountd                `json:"nfs_mountd,omitempty"`
	Nmea               *Nmea                     `json:"nmea,omitempty"`
	Ntp                *Ntp                      `json:"ntp,omitempty"`
	Ntrip              *Ntrip                    `json:"ntrip,omitempty"`
	Onc                *Onc                      `json:"onc,omitempty"`
	Onvif              *Onvif                    `json:"onvif,omitempty"`
	OpcUa              *OpcUa                    `json:"opc_ua,omitempty"`
	Openvpn            *Openvpn                  `json:"openvpn,omitempty"`
	OperatingSystems   []Attribute               `json:"operating_systems,omitempty"`
	Oracle             *Oracle                   `json:"oracle,omitempty"`
	PcAnywhere         *PcAnywhere               `json:"pc_anywhere,omitempty"`
	Pgbouncer          *Pgbouncer                `json:"pgbouncer,omitempty"`
	Pop3               *Pop3                     `json:"pop3,omitempty"`
	Port               *int                      `json:"port,omitempty"`
	Portmap            *Portmap                  `json:"portmap,omitempty"`
	Postgres           *Postgres                 `json:"postgres,omitempty"`
	Pptp               *Pptp                     `json:"pptp,omitempty"`
	ProfinetCm         *ProfinetCm               `json:"profinet_cm,omitempty"`
	Protocol           *string                   `json:"protocol,omitempty"`
	Rdate              *Rdate                    `json:"rdate,omitempty"`
	Rdp                *Rdp                      `json:"rdp,omitempty"`
	Realport           *Realport                 `json:"realport,omitempty"`
	Redis              *Redis                    `json:"redis,omitempty"`
	Redline            *Redline                  `json:"redline,omitempty"`
	RedlionCrimson     *RedlionCrimson           `json:"redlion_crimson,omitempty"`
	RepresentativeInfo *RepresentativeInfo       `json:"representative_info,omitempty"`
	Rifatron           *Rifatron                 `json:"rifatron,omitempty"`
	Ripple             *Ripple                   `json:"ripple,omitempty"`
	Rlogin             *Rlogin                   `json:"rlogin,omitempty"`
	Rocketmq           *Rocketmq                 `json:"rocketmq,omitempty"`
	Rtsp               *Rtsp                     `json:"rtsp,omitempty"`
	S7                 *S7                       `json:"s7,omitempty"`
	SapRouter          *SapRouter                `json:"sap_router,omitempty"`
	ScanTime           *string                   `json:"scan_time,omitempty"`
	Scpi               *Scpi                     `json:"scpi,omitempty"`
	Screenshots        []Screenshot              `json:"screenshots,omitempty"`
	Ser2net            *Ser2Net                  `json:"ser2net,omitempty"`
	SevenDaysToDie     *SevenDaysToDie           `json:"seven_days_to_die,omitempty"`
	Sip                *Sip                      `json:"sip,omitempty"`
	Skinny             *Skinny                   `json:"skinny,omitempty"`
	Smb                *Smb                      `json:"smb,omitempty"`
	SMTP               *SMTP                     `json:"smtp,omitempty"`
	Snmp               *Snmp                     `json:"snmp,omitempty"`
	Socks              *Socks                    `json:"socks,omitempty"`
	Software           []Attribute               `json:"software,omitempty"`
	Spice              *Spice                    `json:"spice,omitempty"`
	Ssdp               *Ssdp                     `json:"ssdp,omitempty"`
	SSH                *SSH                      `json:"ssh,omitempty"`
	Steam              *Steam                    `json:"steam,omitempty"`
	TacacsPlus         *TacacsPlus               `json:"tacacs_plus,omitempty"`
	TeamViewer         *TeamViewer               `json:"team_viewer,omitempty"`
	Telnet             *Telnet                   `json:"telnet,omitempty"`
	Threats            []Threat                  `json:"threats,omitempty"`
	Tibia              *Tibia                    `json:"tibia,omitempty"`
	TLS                *TLS                      `json:"tls,omitempty"`
	TplinkKasa         *TplinkKasa               `json:"tplink_kasa,omitempty"`
	TransportProtocol  *ServiceTransportProtocol `json:"transport_protocol,omitempty"`
	UnitronicsPcom     *UnitronicsPcom           `json:"unitronics_pcom,omitempty"`
	Upnp               *Upnp                     `json:"upnp,omitempty"`
	Ventrilo           *Ventrilo                 `json:"ventrilo,omitempty"`
	Vnc                *Vnc                      `json:"vnc,omitempty"`
	Vulns              []Vuln                    `json:"vulns,omitempty"`
	WeblogicT3         *WeblogicT3               `json:"weblogic_t3,omitempty"`
	Winrm              *Winrm                    `json:"winrm,omitempty"`
	WsDiscovery        *WsDiscovery              `json:"ws_discovery,omitempty"`
	X11                *X11                      `json:"x11,omitempty"`
	Zeromq             *Zeromq                   `json:"zeromq,omitempty"`
}

func (o *Service) GetActivemq() *Activemq {
	if o == nil {
		return nil
	}
	return o.Activemq
}

func (o *Service) GetAmqp() *Amqp {
	if o == nil {
		return nil
	}
	return o.Amqp
}

func (o *Service) GetAnyConnect() *AnyConnect {
	if o == nil {
		return nil
	}
	return o.AnyConnect
}

func (o *Service) GetBacnet() *Bacnet {
	if o == nil {
		return nil
	}
	return o.Bacnet
}

func (o *Service) GetBanner() *string {
	if o == nil {
		return nil
	}
	return o.Banner
}

func (o *Service) GetBannerHashSha256() *string {
	if o == nil {
		return nil
	}
	return o.BannerHashSha256
}

func (o *Service) GetBannerHex() *string {
	if o == nil {
		return nil
	}
	return o.BannerHex
}

func (o *Service) GetCert() *Certificate {
	if o == nil {
		return nil
	}
	return o.Cert
}

func (o *Service) GetCheckpointTopology() *CheckpointTopology {
	if o == nil {
		return nil
	}
	return o.CheckpointTopology
}

func (o *Service) GetChromecast() *Chromecast {
	if o == nil {
		return nil
	}
	return o.Chromecast
}

func (o *Service) GetCiscoIpsla() *CiscoIpsla {
	if o == nil {
		return nil
	}
	return o.CiscoIpsla
}

func (o *Service) GetCmore() *Cmore {
	if o == nil {
		return nil
	}
	return o.Cmore
}

func (o *Service) GetCoap() *Coap {
	if o == nil {
		return nil
	}
	return o.Coap
}

func (o *Service) GetCrestronCp3() *CrestronCp3 {
	if o == nil {
		return nil
	}
	return o.CrestronCp3
}

func (o *Service) GetCrestronDinAp2() *CrestronDinAp2 {
	if o == nil {
		return nil
	}
	return o.CrestronDinAp2
}

func (o *Service) GetCwmp() *Cwmp {
	if o == nil {
		return nil
	}
	return o.Cwmp
}

func (o *Service) GetDarkcomet() *Darkcomet {
	if o == nil {
		return nil
	}
	return o.Darkcomet
}

func (o *Service) GetDarkgate() *Darkgate {
	if o == nil {
		return nil
	}
	return o.Darkgate
}

func (o *Service) GetDcerpc() *Dcerpc {
	if o == nil {
		return nil
	}
	return o.Dcerpc
}

func (o *Service) GetDhcpdiscover() *Dhcpdiscover {
	if o == nil {
		return nil
	}
	return o.Dhcpdiscover
}

func (o *Service) GetDnp3() *Dnp3 {
	if o == nil {
		return nil
	}
	return o.Dnp3
}

func (o *Service) GetDNS() *DNS {
	if o == nil {
		return nil
	}
	return o.DNS
}

func (o *Service) GetDtls() *Dtls {
	if o == nil {
		return nil
	}
	return o.Dtls
}

func (o *Service) GetDvrIP() *DvrIP {
	if o == nil {
		return nil
	}
	return o.DvrIP
}

func (o *Service) GetEip() *Eip {
	if o == nil {
		return nil
	}
	return o.Eip
}

func (o *Service) GetElfFile() *ElfFile {
	if o == nil {
		return nil
	}
	return o.ElfFile
}

func (o *Service) GetEndpoints() []EndpointScanState {
	if o == nil {
		return nil
	}
	return o.Endpoints
}

func (o *Service) GetEpmd() *Epmd {
	if o == nil {
		return nil
	}
	return o.Epmd
}

func (o *Service) GetEtcd() *Etcd {
	if o == nil {
		return nil
	}
	return o.Etcd
}

func (o *Service) GetEthereum() *Ethereum {
	if o == nil {
		return nil
	}
	return o.Ethereum
}

func (o *Service) GetExposures() []Risk {
	if o == nil {
		return nil
	}
	return o.Exposures
}

func (o *Service) GetFox() *Fox {
	if o == nil {
		return nil
	}
	return o.Fox
}

func (o *Service) GetFtp() *Ftp {
	if o == nil {
		return nil
	}
	return o.Ftp
}

func (o *Service) GetGearman() *Gearman {
	if o == nil {
		return nil
	}
	return o.Gearman
}

func (o *Service) GetHardware() []Attribute {
	if o == nil {
		return nil
	}
	return o.Hardware
}

func (o *Service) GetHidVertx() *HidVertx {
	if o == nil {
		return nil
	}
	return o.HidVertx
}

func (o *Service) GetHikvision() *Hikvision {
	if o == nil {
		return nil
	}
	return o.Hikvision
}

func (o *Service) GetIbmnje() *Ibmnje {
	if o == nil {
		return nil
	}
	return o.Ibmnje
}

func (o *Service) GetIke() *Ike {
	if o == nil {
		return nil
	}
	return o.Ike
}

func (o *Service) GetImap() *Imap {
	if o == nil {
		return nil
	}
	return o.Imap
}

func (o *Service) GetIota() *Iota {
	if o == nil {
		return nil
	}
	return o.Iota
}

func (o *Service) GetIP() *string {
	if o == nil {
		return nil
	}
	return o.IP
}

func (o *Service) GetIpmi() *Ipmi {
	if o == nil {
		return nil
	}
	return o.Ipmi
}

func (o *Service) GetIpp() *Ipp {
	if o == nil {
		return nil
	}
	return o.Ipp
}

func (o *Service) GetIscsi() *Iscsi {
	if o == nil {
		return nil
	}
	return o.Iscsi
}

func (o *Service) GetJa4tscan() *Ja4TScanScan {
	if o == nil {
		return nil
	}
	return o.Ja4tscan
}

func (o *Service) GetJarm() *JarmScan {
	if o == nil {
		return nil
	}
	return o.Jarm
}

func (o *Service) GetKrpc() *Krpc {
	if o == nil {
		return nil
	}
	return o.Krpc
}

func (o *Service) GetL2tp() *L2Tp {
	if o == nil {
		return nil
	}
	return o.L2tp
}

func (o *Service) GetLabels() []Label {
	if o == nil {
		return nil
	}
	return o.Labels
}

func (o *Service) GetLdap() *Ldap {
	if o == nil {
		return nil
	}
	return o.Ldap
}

func (o *Service) GetLpd() *Lpd {
	if o == nil {
		return nil
	}
	return o.Lpd
}

func (o *Service) GetMdns() *Mdns {
	if o == nil {
		return nil
	}
	return o.Mdns
}

func (o *Service) GetMemcached() *Memcached {
	if o == nil {
		return nil
	}
	return o.Memcached
}

func (o *Service) GetMinecraft() *Minecraft {
	if o == nil {
		return nil
	}
	return o.Minecraft
}

func (o *Service) GetMisconfigs() []Risk {
	if o == nil {
		return nil
	}
	return o.Misconfigs
}

func (o *Service) GetMms() *Mms {
	if o == nil {
		return nil
	}
	return o.Mms
}

func (o *Service) GetModbus() *Modbus {
	if o == nil {
		return nil
	}
	return o.Modbus
}

func (o *Service) GetMoneroP2p() *MoneroP2P {
	if o == nil {
		return nil
	}
	return o.MoneroP2p
}

func (o *Service) GetMongodb() *Mongodb {
	if o == nil {
		return nil
	}
	return o.Mongodb
}

func (o *Service) GetMqtt() *Mqtt {
	if o == nil {
		return nil
	}
	return o.Mqtt
}

func (o *Service) GetMssql() *Mssql {
	if o == nil {
		return nil
	}
	return o.Mssql
}

func (o *Service) GetMurmur() *Murmur {
	if o == nil {
		return nil
	}
	return o.Murmur
}

func (o *Service) GetMysql() *Mysql {
	if o == nil {
		return nil
	}
	return o.Mysql
}

func (o *Service) GetNatsIo() *NatsIo {
	if o == nil {
		return nil
	}
	return o.NatsIo
}

func (o *Service) GetNbd() *Nbd {
	if o == nil {
		return nil
	}
	return o.Nbd
}

func (o *Service) GetNfsMountd() *NfsMountd {
	if o == nil {
		return nil
	}
	return o.NfsMountd
}

func (o *Service) GetNmea() *Nmea {
	if o == nil {
		return nil
	}
	return o.Nmea
}

func (o *Service) GetNtp() *Ntp {
	if o == nil {
		return nil
	}
	return o.Ntp
}

func (o *Service) GetNtrip() *Ntrip {
	if o == nil {
		return nil
	}
	return o.Ntrip
}

func (o *Service) GetOnc() *Onc {
	if o == nil {
		return nil
	}
	return o.Onc
}

func (o *Service) GetOnvif() *Onvif {
	if o == nil {
		return nil
	}
	return o.Onvif
}

func (o *Service) GetOpcUa() *OpcUa {
	if o == nil {
		return nil
	}
	return o.OpcUa
}

func (o *Service) GetOpenvpn() *Openvpn {
	if o == nil {
		return nil
	}
	return o.Openvpn
}

func (o *Service) GetOperatingSystems() []Attribute {
	if o == nil {
		return nil
	}
	return o.OperatingSystems
}

func (o *Service) GetOracle() *Oracle {
	if o == nil {
		return nil
	}
	return o.Oracle
}

func (o *Service) GetPcAnywhere() *PcAnywhere {
	if o == nil {
		return nil
	}
	return o.PcAnywhere
}

func (o *Service) GetPgbouncer() *Pgbouncer {
	if o == nil {
		return nil
	}
	return o.Pgbouncer
}

func (o *Service) GetPop3() *Pop3 {
	if o == nil {
		return nil
	}
	return o.Pop3
}

func (o *Service) GetPort() *int {
	if o == nil {
		return nil
	}
	return o.Port
}

func (o *Service) GetPortmap() *Portmap {
	if o == nil {
		return nil
	}
	return o.Portmap
}

func (o *Service) GetPostgres() *Postgres {
	if o == nil {
		return nil
	}
	return o.Postgres
}

func (o *Service) GetPptp() *Pptp {
	if o == nil {
		return nil
	}
	return o.Pptp
}

func (o *Service) GetProfinetCm() *ProfinetCm {
	if o == nil {
		return nil
	}
	return o.ProfinetCm
}

func (o *Service) GetProtocol() *string {
	if o == nil {
		return nil
	}
	return o.Protocol
}

func (o *Service) GetRdate() *Rdate {
	if o == nil {
		return nil
	}
	return o.Rdate
}

func (o *Service) GetRdp() *Rdp {
	if o == nil {
		return nil
	}
	return o.Rdp
}

func (o *Service) GetRealport() *Realport {
	if o == nil {
		return nil
	}
	return o.Realport
}

func (o *Service) GetRedis() *Redis {
	if o == nil {
		return nil
	}
	return o.Redis
}

func (o *Service) GetRedline() *Redline {
	if o == nil {
		return nil
	}
	return o.Redline
}

func (o *Service) GetRedlionCrimson() *RedlionCrimson {
	if o == nil {
		return nil
	}
	return o.RedlionCrimson
}

func (o *Service) GetRepresentativeInfo() *RepresentativeInfo {
	if o == nil {
		return nil
	}
	return o.RepresentativeInfo
}

func (o *Service) GetRifatron() *Rifatron {
	if o == nil {
		return nil
	}
	return o.Rifatron
}

func (o *Service) GetRipple() *Ripple {
	if o == nil {
		return nil
	}
	return o.Ripple
}

func (o *Service) GetRlogin() *Rlogin {
	if o == nil {
		return nil
	}
	return o.Rlogin
}

func (o *Service) GetRocketmq() *Rocketmq {
	if o == nil {
		return nil
	}
	return o.Rocketmq
}

func (o *Service) GetRtsp() *Rtsp {
	if o == nil {
		return nil
	}
	return o.Rtsp
}

func (o *Service) GetS7() *S7 {
	if o == nil {
		return nil
	}
	return o.S7
}

func (o *Service) GetSapRouter() *SapRouter {
	if o == nil {
		return nil
	}
	return o.SapRouter
}

func (o *Service) GetScanTime() *string {
	if o == nil {
		return nil
	}
	return o.ScanTime
}

func (o *Service) GetScpi() *Scpi {
	if o == nil {
		return nil
	}
	return o.Scpi
}

func (o *Service) GetScreenshots() []Screenshot {
	if o == nil {
		return nil
	}
	return o.Screenshots
}

func (o *Service) GetSer2net() *Ser2Net {
	if o == nil {
		return nil
	}
	return o.Ser2net
}

func (o *Service) GetSevenDaysToDie() *SevenDaysToDie {
	if o == nil {
		return nil
	}
	return o.SevenDaysToDie
}

func (o *Service) GetSip() *Sip {
	if o == nil {
		return nil
	}
	return o.Sip
}

func (o *Service) GetSkinny() *Skinny {
	if o == nil {
		return nil
	}
	return o.Skinny
}

func (o *Service) GetSmb() *Smb {
	if o == nil {
		return nil
	}
	return o.Smb
}

func (o *Service) GetSMTP() *SMTP {
	if o == nil {
		return nil
	}
	return o.SMTP
}

func (o *Service) GetSnmp() *Snmp {
	if o == nil {
		return nil
	}
	return o.Snmp
}

func (o *Service) GetSocks() *Socks {
	if o == nil {
		return nil
	}
	return o.Socks
}

func (o *Service) GetSoftware() []Attribute {
	if o == nil {
		return nil
	}
	return o.Software
}

func (o *Service) GetSpice() *Spice {
	if o == nil {
		return nil
	}
	return o.Spice
}

func (o *Service) GetSsdp() *Ssdp {
	if o == nil {
		return nil
	}
	return o.Ssdp
}

func (o *Service) GetSSH() *SSH {
	if o == nil {
		return nil
	}
	return o.SSH
}

func (o *Service) GetSteam() *Steam {
	if o == nil {
		return nil
	}
	return o.Steam
}

func (o *Service) GetTacacsPlus() *TacacsPlus {
	if o == nil {
		return nil
	}
	return o.TacacsPlus
}

func (o *Service) GetTeamViewer() *TeamViewer {
	if o == nil {
		return nil
	}
	return o.TeamViewer
}

func (o *Service) GetTelnet() *Telnet {
	if o == nil {
		return nil
	}
	return o.Telnet
}

func (o *Service) GetThreats() []Threat {
	if o == nil {
		return nil
	}
	return o.Threats
}

func (o *Service) GetTibia() *Tibia {
	if o == nil {
		return nil
	}
	return o.Tibia
}

func (o *Service) GetTLS() *TLS {
	if o == nil {
		return nil
	}
	return o.TLS
}

func (o *Service) GetTplinkKasa() *TplinkKasa {
	if o == nil {
		return nil
	}
	return o.TplinkKasa
}

func (o *Service) GetTransportProtocol() *ServiceTransportProtocol {
	if o == nil {
		return nil
	}
	return o.TransportProtocol
}

func (o *Service) GetUnitronicsPcom() *UnitronicsPcom {
	if o == nil {
		return nil
	}
	return o.UnitronicsPcom
}

func (o *Service) GetUpnp() *Upnp {
	if o == nil {
		return nil
	}
	return o.Upnp
}

func (o *Service) GetVentrilo() *Ventrilo {
	if o == nil {
		return nil
	}
	return o.Ventrilo
}

func (o *Service) GetVnc() *Vnc {
	if o == nil {
		return nil
	}
	return o.Vnc
}

func (o *Service) GetVulns() []Vuln {
	if o == nil {
		return nil
	}
	return o.Vulns
}

func (o *Service) GetWeblogicT3() *WeblogicT3 {
	if o == nil {
		return nil
	}
	return o.WeblogicT3
}

func (o *Service) GetWinrm() *Winrm {
	if o == nil {
		return nil
	}
	return o.Winrm
}

func (o *Service) GetWsDiscovery() *WsDiscovery {
	if o == nil {
		return nil
	}
	return o.WsDiscovery
}

func (o *Service) GetX11() *X11 {
	if o == nil {
		return nil
	}
	return o.X11
}

func (o *Service) GetZeromq() *Zeromq {
	if o == nil {
		return nil
	}
	return o.Zeromq
}
