// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssmcontacts

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAcceptPage = "AcceptPage"

// AcceptPageRequest generates a "aws/request.Request" representing the
// client's request for the AcceptPage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptPage for more information on using the AcceptPage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptPageRequest method.
//	req, resp := client.AcceptPageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/AcceptPage
func (c *SSMContacts) AcceptPageRequest(input *AcceptPageInput) (req *request.Request, output *AcceptPageOutput) {
	op := &request.Operation{
		Name:       opAcceptPage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptPageInput{}
	}

	output = &AcceptPageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AcceptPage API operation for AWS Systems Manager Incident Manager Contacts.
//
// Used to acknowledge an engagement to a contact channel during an incident.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation AcceptPage for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/AcceptPage
func (c *SSMContacts) AcceptPage(input *AcceptPageInput) (*AcceptPageOutput, error) {
	req, out := c.AcceptPageRequest(input)
	return out, req.Send()
}

// AcceptPageWithContext is the same as AcceptPage with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptPage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) AcceptPageWithContext(ctx aws.Context, input *AcceptPageInput, opts ...request.Option) (*AcceptPageOutput, error) {
	req, out := c.AcceptPageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opActivateContactChannel = "ActivateContactChannel"

// ActivateContactChannelRequest generates a "aws/request.Request" representing the
// client's request for the ActivateContactChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ActivateContactChannel for more information on using the ActivateContactChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ActivateContactChannelRequest method.
//	req, resp := client.ActivateContactChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ActivateContactChannel
func (c *SSMContacts) ActivateContactChannelRequest(input *ActivateContactChannelInput) (req *request.Request, output *ActivateContactChannelOutput) {
	op := &request.Operation{
		Name:       opActivateContactChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ActivateContactChannelInput{}
	}

	output = &ActivateContactChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ActivateContactChannel API operation for AWS Systems Manager Incident Manager Contacts.
//
// Activates a contact's contact channel. Incident Manager can't engage a contact
// until the contact channel has been activated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation ActivateContactChannel for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ActivateContactChannel
func (c *SSMContacts) ActivateContactChannel(input *ActivateContactChannelInput) (*ActivateContactChannelOutput, error) {
	req, out := c.ActivateContactChannelRequest(input)
	return out, req.Send()
}

// ActivateContactChannelWithContext is the same as ActivateContactChannel with the addition of
// the ability to pass a context and additional request options.
//
// See ActivateContactChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ActivateContactChannelWithContext(ctx aws.Context, input *ActivateContactChannelInput, opts ...request.Option) (*ActivateContactChannelOutput, error) {
	req, out := c.ActivateContactChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateContact = "CreateContact"

// CreateContactRequest generates a "aws/request.Request" representing the
// client's request for the CreateContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateContact for more information on using the CreateContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateContactRequest method.
//	req, resp := client.CreateContactRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/CreateContact
func (c *SSMContacts) CreateContactRequest(input *CreateContactInput) (req *request.Request, output *CreateContactOutput) {
	op := &request.Operation{
		Name:       opCreateContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateContactInput{}
	}

	output = &CreateContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateContact API operation for AWS Systems Manager Incident Manager Contacts.
//
// Contacts are either the contacts that Incident Manager engages during an
// incident or the escalation plans that Incident Manager uses to engage contacts
// in phases during an incident.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation CreateContact for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/CreateContact
func (c *SSMContacts) CreateContact(input *CreateContactInput) (*CreateContactOutput, error) {
	req, out := c.CreateContactRequest(input)
	return out, req.Send()
}

// CreateContactWithContext is the same as CreateContact with the addition of
// the ability to pass a context and additional request options.
//
// See CreateContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) CreateContactWithContext(ctx aws.Context, input *CreateContactInput, opts ...request.Option) (*CreateContactOutput, error) {
	req, out := c.CreateContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateContactChannel = "CreateContactChannel"

// CreateContactChannelRequest generates a "aws/request.Request" representing the
// client's request for the CreateContactChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateContactChannel for more information on using the CreateContactChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateContactChannelRequest method.
//	req, resp := client.CreateContactChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/CreateContactChannel
func (c *SSMContacts) CreateContactChannelRequest(input *CreateContactChannelInput) (req *request.Request, output *CreateContactChannelOutput) {
	op := &request.Operation{
		Name:       opCreateContactChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateContactChannelInput{}
	}

	output = &CreateContactChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateContactChannel API operation for AWS Systems Manager Incident Manager Contacts.
//
// A contact channel is the method that Incident Manager uses to engage your
// contact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation CreateContactChannel for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/CreateContactChannel
func (c *SSMContacts) CreateContactChannel(input *CreateContactChannelInput) (*CreateContactChannelOutput, error) {
	req, out := c.CreateContactChannelRequest(input)
	return out, req.Send()
}

// CreateContactChannelWithContext is the same as CreateContactChannel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateContactChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) CreateContactChannelWithContext(ctx aws.Context, input *CreateContactChannelInput, opts ...request.Option) (*CreateContactChannelOutput, error) {
	req, out := c.CreateContactChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRotation = "CreateRotation"

// CreateRotationRequest generates a "aws/request.Request" representing the
// client's request for the CreateRotation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRotation for more information on using the CreateRotation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRotationRequest method.
//	req, resp := client.CreateRotationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/CreateRotation
func (c *SSMContacts) CreateRotationRequest(input *CreateRotationInput) (req *request.Request, output *CreateRotationOutput) {
	op := &request.Operation{
		Name:       opCreateRotation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRotationInput{}
	}

	output = &CreateRotationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRotation API operation for AWS Systems Manager Incident Manager Contacts.
//
// Creates a rotation in an on-call schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation CreateRotation for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/CreateRotation
func (c *SSMContacts) CreateRotation(input *CreateRotationInput) (*CreateRotationOutput, error) {
	req, out := c.CreateRotationRequest(input)
	return out, req.Send()
}

// CreateRotationWithContext is the same as CreateRotation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRotation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) CreateRotationWithContext(ctx aws.Context, input *CreateRotationInput, opts ...request.Option) (*CreateRotationOutput, error) {
	req, out := c.CreateRotationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRotationOverride = "CreateRotationOverride"

// CreateRotationOverrideRequest generates a "aws/request.Request" representing the
// client's request for the CreateRotationOverride operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRotationOverride for more information on using the CreateRotationOverride
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRotationOverrideRequest method.
//	req, resp := client.CreateRotationOverrideRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/CreateRotationOverride
func (c *SSMContacts) CreateRotationOverrideRequest(input *CreateRotationOverrideInput) (req *request.Request, output *CreateRotationOverrideOutput) {
	op := &request.Operation{
		Name:       opCreateRotationOverride,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRotationOverrideInput{}
	}

	output = &CreateRotationOverrideOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRotationOverride API operation for AWS Systems Manager Incident Manager Contacts.
//
// Creates an override for a rotation in an on-call schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation CreateRotationOverride for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/CreateRotationOverride
func (c *SSMContacts) CreateRotationOverride(input *CreateRotationOverrideInput) (*CreateRotationOverrideOutput, error) {
	req, out := c.CreateRotationOverrideRequest(input)
	return out, req.Send()
}

// CreateRotationOverrideWithContext is the same as CreateRotationOverride with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRotationOverride for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) CreateRotationOverrideWithContext(ctx aws.Context, input *CreateRotationOverrideInput, opts ...request.Option) (*CreateRotationOverrideOutput, error) {
	req, out := c.CreateRotationOverrideRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeactivateContactChannel = "DeactivateContactChannel"

// DeactivateContactChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeactivateContactChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeactivateContactChannel for more information on using the DeactivateContactChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeactivateContactChannelRequest method.
//	req, resp := client.DeactivateContactChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeactivateContactChannel
func (c *SSMContacts) DeactivateContactChannelRequest(input *DeactivateContactChannelInput) (req *request.Request, output *DeactivateContactChannelOutput) {
	op := &request.Operation{
		Name:       opDeactivateContactChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeactivateContactChannelInput{}
	}

	output = &DeactivateContactChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeactivateContactChannel API operation for AWS Systems Manager Incident Manager Contacts.
//
// To no longer receive Incident Manager engagements to a contact channel, you
// can deactivate the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation DeactivateContactChannel for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeactivateContactChannel
func (c *SSMContacts) DeactivateContactChannel(input *DeactivateContactChannelInput) (*DeactivateContactChannelOutput, error) {
	req, out := c.DeactivateContactChannelRequest(input)
	return out, req.Send()
}

// DeactivateContactChannelWithContext is the same as DeactivateContactChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeactivateContactChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) DeactivateContactChannelWithContext(ctx aws.Context, input *DeactivateContactChannelInput, opts ...request.Option) (*DeactivateContactChannelOutput, error) {
	req, out := c.DeactivateContactChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteContact = "DeleteContact"

// DeleteContactRequest generates a "aws/request.Request" representing the
// client's request for the DeleteContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteContact for more information on using the DeleteContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteContactRequest method.
//	req, resp := client.DeleteContactRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeleteContact
func (c *SSMContacts) DeleteContactRequest(input *DeleteContactInput) (req *request.Request, output *DeleteContactOutput) {
	op := &request.Operation{
		Name:       opDeleteContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteContactInput{}
	}

	output = &DeleteContactOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteContact API operation for AWS Systems Manager Incident Manager Contacts.
//
// To remove a contact from Incident Manager, you can delete the contact. Deleting
// a contact removes them from all escalation plans and related response plans.
// Deleting an escalation plan removes it from all related response plans. You
// will have to recreate the contact and its contact channels before you can
// use it again.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation DeleteContact for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeleteContact
func (c *SSMContacts) DeleteContact(input *DeleteContactInput) (*DeleteContactOutput, error) {
	req, out := c.DeleteContactRequest(input)
	return out, req.Send()
}

// DeleteContactWithContext is the same as DeleteContact with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) DeleteContactWithContext(ctx aws.Context, input *DeleteContactInput, opts ...request.Option) (*DeleteContactOutput, error) {
	req, out := c.DeleteContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteContactChannel = "DeleteContactChannel"

// DeleteContactChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteContactChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteContactChannel for more information on using the DeleteContactChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteContactChannelRequest method.
//	req, resp := client.DeleteContactChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeleteContactChannel
func (c *SSMContacts) DeleteContactChannelRequest(input *DeleteContactChannelInput) (req *request.Request, output *DeleteContactChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteContactChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteContactChannelInput{}
	}

	output = &DeleteContactChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteContactChannel API operation for AWS Systems Manager Incident Manager Contacts.
//
// To no longer receive engagements on a contact channel, you can delete the
// channel from a contact. Deleting the contact channel removes it from the
// contact's engagement plan. If you delete the only contact channel for a contact,
// you won't be able to engage that contact during an incident.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation DeleteContactChannel for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeleteContactChannel
func (c *SSMContacts) DeleteContactChannel(input *DeleteContactChannelInput) (*DeleteContactChannelOutput, error) {
	req, out := c.DeleteContactChannelRequest(input)
	return out, req.Send()
}

// DeleteContactChannelWithContext is the same as DeleteContactChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteContactChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) DeleteContactChannelWithContext(ctx aws.Context, input *DeleteContactChannelInput, opts ...request.Option) (*DeleteContactChannelOutput, error) {
	req, out := c.DeleteContactChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRotation = "DeleteRotation"

// DeleteRotationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRotation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRotation for more information on using the DeleteRotation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRotationRequest method.
//	req, resp := client.DeleteRotationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeleteRotation
func (c *SSMContacts) DeleteRotationRequest(input *DeleteRotationInput) (req *request.Request, output *DeleteRotationOutput) {
	op := &request.Operation{
		Name:       opDeleteRotation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRotationInput{}
	}

	output = &DeleteRotationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRotation API operation for AWS Systems Manager Incident Manager Contacts.
//
// Deletes a rotation from the system. If a rotation belongs to more than one
// on-call schedule, this operation deletes it from all of them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation DeleteRotation for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeleteRotation
func (c *SSMContacts) DeleteRotation(input *DeleteRotationInput) (*DeleteRotationOutput, error) {
	req, out := c.DeleteRotationRequest(input)
	return out, req.Send()
}

// DeleteRotationWithContext is the same as DeleteRotation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRotation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) DeleteRotationWithContext(ctx aws.Context, input *DeleteRotationInput, opts ...request.Option) (*DeleteRotationOutput, error) {
	req, out := c.DeleteRotationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRotationOverride = "DeleteRotationOverride"

// DeleteRotationOverrideRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRotationOverride operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRotationOverride for more information on using the DeleteRotationOverride
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRotationOverrideRequest method.
//	req, resp := client.DeleteRotationOverrideRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeleteRotationOverride
func (c *SSMContacts) DeleteRotationOverrideRequest(input *DeleteRotationOverrideInput) (req *request.Request, output *DeleteRotationOverrideOutput) {
	op := &request.Operation{
		Name:       opDeleteRotationOverride,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRotationOverrideInput{}
	}

	output = &DeleteRotationOverrideOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRotationOverride API operation for AWS Systems Manager Incident Manager Contacts.
//
// Deletes an existing override for an on-call rotation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation DeleteRotationOverride for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeleteRotationOverride
func (c *SSMContacts) DeleteRotationOverride(input *DeleteRotationOverrideInput) (*DeleteRotationOverrideOutput, error) {
	req, out := c.DeleteRotationOverrideRequest(input)
	return out, req.Send()
}

// DeleteRotationOverrideWithContext is the same as DeleteRotationOverride with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRotationOverride for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) DeleteRotationOverrideWithContext(ctx aws.Context, input *DeleteRotationOverrideInput, opts ...request.Option) (*DeleteRotationOverrideOutput, error) {
	req, out := c.DeleteRotationOverrideRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEngagement = "DescribeEngagement"

// DescribeEngagementRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEngagement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEngagement for more information on using the DescribeEngagement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEngagementRequest method.
//	req, resp := client.DescribeEngagementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DescribeEngagement
func (c *SSMContacts) DescribeEngagementRequest(input *DescribeEngagementInput) (req *request.Request, output *DescribeEngagementOutput) {
	op := &request.Operation{
		Name:       opDescribeEngagement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEngagementInput{}
	}

	output = &DescribeEngagementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEngagement API operation for AWS Systems Manager Incident Manager Contacts.
//
// Incident Manager uses engagements to engage contacts and escalation plans
// during an incident. Use this command to describe the engagement that occurred
// during an incident.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation DescribeEngagement for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DescribeEngagement
func (c *SSMContacts) DescribeEngagement(input *DescribeEngagementInput) (*DescribeEngagementOutput, error) {
	req, out := c.DescribeEngagementRequest(input)
	return out, req.Send()
}

// DescribeEngagementWithContext is the same as DescribeEngagement with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEngagement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) DescribeEngagementWithContext(ctx aws.Context, input *DescribeEngagementInput, opts ...request.Option) (*DescribeEngagementOutput, error) {
	req, out := c.DescribeEngagementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePage = "DescribePage"

// DescribePageRequest generates a "aws/request.Request" representing the
// client's request for the DescribePage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePage for more information on using the DescribePage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePageRequest method.
//	req, resp := client.DescribePageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DescribePage
func (c *SSMContacts) DescribePageRequest(input *DescribePageInput) (req *request.Request, output *DescribePageOutput) {
	op := &request.Operation{
		Name:       opDescribePage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePageInput{}
	}

	output = &DescribePageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePage API operation for AWS Systems Manager Incident Manager Contacts.
//
// Lists details of the engagement to a contact channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation DescribePage for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DescribePage
func (c *SSMContacts) DescribePage(input *DescribePageInput) (*DescribePageOutput, error) {
	req, out := c.DescribePageRequest(input)
	return out, req.Send()
}

// DescribePageWithContext is the same as DescribePage with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) DescribePageWithContext(ctx aws.Context, input *DescribePageInput, opts ...request.Option) (*DescribePageOutput, error) {
	req, out := c.DescribePageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContact = "GetContact"

// GetContactRequest generates a "aws/request.Request" representing the
// client's request for the GetContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContact for more information on using the GetContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetContactRequest method.
//	req, resp := client.GetContactRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetContact
func (c *SSMContacts) GetContactRequest(input *GetContactInput) (req *request.Request, output *GetContactOutput) {
	op := &request.Operation{
		Name:       opGetContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContactInput{}
	}

	output = &GetContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContact API operation for AWS Systems Manager Incident Manager Contacts.
//
// Retrieves information about the specified contact or escalation plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation GetContact for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetContact
func (c *SSMContacts) GetContact(input *GetContactInput) (*GetContactOutput, error) {
	req, out := c.GetContactRequest(input)
	return out, req.Send()
}

// GetContactWithContext is the same as GetContact with the addition of
// the ability to pass a context and additional request options.
//
// See GetContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) GetContactWithContext(ctx aws.Context, input *GetContactInput, opts ...request.Option) (*GetContactOutput, error) {
	req, out := c.GetContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContactChannel = "GetContactChannel"

// GetContactChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetContactChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContactChannel for more information on using the GetContactChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetContactChannelRequest method.
//	req, resp := client.GetContactChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetContactChannel
func (c *SSMContacts) GetContactChannelRequest(input *GetContactChannelInput) (req *request.Request, output *GetContactChannelOutput) {
	op := &request.Operation{
		Name:       opGetContactChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContactChannelInput{}
	}

	output = &GetContactChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContactChannel API operation for AWS Systems Manager Incident Manager Contacts.
//
// List details about a specific contact channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation GetContactChannel for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetContactChannel
func (c *SSMContacts) GetContactChannel(input *GetContactChannelInput) (*GetContactChannelOutput, error) {
	req, out := c.GetContactChannelRequest(input)
	return out, req.Send()
}

// GetContactChannelWithContext is the same as GetContactChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetContactChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) GetContactChannelWithContext(ctx aws.Context, input *GetContactChannelInput, opts ...request.Option) (*GetContactChannelOutput, error) {
	req, out := c.GetContactChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContactPolicy = "GetContactPolicy"

// GetContactPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetContactPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContactPolicy for more information on using the GetContactPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetContactPolicyRequest method.
//	req, resp := client.GetContactPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetContactPolicy
func (c *SSMContacts) GetContactPolicyRequest(input *GetContactPolicyInput) (req *request.Request, output *GetContactPolicyOutput) {
	op := &request.Operation{
		Name:       opGetContactPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContactPolicyInput{}
	}

	output = &GetContactPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContactPolicy API operation for AWS Systems Manager Incident Manager Contacts.
//
// Retrieves the resource policies attached to the specified contact or escalation
// plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation GetContactPolicy for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetContactPolicy
func (c *SSMContacts) GetContactPolicy(input *GetContactPolicyInput) (*GetContactPolicyOutput, error) {
	req, out := c.GetContactPolicyRequest(input)
	return out, req.Send()
}

// GetContactPolicyWithContext is the same as GetContactPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetContactPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) GetContactPolicyWithContext(ctx aws.Context, input *GetContactPolicyInput, opts ...request.Option) (*GetContactPolicyOutput, error) {
	req, out := c.GetContactPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRotation = "GetRotation"

// GetRotationRequest generates a "aws/request.Request" representing the
// client's request for the GetRotation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRotation for more information on using the GetRotation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRotationRequest method.
//	req, resp := client.GetRotationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetRotation
func (c *SSMContacts) GetRotationRequest(input *GetRotationInput) (req *request.Request, output *GetRotationOutput) {
	op := &request.Operation{
		Name:       opGetRotation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRotationInput{}
	}

	output = &GetRotationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRotation API operation for AWS Systems Manager Incident Manager Contacts.
//
// Retrieves information about an on-call rotation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation GetRotation for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetRotation
func (c *SSMContacts) GetRotation(input *GetRotationInput) (*GetRotationOutput, error) {
	req, out := c.GetRotationRequest(input)
	return out, req.Send()
}

// GetRotationWithContext is the same as GetRotation with the addition of
// the ability to pass a context and additional request options.
//
// See GetRotation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) GetRotationWithContext(ctx aws.Context, input *GetRotationInput, opts ...request.Option) (*GetRotationOutput, error) {
	req, out := c.GetRotationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRotationOverride = "GetRotationOverride"

// GetRotationOverrideRequest generates a "aws/request.Request" representing the
// client's request for the GetRotationOverride operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRotationOverride for more information on using the GetRotationOverride
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRotationOverrideRequest method.
//	req, resp := client.GetRotationOverrideRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetRotationOverride
func (c *SSMContacts) GetRotationOverrideRequest(input *GetRotationOverrideInput) (req *request.Request, output *GetRotationOverrideOutput) {
	op := &request.Operation{
		Name:       opGetRotationOverride,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRotationOverrideInput{}
	}

	output = &GetRotationOverrideOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRotationOverride API operation for AWS Systems Manager Incident Manager Contacts.
//
// Retrieves information about an override to an on-call rotation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation GetRotationOverride for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetRotationOverride
func (c *SSMContacts) GetRotationOverride(input *GetRotationOverrideInput) (*GetRotationOverrideOutput, error) {
	req, out := c.GetRotationOverrideRequest(input)
	return out, req.Send()
}

// GetRotationOverrideWithContext is the same as GetRotationOverride with the addition of
// the ability to pass a context and additional request options.
//
// See GetRotationOverride for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) GetRotationOverrideWithContext(ctx aws.Context, input *GetRotationOverrideInput, opts ...request.Option) (*GetRotationOverrideOutput, error) {
	req, out := c.GetRotationOverrideRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListContactChannels = "ListContactChannels"

// ListContactChannelsRequest generates a "aws/request.Request" representing the
// client's request for the ListContactChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListContactChannels for more information on using the ListContactChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListContactChannelsRequest method.
//	req, resp := client.ListContactChannelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListContactChannels
func (c *SSMContacts) ListContactChannelsRequest(input *ListContactChannelsInput) (req *request.Request, output *ListContactChannelsOutput) {
	op := &request.Operation{
		Name:       opListContactChannels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListContactChannelsInput{}
	}

	output = &ListContactChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListContactChannels API operation for AWS Systems Manager Incident Manager Contacts.
//
// Lists all contact channels for the specified contact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation ListContactChannels for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListContactChannels
func (c *SSMContacts) ListContactChannels(input *ListContactChannelsInput) (*ListContactChannelsOutput, error) {
	req, out := c.ListContactChannelsRequest(input)
	return out, req.Send()
}

// ListContactChannelsWithContext is the same as ListContactChannels with the addition of
// the ability to pass a context and additional request options.
//
// See ListContactChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListContactChannelsWithContext(ctx aws.Context, input *ListContactChannelsInput, opts ...request.Option) (*ListContactChannelsOutput, error) {
	req, out := c.ListContactChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListContactChannelsPages iterates over the pages of a ListContactChannels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListContactChannels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListContactChannels operation.
//	pageNum := 0
//	err := client.ListContactChannelsPages(params,
//	    func(page *ssmcontacts.ListContactChannelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMContacts) ListContactChannelsPages(input *ListContactChannelsInput, fn func(*ListContactChannelsOutput, bool) bool) error {
	return c.ListContactChannelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListContactChannelsPagesWithContext same as ListContactChannelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListContactChannelsPagesWithContext(ctx aws.Context, input *ListContactChannelsInput, fn func(*ListContactChannelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListContactChannelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListContactChannelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListContactChannelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListContacts = "ListContacts"

// ListContactsRequest generates a "aws/request.Request" representing the
// client's request for the ListContacts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListContacts for more information on using the ListContacts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListContactsRequest method.
//	req, resp := client.ListContactsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListContacts
func (c *SSMContacts) ListContactsRequest(input *ListContactsInput) (req *request.Request, output *ListContactsOutput) {
	op := &request.Operation{
		Name:       opListContacts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListContactsInput{}
	}

	output = &ListContactsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListContacts API operation for AWS Systems Manager Incident Manager Contacts.
//
// Lists all contacts and escalation plans in Incident Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation ListContacts for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListContacts
func (c *SSMContacts) ListContacts(input *ListContactsInput) (*ListContactsOutput, error) {
	req, out := c.ListContactsRequest(input)
	return out, req.Send()
}

// ListContactsWithContext is the same as ListContacts with the addition of
// the ability to pass a context and additional request options.
//
// See ListContacts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListContactsWithContext(ctx aws.Context, input *ListContactsInput, opts ...request.Option) (*ListContactsOutput, error) {
	req, out := c.ListContactsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListContactsPages iterates over the pages of a ListContacts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListContacts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListContacts operation.
//	pageNum := 0
//	err := client.ListContactsPages(params,
//	    func(page *ssmcontacts.ListContactsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMContacts) ListContactsPages(input *ListContactsInput, fn func(*ListContactsOutput, bool) bool) error {
	return c.ListContactsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListContactsPagesWithContext same as ListContactsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListContactsPagesWithContext(ctx aws.Context, input *ListContactsInput, fn func(*ListContactsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListContactsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListContactsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListContactsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEngagements = "ListEngagements"

// ListEngagementsRequest generates a "aws/request.Request" representing the
// client's request for the ListEngagements operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEngagements for more information on using the ListEngagements
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEngagementsRequest method.
//	req, resp := client.ListEngagementsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListEngagements
func (c *SSMContacts) ListEngagementsRequest(input *ListEngagementsInput) (req *request.Request, output *ListEngagementsOutput) {
	op := &request.Operation{
		Name:       opListEngagements,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEngagementsInput{}
	}

	output = &ListEngagementsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEngagements API operation for AWS Systems Manager Incident Manager Contacts.
//
// Lists all engagements that have happened in an incident.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation ListEngagements for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListEngagements
func (c *SSMContacts) ListEngagements(input *ListEngagementsInput) (*ListEngagementsOutput, error) {
	req, out := c.ListEngagementsRequest(input)
	return out, req.Send()
}

// ListEngagementsWithContext is the same as ListEngagements with the addition of
// the ability to pass a context and additional request options.
//
// See ListEngagements for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListEngagementsWithContext(ctx aws.Context, input *ListEngagementsInput, opts ...request.Option) (*ListEngagementsOutput, error) {
	req, out := c.ListEngagementsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEngagementsPages iterates over the pages of a ListEngagements operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEngagements method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEngagements operation.
//	pageNum := 0
//	err := client.ListEngagementsPages(params,
//	    func(page *ssmcontacts.ListEngagementsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMContacts) ListEngagementsPages(input *ListEngagementsInput, fn func(*ListEngagementsOutput, bool) bool) error {
	return c.ListEngagementsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEngagementsPagesWithContext same as ListEngagementsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListEngagementsPagesWithContext(ctx aws.Context, input *ListEngagementsInput, fn func(*ListEngagementsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEngagementsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEngagementsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEngagementsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPageReceipts = "ListPageReceipts"

// ListPageReceiptsRequest generates a "aws/request.Request" representing the
// client's request for the ListPageReceipts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPageReceipts for more information on using the ListPageReceipts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPageReceiptsRequest method.
//	req, resp := client.ListPageReceiptsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPageReceipts
func (c *SSMContacts) ListPageReceiptsRequest(input *ListPageReceiptsInput) (req *request.Request, output *ListPageReceiptsOutput) {
	op := &request.Operation{
		Name:       opListPageReceipts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPageReceiptsInput{}
	}

	output = &ListPageReceiptsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPageReceipts API operation for AWS Systems Manager Incident Manager Contacts.
//
// Lists all of the engagements to contact channels that have been acknowledged.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation ListPageReceipts for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPageReceipts
func (c *SSMContacts) ListPageReceipts(input *ListPageReceiptsInput) (*ListPageReceiptsOutput, error) {
	req, out := c.ListPageReceiptsRequest(input)
	return out, req.Send()
}

// ListPageReceiptsWithContext is the same as ListPageReceipts with the addition of
// the ability to pass a context and additional request options.
//
// See ListPageReceipts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListPageReceiptsWithContext(ctx aws.Context, input *ListPageReceiptsInput, opts ...request.Option) (*ListPageReceiptsOutput, error) {
	req, out := c.ListPageReceiptsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPageReceiptsPages iterates over the pages of a ListPageReceipts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPageReceipts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPageReceipts operation.
//	pageNum := 0
//	err := client.ListPageReceiptsPages(params,
//	    func(page *ssmcontacts.ListPageReceiptsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMContacts) ListPageReceiptsPages(input *ListPageReceiptsInput, fn func(*ListPageReceiptsOutput, bool) bool) error {
	return c.ListPageReceiptsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPageReceiptsPagesWithContext same as ListPageReceiptsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListPageReceiptsPagesWithContext(ctx aws.Context, input *ListPageReceiptsInput, fn func(*ListPageReceiptsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPageReceiptsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPageReceiptsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPageReceiptsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPageResolutions = "ListPageResolutions"

// ListPageResolutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListPageResolutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPageResolutions for more information on using the ListPageResolutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPageResolutionsRequest method.
//	req, resp := client.ListPageResolutionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPageResolutions
func (c *SSMContacts) ListPageResolutionsRequest(input *ListPageResolutionsInput) (req *request.Request, output *ListPageResolutionsOutput) {
	op := &request.Operation{
		Name:       opListPageResolutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPageResolutionsInput{}
	}

	output = &ListPageResolutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPageResolutions API operation for AWS Systems Manager Incident Manager Contacts.
//
// Returns the resolution path of an engagement. For example, the escalation
// plan engaged in an incident might target an on-call schedule that includes
// several contacts in a rotation, but just one contact on-call when the incident
// starts. The resolution path indicates the hierarchy of escalation plan >
// on-call schedule > contact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation ListPageResolutions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPageResolutions
func (c *SSMContacts) ListPageResolutions(input *ListPageResolutionsInput) (*ListPageResolutionsOutput, error) {
	req, out := c.ListPageResolutionsRequest(input)
	return out, req.Send()
}

// ListPageResolutionsWithContext is the same as ListPageResolutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListPageResolutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListPageResolutionsWithContext(ctx aws.Context, input *ListPageResolutionsInput, opts ...request.Option) (*ListPageResolutionsOutput, error) {
	req, out := c.ListPageResolutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPageResolutionsPages iterates over the pages of a ListPageResolutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPageResolutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPageResolutions operation.
//	pageNum := 0
//	err := client.ListPageResolutionsPages(params,
//	    func(page *ssmcontacts.ListPageResolutionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMContacts) ListPageResolutionsPages(input *ListPageResolutionsInput, fn func(*ListPageResolutionsOutput, bool) bool) error {
	return c.ListPageResolutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPageResolutionsPagesWithContext same as ListPageResolutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListPageResolutionsPagesWithContext(ctx aws.Context, input *ListPageResolutionsInput, fn func(*ListPageResolutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPageResolutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPageResolutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPageResolutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPagesByContact = "ListPagesByContact"

// ListPagesByContactRequest generates a "aws/request.Request" representing the
// client's request for the ListPagesByContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPagesByContact for more information on using the ListPagesByContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPagesByContactRequest method.
//	req, resp := client.ListPagesByContactRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPagesByContact
func (c *SSMContacts) ListPagesByContactRequest(input *ListPagesByContactInput) (req *request.Request, output *ListPagesByContactOutput) {
	op := &request.Operation{
		Name:       opListPagesByContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPagesByContactInput{}
	}

	output = &ListPagesByContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPagesByContact API operation for AWS Systems Manager Incident Manager Contacts.
//
// Lists the engagements to a contact's contact channels.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation ListPagesByContact for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPagesByContact
func (c *SSMContacts) ListPagesByContact(input *ListPagesByContactInput) (*ListPagesByContactOutput, error) {
	req, out := c.ListPagesByContactRequest(input)
	return out, req.Send()
}

// ListPagesByContactWithContext is the same as ListPagesByContact with the addition of
// the ability to pass a context and additional request options.
//
// See ListPagesByContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListPagesByContactWithContext(ctx aws.Context, input *ListPagesByContactInput, opts ...request.Option) (*ListPagesByContactOutput, error) {
	req, out := c.ListPagesByContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPagesByContactPages iterates over the pages of a ListPagesByContact operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPagesByContact method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPagesByContact operation.
//	pageNum := 0
//	err := client.ListPagesByContactPages(params,
//	    func(page *ssmcontacts.ListPagesByContactOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMContacts) ListPagesByContactPages(input *ListPagesByContactInput, fn func(*ListPagesByContactOutput, bool) bool) error {
	return c.ListPagesByContactPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPagesByContactPagesWithContext same as ListPagesByContactPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListPagesByContactPagesWithContext(ctx aws.Context, input *ListPagesByContactInput, fn func(*ListPagesByContactOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPagesByContactInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPagesByContactRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPagesByContactOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPagesByEngagement = "ListPagesByEngagement"

// ListPagesByEngagementRequest generates a "aws/request.Request" representing the
// client's request for the ListPagesByEngagement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPagesByEngagement for more information on using the ListPagesByEngagement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPagesByEngagementRequest method.
//	req, resp := client.ListPagesByEngagementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPagesByEngagement
func (c *SSMContacts) ListPagesByEngagementRequest(input *ListPagesByEngagementInput) (req *request.Request, output *ListPagesByEngagementOutput) {
	op := &request.Operation{
		Name:       opListPagesByEngagement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPagesByEngagementInput{}
	}

	output = &ListPagesByEngagementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPagesByEngagement API operation for AWS Systems Manager Incident Manager Contacts.
//
// Lists the engagements to contact channels that occurred by engaging a contact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation ListPagesByEngagement for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPagesByEngagement
func (c *SSMContacts) ListPagesByEngagement(input *ListPagesByEngagementInput) (*ListPagesByEngagementOutput, error) {
	req, out := c.ListPagesByEngagementRequest(input)
	return out, req.Send()
}

// ListPagesByEngagementWithContext is the same as ListPagesByEngagement with the addition of
// the ability to pass a context and additional request options.
//
// See ListPagesByEngagement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListPagesByEngagementWithContext(ctx aws.Context, input *ListPagesByEngagementInput, opts ...request.Option) (*ListPagesByEngagementOutput, error) {
	req, out := c.ListPagesByEngagementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPagesByEngagementPages iterates over the pages of a ListPagesByEngagement operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPagesByEngagement method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPagesByEngagement operation.
//	pageNum := 0
//	err := client.ListPagesByEngagementPages(params,
//	    func(page *ssmcontacts.ListPagesByEngagementOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMContacts) ListPagesByEngagementPages(input *ListPagesByEngagementInput, fn func(*ListPagesByEngagementOutput, bool) bool) error {
	return c.ListPagesByEngagementPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPagesByEngagementPagesWithContext same as ListPagesByEngagementPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListPagesByEngagementPagesWithContext(ctx aws.Context, input *ListPagesByEngagementInput, fn func(*ListPagesByEngagementOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPagesByEngagementInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPagesByEngagementRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPagesByEngagementOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPreviewRotationShifts = "ListPreviewRotationShifts"

// ListPreviewRotationShiftsRequest generates a "aws/request.Request" representing the
// client's request for the ListPreviewRotationShifts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPreviewRotationShifts for more information on using the ListPreviewRotationShifts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPreviewRotationShiftsRequest method.
//	req, resp := client.ListPreviewRotationShiftsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPreviewRotationShifts
func (c *SSMContacts) ListPreviewRotationShiftsRequest(input *ListPreviewRotationShiftsInput) (req *request.Request, output *ListPreviewRotationShiftsOutput) {
	op := &request.Operation{
		Name:       opListPreviewRotationShifts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPreviewRotationShiftsInput{}
	}

	output = &ListPreviewRotationShiftsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPreviewRotationShifts API operation for AWS Systems Manager Incident Manager Contacts.
//
// Returns a list of shifts based on rotation configuration parameters.
//
// The Incident Manager primarily uses this operation to populate the Preview
// calendar. It is not typically run by end users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation ListPreviewRotationShifts for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPreviewRotationShifts
func (c *SSMContacts) ListPreviewRotationShifts(input *ListPreviewRotationShiftsInput) (*ListPreviewRotationShiftsOutput, error) {
	req, out := c.ListPreviewRotationShiftsRequest(input)
	return out, req.Send()
}

// ListPreviewRotationShiftsWithContext is the same as ListPreviewRotationShifts with the addition of
// the ability to pass a context and additional request options.
//
// See ListPreviewRotationShifts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListPreviewRotationShiftsWithContext(ctx aws.Context, input *ListPreviewRotationShiftsInput, opts ...request.Option) (*ListPreviewRotationShiftsOutput, error) {
	req, out := c.ListPreviewRotationShiftsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPreviewRotationShiftsPages iterates over the pages of a ListPreviewRotationShifts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPreviewRotationShifts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPreviewRotationShifts operation.
//	pageNum := 0
//	err := client.ListPreviewRotationShiftsPages(params,
//	    func(page *ssmcontacts.ListPreviewRotationShiftsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMContacts) ListPreviewRotationShiftsPages(input *ListPreviewRotationShiftsInput, fn func(*ListPreviewRotationShiftsOutput, bool) bool) error {
	return c.ListPreviewRotationShiftsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPreviewRotationShiftsPagesWithContext same as ListPreviewRotationShiftsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListPreviewRotationShiftsPagesWithContext(ctx aws.Context, input *ListPreviewRotationShiftsInput, fn func(*ListPreviewRotationShiftsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPreviewRotationShiftsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPreviewRotationShiftsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPreviewRotationShiftsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRotationOverrides = "ListRotationOverrides"

// ListRotationOverridesRequest generates a "aws/request.Request" representing the
// client's request for the ListRotationOverrides operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRotationOverrides for more information on using the ListRotationOverrides
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRotationOverridesRequest method.
//	req, resp := client.ListRotationOverridesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListRotationOverrides
func (c *SSMContacts) ListRotationOverridesRequest(input *ListRotationOverridesInput) (req *request.Request, output *ListRotationOverridesOutput) {
	op := &request.Operation{
		Name:       opListRotationOverrides,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRotationOverridesInput{}
	}

	output = &ListRotationOverridesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRotationOverrides API operation for AWS Systems Manager Incident Manager Contacts.
//
// Retrieves a list of overrides currently specified for an on-call rotation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation ListRotationOverrides for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListRotationOverrides
func (c *SSMContacts) ListRotationOverrides(input *ListRotationOverridesInput) (*ListRotationOverridesOutput, error) {
	req, out := c.ListRotationOverridesRequest(input)
	return out, req.Send()
}

// ListRotationOverridesWithContext is the same as ListRotationOverrides with the addition of
// the ability to pass a context and additional request options.
//
// See ListRotationOverrides for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListRotationOverridesWithContext(ctx aws.Context, input *ListRotationOverridesInput, opts ...request.Option) (*ListRotationOverridesOutput, error) {
	req, out := c.ListRotationOverridesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRotationOverridesPages iterates over the pages of a ListRotationOverrides operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRotationOverrides method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRotationOverrides operation.
//	pageNum := 0
//	err := client.ListRotationOverridesPages(params,
//	    func(page *ssmcontacts.ListRotationOverridesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMContacts) ListRotationOverridesPages(input *ListRotationOverridesInput, fn func(*ListRotationOverridesOutput, bool) bool) error {
	return c.ListRotationOverridesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRotationOverridesPagesWithContext same as ListRotationOverridesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListRotationOverridesPagesWithContext(ctx aws.Context, input *ListRotationOverridesInput, fn func(*ListRotationOverridesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRotationOverridesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRotationOverridesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRotationOverridesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRotationShifts = "ListRotationShifts"

// ListRotationShiftsRequest generates a "aws/request.Request" representing the
// client's request for the ListRotationShifts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRotationShifts for more information on using the ListRotationShifts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRotationShiftsRequest method.
//	req, resp := client.ListRotationShiftsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListRotationShifts
func (c *SSMContacts) ListRotationShiftsRequest(input *ListRotationShiftsInput) (req *request.Request, output *ListRotationShiftsOutput) {
	op := &request.Operation{
		Name:       opListRotationShifts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRotationShiftsInput{}
	}

	output = &ListRotationShiftsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRotationShifts API operation for AWS Systems Manager Incident Manager Contacts.
//
// Returns a list of shifts generated by an existing rotation in the system.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation ListRotationShifts for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListRotationShifts
func (c *SSMContacts) ListRotationShifts(input *ListRotationShiftsInput) (*ListRotationShiftsOutput, error) {
	req, out := c.ListRotationShiftsRequest(input)
	return out, req.Send()
}

// ListRotationShiftsWithContext is the same as ListRotationShifts with the addition of
// the ability to pass a context and additional request options.
//
// See ListRotationShifts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListRotationShiftsWithContext(ctx aws.Context, input *ListRotationShiftsInput, opts ...request.Option) (*ListRotationShiftsOutput, error) {
	req, out := c.ListRotationShiftsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRotationShiftsPages iterates over the pages of a ListRotationShifts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRotationShifts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRotationShifts operation.
//	pageNum := 0
//	err := client.ListRotationShiftsPages(params,
//	    func(page *ssmcontacts.ListRotationShiftsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMContacts) ListRotationShiftsPages(input *ListRotationShiftsInput, fn func(*ListRotationShiftsOutput, bool) bool) error {
	return c.ListRotationShiftsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRotationShiftsPagesWithContext same as ListRotationShiftsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListRotationShiftsPagesWithContext(ctx aws.Context, input *ListRotationShiftsInput, fn func(*ListRotationShiftsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRotationShiftsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRotationShiftsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRotationShiftsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRotations = "ListRotations"

// ListRotationsRequest generates a "aws/request.Request" representing the
// client's request for the ListRotations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRotations for more information on using the ListRotations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRotationsRequest method.
//	req, resp := client.ListRotationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListRotations
func (c *SSMContacts) ListRotationsRequest(input *ListRotationsInput) (req *request.Request, output *ListRotationsOutput) {
	op := &request.Operation{
		Name:       opListRotations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRotationsInput{}
	}

	output = &ListRotationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRotations API operation for AWS Systems Manager Incident Manager Contacts.
//
// Retrieves a list of on-call rotations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation ListRotations for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListRotations
func (c *SSMContacts) ListRotations(input *ListRotationsInput) (*ListRotationsOutput, error) {
	req, out := c.ListRotationsRequest(input)
	return out, req.Send()
}

// ListRotationsWithContext is the same as ListRotations with the addition of
// the ability to pass a context and additional request options.
//
// See ListRotations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListRotationsWithContext(ctx aws.Context, input *ListRotationsInput, opts ...request.Option) (*ListRotationsOutput, error) {
	req, out := c.ListRotationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRotationsPages iterates over the pages of a ListRotations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRotations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRotations operation.
//	pageNum := 0
//	err := client.ListRotationsPages(params,
//	    func(page *ssmcontacts.ListRotationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMContacts) ListRotationsPages(input *ListRotationsInput, fn func(*ListRotationsOutput, bool) bool) error {
	return c.ListRotationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRotationsPagesWithContext same as ListRotationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListRotationsPagesWithContext(ctx aws.Context, input *ListRotationsInput, fn func(*ListRotationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRotationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRotationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRotationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListTagsForResource
func (c *SSMContacts) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Systems Manager Incident Manager Contacts.
//
// Lists the tags of an escalation plan or contact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListTagsForResource
func (c *SSMContacts) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutContactPolicy = "PutContactPolicy"

// PutContactPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutContactPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutContactPolicy for more information on using the PutContactPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutContactPolicyRequest method.
//	req, resp := client.PutContactPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/PutContactPolicy
func (c *SSMContacts) PutContactPolicyRequest(input *PutContactPolicyInput) (req *request.Request, output *PutContactPolicyOutput) {
	op := &request.Operation{
		Name:       opPutContactPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutContactPolicyInput{}
	}

	output = &PutContactPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutContactPolicy API operation for AWS Systems Manager Incident Manager Contacts.
//
// Adds a resource policy to the specified contact or escalation plan. The resource
// policy is used to share the contact or escalation plan using Resource Access
// Manager (RAM). For more information about cross-account sharing, see Setting
// up cross-account functionality (https://docs.aws.amazon.com/incident-manager/latest/userguide/xa.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation PutContactPolicy for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/PutContactPolicy
func (c *SSMContacts) PutContactPolicy(input *PutContactPolicyInput) (*PutContactPolicyOutput, error) {
	req, out := c.PutContactPolicyRequest(input)
	return out, req.Send()
}

// PutContactPolicyWithContext is the same as PutContactPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutContactPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) PutContactPolicyWithContext(ctx aws.Context, input *PutContactPolicyInput, opts ...request.Option) (*PutContactPolicyOutput, error) {
	req, out := c.PutContactPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendActivationCode = "SendActivationCode"

// SendActivationCodeRequest generates a "aws/request.Request" representing the
// client's request for the SendActivationCode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendActivationCode for more information on using the SendActivationCode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendActivationCodeRequest method.
//	req, resp := client.SendActivationCodeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/SendActivationCode
func (c *SSMContacts) SendActivationCodeRequest(input *SendActivationCodeInput) (req *request.Request, output *SendActivationCodeOutput) {
	op := &request.Operation{
		Name:       opSendActivationCode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendActivationCodeInput{}
	}

	output = &SendActivationCodeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SendActivationCode API operation for AWS Systems Manager Incident Manager Contacts.
//
// Sends an activation code to a contact channel. The contact can use this code
// to activate the contact channel in the console or with the ActivateChannel
// operation. Incident Manager can't engage a contact channel until it has been
// activated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation SendActivationCode for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/SendActivationCode
func (c *SSMContacts) SendActivationCode(input *SendActivationCodeInput) (*SendActivationCodeOutput, error) {
	req, out := c.SendActivationCodeRequest(input)
	return out, req.Send()
}

// SendActivationCodeWithContext is the same as SendActivationCode with the addition of
// the ability to pass a context and additional request options.
//
// See SendActivationCode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) SendActivationCodeWithContext(ctx aws.Context, input *SendActivationCodeInput, opts ...request.Option) (*SendActivationCodeOutput, error) {
	req, out := c.SendActivationCodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartEngagement = "StartEngagement"

// StartEngagementRequest generates a "aws/request.Request" representing the
// client's request for the StartEngagement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartEngagement for more information on using the StartEngagement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartEngagementRequest method.
//	req, resp := client.StartEngagementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/StartEngagement
func (c *SSMContacts) StartEngagementRequest(input *StartEngagementInput) (req *request.Request, output *StartEngagementOutput) {
	op := &request.Operation{
		Name:       opStartEngagement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartEngagementInput{}
	}

	output = &StartEngagementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartEngagement API operation for AWS Systems Manager Incident Manager Contacts.
//
// Starts an engagement to a contact or escalation plan. The engagement engages
// each contact specified in the incident.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation StartEngagement for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/StartEngagement
func (c *SSMContacts) StartEngagement(input *StartEngagementInput) (*StartEngagementOutput, error) {
	req, out := c.StartEngagementRequest(input)
	return out, req.Send()
}

// StartEngagementWithContext is the same as StartEngagement with the addition of
// the ability to pass a context and additional request options.
//
// See StartEngagement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) StartEngagementWithContext(ctx aws.Context, input *StartEngagementInput, opts ...request.Option) (*StartEngagementOutput, error) {
	req, out := c.StartEngagementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopEngagement = "StopEngagement"

// StopEngagementRequest generates a "aws/request.Request" representing the
// client's request for the StopEngagement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopEngagement for more information on using the StopEngagement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopEngagementRequest method.
//	req, resp := client.StopEngagementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/StopEngagement
func (c *SSMContacts) StopEngagementRequest(input *StopEngagementInput) (req *request.Request, output *StopEngagementOutput) {
	op := &request.Operation{
		Name:       opStopEngagement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopEngagementInput{}
	}

	output = &StopEngagementOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopEngagement API operation for AWS Systems Manager Incident Manager Contacts.
//
// Stops an engagement before it finishes the final stage of the escalation
// plan or engagement plan. Further contacts aren't engaged.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation StopEngagement for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/StopEngagement
func (c *SSMContacts) StopEngagement(input *StopEngagementInput) (*StopEngagementOutput, error) {
	req, out := c.StopEngagementRequest(input)
	return out, req.Send()
}

// StopEngagementWithContext is the same as StopEngagement with the addition of
// the ability to pass a context and additional request options.
//
// See StopEngagement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) StopEngagementWithContext(ctx aws.Context, input *StopEngagementInput, opts ...request.Option) (*StopEngagementOutput, error) {
	req, out := c.StopEngagementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/TagResource
func (c *SSMContacts) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Systems Manager Incident Manager Contacts.
//
// Tags a contact or escalation plan. You can tag only contacts and escalation
// plans in the first region of your replication set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/TagResource
func (c *SSMContacts) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/UntagResource
func (c *SSMContacts) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Systems Manager Incident Manager Contacts.
//
// Removes tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/UntagResource
func (c *SSMContacts) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContact = "UpdateContact"

// UpdateContactRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContact for more information on using the UpdateContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateContactRequest method.
//	req, resp := client.UpdateContactRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/UpdateContact
func (c *SSMContacts) UpdateContactRequest(input *UpdateContactInput) (req *request.Request, output *UpdateContactOutput) {
	op := &request.Operation{
		Name:       opUpdateContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateContactInput{}
	}

	output = &UpdateContactOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateContact API operation for AWS Systems Manager Incident Manager Contacts.
//
// Updates the contact or escalation plan specified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation UpdateContact for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/UpdateContact
func (c *SSMContacts) UpdateContact(input *UpdateContactInput) (*UpdateContactOutput, error) {
	req, out := c.UpdateContactRequest(input)
	return out, req.Send()
}

// UpdateContactWithContext is the same as UpdateContact with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) UpdateContactWithContext(ctx aws.Context, input *UpdateContactInput, opts ...request.Option) (*UpdateContactOutput, error) {
	req, out := c.UpdateContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContactChannel = "UpdateContactChannel"

// UpdateContactChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContactChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContactChannel for more information on using the UpdateContactChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateContactChannelRequest method.
//	req, resp := client.UpdateContactChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/UpdateContactChannel
func (c *SSMContacts) UpdateContactChannelRequest(input *UpdateContactChannelInput) (req *request.Request, output *UpdateContactChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateContactChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateContactChannelInput{}
	}

	output = &UpdateContactChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateContactChannel API operation for AWS Systems Manager Incident Manager Contacts.
//
// Updates a contact's contact channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation UpdateContactChannel for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/UpdateContactChannel
func (c *SSMContacts) UpdateContactChannel(input *UpdateContactChannelInput) (*UpdateContactChannelOutput, error) {
	req, out := c.UpdateContactChannelRequest(input)
	return out, req.Send()
}

// UpdateContactChannelWithContext is the same as UpdateContactChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContactChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) UpdateContactChannelWithContext(ctx aws.Context, input *UpdateContactChannelInput, opts ...request.Option) (*UpdateContactChannelOutput, error) {
	req, out := c.UpdateContactChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRotation = "UpdateRotation"

// UpdateRotationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRotation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRotation for more information on using the UpdateRotation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRotationRequest method.
//	req, resp := client.UpdateRotationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/UpdateRotation
func (c *SSMContacts) UpdateRotationRequest(input *UpdateRotationInput) (req *request.Request, output *UpdateRotationOutput) {
	op := &request.Operation{
		Name:       opUpdateRotation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRotationInput{}
	}

	output = &UpdateRotationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRotation API operation for AWS Systems Manager Incident Manager Contacts.
//
// Updates the information specified for an on-call rotation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation UpdateRotation for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/UpdateRotation
func (c *SSMContacts) UpdateRotation(input *UpdateRotationInput) (*UpdateRotationOutput, error) {
	req, out := c.UpdateRotationRequest(input)
	return out, req.Send()
}

// UpdateRotationWithContext is the same as UpdateRotation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRotation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) UpdateRotationWithContext(ctx aws.Context, input *UpdateRotationInput, opts ...request.Option) (*UpdateRotationOutput, error) {
	req, out := c.UpdateRotationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AcceptPageInput struct {
	_ struct{} `type:"structure"`

	// A 6-digit code used to acknowledge the page.
	//
	// AcceptCode is a required field
	AcceptCode *string `min:"6" type:"string" required:"true"`

	// An optional field that Incident Manager uses to ENFORCE AcceptCode validation
	// when acknowledging an page. Acknowledgement can occur by replying to a page,
	// or when entering the AcceptCode in the console. Enforcing AcceptCode validation
	// causes Incident Manager to verify that the code entered by the user matches
	// the code sent by Incident Manager with the page.
	//
	// Incident Manager can also IGNORE AcceptCode validation. Ignoring AcceptCode
	// validation causes Incident Manager to accept any value entered for the AcceptCode.
	AcceptCodeValidation *string `type:"string" enum:"AcceptCodeValidation"`

	// The type indicates if the page was DELIVERED or READ.
	//
	// AcceptType is a required field
	AcceptType *string `type:"string" required:"true" enum:"AcceptType"`

	// The ARN of the contact channel.
	ContactChannelId *string `min:"1" type:"string"`

	// Information provided by the user when the user acknowledges the page.
	Note *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the engagement to a contact channel.
	//
	// PageId is a required field
	PageId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptPageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptPageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptPageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptPageInput"}
	if s.AcceptCode == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceptCode"))
	}
	if s.AcceptCode != nil && len(*s.AcceptCode) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("AcceptCode", 6))
	}
	if s.AcceptType == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceptType"))
	}
	if s.ContactChannelId != nil && len(*s.ContactChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactChannelId", 1))
	}
	if s.Note != nil && len(*s.Note) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Note", 1))
	}
	if s.PageId == nil {
		invalidParams.Add(request.NewErrParamRequired("PageId"))
	}
	if s.PageId != nil && len(*s.PageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PageId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptCode sets the AcceptCode field's value.
func (s *AcceptPageInput) SetAcceptCode(v string) *AcceptPageInput {
	s.AcceptCode = &v
	return s
}

// SetAcceptCodeValidation sets the AcceptCodeValidation field's value.
func (s *AcceptPageInput) SetAcceptCodeValidation(v string) *AcceptPageInput {
	s.AcceptCodeValidation = &v
	return s
}

// SetAcceptType sets the AcceptType field's value.
func (s *AcceptPageInput) SetAcceptType(v string) *AcceptPageInput {
	s.AcceptType = &v
	return s
}

// SetContactChannelId sets the ContactChannelId field's value.
func (s *AcceptPageInput) SetContactChannelId(v string) *AcceptPageInput {
	s.ContactChannelId = &v
	return s
}

// SetNote sets the Note field's value.
func (s *AcceptPageInput) SetNote(v string) *AcceptPageInput {
	s.Note = &v
	return s
}

// SetPageId sets the PageId field's value.
func (s *AcceptPageInput) SetPageId(v string) *AcceptPageInput {
	s.PageId = &v
	return s
}

type AcceptPageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptPageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptPageOutput) GoString() string {
	return s.String()
}

// You don't have sufficient access to perform this operation.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ActivateContactChannelInput struct {
	_ struct{} `type:"structure"`

	// The code sent to the contact channel when it was created in the contact.
	//
	// ActivationCode is a required field
	ActivationCode *string `min:"6" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the contact channel.
	//
	// ContactChannelId is a required field
	ContactChannelId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateContactChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateContactChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActivateContactChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActivateContactChannelInput"}
	if s.ActivationCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivationCode"))
	}
	if s.ActivationCode != nil && len(*s.ActivationCode) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("ActivationCode", 6))
	}
	if s.ContactChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactChannelId"))
	}
	if s.ContactChannelId != nil && len(*s.ContactChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivationCode sets the ActivationCode field's value.
func (s *ActivateContactChannelInput) SetActivationCode(v string) *ActivateContactChannelInput {
	s.ActivationCode = &v
	return s
}

// SetContactChannelId sets the ContactChannelId field's value.
func (s *ActivateContactChannelInput) SetContactChannelId(v string) *ActivateContactChannelInput {
	s.ContactChannelId = &v
	return s
}

type ActivateContactChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateContactChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateContactChannelOutput) GoString() string {
	return s.String()
}

// Information about the contact channel that Incident Manager uses to engage
// the contact.
type ChannelTargetInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact channel.
	//
	// ContactChannelId is a required field
	ContactChannelId *string `min:"1" type:"string" required:"true"`

	// The number of minutes to wait to retry sending engagement in the case the
	// engagement initially fails.
	RetryIntervalInMinutes *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelTargetInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelTargetInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChannelTargetInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChannelTargetInfo"}
	if s.ContactChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactChannelId"))
	}
	if s.ContactChannelId != nil && len(*s.ContactChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactChannelId sets the ContactChannelId field's value.
func (s *ChannelTargetInfo) SetContactChannelId(v string) *ChannelTargetInfo {
	s.ContactChannelId = &v
	return s
}

// SetRetryIntervalInMinutes sets the RetryIntervalInMinutes field's value.
func (s *ChannelTargetInfo) SetRetryIntervalInMinutes(v int64) *ChannelTargetInfo {
	s.RetryIntervalInMinutes = &v
	return s
}

// Updating or deleting a resource causes an inconsistent state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// List of dependent entities containing information on relation type and resourceArns
	// linked to the resource in use
	DependentEntities []*DependentEntity `type:"list"`

	Message_ *string `locationName:"Message" type:"string"`

	// Identifier of the resource in use
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// Type of the resource in use
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A personal contact or escalation plan that Incident Manager engages during
// an incident.
type Contact struct {
	_ struct{} `type:"structure"`

	// The unique and identifiable alias of the contact or escalation plan.
	//
	// Alias is a required field
	Alias *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the contact or escalation plan.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`

	// The full name of the contact or escalation plan.
	DisplayName *string `type:"string"`

	// Refers to the type of contact. A single contact is type PERSONAL and an escalation
	// plan is type ESCALATION.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ContactType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Contact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Contact) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *Contact) SetAlias(v string) *Contact {
	s.Alias = &v
	return s
}

// SetContactArn sets the ContactArn field's value.
func (s *Contact) SetContactArn(v string) *Contact {
	s.ContactArn = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Contact) SetDisplayName(v string) *Contact {
	s.DisplayName = &v
	return s
}

// SetType sets the Type field's value.
func (s *Contact) SetType(v string) *Contact {
	s.Type = &v
	return s
}

// The method that Incident Manager uses to engage a contact.
type ContactChannel struct {
	_ struct{} `type:"structure"`

	// A Boolean value describing if the contact channel has been activated or not.
	// If the contact channel isn't activated, Incident Manager can't engage the
	// contact through it.
	//
	// ActivationStatus is a required field
	ActivationStatus *string `type:"string" required:"true" enum:"ActivationStatus"`

	// The ARN of the contact that contains the contact channel.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the contact channel.
	//
	// ContactChannelArn is a required field
	ContactChannelArn *string `min:"1" type:"string" required:"true"`

	// The details that Incident Manager uses when trying to engage the contact
	// channel.
	//
	// DeliveryAddress is a required field
	DeliveryAddress *ContactChannelAddress `type:"structure" required:"true"`

	// The name of the contact channel.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The type of the contact channel. Incident Manager supports three contact
	// methods:
	//
	//    * SMS
	//
	//    * VOICE
	//
	//    * EMAIL
	Type *string `type:"string" enum:"ChannelType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactChannel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactChannel) GoString() string {
	return s.String()
}

// SetActivationStatus sets the ActivationStatus field's value.
func (s *ContactChannel) SetActivationStatus(v string) *ContactChannel {
	s.ActivationStatus = &v
	return s
}

// SetContactArn sets the ContactArn field's value.
func (s *ContactChannel) SetContactArn(v string) *ContactChannel {
	s.ContactArn = &v
	return s
}

// SetContactChannelArn sets the ContactChannelArn field's value.
func (s *ContactChannel) SetContactChannelArn(v string) *ContactChannel {
	s.ContactChannelArn = &v
	return s
}

// SetDeliveryAddress sets the DeliveryAddress field's value.
func (s *ContactChannel) SetDeliveryAddress(v *ContactChannelAddress) *ContactChannel {
	s.DeliveryAddress = v
	return s
}

// SetName sets the Name field's value.
func (s *ContactChannel) SetName(v string) *ContactChannel {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *ContactChannel) SetType(v string) *ContactChannel {
	s.Type = &v
	return s
}

// The details that Incident Manager uses when trying to engage the contact
// channel.
type ContactChannelAddress struct {
	_ struct{} `type:"structure"`

	// The format is dependent on the type of the contact channel. The following
	// are the expected formats:
	//
	//    * SMS - '+' followed by the country code and phone number
	//
	//    * VOICE - '+' followed by the country code and phone number
	//
	//    * EMAIL - any standard email format
	SimpleAddress *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactChannelAddress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactChannelAddress) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContactChannelAddress) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContactChannelAddress"}
	if s.SimpleAddress != nil && len(*s.SimpleAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SimpleAddress", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSimpleAddress sets the SimpleAddress field's value.
func (s *ContactChannelAddress) SetSimpleAddress(v string) *ContactChannelAddress {
	s.SimpleAddress = &v
	return s
}

// The contact that Incident Manager is engaging during an incident.
type ContactTargetInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact.
	ContactId *string `min:"1" type:"string"`

	// A Boolean value determining if the contact's acknowledgement stops the progress
	// of stages in the plan.
	//
	// IsEssential is a required field
	IsEssential *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactTargetInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactTargetInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContactTargetInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContactTargetInfo"}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}
	if s.IsEssential == nil {
		invalidParams.Add(request.NewErrParamRequired("IsEssential"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactId sets the ContactId field's value.
func (s *ContactTargetInfo) SetContactId(v string) *ContactTargetInfo {
	s.ContactId = &v
	return s
}

// SetIsEssential sets the IsEssential field's value.
func (s *ContactTargetInfo) SetIsEssential(v bool) *ContactTargetInfo {
	s.IsEssential = &v
	return s
}

// Information about when an on-call shift begins and ends.
type CoverageTime struct {
	_ struct{} `type:"structure"`

	// Information about when the on-call rotation shift ends.
	End *HandOffTime `type:"structure"`

	// Information about when the on-call rotation shift begins.
	Start *HandOffTime `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoverageTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoverageTime) GoString() string {
	return s.String()
}

// SetEnd sets the End field's value.
func (s *CoverageTime) SetEnd(v *HandOffTime) *CoverageTime {
	s.End = v
	return s
}

// SetStart sets the Start field's value.
func (s *CoverageTime) SetStart(v *HandOffTime) *CoverageTime {
	s.Start = v
	return s
}

type CreateContactChannelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact you are adding the contact
	// channel to.
	//
	// ContactId is a required field
	ContactId *string `min:"1" type:"string" required:"true"`

	// If you want to activate the channel at a later time, you can choose to defer
	// activation. Incident Manager can't engage your contact channel until it has
	// been activated.
	DeferActivation *bool `type:"boolean"`

	// The details that Incident Manager uses when trying to engage the contact
	// channel. The format is dependent on the type of the contact channel. The
	// following are the expected formats:
	//
	//    * SMS - '+' followed by the country code and phone number
	//
	//    * VOICE - '+' followed by the country code and phone number
	//
	//    * EMAIL - any standard email format
	//
	// DeliveryAddress is a required field
	DeliveryAddress *ContactChannelAddress `type:"structure" required:"true"`

	// A token ensuring that the operation is called only once with the specified
	// details.
	IdempotencyToken *string `type:"string" idempotencyToken:"true"`

	// The name of the contact channel.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Incident Manager supports three types of contact channels:
	//
	//    * SMS
	//
	//    * VOICE
	//
	//    * EMAIL
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ChannelType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateContactChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateContactChannelInput"}
	if s.ContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}
	if s.DeliveryAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryAddress"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.DeliveryAddress != nil {
		if err := s.DeliveryAddress.Validate(); err != nil {
			invalidParams.AddNested("DeliveryAddress", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactId sets the ContactId field's value.
func (s *CreateContactChannelInput) SetContactId(v string) *CreateContactChannelInput {
	s.ContactId = &v
	return s
}

// SetDeferActivation sets the DeferActivation field's value.
func (s *CreateContactChannelInput) SetDeferActivation(v bool) *CreateContactChannelInput {
	s.DeferActivation = &v
	return s
}

// SetDeliveryAddress sets the DeliveryAddress field's value.
func (s *CreateContactChannelInput) SetDeliveryAddress(v *ContactChannelAddress) *CreateContactChannelInput {
	s.DeliveryAddress = v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateContactChannelInput) SetIdempotencyToken(v string) *CreateContactChannelInput {
	s.IdempotencyToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateContactChannelInput) SetName(v string) *CreateContactChannelInput {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateContactChannelInput) SetType(v string) *CreateContactChannelInput {
	s.Type = &v
	return s
}

type CreateContactChannelOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact channel.
	//
	// ContactChannelArn is a required field
	ContactChannelArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactChannelOutput) GoString() string {
	return s.String()
}

// SetContactChannelArn sets the ContactChannelArn field's value.
func (s *CreateContactChannelOutput) SetContactChannelArn(v string) *CreateContactChannelOutput {
	s.ContactChannelArn = &v
	return s
}

type CreateContactInput struct {
	_ struct{} `type:"structure"`

	// The short name to quickly identify a contact or escalation plan. The contact
	// alias must be unique and identifiable.
	//
	// Alias is a required field
	Alias *string `min:"1" type:"string" required:"true"`

	// The full name of the contact or escalation plan.
	DisplayName *string `type:"string"`

	// A token ensuring that the operation is called only once with the specified
	// details.
	IdempotencyToken *string `type:"string" idempotencyToken:"true"`

	// A list of stages. A contact has an engagement plan with stages that contact
	// specified contact channels. An escalation plan uses stages that contact specified
	// contacts.
	//
	// Plan is a required field
	Plan *Plan `type:"structure" required:"true"`

	// Adds a tag to the target. You can only tag resources created in the first
	// Region of your replication set.
	Tags []*Tag `type:"list"`

	// To create an escalation plan use ESCALATION. To create a contact use PERSONAL.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ContactType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateContactInput"}
	if s.Alias == nil {
		invalidParams.Add(request.NewErrParamRequired("Alias"))
	}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alias", 1))
	}
	if s.Plan == nil {
		invalidParams.Add(request.NewErrParamRequired("Plan"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Plan != nil {
		if err := s.Plan.Validate(); err != nil {
			invalidParams.AddNested("Plan", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlias sets the Alias field's value.
func (s *CreateContactInput) SetAlias(v string) *CreateContactInput {
	s.Alias = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateContactInput) SetDisplayName(v string) *CreateContactInput {
	s.DisplayName = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateContactInput) SetIdempotencyToken(v string) *CreateContactInput {
	s.IdempotencyToken = &v
	return s
}

// SetPlan sets the Plan field's value.
func (s *CreateContactInput) SetPlan(v *Plan) *CreateContactInput {
	s.Plan = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateContactInput) SetTags(v []*Tag) *CreateContactInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateContactInput) SetType(v string) *CreateContactInput {
	s.Type = &v
	return s
}

type CreateContactOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the created contact or escalation plan.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactOutput) GoString() string {
	return s.String()
}

// SetContactArn sets the ContactArn field's value.
func (s *CreateContactOutput) SetContactArn(v string) *CreateContactOutput {
	s.ContactArn = &v
	return s
}

type CreateRotationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARNs) of the contacts to add to the rotation.
	//
	// The order that you list the contacts in is their shift order in the rotation
	// schedule. To change the order of the contact's shifts, use the UpdateRotation
	// operation.
	//
	// ContactIds is a required field
	ContactIds []*string `min:"1" type:"list" required:"true"`

	// A token that ensures that the operation is called only once with the specified
	// details.
	IdempotencyToken *string `type:"string"`

	// The name of the rotation.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Information about the rule that specifies when a shift's team members rotate.
	//
	// Recurrence is a required field
	Recurrence *RecurrenceSettings `type:"structure" required:"true"`

	// The date and time that the rotation goes into effect.
	StartTime *time.Time `type:"timestamp"`

	// Optional metadata to assign to the rotation. Tags enable you to categorize
	// a resource in different ways, such as by purpose, owner, or environment.
	// For more information, see Tagging Incident Manager resources (https://docs.aws.amazon.com/incident-manager/latest/userguide/tagging.html)
	// in the Incident Manager User Guide.
	Tags []*Tag `type:"list"`

	// The time zone to base the rotation’s activity on in Internet Assigned Numbers
	// Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul".
	// For more information, see the Time Zone Database (https://www.iana.org/time-zones)
	// on the IANA website.
	//
	// Designators for time zones that don’t support Daylight Savings Time rules,
	// such as Pacific Standard Time (PST) and Pacific Daylight Time (PDT), are
	// not supported.
	//
	// TimeZoneId is a required field
	TimeZoneId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRotationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRotationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRotationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRotationInput"}
	if s.ContactIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactIds"))
	}
	if s.ContactIds != nil && len(s.ContactIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactIds", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Recurrence == nil {
		invalidParams.Add(request.NewErrParamRequired("Recurrence"))
	}
	if s.TimeZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeZoneId"))
	}
	if s.TimeZoneId != nil && len(*s.TimeZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TimeZoneId", 1))
	}
	if s.Recurrence != nil {
		if err := s.Recurrence.Validate(); err != nil {
			invalidParams.AddNested("Recurrence", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactIds sets the ContactIds field's value.
func (s *CreateRotationInput) SetContactIds(v []*string) *CreateRotationInput {
	s.ContactIds = v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateRotationInput) SetIdempotencyToken(v string) *CreateRotationInput {
	s.IdempotencyToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRotationInput) SetName(v string) *CreateRotationInput {
	s.Name = &v
	return s
}

// SetRecurrence sets the Recurrence field's value.
func (s *CreateRotationInput) SetRecurrence(v *RecurrenceSettings) *CreateRotationInput {
	s.Recurrence = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CreateRotationInput) SetStartTime(v time.Time) *CreateRotationInput {
	s.StartTime = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRotationInput) SetTags(v []*Tag) *CreateRotationInput {
	s.Tags = v
	return s
}

// SetTimeZoneId sets the TimeZoneId field's value.
func (s *CreateRotationInput) SetTimeZoneId(v string) *CreateRotationInput {
	s.TimeZoneId = &v
	return s
}

type CreateRotationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the created rotation.
	//
	// RotationArn is a required field
	RotationArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRotationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRotationOutput) GoString() string {
	return s.String()
}

// SetRotationArn sets the RotationArn field's value.
func (s *CreateRotationOutput) SetRotationArn(v string) *CreateRotationOutput {
	s.RotationArn = &v
	return s
}

type CreateRotationOverrideInput struct {
	_ struct{} `type:"structure"`

	// The date and time when the override ends.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// A token that ensures that the operation is called only once with the specified
	// details.
	IdempotencyToken *string `type:"string"`

	// The Amazon Resource Names (ARNs) of the contacts to replace those in the
	// current on-call rotation with.
	//
	// If you want to include any current team members in the override shift, you
	// must include their ARNs in the new contact ID list.
	//
	// NewContactIds is a required field
	NewContactIds []*string `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the rotation to create an override for.
	//
	// RotationId is a required field
	RotationId *string `min:"1" type:"string" required:"true"`

	// The date and time when the override goes into effect.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRotationOverrideInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRotationOverrideInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRotationOverrideInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRotationOverrideInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.NewContactIds == nil {
		invalidParams.Add(request.NewErrParamRequired("NewContactIds"))
	}
	if s.RotationId == nil {
		invalidParams.Add(request.NewErrParamRequired("RotationId"))
	}
	if s.RotationId != nil && len(*s.RotationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RotationId", 1))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *CreateRotationOverrideInput) SetEndTime(v time.Time) *CreateRotationOverrideInput {
	s.EndTime = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateRotationOverrideInput) SetIdempotencyToken(v string) *CreateRotationOverrideInput {
	s.IdempotencyToken = &v
	return s
}

// SetNewContactIds sets the NewContactIds field's value.
func (s *CreateRotationOverrideInput) SetNewContactIds(v []*string) *CreateRotationOverrideInput {
	s.NewContactIds = v
	return s
}

// SetRotationId sets the RotationId field's value.
func (s *CreateRotationOverrideInput) SetRotationId(v string) *CreateRotationOverrideInput {
	s.RotationId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CreateRotationOverrideInput) SetStartTime(v time.Time) *CreateRotationOverrideInput {
	s.StartTime = &v
	return s
}

type CreateRotationOverrideOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the created rotation override.
	//
	// RotationOverrideId is a required field
	RotationOverrideId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRotationOverrideOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRotationOverrideOutput) GoString() string {
	return s.String()
}

// SetRotationOverrideId sets the RotationOverrideId field's value.
func (s *CreateRotationOverrideOutput) SetRotationOverrideId(v string) *CreateRotationOverrideOutput {
	s.RotationOverrideId = &v
	return s
}

// The operation failed to due an encryption key error.
type DataEncryptionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataEncryptionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataEncryptionException) GoString() string {
	return s.String()
}

func newErrorDataEncryptionException(v protocol.ResponseMetadata) error {
	return &DataEncryptionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DataEncryptionException) Code() string {
	return "DataEncryptionException"
}

// Message returns the exception's message.
func (s *DataEncryptionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DataEncryptionException) OrigErr() error {
	return nil
}

func (s *DataEncryptionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DataEncryptionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DataEncryptionException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeactivateContactChannelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact channel you're deactivating.
	//
	// ContactChannelId is a required field
	ContactChannelId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateContactChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateContactChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeactivateContactChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeactivateContactChannelInput"}
	if s.ContactChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactChannelId"))
	}
	if s.ContactChannelId != nil && len(*s.ContactChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactChannelId sets the ContactChannelId field's value.
func (s *DeactivateContactChannelInput) SetContactChannelId(v string) *DeactivateContactChannelInput {
	s.ContactChannelId = &v
	return s
}

type DeactivateContactChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateContactChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateContactChannelOutput) GoString() string {
	return s.String()
}

type DeleteContactChannelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact channel.
	//
	// ContactChannelId is a required field
	ContactChannelId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContactChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContactChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteContactChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteContactChannelInput"}
	if s.ContactChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactChannelId"))
	}
	if s.ContactChannelId != nil && len(*s.ContactChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactChannelId sets the ContactChannelId field's value.
func (s *DeleteContactChannelInput) SetContactChannelId(v string) *DeleteContactChannelInput {
	s.ContactChannelId = &v
	return s
}

type DeleteContactChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContactChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContactChannelOutput) GoString() string {
	return s.String()
}

type DeleteContactInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact that you're deleting.
	//
	// ContactId is a required field
	ContactId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteContactInput"}
	if s.ContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactId sets the ContactId field's value.
func (s *DeleteContactInput) SetContactId(v string) *DeleteContactInput {
	s.ContactId = &v
	return s
}

type DeleteContactOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContactOutput) GoString() string {
	return s.String()
}

type DeleteRotationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the on-call rotation to delete.
	//
	// RotationId is a required field
	RotationId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRotationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRotationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRotationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRotationInput"}
	if s.RotationId == nil {
		invalidParams.Add(request.NewErrParamRequired("RotationId"))
	}
	if s.RotationId != nil && len(*s.RotationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RotationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRotationId sets the RotationId field's value.
func (s *DeleteRotationInput) SetRotationId(v string) *DeleteRotationInput {
	s.RotationId = &v
	return s
}

type DeleteRotationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRotationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRotationOutput) GoString() string {
	return s.String()
}

type DeleteRotationOverrideInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rotation that was overridden.
	//
	// RotationId is a required field
	RotationId *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the on-call rotation override to delete.
	//
	// RotationOverrideId is a required field
	RotationOverrideId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRotationOverrideInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRotationOverrideInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRotationOverrideInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRotationOverrideInput"}
	if s.RotationId == nil {
		invalidParams.Add(request.NewErrParamRequired("RotationId"))
	}
	if s.RotationId != nil && len(*s.RotationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RotationId", 1))
	}
	if s.RotationOverrideId == nil {
		invalidParams.Add(request.NewErrParamRequired("RotationOverrideId"))
	}
	if s.RotationOverrideId != nil && len(*s.RotationOverrideId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("RotationOverrideId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRotationId sets the RotationId field's value.
func (s *DeleteRotationOverrideInput) SetRotationId(v string) *DeleteRotationOverrideInput {
	s.RotationId = &v
	return s
}

// SetRotationOverrideId sets the RotationOverrideId field's value.
func (s *DeleteRotationOverrideInput) SetRotationOverrideId(v string) *DeleteRotationOverrideInput {
	s.RotationOverrideId = &v
	return s
}

type DeleteRotationOverrideOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRotationOverrideOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRotationOverrideOutput) GoString() string {
	return s.String()
}

// Information about a resource that another resource is related to or depends
// on.
//
// For example, if a contact is a member of a rotation, the rotation is a dependent
// entity of the contact.
type DependentEntity struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARNs) of the dependent resources.
	//
	// DependentResourceIds is a required field
	DependentResourceIds []*string `type:"list" required:"true"`

	// The type of relationship between one resource and the other resource that
	// it is related to or depends on.
	//
	// RelationType is a required field
	RelationType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependentEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependentEntity) GoString() string {
	return s.String()
}

// SetDependentResourceIds sets the DependentResourceIds field's value.
func (s *DependentEntity) SetDependentResourceIds(v []*string) *DependentEntity {
	s.DependentResourceIds = v
	return s
}

// SetRelationType sets the RelationType field's value.
func (s *DependentEntity) SetRelationType(v string) *DependentEntity {
	s.RelationType = &v
	return s
}

type DescribeEngagementInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the engagement you want the details of.
	//
	// EngagementId is a required field
	EngagementId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEngagementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEngagementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEngagementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEngagementInput"}
	if s.EngagementId == nil {
		invalidParams.Add(request.NewErrParamRequired("EngagementId"))
	}
	if s.EngagementId != nil && len(*s.EngagementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EngagementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngagementId sets the EngagementId field's value.
func (s *DescribeEngagementInput) SetEngagementId(v string) *DescribeEngagementInput {
	s.EngagementId = &v
	return s
}

type DescribeEngagementOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the escalation plan or contacts involved in the engagement.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`

	// The secure content of the message that was sent to the contact. Use this
	// field for engagements to VOICE and EMAIL.
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true"`

	// The ARN of the engagement.
	//
	// EngagementArn is a required field
	EngagementArn *string `min:"1" type:"string" required:"true"`

	// The ARN of the incident in which the engagement occurred.
	IncidentId *string `type:"string"`

	// The insecure content of the message that was sent to the contact. Use this
	// field for engagements to SMS.
	PublicContent *string `min:"1" type:"string"`

	// The insecure subject of the message that was sent to the contact. Use this
	// field for engagements to SMS.
	PublicSubject *string `min:"1" type:"string"`

	// The user that started the engagement.
	//
	// Sender is a required field
	Sender *string `type:"string" required:"true"`

	// The time that the engagement started.
	StartTime *time.Time `type:"timestamp"`

	// The time that the engagement ended.
	StopTime *time.Time `type:"timestamp"`

	// The secure subject of the message that was sent to the contact. Use this
	// field for engagements to VOICE and EMAIL.
	//
	// Subject is a required field
	Subject *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEngagementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEngagementOutput) GoString() string {
	return s.String()
}

// SetContactArn sets the ContactArn field's value.
func (s *DescribeEngagementOutput) SetContactArn(v string) *DescribeEngagementOutput {
	s.ContactArn = &v
	return s
}

// SetContent sets the Content field's value.
func (s *DescribeEngagementOutput) SetContent(v string) *DescribeEngagementOutput {
	s.Content = &v
	return s
}

// SetEngagementArn sets the EngagementArn field's value.
func (s *DescribeEngagementOutput) SetEngagementArn(v string) *DescribeEngagementOutput {
	s.EngagementArn = &v
	return s
}

// SetIncidentId sets the IncidentId field's value.
func (s *DescribeEngagementOutput) SetIncidentId(v string) *DescribeEngagementOutput {
	s.IncidentId = &v
	return s
}

// SetPublicContent sets the PublicContent field's value.
func (s *DescribeEngagementOutput) SetPublicContent(v string) *DescribeEngagementOutput {
	s.PublicContent = &v
	return s
}

// SetPublicSubject sets the PublicSubject field's value.
func (s *DescribeEngagementOutput) SetPublicSubject(v string) *DescribeEngagementOutput {
	s.PublicSubject = &v
	return s
}

// SetSender sets the Sender field's value.
func (s *DescribeEngagementOutput) SetSender(v string) *DescribeEngagementOutput {
	s.Sender = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeEngagementOutput) SetStartTime(v time.Time) *DescribeEngagementOutput {
	s.StartTime = &v
	return s
}

// SetStopTime sets the StopTime field's value.
func (s *DescribeEngagementOutput) SetStopTime(v time.Time) *DescribeEngagementOutput {
	s.StopTime = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *DescribeEngagementOutput) SetSubject(v string) *DescribeEngagementOutput {
	s.Subject = &v
	return s
}

type DescribePageInput struct {
	_ struct{} `type:"structure"`

	// The ID of the engagement to a contact channel.
	//
	// PageId is a required field
	PageId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePageInput"}
	if s.PageId == nil {
		invalidParams.Add(request.NewErrParamRequired("PageId"))
	}
	if s.PageId != nil && len(*s.PageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PageId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPageId sets the PageId field's value.
func (s *DescribePageInput) SetPageId(v string) *DescribePageInput {
	s.PageId = &v
	return s
}

type DescribePageOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the contact that was engaged.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`

	// The secure content of the message that was sent to the contact. Use this
	// field for engagements to VOICE and EMAIL.
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true"`

	// The time that the contact channel received the engagement.
	DeliveryTime *time.Time `type:"timestamp"`

	// The ARN of the engagement that engaged the contact channel.
	//
	// EngagementArn is a required field
	EngagementArn *string `min:"1" type:"string" required:"true"`

	// The ARN of the incident that engaged the contact channel.
	IncidentId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the engagement to a contact channel.
	//
	// PageArn is a required field
	PageArn *string `min:"1" type:"string" required:"true"`

	// The insecure content of the message that was sent to the contact. Use this
	// field for engagements to SMS.
	PublicContent *string `min:"1" type:"string"`

	// The insecure subject of the message that was sent to the contact. Use this
	// field for engagements to SMS.
	PublicSubject *string `min:"1" type:"string"`

	// The time that the contact channel acknowledged the engagement.
	ReadTime *time.Time `type:"timestamp"`

	// The user that started the engagement.
	//
	// Sender is a required field
	Sender *string `type:"string" required:"true"`

	// The time the engagement was sent to the contact channel.
	SentTime *time.Time `type:"timestamp"`

	// The secure subject of the message that was sent to the contact. Use this
	// field for engagements to VOICE and EMAIL.
	//
	// Subject is a required field
	Subject *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePageOutput) GoString() string {
	return s.String()
}

// SetContactArn sets the ContactArn field's value.
func (s *DescribePageOutput) SetContactArn(v string) *DescribePageOutput {
	s.ContactArn = &v
	return s
}

// SetContent sets the Content field's value.
func (s *DescribePageOutput) SetContent(v string) *DescribePageOutput {
	s.Content = &v
	return s
}

// SetDeliveryTime sets the DeliveryTime field's value.
func (s *DescribePageOutput) SetDeliveryTime(v time.Time) *DescribePageOutput {
	s.DeliveryTime = &v
	return s
}

// SetEngagementArn sets the EngagementArn field's value.
func (s *DescribePageOutput) SetEngagementArn(v string) *DescribePageOutput {
	s.EngagementArn = &v
	return s
}

// SetIncidentId sets the IncidentId field's value.
func (s *DescribePageOutput) SetIncidentId(v string) *DescribePageOutput {
	s.IncidentId = &v
	return s
}

// SetPageArn sets the PageArn field's value.
func (s *DescribePageOutput) SetPageArn(v string) *DescribePageOutput {
	s.PageArn = &v
	return s
}

// SetPublicContent sets the PublicContent field's value.
func (s *DescribePageOutput) SetPublicContent(v string) *DescribePageOutput {
	s.PublicContent = &v
	return s
}

// SetPublicSubject sets the PublicSubject field's value.
func (s *DescribePageOutput) SetPublicSubject(v string) *DescribePageOutput {
	s.PublicSubject = &v
	return s
}

// SetReadTime sets the ReadTime field's value.
func (s *DescribePageOutput) SetReadTime(v time.Time) *DescribePageOutput {
	s.ReadTime = &v
	return s
}

// SetSender sets the Sender field's value.
func (s *DescribePageOutput) SetSender(v string) *DescribePageOutput {
	s.Sender = &v
	return s
}

// SetSentTime sets the SentTime field's value.
func (s *DescribePageOutput) SetSentTime(v time.Time) *DescribePageOutput {
	s.SentTime = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *DescribePageOutput) SetSubject(v string) *DescribePageOutput {
	s.Subject = &v
	return s
}

// Incident Manager reaching out to a contact or escalation plan to engage contact
// during an incident.
type Engagement struct {
	_ struct{} `type:"structure"`

	// The ARN of the escalation plan or contact that Incident Manager is engaging.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the engagement.
	//
	// EngagementArn is a required field
	EngagementArn *string `min:"1" type:"string" required:"true"`

	// The ARN of the incident that's engaging the contact.
	IncidentId *string `type:"string"`

	// The user that started the engagement.
	//
	// Sender is a required field
	Sender *string `type:"string" required:"true"`

	// The time that the engagement began.
	StartTime *time.Time `type:"timestamp"`

	// The time that the engagement ended.
	StopTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Engagement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Engagement) GoString() string {
	return s.String()
}

// SetContactArn sets the ContactArn field's value.
func (s *Engagement) SetContactArn(v string) *Engagement {
	s.ContactArn = &v
	return s
}

// SetEngagementArn sets the EngagementArn field's value.
func (s *Engagement) SetEngagementArn(v string) *Engagement {
	s.EngagementArn = &v
	return s
}

// SetIncidentId sets the IncidentId field's value.
func (s *Engagement) SetIncidentId(v string) *Engagement {
	s.IncidentId = &v
	return s
}

// SetSender sets the Sender field's value.
func (s *Engagement) SetSender(v string) *Engagement {
	s.Sender = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Engagement) SetStartTime(v time.Time) *Engagement {
	s.StartTime = &v
	return s
}

// SetStopTime sets the StopTime field's value.
func (s *Engagement) SetStopTime(v time.Time) *Engagement {
	s.StopTime = &v
	return s
}

type GetContactChannelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact channel you want information
	// about.
	//
	// ContactChannelId is a required field
	ContactChannelId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetContactChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetContactChannelInput"}
	if s.ContactChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactChannelId"))
	}
	if s.ContactChannelId != nil && len(*s.ContactChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactChannelId sets the ContactChannelId field's value.
func (s *GetContactChannelInput) SetContactChannelId(v string) *GetContactChannelInput {
	s.ContactChannelId = &v
	return s
}

type GetContactChannelOutput struct {
	_ struct{} `type:"structure"`

	// A Boolean value indicating if the contact channel has been activated or not.
	ActivationStatus *string `type:"string" enum:"ActivationStatus"`

	// The ARN of the contact that the channel belongs to.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`

	// The ARN of the contact channel.
	//
	// ContactChannelArn is a required field
	ContactChannelArn *string `min:"1" type:"string" required:"true"`

	// The details that Incident Manager uses when trying to engage the contact
	// channel.
	//
	// DeliveryAddress is a required field
	DeliveryAddress *ContactChannelAddress `type:"structure" required:"true"`

	// The name of the contact channel
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The type of contact channel. The type is SMS, VOICE, or EMAIL.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ChannelType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactChannelOutput) GoString() string {
	return s.String()
}

// SetActivationStatus sets the ActivationStatus field's value.
func (s *GetContactChannelOutput) SetActivationStatus(v string) *GetContactChannelOutput {
	s.ActivationStatus = &v
	return s
}

// SetContactArn sets the ContactArn field's value.
func (s *GetContactChannelOutput) SetContactArn(v string) *GetContactChannelOutput {
	s.ContactArn = &v
	return s
}

// SetContactChannelArn sets the ContactChannelArn field's value.
func (s *GetContactChannelOutput) SetContactChannelArn(v string) *GetContactChannelOutput {
	s.ContactChannelArn = &v
	return s
}

// SetDeliveryAddress sets the DeliveryAddress field's value.
func (s *GetContactChannelOutput) SetDeliveryAddress(v *ContactChannelAddress) *GetContactChannelOutput {
	s.DeliveryAddress = v
	return s
}

// SetName sets the Name field's value.
func (s *GetContactChannelOutput) SetName(v string) *GetContactChannelOutput {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetContactChannelOutput) SetType(v string) *GetContactChannelOutput {
	s.Type = &v
	return s
}

type GetContactInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact or escalation plan.
	//
	// ContactId is a required field
	ContactId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetContactInput"}
	if s.ContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactId sets the ContactId field's value.
func (s *GetContactInput) SetContactId(v string) *GetContactInput {
	s.ContactId = &v
	return s
}

type GetContactOutput struct {
	_ struct{} `type:"structure"`

	// The alias of the contact or escalation plan. The alias is unique and identifiable.
	//
	// Alias is a required field
	Alias *string `min:"1" type:"string" required:"true"`

	// The ARN of the contact or escalation plan.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`

	// The full name of the contact or escalation plan.
	DisplayName *string `type:"string"`

	// Details about the specific timing or stages and targets of the escalation
	// plan or engagement plan.
	//
	// Plan is a required field
	Plan *Plan `type:"structure" required:"true"`

	// The type of contact, either PERSONAL or ESCALATION.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ContactType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactOutput) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *GetContactOutput) SetAlias(v string) *GetContactOutput {
	s.Alias = &v
	return s
}

// SetContactArn sets the ContactArn field's value.
func (s *GetContactOutput) SetContactArn(v string) *GetContactOutput {
	s.ContactArn = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *GetContactOutput) SetDisplayName(v string) *GetContactOutput {
	s.DisplayName = &v
	return s
}

// SetPlan sets the Plan field's value.
func (s *GetContactOutput) SetPlan(v *Plan) *GetContactOutput {
	s.Plan = v
	return s
}

// SetType sets the Type field's value.
func (s *GetContactOutput) SetType(v string) *GetContactOutput {
	s.Type = &v
	return s
}

type GetContactPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact or escalation plan.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetContactPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetContactPolicyInput"}
	if s.ContactArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactArn"))
	}
	if s.ContactArn != nil && len(*s.ContactArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactArn sets the ContactArn field's value.
func (s *GetContactPolicyInput) SetContactArn(v string) *GetContactPolicyInput {
	s.ContactArn = &v
	return s
}

type GetContactPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the contact or escalation plan.
	ContactArn *string `min:"1" type:"string"`

	// Details about the resource policy attached to the contact or escalation plan.
	Policy *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactPolicyOutput) GoString() string {
	return s.String()
}

// SetContactArn sets the ContactArn field's value.
func (s *GetContactPolicyOutput) SetContactArn(v string) *GetContactPolicyOutput {
	s.ContactArn = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *GetContactPolicyOutput) SetPolicy(v string) *GetContactPolicyOutput {
	s.Policy = &v
	return s
}

type GetRotationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the on-call rotation to retrieve information
	// about.
	//
	// RotationId is a required field
	RotationId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRotationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRotationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRotationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRotationInput"}
	if s.RotationId == nil {
		invalidParams.Add(request.NewErrParamRequired("RotationId"))
	}
	if s.RotationId != nil && len(*s.RotationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RotationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRotationId sets the RotationId field's value.
func (s *GetRotationInput) SetRotationId(v string) *GetRotationInput {
	s.RotationId = &v
	return s
}

type GetRotationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARNs) of the contacts assigned to the on-call
	// rotation team.
	//
	// ContactIds is a required field
	ContactIds []*string `min:"1" type:"list" required:"true"`

	// The name of the on-call rotation.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies how long a rotation lasts before restarting at the beginning of
	// the shift order.
	//
	// Recurrence is a required field
	Recurrence *RecurrenceSettings `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the on-call rotation.
	//
	// RotationArn is a required field
	RotationArn *string `min:"1" type:"string" required:"true"`

	// The specified start time for the on-call rotation.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`

	// The time zone that the rotation’s activity is based on, in Internet Assigned
	// Numbers Authority (IANA) format.
	//
	// TimeZoneId is a required field
	TimeZoneId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRotationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRotationOutput) GoString() string {
	return s.String()
}

// SetContactIds sets the ContactIds field's value.
func (s *GetRotationOutput) SetContactIds(v []*string) *GetRotationOutput {
	s.ContactIds = v
	return s
}

// SetName sets the Name field's value.
func (s *GetRotationOutput) SetName(v string) *GetRotationOutput {
	s.Name = &v
	return s
}

// SetRecurrence sets the Recurrence field's value.
func (s *GetRotationOutput) SetRecurrence(v *RecurrenceSettings) *GetRotationOutput {
	s.Recurrence = v
	return s
}

// SetRotationArn sets the RotationArn field's value.
func (s *GetRotationOutput) SetRotationArn(v string) *GetRotationOutput {
	s.RotationArn = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetRotationOutput) SetStartTime(v time.Time) *GetRotationOutput {
	s.StartTime = &v
	return s
}

// SetTimeZoneId sets the TimeZoneId field's value.
func (s *GetRotationOutput) SetTimeZoneId(v string) *GetRotationOutput {
	s.TimeZoneId = &v
	return s
}

type GetRotationOverrideInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the overridden rotation to retrieve information
	// about.
	//
	// RotationId is a required field
	RotationId *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the on-call rotation override to retrieve
	// information about.
	//
	// RotationOverrideId is a required field
	RotationOverrideId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRotationOverrideInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRotationOverrideInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRotationOverrideInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRotationOverrideInput"}
	if s.RotationId == nil {
		invalidParams.Add(request.NewErrParamRequired("RotationId"))
	}
	if s.RotationId != nil && len(*s.RotationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RotationId", 1))
	}
	if s.RotationOverrideId == nil {
		invalidParams.Add(request.NewErrParamRequired("RotationOverrideId"))
	}
	if s.RotationOverrideId != nil && len(*s.RotationOverrideId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("RotationOverrideId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRotationId sets the RotationId field's value.
func (s *GetRotationOverrideInput) SetRotationId(v string) *GetRotationOverrideInput {
	s.RotationId = &v
	return s
}

// SetRotationOverrideId sets the RotationOverrideId field's value.
func (s *GetRotationOverrideInput) SetRotationOverrideId(v string) *GetRotationOverrideInput {
	s.RotationOverrideId = &v
	return s
}

type GetRotationOverrideOutput struct {
	_ struct{} `type:"structure"`

	// The date and time when the override was created.
	CreateTime *time.Time `type:"timestamp"`

	// The date and time when the override ends.
	EndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Names (ARNs) of the contacts assigned to the override
	// of the on-call rotation.
	NewContactIds []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the on-call rotation that was overridden.
	RotationArn *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the override to an on-call rotation.
	RotationOverrideId *string `min:"36" type:"string"`

	// The date and time when the override goes into effect.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRotationOverrideOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRotationOverrideOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *GetRotationOverrideOutput) SetCreateTime(v time.Time) *GetRotationOverrideOutput {
	s.CreateTime = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GetRotationOverrideOutput) SetEndTime(v time.Time) *GetRotationOverrideOutput {
	s.EndTime = &v
	return s
}

// SetNewContactIds sets the NewContactIds field's value.
func (s *GetRotationOverrideOutput) SetNewContactIds(v []*string) *GetRotationOverrideOutput {
	s.NewContactIds = v
	return s
}

// SetRotationArn sets the RotationArn field's value.
func (s *GetRotationOverrideOutput) SetRotationArn(v string) *GetRotationOverrideOutput {
	s.RotationArn = &v
	return s
}

// SetRotationOverrideId sets the RotationOverrideId field's value.
func (s *GetRotationOverrideOutput) SetRotationOverrideId(v string) *GetRotationOverrideOutput {
	s.RotationOverrideId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetRotationOverrideOutput) SetStartTime(v time.Time) *GetRotationOverrideOutput {
	s.StartTime = &v
	return s
}

// Details about when an on-call rotation shift begins or ends.
type HandOffTime struct {
	_ struct{} `type:"structure"`

	// The hour when an on-call rotation shift begins or ends.
	//
	// HourOfDay is a required field
	HourOfDay *int64 `type:"integer" required:"true"`

	// The minute when an on-call rotation shift begins or ends.
	//
	// MinuteOfHour is a required field
	MinuteOfHour *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HandOffTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HandOffTime) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HandOffTime) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HandOffTime"}
	if s.HourOfDay == nil {
		invalidParams.Add(request.NewErrParamRequired("HourOfDay"))
	}
	if s.MinuteOfHour == nil {
		invalidParams.Add(request.NewErrParamRequired("MinuteOfHour"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHourOfDay sets the HourOfDay field's value.
func (s *HandOffTime) SetHourOfDay(v int64) *HandOffTime {
	s.HourOfDay = &v
	return s
}

// SetMinuteOfHour sets the MinuteOfHour field's value.
func (s *HandOffTime) SetMinuteOfHour(v int64) *HandOffTime {
	s.MinuteOfHour = &v
	return s
}

// Unexpected error occurred while processing the request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Advice to clients on when the call can be safely retried
	RetryAfterSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListContactChannelsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact.
	//
	// ContactId is a required field
	ContactId *string `min:"1" type:"string" required:"true"`

	// The maximum number of contact channels per page.
	MaxResults *int64 `type:"integer"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContactChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContactChannelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListContactChannelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListContactChannelsInput"}
	if s.ContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactId sets the ContactId field's value.
func (s *ListContactChannelsInput) SetContactId(v string) *ListContactChannelsInput {
	s.ContactId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListContactChannelsInput) SetMaxResults(v int64) *ListContactChannelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContactChannelsInput) SetNextToken(v string) *ListContactChannelsInput {
	s.NextToken = &v
	return s
}

type ListContactChannelsOutput struct {
	_ struct{} `type:"structure"`

	// A list of contact channels related to the specified contact.
	//
	// ContactChannels is a required field
	ContactChannels []*ContactChannel `type:"list" required:"true"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContactChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContactChannelsOutput) GoString() string {
	return s.String()
}

// SetContactChannels sets the ContactChannels field's value.
func (s *ListContactChannelsOutput) SetContactChannels(v []*ContactChannel) *ListContactChannelsOutput {
	s.ContactChannels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContactChannelsOutput) SetNextToken(v string) *ListContactChannelsOutput {
	s.NextToken = &v
	return s
}

type ListContactsInput struct {
	_ struct{} `type:"structure"`

	// Used to list only contacts who's aliases start with the specified prefix.
	AliasPrefix *string `min:"1" type:"string"`

	// The maximum number of contacts and escalation plans per page of results.
	MaxResults *int64 `type:"integer"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`

	// The type of contact. A contact is type PERSONAL and an escalation plan is
	// type ESCALATION.
	Type *string `type:"string" enum:"ContactType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContactsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContactsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListContactsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListContactsInput"}
	if s.AliasPrefix != nil && len(*s.AliasPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasPrefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasPrefix sets the AliasPrefix field's value.
func (s *ListContactsInput) SetAliasPrefix(v string) *ListContactsInput {
	s.AliasPrefix = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListContactsInput) SetMaxResults(v int64) *ListContactsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContactsInput) SetNextToken(v string) *ListContactsInput {
	s.NextToken = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListContactsInput) SetType(v string) *ListContactsInput {
	s.Type = &v
	return s
}

type ListContactsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the contacts and escalation plans in your Incident Manager account.
	Contacts []*Contact `type:"list"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContactsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContactsOutput) GoString() string {
	return s.String()
}

// SetContacts sets the Contacts field's value.
func (s *ListContactsOutput) SetContacts(v []*Contact) *ListContactsOutput {
	s.Contacts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContactsOutput) SetNextToken(v string) *ListContactsOutput {
	s.NextToken = &v
	return s
}

type ListEngagementsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the incident you're listing engagements
	// for.
	IncidentId *string `type:"string"`

	// The maximum number of engagements per page of results.
	MaxResults *int64 `type:"integer"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`

	// The time range to lists engagements for an incident.
	TimeRangeValue *TimeRange `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEngagementsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEngagementsInput) GoString() string {
	return s.String()
}

// SetIncidentId sets the IncidentId field's value.
func (s *ListEngagementsInput) SetIncidentId(v string) *ListEngagementsInput {
	s.IncidentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEngagementsInput) SetMaxResults(v int64) *ListEngagementsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEngagementsInput) SetNextToken(v string) *ListEngagementsInput {
	s.NextToken = &v
	return s
}

// SetTimeRangeValue sets the TimeRangeValue field's value.
func (s *ListEngagementsInput) SetTimeRangeValue(v *TimeRange) *ListEngagementsInput {
	s.TimeRangeValue = v
	return s
}

type ListEngagementsOutput struct {
	_ struct{} `type:"structure"`

	// A list of each engagement that occurred during the specified time range of
	// an incident.
	//
	// Engagements is a required field
	Engagements []*Engagement `type:"list" required:"true"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEngagementsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEngagementsOutput) GoString() string {
	return s.String()
}

// SetEngagements sets the Engagements field's value.
func (s *ListEngagementsOutput) SetEngagements(v []*Engagement) *ListEngagementsOutput {
	s.Engagements = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEngagementsOutput) SetNextToken(v string) *ListEngagementsOutput {
	s.NextToken = &v
	return s
}

type ListPageReceiptsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of acknowledgements per page of results.
	MaxResults *int64 `type:"integer"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) of the engagement to a specific contact channel.
	//
	// PageId is a required field
	PageId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPageReceiptsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPageReceiptsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPageReceiptsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPageReceiptsInput"}
	if s.PageId == nil {
		invalidParams.Add(request.NewErrParamRequired("PageId"))
	}
	if s.PageId != nil && len(*s.PageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PageId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPageReceiptsInput) SetMaxResults(v int64) *ListPageReceiptsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPageReceiptsInput) SetNextToken(v string) *ListPageReceiptsInput {
	s.NextToken = &v
	return s
}

// SetPageId sets the PageId field's value.
func (s *ListPageReceiptsInput) SetPageId(v string) *ListPageReceiptsInput {
	s.PageId = &v
	return s
}

type ListPageReceiptsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`

	// A list of each acknowledgement.
	Receipts []*Receipt `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPageReceiptsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPageReceiptsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPageReceiptsOutput) SetNextToken(v string) *ListPageReceiptsOutput {
	s.NextToken = &v
	return s
}

// SetReceipts sets the Receipts field's value.
func (s *ListPageReceiptsOutput) SetReceipts(v []*Receipt) *ListPageReceiptsOutput {
	s.Receipts = v
	return s
}

type ListPageResolutionsInput struct {
	_ struct{} `type:"structure"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) of the contact engaged for the incident.
	//
	// PageId is a required field
	PageId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPageResolutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPageResolutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPageResolutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPageResolutionsInput"}
	if s.PageId == nil {
		invalidParams.Add(request.NewErrParamRequired("PageId"))
	}
	if s.PageId != nil && len(*s.PageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PageId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListPageResolutionsInput) SetNextToken(v string) *ListPageResolutionsInput {
	s.NextToken = &v
	return s
}

// SetPageId sets the PageId field's value.
func (s *ListPageResolutionsInput) SetPageId(v string) *ListPageResolutionsInput {
	s.PageId = &v
	return s
}

type ListPageResolutionsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `type:"string"`

	// Information about the resolution for an engagement.
	//
	// PageResolutions is a required field
	PageResolutions []*ResolutionContact `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPageResolutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPageResolutionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPageResolutionsOutput) SetNextToken(v string) *ListPageResolutionsOutput {
	s.NextToken = &v
	return s
}

// SetPageResolutions sets the PageResolutions field's value.
func (s *ListPageResolutionsOutput) SetPageResolutions(v []*ResolutionContact) *ListPageResolutionsOutput {
	s.PageResolutions = v
	return s
}

type ListPagesByContactInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact you are retrieving engagements
	// for.
	//
	// ContactId is a required field
	ContactId *string `min:"1" type:"string" required:"true"`

	// The maximum number of engagements to contact channels to list per page of
	// results.
	MaxResults *int64 `type:"integer"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPagesByContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPagesByContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPagesByContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPagesByContactInput"}
	if s.ContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactId sets the ContactId field's value.
func (s *ListPagesByContactInput) SetContactId(v string) *ListPagesByContactInput {
	s.ContactId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPagesByContactInput) SetMaxResults(v int64) *ListPagesByContactInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPagesByContactInput) SetNextToken(v string) *ListPagesByContactInput {
	s.NextToken = &v
	return s
}

type ListPagesByContactOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`

	// The list of engagements to a contact's contact channel.
	//
	// Pages is a required field
	Pages []*Page `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPagesByContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPagesByContactOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPagesByContactOutput) SetNextToken(v string) *ListPagesByContactOutput {
	s.NextToken = &v
	return s
}

// SetPages sets the Pages field's value.
func (s *ListPagesByContactOutput) SetPages(v []*Page) *ListPagesByContactOutput {
	s.Pages = v
	return s
}

type ListPagesByEngagementInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the engagement.
	//
	// EngagementId is a required field
	EngagementId *string `min:"1" type:"string" required:"true"`

	// The maximum number of engagements to contact channels to list per page of
	// results.
	MaxResults *int64 `type:"integer"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPagesByEngagementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPagesByEngagementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPagesByEngagementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPagesByEngagementInput"}
	if s.EngagementId == nil {
		invalidParams.Add(request.NewErrParamRequired("EngagementId"))
	}
	if s.EngagementId != nil && len(*s.EngagementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EngagementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngagementId sets the EngagementId field's value.
func (s *ListPagesByEngagementInput) SetEngagementId(v string) *ListPagesByEngagementInput {
	s.EngagementId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPagesByEngagementInput) SetMaxResults(v int64) *ListPagesByEngagementInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPagesByEngagementInput) SetNextToken(v string) *ListPagesByEngagementInput {
	s.NextToken = &v
	return s
}

type ListPagesByEngagementOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`

	// The list of engagements to contact channels.
	//
	// Pages is a required field
	Pages []*Page `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPagesByEngagementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPagesByEngagementOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPagesByEngagementOutput) SetNextToken(v string) *ListPagesByEngagementOutput {
	s.NextToken = &v
	return s
}

// SetPages sets the Pages field's value.
func (s *ListPagesByEngagementOutput) SetPages(v []*Page) *ListPagesByEngagementOutput {
	s.Pages = v
	return s
}

type ListPreviewRotationShiftsInput struct {
	_ struct{} `type:"structure"`

	// The date and time a rotation shift would end.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// The maximum number of items to return for this call. The call also returns
	// a token that can be specified in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `type:"integer"`

	// The contacts that would be assigned to a rotation.
	//
	// Members is a required field
	Members []*string `min:"1" type:"list" required:"true"`

	// A token to start the list. This token is used to get the next set of results.
	NextToken *string `type:"string"`

	// Information about changes that would be made in a rotation override.
	Overrides []*PreviewOverride `type:"list"`

	// Information about how long a rotation would last before restarting at the
	// beginning of the shift order.
	//
	// Recurrence is a required field
	Recurrence *RecurrenceSettings `type:"structure" required:"true"`

	// The date and time a rotation would begin. The first shift is calculated from
	// this date and time.
	RotationStartTime *time.Time `type:"timestamp"`

	// Used to filter the range of calculated shifts before sending the response
	// back to the user.
	StartTime *time.Time `type:"timestamp"`

	// The time zone the rotation’s activity would be based on, in Internet Assigned
	// Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC",
	// or "Asia/Seoul".
	//
	// TimeZoneId is a required field
	TimeZoneId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPreviewRotationShiftsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPreviewRotationShiftsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPreviewRotationShiftsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPreviewRotationShiftsInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.Members == nil {
		invalidParams.Add(request.NewErrParamRequired("Members"))
	}
	if s.Members != nil && len(s.Members) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Members", 1))
	}
	if s.Recurrence == nil {
		invalidParams.Add(request.NewErrParamRequired("Recurrence"))
	}
	if s.TimeZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeZoneId"))
	}
	if s.TimeZoneId != nil && len(*s.TimeZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TimeZoneId", 1))
	}
	if s.Recurrence != nil {
		if err := s.Recurrence.Validate(); err != nil {
			invalidParams.AddNested("Recurrence", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *ListPreviewRotationShiftsInput) SetEndTime(v time.Time) *ListPreviewRotationShiftsInput {
	s.EndTime = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPreviewRotationShiftsInput) SetMaxResults(v int64) *ListPreviewRotationShiftsInput {
	s.MaxResults = &v
	return s
}

// SetMembers sets the Members field's value.
func (s *ListPreviewRotationShiftsInput) SetMembers(v []*string) *ListPreviewRotationShiftsInput {
	s.Members = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPreviewRotationShiftsInput) SetNextToken(v string) *ListPreviewRotationShiftsInput {
	s.NextToken = &v
	return s
}

// SetOverrides sets the Overrides field's value.
func (s *ListPreviewRotationShiftsInput) SetOverrides(v []*PreviewOverride) *ListPreviewRotationShiftsInput {
	s.Overrides = v
	return s
}

// SetRecurrence sets the Recurrence field's value.
func (s *ListPreviewRotationShiftsInput) SetRecurrence(v *RecurrenceSettings) *ListPreviewRotationShiftsInput {
	s.Recurrence = v
	return s
}

// SetRotationStartTime sets the RotationStartTime field's value.
func (s *ListPreviewRotationShiftsInput) SetRotationStartTime(v time.Time) *ListPreviewRotationShiftsInput {
	s.RotationStartTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListPreviewRotationShiftsInput) SetStartTime(v time.Time) *ListPreviewRotationShiftsInput {
	s.StartTime = &v
	return s
}

// SetTimeZoneId sets the TimeZoneId field's value.
func (s *ListPreviewRotationShiftsInput) SetTimeZoneId(v string) *ListPreviewRotationShiftsInput {
	s.TimeZoneId = &v
	return s
}

type ListPreviewRotationShiftsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of items to return. This token is used to get
	// the next set of results.
	NextToken *string `type:"string"`

	// Details about a rotation shift, including times, types, and contacts.
	RotationShifts []*RotationShift `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPreviewRotationShiftsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPreviewRotationShiftsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPreviewRotationShiftsOutput) SetNextToken(v string) *ListPreviewRotationShiftsOutput {
	s.NextToken = &v
	return s
}

// SetRotationShifts sets the RotationShifts field's value.
func (s *ListPreviewRotationShiftsOutput) SetRotationShifts(v []*RotationShift) *ListPreviewRotationShiftsOutput {
	s.RotationShifts = v
	return s
}

type ListRotationOverridesInput struct {
	_ struct{} `type:"structure"`

	// The date and time for the end of a time range for listing overrides.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) of the rotation to retrieve information about.
	//
	// RotationId is a required field
	RotationId *string `min:"1" type:"string" required:"true"`

	// The date and time for the beginning of a time range for listing overrides.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRotationOverridesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRotationOverridesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRotationOverridesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRotationOverridesInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.RotationId == nil {
		invalidParams.Add(request.NewErrParamRequired("RotationId"))
	}
	if s.RotationId != nil && len(*s.RotationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RotationId", 1))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *ListRotationOverridesInput) SetEndTime(v time.Time) *ListRotationOverridesInput {
	s.EndTime = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRotationOverridesInput) SetMaxResults(v int64) *ListRotationOverridesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRotationOverridesInput) SetNextToken(v string) *ListRotationOverridesInput {
	s.NextToken = &v
	return s
}

// SetRotationId sets the RotationId field's value.
func (s *ListRotationOverridesInput) SetRotationId(v string) *ListRotationOverridesInput {
	s.RotationId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListRotationOverridesInput) SetStartTime(v time.Time) *ListRotationOverridesInput {
	s.StartTime = &v
	return s
}

type ListRotationOverridesOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `type:"string"`

	// A list of rotation overrides in the specified time range.
	RotationOverrides []*RotationOverride `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRotationOverridesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRotationOverridesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRotationOverridesOutput) SetNextToken(v string) *ListRotationOverridesOutput {
	s.NextToken = &v
	return s
}

// SetRotationOverrides sets the RotationOverrides field's value.
func (s *ListRotationOverridesOutput) SetRotationOverrides(v []*RotationOverride) *ListRotationOverridesOutput {
	s.RotationOverrides = v
	return s
}

type ListRotationShiftsInput struct {
	_ struct{} `type:"structure"`

	// The date and time for the end of the time range to list shifts for.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) of the rotation to retrieve shift information
	// about.
	//
	// RotationId is a required field
	RotationId *string `min:"1" type:"string" required:"true"`

	// The date and time for the beginning of the time range to list shifts for.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRotationShiftsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRotationShiftsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRotationShiftsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRotationShiftsInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.RotationId == nil {
		invalidParams.Add(request.NewErrParamRequired("RotationId"))
	}
	if s.RotationId != nil && len(*s.RotationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RotationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *ListRotationShiftsInput) SetEndTime(v time.Time) *ListRotationShiftsInput {
	s.EndTime = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRotationShiftsInput) SetMaxResults(v int64) *ListRotationShiftsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRotationShiftsInput) SetNextToken(v string) *ListRotationShiftsInput {
	s.NextToken = &v
	return s
}

// SetRotationId sets the RotationId field's value.
func (s *ListRotationShiftsInput) SetRotationId(v string) *ListRotationShiftsInput {
	s.RotationId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListRotationShiftsInput) SetStartTime(v time.Time) *ListRotationShiftsInput {
	s.StartTime = &v
	return s
}

type ListRotationShiftsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `type:"string"`

	// Information about shifts that meet the filter criteria.
	RotationShifts []*RotationShift `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRotationShiftsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRotationShiftsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRotationShiftsOutput) SetNextToken(v string) *ListRotationShiftsOutput {
	s.NextToken = &v
	return s
}

// SetRotationShifts sets the RotationShifts field's value.
func (s *ListRotationShiftsOutput) SetRotationShifts(v []*RotationShift) *ListRotationShiftsOutput {
	s.RotationShifts = v
	return s
}

type ListRotationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `type:"string"`

	// A filter to include rotations in list results based on their common prefix.
	// For example, entering prod returns a list of all rotation names that begin
	// with prod, such as production and prod-1.
	RotationNamePrefix *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRotationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRotationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRotationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRotationsInput"}
	if s.RotationNamePrefix != nil && len(*s.RotationNamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RotationNamePrefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRotationsInput) SetMaxResults(v int64) *ListRotationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRotationsInput) SetNextToken(v string) *ListRotationsInput {
	s.NextToken = &v
	return s
}

// SetRotationNamePrefix sets the RotationNamePrefix field's value.
func (s *ListRotationsInput) SetRotationNamePrefix(v string) *ListRotationsInput {
	s.RotationNamePrefix = &v
	return s
}

type ListRotationsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `type:"string"`

	// Information about rotations that meet the filter criteria.
	//
	// Rotations is a required field
	Rotations []*Rotation `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRotationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRotationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRotationsOutput) SetNextToken(v string) *ListRotationsOutput {
	s.NextToken = &v
	return s
}

// SetRotations sets the Rotations field's value.
func (s *ListRotationsOutput) SetRotations(v []*Rotation) *ListRotationsOutput {
	s.Rotations = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact or escalation plan.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags related to the contact or escalation plan.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Information about on-call rotations that recur monthly.
type MonthlySetting struct {
	_ struct{} `type:"structure"`

	// The day of the month when monthly recurring on-call rotations begin.
	//
	// DayOfMonth is a required field
	DayOfMonth *int64 `min:"1" type:"integer" required:"true"`

	// The time of day when a monthly recurring on-call shift rotation begins.
	//
	// HandOffTime is a required field
	HandOffTime *HandOffTime `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonthlySetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonthlySetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MonthlySetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MonthlySetting"}
	if s.DayOfMonth == nil {
		invalidParams.Add(request.NewErrParamRequired("DayOfMonth"))
	}
	if s.DayOfMonth != nil && *s.DayOfMonth < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DayOfMonth", 1))
	}
	if s.HandOffTime == nil {
		invalidParams.Add(request.NewErrParamRequired("HandOffTime"))
	}
	if s.HandOffTime != nil {
		if err := s.HandOffTime.Validate(); err != nil {
			invalidParams.AddNested("HandOffTime", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDayOfMonth sets the DayOfMonth field's value.
func (s *MonthlySetting) SetDayOfMonth(v int64) *MonthlySetting {
	s.DayOfMonth = &v
	return s
}

// SetHandOffTime sets the HandOffTime field's value.
func (s *MonthlySetting) SetHandOffTime(v *HandOffTime) *MonthlySetting {
	s.HandOffTime = v
	return s
}

// Incident Manager engaging a contact's contact channel.
type Page struct {
	_ struct{} `type:"structure"`

	// The ARN of the contact that Incident Manager is engaging.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`

	// The time the message was delivered to the contact channel.
	DeliveryTime *time.Time `type:"timestamp"`

	// The ARN of the engagement that this page is part of.
	//
	// EngagementArn is a required field
	EngagementArn *string `min:"1" type:"string" required:"true"`

	// The ARN of the incident that's engaging the contact channel.
	IncidentId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the page to the contact channel.
	//
	// PageArn is a required field
	PageArn *string `min:"1" type:"string" required:"true"`

	// The time that the contact channel acknowledged engagement.
	ReadTime *time.Time `type:"timestamp"`

	// The user that started the engagement.
	//
	// Sender is a required field
	Sender *string `type:"string" required:"true"`

	// The time that Incident Manager engaged the contact channel.
	SentTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Page) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Page) GoString() string {
	return s.String()
}

// SetContactArn sets the ContactArn field's value.
func (s *Page) SetContactArn(v string) *Page {
	s.ContactArn = &v
	return s
}

// SetDeliveryTime sets the DeliveryTime field's value.
func (s *Page) SetDeliveryTime(v time.Time) *Page {
	s.DeliveryTime = &v
	return s
}

// SetEngagementArn sets the EngagementArn field's value.
func (s *Page) SetEngagementArn(v string) *Page {
	s.EngagementArn = &v
	return s
}

// SetIncidentId sets the IncidentId field's value.
func (s *Page) SetIncidentId(v string) *Page {
	s.IncidentId = &v
	return s
}

// SetPageArn sets the PageArn field's value.
func (s *Page) SetPageArn(v string) *Page {
	s.PageArn = &v
	return s
}

// SetReadTime sets the ReadTime field's value.
func (s *Page) SetReadTime(v time.Time) *Page {
	s.ReadTime = &v
	return s
}

// SetSender sets the Sender field's value.
func (s *Page) SetSender(v string) *Page {
	s.Sender = &v
	return s
}

// SetSentTime sets the SentTime field's value.
func (s *Page) SetSentTime(v time.Time) *Page {
	s.SentTime = &v
	return s
}

// Information about the stages and on-call rotation teams associated with an
// escalation plan or engagement plan.
type Plan struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARNs) of the on-call rotations associated with
	// the plan.
	RotationIds []*string `type:"list"`

	// A list of stages that the escalation plan or engagement plan uses to engage
	// contacts and contact methods.
	Stages []*Stage `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Plan) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Plan) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Plan) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Plan"}
	if s.Stages != nil {
		for i, v := range s.Stages {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Stages", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRotationIds sets the RotationIds field's value.
func (s *Plan) SetRotationIds(v []*string) *Plan {
	s.RotationIds = v
	return s
}

// SetStages sets the Stages field's value.
func (s *Plan) SetStages(v []*Stage) *Plan {
	s.Stages = v
	return s
}

// Information about contacts and times that an on-call override replaces.
type PreviewOverride struct {
	_ struct{} `type:"structure"`

	// Information about the time a rotation override would end.
	EndTime *time.Time `type:"timestamp"`

	// Information about contacts to add to an on-call rotation override.
	NewMembers []*string `type:"list"`

	// Information about the time a rotation override would begin.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreviewOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreviewOverride) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *PreviewOverride) SetEndTime(v time.Time) *PreviewOverride {
	s.EndTime = &v
	return s
}

// SetNewMembers sets the NewMembers field's value.
func (s *PreviewOverride) SetNewMembers(v []*string) *PreviewOverride {
	s.NewMembers = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *PreviewOverride) SetStartTime(v time.Time) *PreviewOverride {
	s.StartTime = &v
	return s
}

type PutContactPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact or escalation plan.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`

	// Details of the resource policy.
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutContactPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutContactPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutContactPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutContactPolicyInput"}
	if s.ContactArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactArn"))
	}
	if s.ContactArn != nil && len(*s.ContactArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactArn", 1))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactArn sets the ContactArn field's value.
func (s *PutContactPolicyInput) SetContactArn(v string) *PutContactPolicyInput {
	s.ContactArn = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutContactPolicyInput) SetPolicy(v string) *PutContactPolicyInput {
	s.Policy = &v
	return s
}

type PutContactPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutContactPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutContactPolicyOutput) GoString() string {
	return s.String()
}

// Records events during an engagement.
type Receipt struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact channel Incident Manager engaged.
	ContactChannelArn *string `min:"1" type:"string"`

	// Information provided during the page acknowledgement.
	ReceiptInfo *string `min:"1" type:"string"`

	// The time receipt was SENT, DELIVERED, or READ.
	//
	// ReceiptTime is a required field
	ReceiptTime *time.Time `type:"timestamp" required:"true"`

	// The type follows the engagement cycle, SENT, DELIVERED, and READ.
	//
	// ReceiptType is a required field
	ReceiptType *string `type:"string" required:"true" enum:"ReceiptType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Receipt) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Receipt) GoString() string {
	return s.String()
}

// SetContactChannelArn sets the ContactChannelArn field's value.
func (s *Receipt) SetContactChannelArn(v string) *Receipt {
	s.ContactChannelArn = &v
	return s
}

// SetReceiptInfo sets the ReceiptInfo field's value.
func (s *Receipt) SetReceiptInfo(v string) *Receipt {
	s.ReceiptInfo = &v
	return s
}

// SetReceiptTime sets the ReceiptTime field's value.
func (s *Receipt) SetReceiptTime(v time.Time) *Receipt {
	s.ReceiptTime = &v
	return s
}

// SetReceiptType sets the ReceiptType field's value.
func (s *Receipt) SetReceiptType(v string) *Receipt {
	s.ReceiptType = &v
	return s
}

// Information about when an on-call rotation is in effect and how long the
// rotation period lasts.
type RecurrenceSettings struct {
	_ struct{} `type:"structure"`

	// Information about on-call rotations that recur daily.
	DailySettings []*HandOffTime `type:"list"`

	// Information about on-call rotations that recur monthly.
	MonthlySettings []*MonthlySetting `type:"list"`

	// The number of contacts, or shift team members designated to be on call concurrently
	// during a shift. For example, in an on-call schedule containing ten contacts,
	// a value of 2 designates that two of them are on call at any given time.
	//
	// NumberOfOnCalls is a required field
	NumberOfOnCalls *int64 `min:"1" type:"integer" required:"true"`

	// The number of days, weeks, or months a single rotation lasts.
	//
	// RecurrenceMultiplier is a required field
	RecurrenceMultiplier *int64 `min:"1" type:"integer" required:"true"`

	// Information about the days of the week included in on-call rotation coverage.
	ShiftCoverages map[string][]*CoverageTime `type:"map"`

	// Information about on-call rotations that recur weekly.
	WeeklySettings []*WeeklySetting `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecurrenceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecurrenceSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecurrenceSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecurrenceSettings"}
	if s.NumberOfOnCalls == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberOfOnCalls"))
	}
	if s.NumberOfOnCalls != nil && *s.NumberOfOnCalls < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfOnCalls", 1))
	}
	if s.RecurrenceMultiplier == nil {
		invalidParams.Add(request.NewErrParamRequired("RecurrenceMultiplier"))
	}
	if s.RecurrenceMultiplier != nil && *s.RecurrenceMultiplier < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RecurrenceMultiplier", 1))
	}
	if s.DailySettings != nil {
		for i, v := range s.DailySettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DailySettings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MonthlySettings != nil {
		for i, v := range s.MonthlySettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MonthlySettings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.WeeklySettings != nil {
		for i, v := range s.WeeklySettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "WeeklySettings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDailySettings sets the DailySettings field's value.
func (s *RecurrenceSettings) SetDailySettings(v []*HandOffTime) *RecurrenceSettings {
	s.DailySettings = v
	return s
}

// SetMonthlySettings sets the MonthlySettings field's value.
func (s *RecurrenceSettings) SetMonthlySettings(v []*MonthlySetting) *RecurrenceSettings {
	s.MonthlySettings = v
	return s
}

// SetNumberOfOnCalls sets the NumberOfOnCalls field's value.
func (s *RecurrenceSettings) SetNumberOfOnCalls(v int64) *RecurrenceSettings {
	s.NumberOfOnCalls = &v
	return s
}

// SetRecurrenceMultiplier sets the RecurrenceMultiplier field's value.
func (s *RecurrenceSettings) SetRecurrenceMultiplier(v int64) *RecurrenceSettings {
	s.RecurrenceMultiplier = &v
	return s
}

// SetShiftCoverages sets the ShiftCoverages field's value.
func (s *RecurrenceSettings) SetShiftCoverages(v map[string][]*CoverageTime) *RecurrenceSettings {
	s.ShiftCoverages = v
	return s
}

// SetWeeklySettings sets the WeeklySettings field's value.
func (s *RecurrenceSettings) SetWeeklySettings(v []*WeeklySetting) *RecurrenceSettings {
	s.WeeklySettings = v
	return s
}

// Information about the engagement resolution steps. The resolution starts
// from the first contact, which can be an escalation plan, then resolves to
// an on-call rotation, and finally to a personal contact.
//
// The ResolutionContact structure describes the information for each node or
// step in that process. It contains information about different contact types,
// such as the escalation, rotation, and personal contacts.
type ResolutionContact struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of a contact in the engagement resolution
	// process.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`

	// The stage in the escalation plan that resolves to this contact.
	StageIndex *int64 `type:"integer"`

	// The type of contact for a resolution step.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ContactType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolutionContact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolutionContact) GoString() string {
	return s.String()
}

// SetContactArn sets the ContactArn field's value.
func (s *ResolutionContact) SetContactArn(v string) *ResolutionContact {
	s.ContactArn = &v
	return s
}

// SetStageIndex sets the StageIndex field's value.
func (s *ResolutionContact) SetStageIndex(v int64) *ResolutionContact {
	s.StageIndex = &v
	return s
}

// SetType sets the Type field's value.
func (s *ResolutionContact) SetType(v string) *ResolutionContact {
	s.Type = &v
	return s
}

// Request references a resource that doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Hypothetical resource identifier that was not found
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// Hypothetical resource type that was not found
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a rotation in an on-call schedule.
type Rotation struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARNs) of the contacts assigned to the rotation
	// team.
	ContactIds []*string `type:"list"`

	// The name of the rotation.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Information about when an on-call rotation is in effect and how long the
	// rotation period lasts.
	Recurrence *RecurrenceSettings `type:"structure"`

	// The Amazon Resource Name (ARN) of the rotation.
	//
	// RotationArn is a required field
	RotationArn *string `min:"1" type:"string" required:"true"`

	// The date and time the rotation becomes active.
	StartTime *time.Time `type:"timestamp"`

	// The time zone the rotation’s activity is based on, in Internet Assigned
	// Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC",
	// or "Asia/Seoul".
	TimeZoneId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rotation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rotation) GoString() string {
	return s.String()
}

// SetContactIds sets the ContactIds field's value.
func (s *Rotation) SetContactIds(v []*string) *Rotation {
	s.ContactIds = v
	return s
}

// SetName sets the Name field's value.
func (s *Rotation) SetName(v string) *Rotation {
	s.Name = &v
	return s
}

// SetRecurrence sets the Recurrence field's value.
func (s *Rotation) SetRecurrence(v *RecurrenceSettings) *Rotation {
	s.Recurrence = v
	return s
}

// SetRotationArn sets the RotationArn field's value.
func (s *Rotation) SetRotationArn(v string) *Rotation {
	s.RotationArn = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Rotation) SetStartTime(v time.Time) *Rotation {
	s.StartTime = &v
	return s
}

// SetTimeZoneId sets the TimeZoneId field's value.
func (s *Rotation) SetTimeZoneId(v string) *Rotation {
	s.TimeZoneId = &v
	return s
}

// Information about an override specified for an on-call rotation.
type RotationOverride struct {
	_ struct{} `type:"structure"`

	// The time a rotation override was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" required:"true"`

	// The time a rotation override ends.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// The Amazon Resource Names (ARNs) of the contacts assigned to the override
	// of the on-call rotation.
	//
	// NewContactIds is a required field
	NewContactIds []*string `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the override to an on-call rotation.
	//
	// RotationOverrideId is a required field
	RotationOverrideId *string `min:"36" type:"string" required:"true"`

	// The time a rotation override begins.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RotationOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RotationOverride) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *RotationOverride) SetCreateTime(v time.Time) *RotationOverride {
	s.CreateTime = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *RotationOverride) SetEndTime(v time.Time) *RotationOverride {
	s.EndTime = &v
	return s
}

// SetNewContactIds sets the NewContactIds field's value.
func (s *RotationOverride) SetNewContactIds(v []*string) *RotationOverride {
	s.NewContactIds = v
	return s
}

// SetRotationOverrideId sets the RotationOverrideId field's value.
func (s *RotationOverride) SetRotationOverrideId(v string) *RotationOverride {
	s.RotationOverrideId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *RotationOverride) SetStartTime(v time.Time) *RotationOverride {
	s.StartTime = &v
	return s
}

// Information about a shift that belongs to an on-call rotation.
type RotationShift struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARNs) of the contacts who are part of the shift
	// rotation.
	ContactIds []*string `type:"list"`

	// The time a shift rotation ends.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// Additional information about an on-call rotation shift.
	ShiftDetails *ShiftDetails `type:"structure"`

	// The time a shift rotation begins.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`

	// The type of shift rotation.
	Type *string `type:"string" enum:"ShiftType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RotationShift) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RotationShift) GoString() string {
	return s.String()
}

// SetContactIds sets the ContactIds field's value.
func (s *RotationShift) SetContactIds(v []*string) *RotationShift {
	s.ContactIds = v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *RotationShift) SetEndTime(v time.Time) *RotationShift {
	s.EndTime = &v
	return s
}

// SetShiftDetails sets the ShiftDetails field's value.
func (s *RotationShift) SetShiftDetails(v *ShiftDetails) *RotationShift {
	s.ShiftDetails = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *RotationShift) SetStartTime(v time.Time) *RotationShift {
	s.StartTime = &v
	return s
}

// SetType sets the Type field's value.
func (s *RotationShift) SetType(v string) *RotationShift {
	s.Type = &v
	return s
}

type SendActivationCodeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact channel.
	//
	// ContactChannelId is a required field
	ContactChannelId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendActivationCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendActivationCodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendActivationCodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendActivationCodeInput"}
	if s.ContactChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactChannelId"))
	}
	if s.ContactChannelId != nil && len(*s.ContactChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactChannelId sets the ContactChannelId field's value.
func (s *SendActivationCodeInput) SetContactChannelId(v string) *SendActivationCodeInput {
	s.ContactChannelId = &v
	return s
}

type SendActivationCodeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendActivationCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendActivationCodeOutput) GoString() string {
	return s.String()
}

// Request would cause a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Service Quotas requirement to identify originating service
	//
	// QuotaCode is a required field
	QuotaCode *string `type:"string" required:"true"`

	// Identifier of the resource affected
	ResourceId *string `type:"string"`

	// Type of the resource affected
	ResourceType *string `type:"string"`

	// Service Quotas requirement to identify originating quota
	//
	// ServiceCode is a required field
	ServiceCode *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about overrides to an on-call rotation shift.
type ShiftDetails struct {
	_ struct{} `type:"structure"`

	// The Amazon Resources Names (ARNs) of the contacts who were replaced in a
	// shift when an override was created. If the override is deleted, these contacts
	// are restored to the shift.
	//
	// OverriddenContactIds is a required field
	OverriddenContactIds []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShiftDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShiftDetails) GoString() string {
	return s.String()
}

// SetOverriddenContactIds sets the OverriddenContactIds field's value.
func (s *ShiftDetails) SetOverriddenContactIds(v []*string) *ShiftDetails {
	s.OverriddenContactIds = v
	return s
}

// A set amount of time that an escalation plan or engagement plan engages the
// specified contacts or contact methods.
type Stage struct {
	_ struct{} `type:"structure"`

	// The time to wait until beginning the next stage. The duration can only be
	// set to 0 if a target is specified.
	//
	// DurationInMinutes is a required field
	DurationInMinutes *int64 `type:"integer" required:"true"`

	// The contacts or contact methods that the escalation plan or engagement plan
	// is engaging.
	//
	// Targets is a required field
	Targets []*Target `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Stage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Stage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Stage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Stage"}
	if s.DurationInMinutes == nil {
		invalidParams.Add(request.NewErrParamRequired("DurationInMinutes"))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDurationInMinutes sets the DurationInMinutes field's value.
func (s *Stage) SetDurationInMinutes(v int64) *Stage {
	s.DurationInMinutes = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *Stage) SetTargets(v []*Target) *Stage {
	s.Targets = v
	return s
}

type StartEngagementInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact being engaged.
	//
	// ContactId is a required field
	ContactId *string `min:"1" type:"string" required:"true"`

	// The secure content of the message that was sent to the contact. Use this
	// field for engagements to VOICE or EMAIL.
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true"`

	// A token ensuring that the operation is called only once with the specified
	// details.
	IdempotencyToken *string `type:"string" idempotencyToken:"true"`

	// The ARN of the incident that the engagement is part of.
	IncidentId *string `type:"string"`

	// The insecure content of the message that was sent to the contact. Use this
	// field for engagements to SMS.
	PublicContent *string `min:"1" type:"string"`

	// The insecure subject of the message that was sent to the contact. Use this
	// field for engagements to SMS.
	PublicSubject *string `min:"1" type:"string"`

	// The user that started the engagement.
	//
	// Sender is a required field
	Sender *string `type:"string" required:"true"`

	// The secure subject of the message that was sent to the contact. Use this
	// field for engagements to VOICE or EMAIL.
	//
	// Subject is a required field
	Subject *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEngagementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEngagementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartEngagementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartEngagementInput"}
	if s.ContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.PublicContent != nil && len(*s.PublicContent) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PublicContent", 1))
	}
	if s.PublicSubject != nil && len(*s.PublicSubject) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PublicSubject", 1))
	}
	if s.Sender == nil {
		invalidParams.Add(request.NewErrParamRequired("Sender"))
	}
	if s.Subject == nil {
		invalidParams.Add(request.NewErrParamRequired("Subject"))
	}
	if s.Subject != nil && len(*s.Subject) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Subject", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactId sets the ContactId field's value.
func (s *StartEngagementInput) SetContactId(v string) *StartEngagementInput {
	s.ContactId = &v
	return s
}

// SetContent sets the Content field's value.
func (s *StartEngagementInput) SetContent(v string) *StartEngagementInput {
	s.Content = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *StartEngagementInput) SetIdempotencyToken(v string) *StartEngagementInput {
	s.IdempotencyToken = &v
	return s
}

// SetIncidentId sets the IncidentId field's value.
func (s *StartEngagementInput) SetIncidentId(v string) *StartEngagementInput {
	s.IncidentId = &v
	return s
}

// SetPublicContent sets the PublicContent field's value.
func (s *StartEngagementInput) SetPublicContent(v string) *StartEngagementInput {
	s.PublicContent = &v
	return s
}

// SetPublicSubject sets the PublicSubject field's value.
func (s *StartEngagementInput) SetPublicSubject(v string) *StartEngagementInput {
	s.PublicSubject = &v
	return s
}

// SetSender sets the Sender field's value.
func (s *StartEngagementInput) SetSender(v string) *StartEngagementInput {
	s.Sender = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *StartEngagementInput) SetSubject(v string) *StartEngagementInput {
	s.Subject = &v
	return s
}

type StartEngagementOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the engagement.
	//
	// EngagementArn is a required field
	EngagementArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEngagementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEngagementOutput) GoString() string {
	return s.String()
}

// SetEngagementArn sets the EngagementArn field's value.
func (s *StartEngagementOutput) SetEngagementArn(v string) *StartEngagementOutput {
	s.EngagementArn = &v
	return s
}

type StopEngagementInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the engagement.
	//
	// EngagementId is a required field
	EngagementId *string `min:"1" type:"string" required:"true"`

	// The reason that you're stopping the engagement.
	Reason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEngagementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEngagementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopEngagementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopEngagementInput"}
	if s.EngagementId == nil {
		invalidParams.Add(request.NewErrParamRequired("EngagementId"))
	}
	if s.EngagementId != nil && len(*s.EngagementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EngagementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngagementId sets the EngagementId field's value.
func (s *StopEngagementInput) SetEngagementId(v string) *StopEngagementInput {
	s.EngagementId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *StopEngagementInput) SetReason(v string) *StopEngagementInput {
	s.Reason = &v
	return s
}

type StopEngagementOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEngagementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEngagementOutput) GoString() string {
	return s.String()
}

// A container of a key-value name pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// Name of the object key.
	Key *string `min:"1" type:"string"`

	// Value of the tag.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact or escalation plan.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// A list of tags that you are adding to the contact or escalation plan.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The contact or contact channel that's being engaged.
type Target struct {
	_ struct{} `type:"structure"`

	// Information about the contact channel Incident Manager is engaging.
	ChannelTargetInfo *ChannelTargetInfo `type:"structure"`

	// Information about the contact that Incident Manager is engaging.
	ContactTargetInfo *ContactTargetInfo `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Target) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Target) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Target) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Target"}
	if s.ChannelTargetInfo != nil {
		if err := s.ChannelTargetInfo.Validate(); err != nil {
			invalidParams.AddNested("ChannelTargetInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.ContactTargetInfo != nil {
		if err := s.ContactTargetInfo.Validate(); err != nil {
			invalidParams.AddNested("ContactTargetInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelTargetInfo sets the ChannelTargetInfo field's value.
func (s *Target) SetChannelTargetInfo(v *ChannelTargetInfo) *Target {
	s.ChannelTargetInfo = v
	return s
}

// SetContactTargetInfo sets the ContactTargetInfo field's value.
func (s *Target) SetContactTargetInfo(v *ContactTargetInfo) *Target {
	s.ContactTargetInfo = v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Service Quotas requirement to identify originating service
	QuotaCode *string `type:"string"`

	// Advice to clients on when the call can be safely retried
	RetryAfterSeconds *int64 `type:"integer"`

	// Service Quotas requirement to identify originating quota
	ServiceCode *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A range of between two set times
type TimeRange struct {
	_ struct{} `type:"structure"`

	// The end of the time range.
	EndTime *time.Time `type:"timestamp"`

	// The start of the time range.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeRange) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *TimeRange) SetEndTime(v time.Time) *TimeRange {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *TimeRange) SetStartTime(v time.Time) *TimeRange {
	s.StartTime = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact or escalation plan.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The key of the tag that you want to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateContactChannelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact channel you want to update.
	//
	// ContactChannelId is a required field
	ContactChannelId *string `min:"1" type:"string" required:"true"`

	// The details that Incident Manager uses when trying to engage the contact
	// channel.
	DeliveryAddress *ContactChannelAddress `type:"structure"`

	// The name of the contact channel.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContactChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContactChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateContactChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateContactChannelInput"}
	if s.ContactChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactChannelId"))
	}
	if s.ContactChannelId != nil && len(*s.ContactChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactChannelId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.DeliveryAddress != nil {
		if err := s.DeliveryAddress.Validate(); err != nil {
			invalidParams.AddNested("DeliveryAddress", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactChannelId sets the ContactChannelId field's value.
func (s *UpdateContactChannelInput) SetContactChannelId(v string) *UpdateContactChannelInput {
	s.ContactChannelId = &v
	return s
}

// SetDeliveryAddress sets the DeliveryAddress field's value.
func (s *UpdateContactChannelInput) SetDeliveryAddress(v *ContactChannelAddress) *UpdateContactChannelInput {
	s.DeliveryAddress = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateContactChannelInput) SetName(v string) *UpdateContactChannelInput {
	s.Name = &v
	return s
}

type UpdateContactChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContactChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContactChannelOutput) GoString() string {
	return s.String()
}

type UpdateContactInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact or escalation plan you're updating.
	//
	// ContactId is a required field
	ContactId *string `min:"1" type:"string" required:"true"`

	// The full name of the contact or escalation plan.
	DisplayName *string `type:"string"`

	// A list of stages. A contact has an engagement plan with stages for specified
	// contact channels. An escalation plan uses these stages to contact specified
	// contacts.
	Plan *Plan `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateContactInput"}
	if s.ContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}
	if s.Plan != nil {
		if err := s.Plan.Validate(); err != nil {
			invalidParams.AddNested("Plan", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactId sets the ContactId field's value.
func (s *UpdateContactInput) SetContactId(v string) *UpdateContactInput {
	s.ContactId = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateContactInput) SetDisplayName(v string) *UpdateContactInput {
	s.DisplayName = &v
	return s
}

// SetPlan sets the Plan field's value.
func (s *UpdateContactInput) SetPlan(v *Plan) *UpdateContactInput {
	s.Plan = v
	return s
}

type UpdateContactOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContactOutput) GoString() string {
	return s.String()
}

type UpdateRotationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARNs) of the contacts to include in the updated
	// rotation.
	//
	// The order in which you list the contacts is their shift order in the rotation
	// schedule.
	ContactIds []*string `min:"1" type:"list"`

	// Information about how long the updated rotation lasts before restarting at
	// the beginning of the shift order.
	//
	// Recurrence is a required field
	Recurrence *RecurrenceSettings `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the rotation to update.
	//
	// RotationId is a required field
	RotationId *string `min:"1" type:"string" required:"true"`

	// The date and time the rotation goes into effect.
	StartTime *time.Time `type:"timestamp"`

	// The time zone to base the updated rotation’s activity on, in Internet Assigned
	// Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC",
	// or "Asia/Seoul". For more information, see the Time Zone Database (https://www.iana.org/time-zones)
	// on the IANA website.
	//
	// Designators for time zones that don’t support Daylight Savings Time Rules,
	// such as Pacific Standard Time (PST) and Pacific Daylight Time (PDT), aren't
	// supported.
	TimeZoneId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRotationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRotationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRotationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRotationInput"}
	if s.ContactIds != nil && len(s.ContactIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactIds", 1))
	}
	if s.Recurrence == nil {
		invalidParams.Add(request.NewErrParamRequired("Recurrence"))
	}
	if s.RotationId == nil {
		invalidParams.Add(request.NewErrParamRequired("RotationId"))
	}
	if s.RotationId != nil && len(*s.RotationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RotationId", 1))
	}
	if s.TimeZoneId != nil && len(*s.TimeZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TimeZoneId", 1))
	}
	if s.Recurrence != nil {
		if err := s.Recurrence.Validate(); err != nil {
			invalidParams.AddNested("Recurrence", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactIds sets the ContactIds field's value.
func (s *UpdateRotationInput) SetContactIds(v []*string) *UpdateRotationInput {
	s.ContactIds = v
	return s
}

// SetRecurrence sets the Recurrence field's value.
func (s *UpdateRotationInput) SetRecurrence(v *RecurrenceSettings) *UpdateRotationInput {
	s.Recurrence = v
	return s
}

// SetRotationId sets the RotationId field's value.
func (s *UpdateRotationInput) SetRotationId(v string) *UpdateRotationInput {
	s.RotationId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *UpdateRotationInput) SetStartTime(v time.Time) *UpdateRotationInput {
	s.StartTime = &v
	return s
}

// SetTimeZoneId sets the TimeZoneId field's value.
func (s *UpdateRotationInput) SetTimeZoneId(v string) *UpdateRotationInput {
	s.TimeZoneId = &v
	return s
}

type UpdateRotationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRotationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRotationOutput) GoString() string {
	return s.String()
}

// The input fails to satisfy the constraints specified by an Amazon Web Services
// service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The fields that caused the error
	Fields []*ValidationExceptionField `type:"list"`

	Message_ *string `locationName:"Message" type:"string"`

	// Reason the request failed validation
	Reason *string `type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information about which field caused the exception.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// Information about what caused the field to cause an exception.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The name of the field that caused the exception.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// Information about rotations that recur weekly.
type WeeklySetting struct {
	_ struct{} `type:"structure"`

	// The day of the week when weekly recurring on-call shift rotations begins.
	//
	// DayOfWeek is a required field
	DayOfWeek *string `type:"string" required:"true" enum:"DayOfWeek"`

	// The time of day when a weekly recurring on-call shift rotation begins.
	//
	// HandOffTime is a required field
	HandOffTime *HandOffTime `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WeeklySetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WeeklySetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WeeklySetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WeeklySetting"}
	if s.DayOfWeek == nil {
		invalidParams.Add(request.NewErrParamRequired("DayOfWeek"))
	}
	if s.HandOffTime == nil {
		invalidParams.Add(request.NewErrParamRequired("HandOffTime"))
	}
	if s.HandOffTime != nil {
		if err := s.HandOffTime.Validate(); err != nil {
			invalidParams.AddNested("HandOffTime", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDayOfWeek sets the DayOfWeek field's value.
func (s *WeeklySetting) SetDayOfWeek(v string) *WeeklySetting {
	s.DayOfWeek = &v
	return s
}

// SetHandOffTime sets the HandOffTime field's value.
func (s *WeeklySetting) SetHandOffTime(v *HandOffTime) *WeeklySetting {
	s.HandOffTime = v
	return s
}

const (
	// AcceptCodeValidationIgnore is a AcceptCodeValidation enum value
	AcceptCodeValidationIgnore = "IGNORE"

	// AcceptCodeValidationEnforce is a AcceptCodeValidation enum value
	AcceptCodeValidationEnforce = "ENFORCE"
)

// AcceptCodeValidation_Values returns all elements of the AcceptCodeValidation enum
func AcceptCodeValidation_Values() []string {
	return []string{
		AcceptCodeValidationIgnore,
		AcceptCodeValidationEnforce,
	}
}

const (
	// AcceptTypeDelivered is a AcceptType enum value
	AcceptTypeDelivered = "DELIVERED"

	// AcceptTypeRead is a AcceptType enum value
	AcceptTypeRead = "READ"
)

// AcceptType_Values returns all elements of the AcceptType enum
func AcceptType_Values() []string {
	return []string{
		AcceptTypeDelivered,
		AcceptTypeRead,
	}
}

const (
	// ActivationStatusActivated is a ActivationStatus enum value
	ActivationStatusActivated = "ACTIVATED"

	// ActivationStatusNotActivated is a ActivationStatus enum value
	ActivationStatusNotActivated = "NOT_ACTIVATED"
)

// ActivationStatus_Values returns all elements of the ActivationStatus enum
func ActivationStatus_Values() []string {
	return []string{
		ActivationStatusActivated,
		ActivationStatusNotActivated,
	}
}

const (
	// ChannelTypeSms is a ChannelType enum value
	ChannelTypeSms = "SMS"

	// ChannelTypeVoice is a ChannelType enum value
	ChannelTypeVoice = "VOICE"

	// ChannelTypeEmail is a ChannelType enum value
	ChannelTypeEmail = "EMAIL"
)

// ChannelType_Values returns all elements of the ChannelType enum
func ChannelType_Values() []string {
	return []string{
		ChannelTypeSms,
		ChannelTypeVoice,
		ChannelTypeEmail,
	}
}

const (
	// ContactTypePersonal is a ContactType enum value
	ContactTypePersonal = "PERSONAL"

	// ContactTypeEscalation is a ContactType enum value
	ContactTypeEscalation = "ESCALATION"

	// ContactTypeOncallSchedule is a ContactType enum value
	ContactTypeOncallSchedule = "ONCALL_SCHEDULE"
)

// ContactType_Values returns all elements of the ContactType enum
func ContactType_Values() []string {
	return []string{
		ContactTypePersonal,
		ContactTypeEscalation,
		ContactTypeOncallSchedule,
	}
}

const (
	// DayOfWeekMon is a DayOfWeek enum value
	DayOfWeekMon = "MON"

	// DayOfWeekTue is a DayOfWeek enum value
	DayOfWeekTue = "TUE"

	// DayOfWeekWed is a DayOfWeek enum value
	DayOfWeekWed = "WED"

	// DayOfWeekThu is a DayOfWeek enum value
	DayOfWeekThu = "THU"

	// DayOfWeekFri is a DayOfWeek enum value
	DayOfWeekFri = "FRI"

	// DayOfWeekSat is a DayOfWeek enum value
	DayOfWeekSat = "SAT"

	// DayOfWeekSun is a DayOfWeek enum value
	DayOfWeekSun = "SUN"
)

// DayOfWeek_Values returns all elements of the DayOfWeek enum
func DayOfWeek_Values() []string {
	return []string{
		DayOfWeekMon,
		DayOfWeekTue,
		DayOfWeekWed,
		DayOfWeekThu,
		DayOfWeekFri,
		DayOfWeekSat,
		DayOfWeekSun,
	}
}

const (
	// ReceiptTypeDelivered is a ReceiptType enum value
	ReceiptTypeDelivered = "DELIVERED"

	// ReceiptTypeError is a ReceiptType enum value
	ReceiptTypeError = "ERROR"

	// ReceiptTypeRead is a ReceiptType enum value
	ReceiptTypeRead = "READ"

	// ReceiptTypeSent is a ReceiptType enum value
	ReceiptTypeSent = "SENT"

	// ReceiptTypeStop is a ReceiptType enum value
	ReceiptTypeStop = "STOP"
)

// ReceiptType_Values returns all elements of the ReceiptType enum
func ReceiptType_Values() []string {
	return []string{
		ReceiptTypeDelivered,
		ReceiptTypeError,
		ReceiptTypeRead,
		ReceiptTypeSent,
		ReceiptTypeStop,
	}
}

const (
	// ShiftTypeRegular is a ShiftType enum value
	ShiftTypeRegular = "REGULAR"

	// ShiftTypeOverridden is a ShiftType enum value
	ShiftTypeOverridden = "OVERRIDDEN"
)

// ShiftType_Values returns all elements of the ShiftType enum
func ShiftType_Values() []string {
	return []string{
		ShiftTypeRegular,
		ShiftTypeOverridden,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UNKNOWN_OPERATION"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "CANNOT_PARSE"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
