// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pcaconnectorad

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateConnector = "CreateConnector"

// CreateConnectorRequest generates a "aws/request.Request" representing the
// client's request for the CreateConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConnector for more information on using the CreateConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateConnectorRequest method.
//	req, resp := client.CreateConnectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/CreateConnector
func (c *PcaConnectorAd) CreateConnectorRequest(input *CreateConnectorInput) (req *request.Request, output *CreateConnectorOutput) {
	op := &request.Operation{
		Name:       opCreateConnector,
		HTTPMethod: "POST",
		HTTPPath:   "/connectors",
	}

	if input == nil {
		input = &CreateConnectorInput{}
	}

	output = &CreateConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConnector API operation for PcaConnectorAd.
//
// Creates a connector between Amazon Web Services Private CA and an Active
// Directory. You must specify the private CA, directory ID, and security groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation CreateConnector for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ConflictException
//     This request cannot be completed for one of the following reasons because
//     the requested resource was being concurrently modified by another request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/CreateConnector
func (c *PcaConnectorAd) CreateConnector(input *CreateConnectorInput) (*CreateConnectorOutput, error) {
	req, out := c.CreateConnectorRequest(input)
	return out, req.Send()
}

// CreateConnectorWithContext is the same as CreateConnector with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) CreateConnectorWithContext(ctx aws.Context, input *CreateConnectorInput, opts ...request.Option) (*CreateConnectorOutput, error) {
	req, out := c.CreateConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDirectoryRegistration = "CreateDirectoryRegistration"

// CreateDirectoryRegistrationRequest generates a "aws/request.Request" representing the
// client's request for the CreateDirectoryRegistration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDirectoryRegistration for more information on using the CreateDirectoryRegistration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDirectoryRegistrationRequest method.
//	req, resp := client.CreateDirectoryRegistrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/CreateDirectoryRegistration
func (c *PcaConnectorAd) CreateDirectoryRegistrationRequest(input *CreateDirectoryRegistrationInput) (req *request.Request, output *CreateDirectoryRegistrationOutput) {
	op := &request.Operation{
		Name:       opCreateDirectoryRegistration,
		HTTPMethod: "POST",
		HTTPPath:   "/directoryRegistrations",
	}

	if input == nil {
		input = &CreateDirectoryRegistrationInput{}
	}

	output = &CreateDirectoryRegistrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDirectoryRegistration API operation for PcaConnectorAd.
//
// Creates a directory registration that authorizes communication between Amazon
// Web Services Private CA and an Active Directory
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation CreateDirectoryRegistration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ConflictException
//     This request cannot be completed for one of the following reasons because
//     the requested resource was being concurrently modified by another request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/CreateDirectoryRegistration
func (c *PcaConnectorAd) CreateDirectoryRegistration(input *CreateDirectoryRegistrationInput) (*CreateDirectoryRegistrationOutput, error) {
	req, out := c.CreateDirectoryRegistrationRequest(input)
	return out, req.Send()
}

// CreateDirectoryRegistrationWithContext is the same as CreateDirectoryRegistration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDirectoryRegistration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) CreateDirectoryRegistrationWithContext(ctx aws.Context, input *CreateDirectoryRegistrationInput, opts ...request.Option) (*CreateDirectoryRegistrationOutput, error) {
	req, out := c.CreateDirectoryRegistrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateServicePrincipalName = "CreateServicePrincipalName"

// CreateServicePrincipalNameRequest generates a "aws/request.Request" representing the
// client's request for the CreateServicePrincipalName operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateServicePrincipalName for more information on using the CreateServicePrincipalName
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateServicePrincipalNameRequest method.
//	req, resp := client.CreateServicePrincipalNameRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/CreateServicePrincipalName
func (c *PcaConnectorAd) CreateServicePrincipalNameRequest(input *CreateServicePrincipalNameInput) (req *request.Request, output *CreateServicePrincipalNameOutput) {
	op := &request.Operation{
		Name:       opCreateServicePrincipalName,
		HTTPMethod: "POST",
		HTTPPath:   "/directoryRegistrations/{DirectoryRegistrationArn}/servicePrincipalNames/{ConnectorArn}",
	}

	if input == nil {
		input = &CreateServicePrincipalNameInput{}
	}

	output = &CreateServicePrincipalNameOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateServicePrincipalName API operation for PcaConnectorAd.
//
// Creates a service principal name (SPN) for the service account in Active
// Directory. Kerberos authentication uses SPNs to associate a service instance
// with a service sign-in account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation CreateServicePrincipalName for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ConflictException
//     This request cannot be completed for one of the following reasons because
//     the requested resource was being concurrently modified by another request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/CreateServicePrincipalName
func (c *PcaConnectorAd) CreateServicePrincipalName(input *CreateServicePrincipalNameInput) (*CreateServicePrincipalNameOutput, error) {
	req, out := c.CreateServicePrincipalNameRequest(input)
	return out, req.Send()
}

// CreateServicePrincipalNameWithContext is the same as CreateServicePrincipalName with the addition of
// the ability to pass a context and additional request options.
//
// See CreateServicePrincipalName for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) CreateServicePrincipalNameWithContext(ctx aws.Context, input *CreateServicePrincipalNameInput, opts ...request.Option) (*CreateServicePrincipalNameOutput, error) {
	req, out := c.CreateServicePrincipalNameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTemplate = "CreateTemplate"

// CreateTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTemplate for more information on using the CreateTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTemplateRequest method.
//	req, resp := client.CreateTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/CreateTemplate
func (c *PcaConnectorAd) CreateTemplateRequest(input *CreateTemplateInput) (req *request.Request, output *CreateTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/templates",
	}

	if input == nil {
		input = &CreateTemplateInput{}
	}

	output = &CreateTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTemplate API operation for PcaConnectorAd.
//
// Creates an Active Directory compatible certificate template. The connectors
// issues certificates using these templates based on the requester’s Active
// Directory group membership.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation CreateTemplate for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ConflictException
//     This request cannot be completed for one of the following reasons because
//     the requested resource was being concurrently modified by another request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/CreateTemplate
func (c *PcaConnectorAd) CreateTemplate(input *CreateTemplateInput) (*CreateTemplateOutput, error) {
	req, out := c.CreateTemplateRequest(input)
	return out, req.Send()
}

// CreateTemplateWithContext is the same as CreateTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) CreateTemplateWithContext(ctx aws.Context, input *CreateTemplateInput, opts ...request.Option) (*CreateTemplateOutput, error) {
	req, out := c.CreateTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTemplateGroupAccessControlEntry = "CreateTemplateGroupAccessControlEntry"

// CreateTemplateGroupAccessControlEntryRequest generates a "aws/request.Request" representing the
// client's request for the CreateTemplateGroupAccessControlEntry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTemplateGroupAccessControlEntry for more information on using the CreateTemplateGroupAccessControlEntry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTemplateGroupAccessControlEntryRequest method.
//	req, resp := client.CreateTemplateGroupAccessControlEntryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/CreateTemplateGroupAccessControlEntry
func (c *PcaConnectorAd) CreateTemplateGroupAccessControlEntryRequest(input *CreateTemplateGroupAccessControlEntryInput) (req *request.Request, output *CreateTemplateGroupAccessControlEntryOutput) {
	op := &request.Operation{
		Name:       opCreateTemplateGroupAccessControlEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/templates/{TemplateArn}/accessControlEntries",
	}

	if input == nil {
		input = &CreateTemplateGroupAccessControlEntryInput{}
	}

	output = &CreateTemplateGroupAccessControlEntryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateTemplateGroupAccessControlEntry API operation for PcaConnectorAd.
//
// Create a group access control entry. Allow or deny Active Directory groups
// from enrolling and/or autoenrolling with the template based on the group
// security identifiers (SIDs).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation CreateTemplateGroupAccessControlEntry for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ConflictException
//     This request cannot be completed for one of the following reasons because
//     the requested resource was being concurrently modified by another request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/CreateTemplateGroupAccessControlEntry
func (c *PcaConnectorAd) CreateTemplateGroupAccessControlEntry(input *CreateTemplateGroupAccessControlEntryInput) (*CreateTemplateGroupAccessControlEntryOutput, error) {
	req, out := c.CreateTemplateGroupAccessControlEntryRequest(input)
	return out, req.Send()
}

// CreateTemplateGroupAccessControlEntryWithContext is the same as CreateTemplateGroupAccessControlEntry with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTemplateGroupAccessControlEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) CreateTemplateGroupAccessControlEntryWithContext(ctx aws.Context, input *CreateTemplateGroupAccessControlEntryInput, opts ...request.Option) (*CreateTemplateGroupAccessControlEntryOutput, error) {
	req, out := c.CreateTemplateGroupAccessControlEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConnector = "DeleteConnector"

// DeleteConnectorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConnector for more information on using the DeleteConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteConnectorRequest method.
//	req, resp := client.DeleteConnectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/DeleteConnector
func (c *PcaConnectorAd) DeleteConnectorRequest(input *DeleteConnectorInput) (req *request.Request, output *DeleteConnectorOutput) {
	op := &request.Operation{
		Name:       opDeleteConnector,
		HTTPMethod: "DELETE",
		HTTPPath:   "/connectors/{ConnectorArn}",
	}

	if input == nil {
		input = &DeleteConnectorInput{}
	}

	output = &DeleteConnectorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConnector API operation for PcaConnectorAd.
//
// Deletes a connector for Active Directory. You must provide the Amazon Resource
// Name (ARN) of the connector that you want to delete. You can find the ARN
// by calling the https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_ListConnectors
// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_ListConnectors)
// action. Deleting a connector does not deregister your directory with Amazon
// Web Services Private CA. You can deregister your directory by calling the
// https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_DeleteDirectoryRegistration
// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_DeleteDirectoryRegistration)
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation DeleteConnector for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ConflictException
//     This request cannot be completed for one of the following reasons because
//     the requested resource was being concurrently modified by another request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/DeleteConnector
func (c *PcaConnectorAd) DeleteConnector(input *DeleteConnectorInput) (*DeleteConnectorOutput, error) {
	req, out := c.DeleteConnectorRequest(input)
	return out, req.Send()
}

// DeleteConnectorWithContext is the same as DeleteConnector with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) DeleteConnectorWithContext(ctx aws.Context, input *DeleteConnectorInput, opts ...request.Option) (*DeleteConnectorOutput, error) {
	req, out := c.DeleteConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDirectoryRegistration = "DeleteDirectoryRegistration"

// DeleteDirectoryRegistrationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDirectoryRegistration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDirectoryRegistration for more information on using the DeleteDirectoryRegistration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDirectoryRegistrationRequest method.
//	req, resp := client.DeleteDirectoryRegistrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/DeleteDirectoryRegistration
func (c *PcaConnectorAd) DeleteDirectoryRegistrationRequest(input *DeleteDirectoryRegistrationInput) (req *request.Request, output *DeleteDirectoryRegistrationOutput) {
	op := &request.Operation{
		Name:       opDeleteDirectoryRegistration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/directoryRegistrations/{DirectoryRegistrationArn}",
	}

	if input == nil {
		input = &DeleteDirectoryRegistrationInput{}
	}

	output = &DeleteDirectoryRegistrationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDirectoryRegistration API operation for PcaConnectorAd.
//
// Deletes a directory registration. Deleting a directory registration deauthorizes
// Amazon Web Services Private CA with the directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation DeleteDirectoryRegistration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ConflictException
//     This request cannot be completed for one of the following reasons because
//     the requested resource was being concurrently modified by another request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/DeleteDirectoryRegistration
func (c *PcaConnectorAd) DeleteDirectoryRegistration(input *DeleteDirectoryRegistrationInput) (*DeleteDirectoryRegistrationOutput, error) {
	req, out := c.DeleteDirectoryRegistrationRequest(input)
	return out, req.Send()
}

// DeleteDirectoryRegistrationWithContext is the same as DeleteDirectoryRegistration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDirectoryRegistration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) DeleteDirectoryRegistrationWithContext(ctx aws.Context, input *DeleteDirectoryRegistrationInput, opts ...request.Option) (*DeleteDirectoryRegistrationOutput, error) {
	req, out := c.DeleteDirectoryRegistrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteServicePrincipalName = "DeleteServicePrincipalName"

// DeleteServicePrincipalNameRequest generates a "aws/request.Request" representing the
// client's request for the DeleteServicePrincipalName operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteServicePrincipalName for more information on using the DeleteServicePrincipalName
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteServicePrincipalNameRequest method.
//	req, resp := client.DeleteServicePrincipalNameRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/DeleteServicePrincipalName
func (c *PcaConnectorAd) DeleteServicePrincipalNameRequest(input *DeleteServicePrincipalNameInput) (req *request.Request, output *DeleteServicePrincipalNameOutput) {
	op := &request.Operation{
		Name:       opDeleteServicePrincipalName,
		HTTPMethod: "DELETE",
		HTTPPath:   "/directoryRegistrations/{DirectoryRegistrationArn}/servicePrincipalNames/{ConnectorArn}",
	}

	if input == nil {
		input = &DeleteServicePrincipalNameInput{}
	}

	output = &DeleteServicePrincipalNameOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteServicePrincipalName API operation for PcaConnectorAd.
//
// Deletes the service principal name (SPN) used by a connector to authenticate
// with your Active Directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation DeleteServicePrincipalName for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ConflictException
//     This request cannot be completed for one of the following reasons because
//     the requested resource was being concurrently modified by another request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/DeleteServicePrincipalName
func (c *PcaConnectorAd) DeleteServicePrincipalName(input *DeleteServicePrincipalNameInput) (*DeleteServicePrincipalNameOutput, error) {
	req, out := c.DeleteServicePrincipalNameRequest(input)
	return out, req.Send()
}

// DeleteServicePrincipalNameWithContext is the same as DeleteServicePrincipalName with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteServicePrincipalName for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) DeleteServicePrincipalNameWithContext(ctx aws.Context, input *DeleteServicePrincipalNameInput, opts ...request.Option) (*DeleteServicePrincipalNameOutput, error) {
	req, out := c.DeleteServicePrincipalNameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTemplate = "DeleteTemplate"

// DeleteTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTemplate for more information on using the DeleteTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTemplateRequest method.
//	req, resp := client.DeleteTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/DeleteTemplate
func (c *PcaConnectorAd) DeleteTemplateRequest(input *DeleteTemplateInput) (req *request.Request, output *DeleteTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/templates/{TemplateArn}",
	}

	if input == nil {
		input = &DeleteTemplateInput{}
	}

	output = &DeleteTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTemplate API operation for PcaConnectorAd.
//
// Deletes a template. Certificates issued using the template are still valid
// until they are revoked or expired.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation DeleteTemplate for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ConflictException
//     This request cannot be completed for one of the following reasons because
//     the requested resource was being concurrently modified by another request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/DeleteTemplate
func (c *PcaConnectorAd) DeleteTemplate(input *DeleteTemplateInput) (*DeleteTemplateOutput, error) {
	req, out := c.DeleteTemplateRequest(input)
	return out, req.Send()
}

// DeleteTemplateWithContext is the same as DeleteTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) DeleteTemplateWithContext(ctx aws.Context, input *DeleteTemplateInput, opts ...request.Option) (*DeleteTemplateOutput, error) {
	req, out := c.DeleteTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTemplateGroupAccessControlEntry = "DeleteTemplateGroupAccessControlEntry"

// DeleteTemplateGroupAccessControlEntryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTemplateGroupAccessControlEntry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTemplateGroupAccessControlEntry for more information on using the DeleteTemplateGroupAccessControlEntry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTemplateGroupAccessControlEntryRequest method.
//	req, resp := client.DeleteTemplateGroupAccessControlEntryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/DeleteTemplateGroupAccessControlEntry
func (c *PcaConnectorAd) DeleteTemplateGroupAccessControlEntryRequest(input *DeleteTemplateGroupAccessControlEntryInput) (req *request.Request, output *DeleteTemplateGroupAccessControlEntryOutput) {
	op := &request.Operation{
		Name:       opDeleteTemplateGroupAccessControlEntry,
		HTTPMethod: "DELETE",
		HTTPPath:   "/templates/{TemplateArn}/accessControlEntries/{GroupSecurityIdentifier}",
	}

	if input == nil {
		input = &DeleteTemplateGroupAccessControlEntryInput{}
	}

	output = &DeleteTemplateGroupAccessControlEntryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTemplateGroupAccessControlEntry API operation for PcaConnectorAd.
//
// Deletes a group access control entry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation DeleteTemplateGroupAccessControlEntry for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ConflictException
//     This request cannot be completed for one of the following reasons because
//     the requested resource was being concurrently modified by another request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/DeleteTemplateGroupAccessControlEntry
func (c *PcaConnectorAd) DeleteTemplateGroupAccessControlEntry(input *DeleteTemplateGroupAccessControlEntryInput) (*DeleteTemplateGroupAccessControlEntryOutput, error) {
	req, out := c.DeleteTemplateGroupAccessControlEntryRequest(input)
	return out, req.Send()
}

// DeleteTemplateGroupAccessControlEntryWithContext is the same as DeleteTemplateGroupAccessControlEntry with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTemplateGroupAccessControlEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) DeleteTemplateGroupAccessControlEntryWithContext(ctx aws.Context, input *DeleteTemplateGroupAccessControlEntryInput, opts ...request.Option) (*DeleteTemplateGroupAccessControlEntryOutput, error) {
	req, out := c.DeleteTemplateGroupAccessControlEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConnector = "GetConnector"

// GetConnectorRequest generates a "aws/request.Request" representing the
// client's request for the GetConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConnector for more information on using the GetConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetConnectorRequest method.
//	req, resp := client.GetConnectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/GetConnector
func (c *PcaConnectorAd) GetConnectorRequest(input *GetConnectorInput) (req *request.Request, output *GetConnectorOutput) {
	op := &request.Operation{
		Name:       opGetConnector,
		HTTPMethod: "GET",
		HTTPPath:   "/connectors/{ConnectorArn}",
	}

	if input == nil {
		input = &GetConnectorInput{}
	}

	output = &GetConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConnector API operation for PcaConnectorAd.
//
// Lists information about your connector. You specify the connector on input
// by its ARN (Amazon Resource Name).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation GetConnector for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/GetConnector
func (c *PcaConnectorAd) GetConnector(input *GetConnectorInput) (*GetConnectorOutput, error) {
	req, out := c.GetConnectorRequest(input)
	return out, req.Send()
}

// GetConnectorWithContext is the same as GetConnector with the addition of
// the ability to pass a context and additional request options.
//
// See GetConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) GetConnectorWithContext(ctx aws.Context, input *GetConnectorInput, opts ...request.Option) (*GetConnectorOutput, error) {
	req, out := c.GetConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDirectoryRegistration = "GetDirectoryRegistration"

// GetDirectoryRegistrationRequest generates a "aws/request.Request" representing the
// client's request for the GetDirectoryRegistration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDirectoryRegistration for more information on using the GetDirectoryRegistration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDirectoryRegistrationRequest method.
//	req, resp := client.GetDirectoryRegistrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/GetDirectoryRegistration
func (c *PcaConnectorAd) GetDirectoryRegistrationRequest(input *GetDirectoryRegistrationInput) (req *request.Request, output *GetDirectoryRegistrationOutput) {
	op := &request.Operation{
		Name:       opGetDirectoryRegistration,
		HTTPMethod: "GET",
		HTTPPath:   "/directoryRegistrations/{DirectoryRegistrationArn}",
	}

	if input == nil {
		input = &GetDirectoryRegistrationInput{}
	}

	output = &GetDirectoryRegistrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDirectoryRegistration API operation for PcaConnectorAd.
//
// A structure that contains information about your directory registration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation GetDirectoryRegistration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/GetDirectoryRegistration
func (c *PcaConnectorAd) GetDirectoryRegistration(input *GetDirectoryRegistrationInput) (*GetDirectoryRegistrationOutput, error) {
	req, out := c.GetDirectoryRegistrationRequest(input)
	return out, req.Send()
}

// GetDirectoryRegistrationWithContext is the same as GetDirectoryRegistration with the addition of
// the ability to pass a context and additional request options.
//
// See GetDirectoryRegistration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) GetDirectoryRegistrationWithContext(ctx aws.Context, input *GetDirectoryRegistrationInput, opts ...request.Option) (*GetDirectoryRegistrationOutput, error) {
	req, out := c.GetDirectoryRegistrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServicePrincipalName = "GetServicePrincipalName"

// GetServicePrincipalNameRequest generates a "aws/request.Request" representing the
// client's request for the GetServicePrincipalName operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServicePrincipalName for more information on using the GetServicePrincipalName
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetServicePrincipalNameRequest method.
//	req, resp := client.GetServicePrincipalNameRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/GetServicePrincipalName
func (c *PcaConnectorAd) GetServicePrincipalNameRequest(input *GetServicePrincipalNameInput) (req *request.Request, output *GetServicePrincipalNameOutput) {
	op := &request.Operation{
		Name:       opGetServicePrincipalName,
		HTTPMethod: "GET",
		HTTPPath:   "/directoryRegistrations/{DirectoryRegistrationArn}/servicePrincipalNames/{ConnectorArn}",
	}

	if input == nil {
		input = &GetServicePrincipalNameInput{}
	}

	output = &GetServicePrincipalNameOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServicePrincipalName API operation for PcaConnectorAd.
//
// Lists the service principal name that the connector uses to authenticate
// with Active Directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation GetServicePrincipalName for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/GetServicePrincipalName
func (c *PcaConnectorAd) GetServicePrincipalName(input *GetServicePrincipalNameInput) (*GetServicePrincipalNameOutput, error) {
	req, out := c.GetServicePrincipalNameRequest(input)
	return out, req.Send()
}

// GetServicePrincipalNameWithContext is the same as GetServicePrincipalName with the addition of
// the ability to pass a context and additional request options.
//
// See GetServicePrincipalName for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) GetServicePrincipalNameWithContext(ctx aws.Context, input *GetServicePrincipalNameInput, opts ...request.Option) (*GetServicePrincipalNameOutput, error) {
	req, out := c.GetServicePrincipalNameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTemplate = "GetTemplate"

// GetTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTemplate for more information on using the GetTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTemplateRequest method.
//	req, resp := client.GetTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/GetTemplate
func (c *PcaConnectorAd) GetTemplateRequest(input *GetTemplateInput) (req *request.Request, output *GetTemplateOutput) {
	op := &request.Operation{
		Name:       opGetTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/templates/{TemplateArn}",
	}

	if input == nil {
		input = &GetTemplateInput{}
	}

	output = &GetTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTemplate API operation for PcaConnectorAd.
//
// Retrieves a certificate template that the connector uses to issue certificates
// from a private CA.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation GetTemplate for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/GetTemplate
func (c *PcaConnectorAd) GetTemplate(input *GetTemplateInput) (*GetTemplateOutput, error) {
	req, out := c.GetTemplateRequest(input)
	return out, req.Send()
}

// GetTemplateWithContext is the same as GetTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) GetTemplateWithContext(ctx aws.Context, input *GetTemplateInput, opts ...request.Option) (*GetTemplateOutput, error) {
	req, out := c.GetTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTemplateGroupAccessControlEntry = "GetTemplateGroupAccessControlEntry"

// GetTemplateGroupAccessControlEntryRequest generates a "aws/request.Request" representing the
// client's request for the GetTemplateGroupAccessControlEntry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTemplateGroupAccessControlEntry for more information on using the GetTemplateGroupAccessControlEntry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTemplateGroupAccessControlEntryRequest method.
//	req, resp := client.GetTemplateGroupAccessControlEntryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/GetTemplateGroupAccessControlEntry
func (c *PcaConnectorAd) GetTemplateGroupAccessControlEntryRequest(input *GetTemplateGroupAccessControlEntryInput) (req *request.Request, output *GetTemplateGroupAccessControlEntryOutput) {
	op := &request.Operation{
		Name:       opGetTemplateGroupAccessControlEntry,
		HTTPMethod: "GET",
		HTTPPath:   "/templates/{TemplateArn}/accessControlEntries/{GroupSecurityIdentifier}",
	}

	if input == nil {
		input = &GetTemplateGroupAccessControlEntryInput{}
	}

	output = &GetTemplateGroupAccessControlEntryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTemplateGroupAccessControlEntry API operation for PcaConnectorAd.
//
// Retrieves the group access control entries for a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation GetTemplateGroupAccessControlEntry for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/GetTemplateGroupAccessControlEntry
func (c *PcaConnectorAd) GetTemplateGroupAccessControlEntry(input *GetTemplateGroupAccessControlEntryInput) (*GetTemplateGroupAccessControlEntryOutput, error) {
	req, out := c.GetTemplateGroupAccessControlEntryRequest(input)
	return out, req.Send()
}

// GetTemplateGroupAccessControlEntryWithContext is the same as GetTemplateGroupAccessControlEntry with the addition of
// the ability to pass a context and additional request options.
//
// See GetTemplateGroupAccessControlEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) GetTemplateGroupAccessControlEntryWithContext(ctx aws.Context, input *GetTemplateGroupAccessControlEntryInput, opts ...request.Option) (*GetTemplateGroupAccessControlEntryOutput, error) {
	req, out := c.GetTemplateGroupAccessControlEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListConnectors = "ListConnectors"

// ListConnectorsRequest generates a "aws/request.Request" representing the
// client's request for the ListConnectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConnectors for more information on using the ListConnectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListConnectorsRequest method.
//	req, resp := client.ListConnectorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListConnectors
func (c *PcaConnectorAd) ListConnectorsRequest(input *ListConnectorsInput) (req *request.Request, output *ListConnectorsOutput) {
	op := &request.Operation{
		Name:       opListConnectors,
		HTTPMethod: "GET",
		HTTPPath:   "/connectors",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConnectorsInput{}
	}

	output = &ListConnectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConnectors API operation for PcaConnectorAd.
//
// Lists the connectors that you created by using the https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector
// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector)
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation ListConnectors for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListConnectors
func (c *PcaConnectorAd) ListConnectors(input *ListConnectorsInput) (*ListConnectorsOutput, error) {
	req, out := c.ListConnectorsRequest(input)
	return out, req.Send()
}

// ListConnectorsWithContext is the same as ListConnectors with the addition of
// the ability to pass a context and additional request options.
//
// See ListConnectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) ListConnectorsWithContext(ctx aws.Context, input *ListConnectorsInput, opts ...request.Option) (*ListConnectorsOutput, error) {
	req, out := c.ListConnectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListConnectorsPages iterates over the pages of a ListConnectors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListConnectors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListConnectors operation.
//	pageNum := 0
//	err := client.ListConnectorsPages(params,
//	    func(page *pcaconnectorad.ListConnectorsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PcaConnectorAd) ListConnectorsPages(input *ListConnectorsInput, fn func(*ListConnectorsOutput, bool) bool) error {
	return c.ListConnectorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListConnectorsPagesWithContext same as ListConnectorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) ListConnectorsPagesWithContext(ctx aws.Context, input *ListConnectorsInput, fn func(*ListConnectorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListConnectorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListConnectorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListConnectorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDirectoryRegistrations = "ListDirectoryRegistrations"

// ListDirectoryRegistrationsRequest generates a "aws/request.Request" representing the
// client's request for the ListDirectoryRegistrations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDirectoryRegistrations for more information on using the ListDirectoryRegistrations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDirectoryRegistrationsRequest method.
//	req, resp := client.ListDirectoryRegistrationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListDirectoryRegistrations
func (c *PcaConnectorAd) ListDirectoryRegistrationsRequest(input *ListDirectoryRegistrationsInput) (req *request.Request, output *ListDirectoryRegistrationsOutput) {
	op := &request.Operation{
		Name:       opListDirectoryRegistrations,
		HTTPMethod: "GET",
		HTTPPath:   "/directoryRegistrations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDirectoryRegistrationsInput{}
	}

	output = &ListDirectoryRegistrationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDirectoryRegistrations API operation for PcaConnectorAd.
//
// Lists the directory registrations that you created by using the https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration
// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration)
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation ListDirectoryRegistrations for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListDirectoryRegistrations
func (c *PcaConnectorAd) ListDirectoryRegistrations(input *ListDirectoryRegistrationsInput) (*ListDirectoryRegistrationsOutput, error) {
	req, out := c.ListDirectoryRegistrationsRequest(input)
	return out, req.Send()
}

// ListDirectoryRegistrationsWithContext is the same as ListDirectoryRegistrations with the addition of
// the ability to pass a context and additional request options.
//
// See ListDirectoryRegistrations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) ListDirectoryRegistrationsWithContext(ctx aws.Context, input *ListDirectoryRegistrationsInput, opts ...request.Option) (*ListDirectoryRegistrationsOutput, error) {
	req, out := c.ListDirectoryRegistrationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDirectoryRegistrationsPages iterates over the pages of a ListDirectoryRegistrations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDirectoryRegistrations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDirectoryRegistrations operation.
//	pageNum := 0
//	err := client.ListDirectoryRegistrationsPages(params,
//	    func(page *pcaconnectorad.ListDirectoryRegistrationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PcaConnectorAd) ListDirectoryRegistrationsPages(input *ListDirectoryRegistrationsInput, fn func(*ListDirectoryRegistrationsOutput, bool) bool) error {
	return c.ListDirectoryRegistrationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDirectoryRegistrationsPagesWithContext same as ListDirectoryRegistrationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) ListDirectoryRegistrationsPagesWithContext(ctx aws.Context, input *ListDirectoryRegistrationsInput, fn func(*ListDirectoryRegistrationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDirectoryRegistrationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDirectoryRegistrationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDirectoryRegistrationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServicePrincipalNames = "ListServicePrincipalNames"

// ListServicePrincipalNamesRequest generates a "aws/request.Request" representing the
// client's request for the ListServicePrincipalNames operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServicePrincipalNames for more information on using the ListServicePrincipalNames
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServicePrincipalNamesRequest method.
//	req, resp := client.ListServicePrincipalNamesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListServicePrincipalNames
func (c *PcaConnectorAd) ListServicePrincipalNamesRequest(input *ListServicePrincipalNamesInput) (req *request.Request, output *ListServicePrincipalNamesOutput) {
	op := &request.Operation{
		Name:       opListServicePrincipalNames,
		HTTPMethod: "GET",
		HTTPPath:   "/directoryRegistrations/{DirectoryRegistrationArn}/servicePrincipalNames",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServicePrincipalNamesInput{}
	}

	output = &ListServicePrincipalNamesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServicePrincipalNames API operation for PcaConnectorAd.
//
// Lists the service principal names that the connector uses to authenticate
// with Active Directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation ListServicePrincipalNames for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListServicePrincipalNames
func (c *PcaConnectorAd) ListServicePrincipalNames(input *ListServicePrincipalNamesInput) (*ListServicePrincipalNamesOutput, error) {
	req, out := c.ListServicePrincipalNamesRequest(input)
	return out, req.Send()
}

// ListServicePrincipalNamesWithContext is the same as ListServicePrincipalNames with the addition of
// the ability to pass a context and additional request options.
//
// See ListServicePrincipalNames for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) ListServicePrincipalNamesWithContext(ctx aws.Context, input *ListServicePrincipalNamesInput, opts ...request.Option) (*ListServicePrincipalNamesOutput, error) {
	req, out := c.ListServicePrincipalNamesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServicePrincipalNamesPages iterates over the pages of a ListServicePrincipalNames operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServicePrincipalNames method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListServicePrincipalNames operation.
//	pageNum := 0
//	err := client.ListServicePrincipalNamesPages(params,
//	    func(page *pcaconnectorad.ListServicePrincipalNamesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PcaConnectorAd) ListServicePrincipalNamesPages(input *ListServicePrincipalNamesInput, fn func(*ListServicePrincipalNamesOutput, bool) bool) error {
	return c.ListServicePrincipalNamesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServicePrincipalNamesPagesWithContext same as ListServicePrincipalNamesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) ListServicePrincipalNamesPagesWithContext(ctx aws.Context, input *ListServicePrincipalNamesInput, fn func(*ListServicePrincipalNamesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServicePrincipalNamesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServicePrincipalNamesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServicePrincipalNamesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListTagsForResource
func (c *PcaConnectorAd) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for PcaConnectorAd.
//
// Lists the tags, if any, that are associated with your resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListTagsForResource
func (c *PcaConnectorAd) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTemplateGroupAccessControlEntries = "ListTemplateGroupAccessControlEntries"

// ListTemplateGroupAccessControlEntriesRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplateGroupAccessControlEntries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplateGroupAccessControlEntries for more information on using the ListTemplateGroupAccessControlEntries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTemplateGroupAccessControlEntriesRequest method.
//	req, resp := client.ListTemplateGroupAccessControlEntriesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListTemplateGroupAccessControlEntries
func (c *PcaConnectorAd) ListTemplateGroupAccessControlEntriesRequest(input *ListTemplateGroupAccessControlEntriesInput) (req *request.Request, output *ListTemplateGroupAccessControlEntriesOutput) {
	op := &request.Operation{
		Name:       opListTemplateGroupAccessControlEntries,
		HTTPMethod: "GET",
		HTTPPath:   "/templates/{TemplateArn}/accessControlEntries",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTemplateGroupAccessControlEntriesInput{}
	}

	output = &ListTemplateGroupAccessControlEntriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplateGroupAccessControlEntries API operation for PcaConnectorAd.
//
// Lists group access control entries you created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation ListTemplateGroupAccessControlEntries for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListTemplateGroupAccessControlEntries
func (c *PcaConnectorAd) ListTemplateGroupAccessControlEntries(input *ListTemplateGroupAccessControlEntriesInput) (*ListTemplateGroupAccessControlEntriesOutput, error) {
	req, out := c.ListTemplateGroupAccessControlEntriesRequest(input)
	return out, req.Send()
}

// ListTemplateGroupAccessControlEntriesWithContext is the same as ListTemplateGroupAccessControlEntries with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplateGroupAccessControlEntries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) ListTemplateGroupAccessControlEntriesWithContext(ctx aws.Context, input *ListTemplateGroupAccessControlEntriesInput, opts ...request.Option) (*ListTemplateGroupAccessControlEntriesOutput, error) {
	req, out := c.ListTemplateGroupAccessControlEntriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTemplateGroupAccessControlEntriesPages iterates over the pages of a ListTemplateGroupAccessControlEntries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTemplateGroupAccessControlEntries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTemplateGroupAccessControlEntries operation.
//	pageNum := 0
//	err := client.ListTemplateGroupAccessControlEntriesPages(params,
//	    func(page *pcaconnectorad.ListTemplateGroupAccessControlEntriesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PcaConnectorAd) ListTemplateGroupAccessControlEntriesPages(input *ListTemplateGroupAccessControlEntriesInput, fn func(*ListTemplateGroupAccessControlEntriesOutput, bool) bool) error {
	return c.ListTemplateGroupAccessControlEntriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTemplateGroupAccessControlEntriesPagesWithContext same as ListTemplateGroupAccessControlEntriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) ListTemplateGroupAccessControlEntriesPagesWithContext(ctx aws.Context, input *ListTemplateGroupAccessControlEntriesInput, fn func(*ListTemplateGroupAccessControlEntriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTemplateGroupAccessControlEntriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTemplateGroupAccessControlEntriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTemplateGroupAccessControlEntriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTemplates = "ListTemplates"

// ListTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplates for more information on using the ListTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTemplatesRequest method.
//	req, resp := client.ListTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListTemplates
func (c *PcaConnectorAd) ListTemplatesRequest(input *ListTemplatesInput) (req *request.Request, output *ListTemplatesOutput) {
	op := &request.Operation{
		Name:       opListTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/templates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTemplatesInput{}
	}

	output = &ListTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplates API operation for PcaConnectorAd.
//
// Lists the templates, if any, that are associated with a connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation ListTemplates for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/ListTemplates
func (c *PcaConnectorAd) ListTemplates(input *ListTemplatesInput) (*ListTemplatesOutput, error) {
	req, out := c.ListTemplatesRequest(input)
	return out, req.Send()
}

// ListTemplatesWithContext is the same as ListTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) ListTemplatesWithContext(ctx aws.Context, input *ListTemplatesInput, opts ...request.Option) (*ListTemplatesOutput, error) {
	req, out := c.ListTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTemplatesPages iterates over the pages of a ListTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTemplates operation.
//	pageNum := 0
//	err := client.ListTemplatesPages(params,
//	    func(page *pcaconnectorad.ListTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PcaConnectorAd) ListTemplatesPages(input *ListTemplatesInput, fn func(*ListTemplatesOutput, bool) bool) error {
	return c.ListTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTemplatesPagesWithContext same as ListTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) ListTemplatesPagesWithContext(ctx aws.Context, input *ListTemplatesInput, fn func(*ListTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/TagResource
func (c *PcaConnectorAd) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for PcaConnectorAd.
//
// Adds one or more tags to your resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/TagResource
func (c *PcaConnectorAd) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/UntagResource
func (c *PcaConnectorAd) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for PcaConnectorAd.
//
// Removes one or more tags from your resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/UntagResource
func (c *PcaConnectorAd) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTemplate = "UpdateTemplate"

// UpdateTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTemplate for more information on using the UpdateTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTemplateRequest method.
//	req, resp := client.UpdateTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/UpdateTemplate
func (c *PcaConnectorAd) UpdateTemplateRequest(input *UpdateTemplateInput) (req *request.Request, output *UpdateTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateTemplate,
		HTTPMethod: "PATCH",
		HTTPPath:   "/templates/{TemplateArn}",
	}

	if input == nil {
		input = &UpdateTemplateInput{}
	}

	output = &UpdateTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateTemplate API operation for PcaConnectorAd.
//
// Update template configuration to define the information included in certificates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation UpdateTemplate for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ConflictException
//     This request cannot be completed for one of the following reasons because
//     the requested resource was being concurrently modified by another request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/UpdateTemplate
func (c *PcaConnectorAd) UpdateTemplate(input *UpdateTemplateInput) (*UpdateTemplateOutput, error) {
	req, out := c.UpdateTemplateRequest(input)
	return out, req.Send()
}

// UpdateTemplateWithContext is the same as UpdateTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) UpdateTemplateWithContext(ctx aws.Context, input *UpdateTemplateInput, opts ...request.Option) (*UpdateTemplateOutput, error) {
	req, out := c.UpdateTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTemplateGroupAccessControlEntry = "UpdateTemplateGroupAccessControlEntry"

// UpdateTemplateGroupAccessControlEntryRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTemplateGroupAccessControlEntry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTemplateGroupAccessControlEntry for more information on using the UpdateTemplateGroupAccessControlEntry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTemplateGroupAccessControlEntryRequest method.
//	req, resp := client.UpdateTemplateGroupAccessControlEntryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/UpdateTemplateGroupAccessControlEntry
func (c *PcaConnectorAd) UpdateTemplateGroupAccessControlEntryRequest(input *UpdateTemplateGroupAccessControlEntryInput) (req *request.Request, output *UpdateTemplateGroupAccessControlEntryOutput) {
	op := &request.Operation{
		Name:       opUpdateTemplateGroupAccessControlEntry,
		HTTPMethod: "PATCH",
		HTTPPath:   "/templates/{TemplateArn}/accessControlEntries/{GroupSecurityIdentifier}",
	}

	if input == nil {
		input = &UpdateTemplateGroupAccessControlEntryInput{}
	}

	output = &UpdateTemplateGroupAccessControlEntryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateTemplateGroupAccessControlEntry API operation for PcaConnectorAd.
//
// Update a group access control entry you created using CreateTemplateGroupAccessControlEntry
// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplateGroupAccessControlEntry.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for PcaConnectorAd's
// API operation UpdateTemplateGroupAccessControlEntry for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You can receive this error if you attempt to create a resource share when
//     you don't have the required permissions. This can be caused by insufficient
//     permissions in policies attached to your Amazon Web Services Identity and
//     Access Management (IAM) principal. It can also happen because of restrictions
//     in place from an Amazon Web Services Organizations service control policy
//     (SCP) that affects your Amazon Web Services account.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     template name, or if a pagination token is invalid.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ConflictException
//     This request cannot be completed for one of the following reasons because
//     the requested resource was being concurrently modified by another request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/UpdateTemplateGroupAccessControlEntry
func (c *PcaConnectorAd) UpdateTemplateGroupAccessControlEntry(input *UpdateTemplateGroupAccessControlEntryInput) (*UpdateTemplateGroupAccessControlEntryOutput, error) {
	req, out := c.UpdateTemplateGroupAccessControlEntryRequest(input)
	return out, req.Send()
}

// UpdateTemplateGroupAccessControlEntryWithContext is the same as UpdateTemplateGroupAccessControlEntry with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTemplateGroupAccessControlEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorAd) UpdateTemplateGroupAccessControlEntryWithContext(ctx aws.Context, input *UpdateTemplateGroupAccessControlEntryInput, opts ...request.Option) (*UpdateTemplateGroupAccessControlEntryOutput, error) {
	req, out := c.UpdateTemplateGroupAccessControlEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An access control entry allows or denies Active Directory groups based on
// their security identifiers (SIDs) from enrolling and/or autoenrolling with
// the template.
type AccessControlEntry struct {
	_ struct{} `type:"structure"`

	// Permissions to allow or deny an Active Directory group to enroll or autoenroll
	// certificates issued against a template.
	AccessRights *AccessRights `type:"structure"`

	// The date and time that the Access Control Entry was created.
	CreatedAt *time.Time `type:"timestamp"`

	// Name of the Active Directory group. This name does not need to match the
	// group name in Active Directory.
	GroupDisplayName *string `type:"string"`

	// Security identifier (SID) of the group object from Active Directory. The
	// SID starts with "S-".
	GroupSecurityIdentifier *string `min:"7" type:"string"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateTemplate
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html).
	TemplateArn *string `min:"5" type:"string"`

	// The date and time that the Access Control Entry was updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessControlEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessControlEntry) GoString() string {
	return s.String()
}

// SetAccessRights sets the AccessRights field's value.
func (s *AccessControlEntry) SetAccessRights(v *AccessRights) *AccessControlEntry {
	s.AccessRights = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AccessControlEntry) SetCreatedAt(v time.Time) *AccessControlEntry {
	s.CreatedAt = &v
	return s
}

// SetGroupDisplayName sets the GroupDisplayName field's value.
func (s *AccessControlEntry) SetGroupDisplayName(v string) *AccessControlEntry {
	s.GroupDisplayName = &v
	return s
}

// SetGroupSecurityIdentifier sets the GroupSecurityIdentifier field's value.
func (s *AccessControlEntry) SetGroupSecurityIdentifier(v string) *AccessControlEntry {
	s.GroupSecurityIdentifier = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *AccessControlEntry) SetTemplateArn(v string) *AccessControlEntry {
	s.TemplateArn = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AccessControlEntry) SetUpdatedAt(v time.Time) *AccessControlEntry {
	s.UpdatedAt = &v
	return s
}

// Summary of group access control entries that allow or deny Active Directory
// groups based on their security identifiers (SIDs) from enrolling and/or autofenrolling
// with the template.
type AccessControlEntrySummary struct {
	_ struct{} `type:"structure"`

	// Allow or deny an Active Directory group from enrolling and autoenrolling
	// certificates issued against a template.
	AccessRights *AccessRights `type:"structure"`

	// The date and time that the Access Control Entry was created.
	CreatedAt *time.Time `type:"timestamp"`

	// Name of the Active Directory group. This name does not need to match the
	// group name in Active Directory.
	GroupDisplayName *string `type:"string"`

	// Security identifier (SID) of the group object from Active Directory. The
	// SID starts with "S-".
	GroupSecurityIdentifier *string `min:"7" type:"string"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateTemplate
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html).
	TemplateArn *string `min:"5" type:"string"`

	// The date and time that the Access Control Entry was updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessControlEntrySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessControlEntrySummary) GoString() string {
	return s.String()
}

// SetAccessRights sets the AccessRights field's value.
func (s *AccessControlEntrySummary) SetAccessRights(v *AccessRights) *AccessControlEntrySummary {
	s.AccessRights = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AccessControlEntrySummary) SetCreatedAt(v time.Time) *AccessControlEntrySummary {
	s.CreatedAt = &v
	return s
}

// SetGroupDisplayName sets the GroupDisplayName field's value.
func (s *AccessControlEntrySummary) SetGroupDisplayName(v string) *AccessControlEntrySummary {
	s.GroupDisplayName = &v
	return s
}

// SetGroupSecurityIdentifier sets the GroupSecurityIdentifier field's value.
func (s *AccessControlEntrySummary) SetGroupSecurityIdentifier(v string) *AccessControlEntrySummary {
	s.GroupSecurityIdentifier = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *AccessControlEntrySummary) SetTemplateArn(v string) *AccessControlEntrySummary {
	s.TemplateArn = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AccessControlEntrySummary) SetUpdatedAt(v time.Time) *AccessControlEntrySummary {
	s.UpdatedAt = &v
	return s
}

// You can receive this error if you attempt to create a resource share when
// you don't have the required permissions. This can be caused by insufficient
// permissions in policies attached to your Amazon Web Services Identity and
// Access Management (IAM) principal. It can also happen because of restrictions
// in place from an Amazon Web Services Organizations service control policy
// (SCP) that affects your Amazon Web Services account.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Allow or deny permissions for an Active Directory group to enroll or autoenroll
// certificates for a template.
type AccessRights struct {
	_ struct{} `type:"structure"`

	// Allow or deny an Active Directory group from autoenrolling certificates issued
	// against a template. The Active Directory group must be allowed to enroll
	// to allow autoenrollment
	AutoEnroll *string `type:"string" enum:"AccessRight"`

	// Allow or deny an Active Directory group from enrolling certificates issued
	// against a template.
	Enroll *string `type:"string" enum:"AccessRight"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessRights) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessRights) GoString() string {
	return s.String()
}

// SetAutoEnroll sets the AutoEnroll field's value.
func (s *AccessRights) SetAutoEnroll(v string) *AccessRights {
	s.AutoEnroll = &v
	return s
}

// SetEnroll sets the Enroll field's value.
func (s *AccessRights) SetEnroll(v string) *AccessRights {
	s.Enroll = &v
	return s
}

// Application policies describe what the certificate can be used for.
type ApplicationPolicies struct {
	_ struct{} `type:"structure"`

	// Marks the application policy extension as critical.
	Critical *bool `type:"boolean"`

	// Application policies describe what the certificate can be used for.
	//
	// Policies is a required field
	Policies []*ApplicationPolicy `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationPolicies) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationPolicies) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationPolicies) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplicationPolicies"}
	if s.Policies == nil {
		invalidParams.Add(request.NewErrParamRequired("Policies"))
	}
	if s.Policies != nil && len(s.Policies) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policies", 1))
	}
	if s.Policies != nil {
		for i, v := range s.Policies {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Policies", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCritical sets the Critical field's value.
func (s *ApplicationPolicies) SetCritical(v bool) *ApplicationPolicies {
	s.Critical = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *ApplicationPolicies) SetPolicies(v []*ApplicationPolicy) *ApplicationPolicies {
	s.Policies = v
	return s
}

// Application policies describe what the certificate can be used for.
type ApplicationPolicy struct {
	_ struct{} `type:"structure"`

	// The object identifier (OID) of an application policy.
	PolicyObjectIdentifier *string `min:"1" type:"string"`

	// The type of application policy
	PolicyType *string `type:"string" enum:"ApplicationPolicyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplicationPolicy"}
	if s.PolicyObjectIdentifier != nil && len(*s.PolicyObjectIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyObjectIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyObjectIdentifier sets the PolicyObjectIdentifier field's value.
func (s *ApplicationPolicy) SetPolicyObjectIdentifier(v string) *ApplicationPolicy {
	s.PolicyObjectIdentifier = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *ApplicationPolicy) SetPolicyType(v string) *ApplicationPolicy {
	s.PolicyType = &v
	return s
}

// Information describing the end of the validity period of the certificate.
// This parameter sets the “Not After” date for the certificate. Certificate
// validity is the period of time during which a certificate is valid. Validity
// can be expressed as an explicit date and time when the certificate expires,
// or as a span of time after issuance, stated in days, months, or years. For
// more information, see Validity in RFC 5280. This value is unaffected when
// ValidityNotBefore is also specified. For example, if Validity is set to 20
// days in the future, the certificate will expire 20 days from issuance time
// regardless of the ValidityNotBefore value.
type CertificateValidity struct {
	_ struct{} `type:"structure"`

	// Renewal period is the period of time before certificate expiration when a
	// new certificate will be requested.
	//
	// RenewalPeriod is a required field
	RenewalPeriod *ValidityPeriod `type:"structure" required:"true"`

	// Information describing the end of the validity period of the certificate.
	// This parameter sets the “Not After” date for the certificate. Certificate
	// validity is the period of time during which a certificate is valid. Validity
	// can be expressed as an explicit date and time when the certificate expires,
	// or as a span of time after issuance, stated in days, months, or years. For
	// more information, see Validity in RFC 5280. This value is unaffected when
	// ValidityNotBefore is also specified. For example, if Validity is set to 20
	// days in the future, the certificate will expire 20 days from issuance time
	// regardless of the ValidityNotBefore value.
	//
	// ValidityPeriod is a required field
	ValidityPeriod *ValidityPeriod `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CertificateValidity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CertificateValidity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CertificateValidity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CertificateValidity"}
	if s.RenewalPeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("RenewalPeriod"))
	}
	if s.ValidityPeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("ValidityPeriod"))
	}
	if s.RenewalPeriod != nil {
		if err := s.RenewalPeriod.Validate(); err != nil {
			invalidParams.AddNested("RenewalPeriod", err.(request.ErrInvalidParams))
		}
	}
	if s.ValidityPeriod != nil {
		if err := s.ValidityPeriod.Validate(); err != nil {
			invalidParams.AddNested("ValidityPeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRenewalPeriod sets the RenewalPeriod field's value.
func (s *CertificateValidity) SetRenewalPeriod(v *ValidityPeriod) *CertificateValidity {
	s.RenewalPeriod = v
	return s
}

// SetValidityPeriod sets the ValidityPeriod field's value.
func (s *CertificateValidity) SetValidityPeriod(v *ValidityPeriod) *CertificateValidity {
	s.ValidityPeriod = v
	return s
}

// This request cannot be completed for one of the following reasons because
// the requested resource was being concurrently modified by another request.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The identifier of the Amazon Web Services resource.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The resource type, which can be one of Connector, Template, TemplateGroupAccessControlEntry,
	// ServicePrincipalName, or DirectoryRegistration.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Amazon Web Services Private CA Connector for Active Directory is a service
// that links your Active Directory with Amazon Web Services Private CA. The
// connector brokers the exchange of certificates from Amazon Web Services Private
// CA to domain-joined users and machines managed with Active Directory.
type Connector struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateConnector
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html).
	Arn *string `min:"5" type:"string"`

	// The Amazon Resource Name (ARN) of the certificate authority being used.
	CertificateAuthorityArn *string `min:"5" type:"string"`

	// Certificate enrollment endpoint for Active Directory domain-joined objects
	// reach out to when requesting certificates.
	CertificateEnrollmentPolicyServerEndpoint *string `type:"string"`

	// The date and time that the connector was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The identifier of the Active Directory.
	DirectoryId *string `type:"string"`

	// Status of the connector. Status can be creating, active, deleting, or failed.
	Status *string `type:"string" enum:"ConnectorStatus"`

	// Additional information about the connector status if the status is failed.
	StatusReason *string `type:"string" enum:"ConnectorStatusReason"`

	// The date and time that the connector was updated.
	UpdatedAt *time.Time `type:"timestamp"`

	// Information of the VPC and security group(s) used with the connector.
	VpcInformation *VpcInformation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Connector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Connector) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Connector) SetArn(v string) *Connector {
	s.Arn = &v
	return s
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *Connector) SetCertificateAuthorityArn(v string) *Connector {
	s.CertificateAuthorityArn = &v
	return s
}

// SetCertificateEnrollmentPolicyServerEndpoint sets the CertificateEnrollmentPolicyServerEndpoint field's value.
func (s *Connector) SetCertificateEnrollmentPolicyServerEndpoint(v string) *Connector {
	s.CertificateEnrollmentPolicyServerEndpoint = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Connector) SetCreatedAt(v time.Time) *Connector {
	s.CreatedAt = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *Connector) SetDirectoryId(v string) *Connector {
	s.DirectoryId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Connector) SetStatus(v string) *Connector {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *Connector) SetStatusReason(v string) *Connector {
	s.StatusReason = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Connector) SetUpdatedAt(v time.Time) *Connector {
	s.UpdatedAt = &v
	return s
}

// SetVpcInformation sets the VpcInformation field's value.
func (s *Connector) SetVpcInformation(v *VpcInformation) *Connector {
	s.VpcInformation = v
	return s
}

// Summary description of the Amazon Web Services Private CA AD connectors belonging
// to an Amazon Web Services account.
type ConnectorSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateConnector
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html).
	Arn *string `min:"5" type:"string"`

	// The Amazon Resource Name (ARN) of the certificate authority being used.
	CertificateAuthorityArn *string `min:"5" type:"string"`

	// Certificate enrollment endpoint for Active Directory domain-joined objects
	// to request certificates.
	CertificateEnrollmentPolicyServerEndpoint *string `type:"string"`

	// The date and time that the connector was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The identifier of the Active Directory.
	DirectoryId *string `type:"string"`

	// Status of the connector. Status can be creating, active, deleting, or failed.
	Status *string `type:"string" enum:"ConnectorStatus"`

	// Additional information about the connector status if the status is failed.
	StatusReason *string `type:"string" enum:"ConnectorStatusReason"`

	// The date and time that the connector was updated.
	UpdatedAt *time.Time `type:"timestamp"`

	// Information of the VPC and security group(s) used with the connector.
	VpcInformation *VpcInformation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectorSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectorSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ConnectorSummary) SetArn(v string) *ConnectorSummary {
	s.Arn = &v
	return s
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *ConnectorSummary) SetCertificateAuthorityArn(v string) *ConnectorSummary {
	s.CertificateAuthorityArn = &v
	return s
}

// SetCertificateEnrollmentPolicyServerEndpoint sets the CertificateEnrollmentPolicyServerEndpoint field's value.
func (s *ConnectorSummary) SetCertificateEnrollmentPolicyServerEndpoint(v string) *ConnectorSummary {
	s.CertificateEnrollmentPolicyServerEndpoint = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ConnectorSummary) SetCreatedAt(v time.Time) *ConnectorSummary {
	s.CreatedAt = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *ConnectorSummary) SetDirectoryId(v string) *ConnectorSummary {
	s.DirectoryId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ConnectorSummary) SetStatus(v string) *ConnectorSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *ConnectorSummary) SetStatusReason(v string) *ConnectorSummary {
	s.StatusReason = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ConnectorSummary) SetUpdatedAt(v time.Time) *ConnectorSummary {
	s.UpdatedAt = &v
	return s
}

// SetVpcInformation sets the VpcInformation field's value.
func (s *ConnectorSummary) SetVpcInformation(v *VpcInformation) *ConnectorSummary {
	s.VpcInformation = v
	return s
}

type CreateConnectorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the certificate authority being used.
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// Idempotency token.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The identifier of the Active Directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// Metadata assigned to a connector consisting of a key-value pair.
	Tags map[string]*string `type:"map"`

	// Security group IDs that describe the inbound and outbound rules.
	//
	// VpcInformation is a required field
	VpcInformation *VpcInformation `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectorInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.VpcInformation == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcInformation"))
	}
	if s.VpcInformation != nil {
		if err := s.VpcInformation.Validate(); err != nil {
			invalidParams.AddNested("VpcInformation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *CreateConnectorInput) SetCertificateAuthorityArn(v string) *CreateConnectorInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateConnectorInput) SetClientToken(v string) *CreateConnectorInput {
	s.ClientToken = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *CreateConnectorInput) SetDirectoryId(v string) *CreateConnectorInput {
	s.DirectoryId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConnectorInput) SetTags(v map[string]*string) *CreateConnectorInput {
	s.Tags = v
	return s
}

// SetVpcInformation sets the VpcInformation field's value.
func (s *CreateConnectorInput) SetVpcInformation(v *VpcInformation) *CreateConnectorInput {
	s.VpcInformation = v
	return s
}

type CreateConnectorOutput struct {
	_ struct{} `type:"structure"`

	// If successful, the Amazon Resource Name (ARN) of the connector for Active
	// Directory.
	ConnectorArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectorOutput) GoString() string {
	return s.String()
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *CreateConnectorOutput) SetConnectorArn(v string) *CreateConnectorOutput {
	s.ConnectorArn = &v
	return s
}

type CreateDirectoryRegistrationInput struct {
	_ struct{} `type:"structure"`

	// Idempotency token.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The identifier of the Active Directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// Metadata assigned to a directory registration consisting of a key-value pair.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDirectoryRegistrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDirectoryRegistrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDirectoryRegistrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDirectoryRegistrationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDirectoryRegistrationInput) SetClientToken(v string) *CreateDirectoryRegistrationInput {
	s.ClientToken = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *CreateDirectoryRegistrationInput) SetDirectoryId(v string) *CreateDirectoryRegistrationInput {
	s.DirectoryId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDirectoryRegistrationInput) SetTags(v map[string]*string) *CreateDirectoryRegistrationInput {
	s.Tags = v
	return s
}

type CreateDirectoryRegistrationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateDirectoryRegistration
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html).
	DirectoryRegistrationArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDirectoryRegistrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDirectoryRegistrationOutput) GoString() string {
	return s.String()
}

// SetDirectoryRegistrationArn sets the DirectoryRegistrationArn field's value.
func (s *CreateDirectoryRegistrationOutput) SetDirectoryRegistrationArn(v string) *CreateDirectoryRegistrationOutput {
	s.DirectoryRegistrationArn = &v
	return s
}

type CreateServicePrincipalNameInput struct {
	_ struct{} `type:"structure"`

	// Idempotency token.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateConnector
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html).
	//
	// ConnectorArn is a required field
	ConnectorArn *string `location:"uri" locationName:"ConnectorArn" min:"5" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateDirectoryRegistration
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html).
	//
	// DirectoryRegistrationArn is a required field
	DirectoryRegistrationArn *string `location:"uri" locationName:"DirectoryRegistrationArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServicePrincipalNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServicePrincipalNameInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServicePrincipalNameInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServicePrincipalNameInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ConnectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorArn"))
	}
	if s.ConnectorArn != nil && len(*s.ConnectorArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorArn", 5))
	}
	if s.DirectoryRegistrationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryRegistrationArn"))
	}
	if s.DirectoryRegistrationArn != nil && len(*s.DirectoryRegistrationArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryRegistrationArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateServicePrincipalNameInput) SetClientToken(v string) *CreateServicePrincipalNameInput {
	s.ClientToken = &v
	return s
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *CreateServicePrincipalNameInput) SetConnectorArn(v string) *CreateServicePrincipalNameInput {
	s.ConnectorArn = &v
	return s
}

// SetDirectoryRegistrationArn sets the DirectoryRegistrationArn field's value.
func (s *CreateServicePrincipalNameInput) SetDirectoryRegistrationArn(v string) *CreateServicePrincipalNameInput {
	s.DirectoryRegistrationArn = &v
	return s
}

type CreateServicePrincipalNameOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServicePrincipalNameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServicePrincipalNameOutput) GoString() string {
	return s.String()
}

type CreateTemplateGroupAccessControlEntryInput struct {
	_ struct{} `type:"structure"`

	// Allow or deny permissions for an Active Directory group to enroll or autoenroll
	// certificates for a template.
	//
	// AccessRights is a required field
	AccessRights *AccessRights `type:"structure" required:"true"`

	// Idempotency token.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// Name of the Active Directory group. This name does not need to match the
	// group name in Active Directory.
	//
	// GroupDisplayName is a required field
	GroupDisplayName *string `type:"string" required:"true"`

	// Security identifier (SID) of the group object from Active Directory. The
	// SID starts with "S-".
	//
	// GroupSecurityIdentifier is a required field
	GroupSecurityIdentifier *string `min:"7" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateTemplate
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html).
	//
	// TemplateArn is a required field
	TemplateArn *string `location:"uri" locationName:"TemplateArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateGroupAccessControlEntryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateGroupAccessControlEntryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTemplateGroupAccessControlEntryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTemplateGroupAccessControlEntryInput"}
	if s.AccessRights == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessRights"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.GroupDisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupDisplayName"))
	}
	if s.GroupSecurityIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupSecurityIdentifier"))
	}
	if s.GroupSecurityIdentifier != nil && len(*s.GroupSecurityIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("GroupSecurityIdentifier", 7))
	}
	if s.TemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateArn"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessRights sets the AccessRights field's value.
func (s *CreateTemplateGroupAccessControlEntryInput) SetAccessRights(v *AccessRights) *CreateTemplateGroupAccessControlEntryInput {
	s.AccessRights = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateTemplateGroupAccessControlEntryInput) SetClientToken(v string) *CreateTemplateGroupAccessControlEntryInput {
	s.ClientToken = &v
	return s
}

// SetGroupDisplayName sets the GroupDisplayName field's value.
func (s *CreateTemplateGroupAccessControlEntryInput) SetGroupDisplayName(v string) *CreateTemplateGroupAccessControlEntryInput {
	s.GroupDisplayName = &v
	return s
}

// SetGroupSecurityIdentifier sets the GroupSecurityIdentifier field's value.
func (s *CreateTemplateGroupAccessControlEntryInput) SetGroupSecurityIdentifier(v string) *CreateTemplateGroupAccessControlEntryInput {
	s.GroupSecurityIdentifier = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *CreateTemplateGroupAccessControlEntryInput) SetTemplateArn(v string) *CreateTemplateGroupAccessControlEntryInput {
	s.TemplateArn = &v
	return s
}

type CreateTemplateGroupAccessControlEntryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateGroupAccessControlEntryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateGroupAccessControlEntryOutput) GoString() string {
	return s.String()
}

type CreateTemplateInput struct {
	_ struct{} `type:"structure"`

	// Idempotency token.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateConnector
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html).
	//
	// ConnectorArn is a required field
	ConnectorArn *string `min:"5" type:"string" required:"true"`

	// Template configuration to define the information included in certificates.
	// Define certificate validity and renewal periods, certificate request handling
	// and enrollment options, key usage extensions, application policies, and cryptography
	// settings.
	//
	// Definition is a required field
	Definition *TemplateDefinition `type:"structure" required:"true"`

	// Name of the template. The template name must be unique.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Metadata assigned to a template consisting of a key-value pair.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTemplateInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ConnectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorArn"))
	}
	if s.ConnectorArn != nil && len(*s.ConnectorArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorArn", 5))
	}
	if s.Definition == nil {
		invalidParams.Add(request.NewErrParamRequired("Definition"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Definition != nil {
		if err := s.Definition.Validate(); err != nil {
			invalidParams.AddNested("Definition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateTemplateInput) SetClientToken(v string) *CreateTemplateInput {
	s.ClientToken = &v
	return s
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *CreateTemplateInput) SetConnectorArn(v string) *CreateTemplateInput {
	s.ConnectorArn = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *CreateTemplateInput) SetDefinition(v *TemplateDefinition) *CreateTemplateInput {
	s.Definition = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTemplateInput) SetName(v string) *CreateTemplateInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTemplateInput) SetTags(v map[string]*string) *CreateTemplateInput {
	s.Tags = v
	return s
}

type CreateTemplateOutput struct {
	_ struct{} `type:"structure"`

	// If successful, the Amazon Resource Name (ARN) of the template.
	TemplateArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateOutput) GoString() string {
	return s.String()
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *CreateTemplateOutput) SetTemplateArn(v string) *CreateTemplateOutput {
	s.TemplateArn = &v
	return s
}

type DeleteConnectorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateConnector
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html).
	//
	// ConnectorArn is a required field
	ConnectorArn *string `location:"uri" locationName:"ConnectorArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConnectorInput"}
	if s.ConnectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorArn"))
	}
	if s.ConnectorArn != nil && len(*s.ConnectorArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *DeleteConnectorInput) SetConnectorArn(v string) *DeleteConnectorInput {
	s.ConnectorArn = &v
	return s
}

type DeleteConnectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectorOutput) GoString() string {
	return s.String()
}

type DeleteDirectoryRegistrationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateDirectoryRegistration
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html).
	//
	// DirectoryRegistrationArn is a required field
	DirectoryRegistrationArn *string `location:"uri" locationName:"DirectoryRegistrationArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDirectoryRegistrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDirectoryRegistrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDirectoryRegistrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDirectoryRegistrationInput"}
	if s.DirectoryRegistrationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryRegistrationArn"))
	}
	if s.DirectoryRegistrationArn != nil && len(*s.DirectoryRegistrationArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryRegistrationArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryRegistrationArn sets the DirectoryRegistrationArn field's value.
func (s *DeleteDirectoryRegistrationInput) SetDirectoryRegistrationArn(v string) *DeleteDirectoryRegistrationInput {
	s.DirectoryRegistrationArn = &v
	return s
}

type DeleteDirectoryRegistrationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDirectoryRegistrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDirectoryRegistrationOutput) GoString() string {
	return s.String()
}

type DeleteServicePrincipalNameInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateConnector
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html).
	//
	// ConnectorArn is a required field
	ConnectorArn *string `location:"uri" locationName:"ConnectorArn" min:"5" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateDirectoryRegistration
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html).
	//
	// DirectoryRegistrationArn is a required field
	DirectoryRegistrationArn *string `location:"uri" locationName:"DirectoryRegistrationArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServicePrincipalNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServicePrincipalNameInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServicePrincipalNameInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServicePrincipalNameInput"}
	if s.ConnectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorArn"))
	}
	if s.ConnectorArn != nil && len(*s.ConnectorArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorArn", 5))
	}
	if s.DirectoryRegistrationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryRegistrationArn"))
	}
	if s.DirectoryRegistrationArn != nil && len(*s.DirectoryRegistrationArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryRegistrationArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *DeleteServicePrincipalNameInput) SetConnectorArn(v string) *DeleteServicePrincipalNameInput {
	s.ConnectorArn = &v
	return s
}

// SetDirectoryRegistrationArn sets the DirectoryRegistrationArn field's value.
func (s *DeleteServicePrincipalNameInput) SetDirectoryRegistrationArn(v string) *DeleteServicePrincipalNameInput {
	s.DirectoryRegistrationArn = &v
	return s
}

type DeleteServicePrincipalNameOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServicePrincipalNameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServicePrincipalNameOutput) GoString() string {
	return s.String()
}

type DeleteTemplateGroupAccessControlEntryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Security identifier (SID) of the group object from Active Directory. The
	// SID starts with "S-".
	//
	// GroupSecurityIdentifier is a required field
	GroupSecurityIdentifier *string `location:"uri" locationName:"GroupSecurityIdentifier" min:"7" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateTemplate
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html).
	//
	// TemplateArn is a required field
	TemplateArn *string `location:"uri" locationName:"TemplateArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateGroupAccessControlEntryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateGroupAccessControlEntryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTemplateGroupAccessControlEntryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTemplateGroupAccessControlEntryInput"}
	if s.GroupSecurityIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupSecurityIdentifier"))
	}
	if s.GroupSecurityIdentifier != nil && len(*s.GroupSecurityIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("GroupSecurityIdentifier", 7))
	}
	if s.TemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateArn"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupSecurityIdentifier sets the GroupSecurityIdentifier field's value.
func (s *DeleteTemplateGroupAccessControlEntryInput) SetGroupSecurityIdentifier(v string) *DeleteTemplateGroupAccessControlEntryInput {
	s.GroupSecurityIdentifier = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *DeleteTemplateGroupAccessControlEntryInput) SetTemplateArn(v string) *DeleteTemplateGroupAccessControlEntryInput {
	s.TemplateArn = &v
	return s
}

type DeleteTemplateGroupAccessControlEntryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateGroupAccessControlEntryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateGroupAccessControlEntryOutput) GoString() string {
	return s.String()
}

type DeleteTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateTemplate
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html).
	//
	// TemplateArn is a required field
	TemplateArn *string `location:"uri" locationName:"TemplateArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTemplateInput"}
	if s.TemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateArn"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *DeleteTemplateInput) SetTemplateArn(v string) *DeleteTemplateInput {
	s.TemplateArn = &v
	return s
}

type DeleteTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateOutput) GoString() string {
	return s.String()
}

// The directory registration represents the authorization of the connector
// service with a directory.
type DirectoryRegistration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateDirectoryRegistration.
	Arn *string `min:"5" type:"string"`

	// The date and time that the directory registration was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The identifier of the Active Directory.
	DirectoryId *string `type:"string"`

	// Status of the directory registration.
	Status *string `type:"string" enum:"DirectoryRegistrationStatus"`

	// Additional information about the directory registration status if the status
	// is failed.
	StatusReason *string `type:"string" enum:"DirectoryRegistrationStatusReason"`

	// The date and time that the directory registration was updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DirectoryRegistration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DirectoryRegistration) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DirectoryRegistration) SetArn(v string) *DirectoryRegistration {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DirectoryRegistration) SetCreatedAt(v time.Time) *DirectoryRegistration {
	s.CreatedAt = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DirectoryRegistration) SetDirectoryId(v string) *DirectoryRegistration {
	s.DirectoryId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DirectoryRegistration) SetStatus(v string) *DirectoryRegistration {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *DirectoryRegistration) SetStatusReason(v string) *DirectoryRegistration {
	s.StatusReason = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DirectoryRegistration) SetUpdatedAt(v time.Time) *DirectoryRegistration {
	s.UpdatedAt = &v
	return s
}

// The directory registration represents the authorization of the connector
// service with the Active Directory.
type DirectoryRegistrationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateDirectoryRegistration
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html).
	Arn *string `min:"5" type:"string"`

	// The date and time that the directory registration was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The identifier of the Active Directory.
	DirectoryId *string `type:"string"`

	// Status of the directory registration.
	Status *string `type:"string" enum:"DirectoryRegistrationStatus"`

	// Additional information about the directory registration status if the status
	// is failed.
	StatusReason *string `type:"string" enum:"DirectoryRegistrationStatusReason"`

	// The date and time that the directory registration was updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DirectoryRegistrationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DirectoryRegistrationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DirectoryRegistrationSummary) SetArn(v string) *DirectoryRegistrationSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DirectoryRegistrationSummary) SetCreatedAt(v time.Time) *DirectoryRegistrationSummary {
	s.CreatedAt = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DirectoryRegistrationSummary) SetDirectoryId(v string) *DirectoryRegistrationSummary {
	s.DirectoryId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DirectoryRegistrationSummary) SetStatus(v string) *DirectoryRegistrationSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *DirectoryRegistrationSummary) SetStatusReason(v string) *DirectoryRegistrationSummary {
	s.StatusReason = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DirectoryRegistrationSummary) SetUpdatedAt(v time.Time) *DirectoryRegistrationSummary {
	s.UpdatedAt = &v
	return s
}

// Template configurations for v2 template schema.
type EnrollmentFlagsV2 struct {
	_ struct{} `type:"structure"`

	// Allow renewal using the same key.
	EnableKeyReuseOnNtTokenKeysetStorageFull *bool `type:"boolean"`

	// Include symmetric algorithms allowed by the subject.
	IncludeSymmetricAlgorithms *bool `type:"boolean"`

	// This flag instructs the CA to not include the security extension szOID_NTDS_CA_SECURITY_EXT
	// (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE] sections 2.2.2.7.7.4
	// and 3.2.2.6.2.1.4.5.9, in the issued certificate. This addresses a Windows
	// Kerberos elevation-of-privilege vulnerability.
	NoSecurityExtension *bool `type:"boolean"`

	// Delete expired or revoked certificates instead of archiving them.
	RemoveInvalidCertificateFromPersonalStore *bool `type:"boolean"`

	// Require user interaction when the subject is enrolled and the private key
	// associated with the certificate is used.
	UserInteractionRequired *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnrollmentFlagsV2) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnrollmentFlagsV2) GoString() string {
	return s.String()
}

// SetEnableKeyReuseOnNtTokenKeysetStorageFull sets the EnableKeyReuseOnNtTokenKeysetStorageFull field's value.
func (s *EnrollmentFlagsV2) SetEnableKeyReuseOnNtTokenKeysetStorageFull(v bool) *EnrollmentFlagsV2 {
	s.EnableKeyReuseOnNtTokenKeysetStorageFull = &v
	return s
}

// SetIncludeSymmetricAlgorithms sets the IncludeSymmetricAlgorithms field's value.
func (s *EnrollmentFlagsV2) SetIncludeSymmetricAlgorithms(v bool) *EnrollmentFlagsV2 {
	s.IncludeSymmetricAlgorithms = &v
	return s
}

// SetNoSecurityExtension sets the NoSecurityExtension field's value.
func (s *EnrollmentFlagsV2) SetNoSecurityExtension(v bool) *EnrollmentFlagsV2 {
	s.NoSecurityExtension = &v
	return s
}

// SetRemoveInvalidCertificateFromPersonalStore sets the RemoveInvalidCertificateFromPersonalStore field's value.
func (s *EnrollmentFlagsV2) SetRemoveInvalidCertificateFromPersonalStore(v bool) *EnrollmentFlagsV2 {
	s.RemoveInvalidCertificateFromPersonalStore = &v
	return s
}

// SetUserInteractionRequired sets the UserInteractionRequired field's value.
func (s *EnrollmentFlagsV2) SetUserInteractionRequired(v bool) *EnrollmentFlagsV2 {
	s.UserInteractionRequired = &v
	return s
}

// Template configurations for v3 template schema.
type EnrollmentFlagsV3 struct {
	_ struct{} `type:"structure"`

	// Allow renewal using the same key.
	EnableKeyReuseOnNtTokenKeysetStorageFull *bool `type:"boolean"`

	// Include symmetric algorithms allowed by the subject.
	IncludeSymmetricAlgorithms *bool `type:"boolean"`

	// This flag instructs the CA to not include the security extension szOID_NTDS_CA_SECURITY_EXT
	// (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE] sections 2.2.2.7.7.4
	// and 3.2.2.6.2.1.4.5.9, in the issued certificate. This addresses a Windows
	// Kerberos elevation-of-privilege vulnerability.
	NoSecurityExtension *bool `type:"boolean"`

	// Delete expired or revoked certificates instead of archiving them.
	RemoveInvalidCertificateFromPersonalStore *bool `type:"boolean"`

	// Require user interaction when the subject is enrolled and the private key
	// associated with the certificate is used.
	UserInteractionRequired *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnrollmentFlagsV3) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnrollmentFlagsV3) GoString() string {
	return s.String()
}

// SetEnableKeyReuseOnNtTokenKeysetStorageFull sets the EnableKeyReuseOnNtTokenKeysetStorageFull field's value.
func (s *EnrollmentFlagsV3) SetEnableKeyReuseOnNtTokenKeysetStorageFull(v bool) *EnrollmentFlagsV3 {
	s.EnableKeyReuseOnNtTokenKeysetStorageFull = &v
	return s
}

// SetIncludeSymmetricAlgorithms sets the IncludeSymmetricAlgorithms field's value.
func (s *EnrollmentFlagsV3) SetIncludeSymmetricAlgorithms(v bool) *EnrollmentFlagsV3 {
	s.IncludeSymmetricAlgorithms = &v
	return s
}

// SetNoSecurityExtension sets the NoSecurityExtension field's value.
func (s *EnrollmentFlagsV3) SetNoSecurityExtension(v bool) *EnrollmentFlagsV3 {
	s.NoSecurityExtension = &v
	return s
}

// SetRemoveInvalidCertificateFromPersonalStore sets the RemoveInvalidCertificateFromPersonalStore field's value.
func (s *EnrollmentFlagsV3) SetRemoveInvalidCertificateFromPersonalStore(v bool) *EnrollmentFlagsV3 {
	s.RemoveInvalidCertificateFromPersonalStore = &v
	return s
}

// SetUserInteractionRequired sets the UserInteractionRequired field's value.
func (s *EnrollmentFlagsV3) SetUserInteractionRequired(v bool) *EnrollmentFlagsV3 {
	s.UserInteractionRequired = &v
	return s
}

// Template configurations for v4 template schema.
type EnrollmentFlagsV4 struct {
	_ struct{} `type:"structure"`

	// Allow renewal using the same key.
	EnableKeyReuseOnNtTokenKeysetStorageFull *bool `type:"boolean"`

	// Include symmetric algorithms allowed by the subject.
	IncludeSymmetricAlgorithms *bool `type:"boolean"`

	// This flag instructs the CA to not include the security extension szOID_NTDS_CA_SECURITY_EXT
	// (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE] sections 2.2.2.7.7.4
	// and 3.2.2.6.2.1.4.5.9, in the issued certificate. This addresses a Windows
	// Kerberos elevation-of-privilege vulnerability.
	NoSecurityExtension *bool `type:"boolean"`

	// Delete expired or revoked certificates instead of archiving them.
	RemoveInvalidCertificateFromPersonalStore *bool `type:"boolean"`

	// Require user interaction when the subject is enrolled and the private key
	// associated with the certificate is used.
	UserInteractionRequired *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnrollmentFlagsV4) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnrollmentFlagsV4) GoString() string {
	return s.String()
}

// SetEnableKeyReuseOnNtTokenKeysetStorageFull sets the EnableKeyReuseOnNtTokenKeysetStorageFull field's value.
func (s *EnrollmentFlagsV4) SetEnableKeyReuseOnNtTokenKeysetStorageFull(v bool) *EnrollmentFlagsV4 {
	s.EnableKeyReuseOnNtTokenKeysetStorageFull = &v
	return s
}

// SetIncludeSymmetricAlgorithms sets the IncludeSymmetricAlgorithms field's value.
func (s *EnrollmentFlagsV4) SetIncludeSymmetricAlgorithms(v bool) *EnrollmentFlagsV4 {
	s.IncludeSymmetricAlgorithms = &v
	return s
}

// SetNoSecurityExtension sets the NoSecurityExtension field's value.
func (s *EnrollmentFlagsV4) SetNoSecurityExtension(v bool) *EnrollmentFlagsV4 {
	s.NoSecurityExtension = &v
	return s
}

// SetRemoveInvalidCertificateFromPersonalStore sets the RemoveInvalidCertificateFromPersonalStore field's value.
func (s *EnrollmentFlagsV4) SetRemoveInvalidCertificateFromPersonalStore(v bool) *EnrollmentFlagsV4 {
	s.RemoveInvalidCertificateFromPersonalStore = &v
	return s
}

// SetUserInteractionRequired sets the UserInteractionRequired field's value.
func (s *EnrollmentFlagsV4) SetUserInteractionRequired(v bool) *EnrollmentFlagsV4 {
	s.UserInteractionRequired = &v
	return s
}

// Certificate extensions for v2 template schema
type ExtensionsV2 struct {
	_ struct{} `type:"structure"`

	// Application policies specify what the certificate is used for and its purpose.
	ApplicationPolicies *ApplicationPolicies `type:"structure"`

	// The key usage extension defines the purpose (e.g., encipherment, signature,
	// certificate signing) of the key contained in the certificate.
	//
	// KeyUsage is a required field
	KeyUsage *KeyUsage `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtensionsV2) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtensionsV2) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExtensionsV2) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExtensionsV2"}
	if s.KeyUsage == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyUsage"))
	}
	if s.ApplicationPolicies != nil {
		if err := s.ApplicationPolicies.Validate(); err != nil {
			invalidParams.AddNested("ApplicationPolicies", err.(request.ErrInvalidParams))
		}
	}
	if s.KeyUsage != nil {
		if err := s.KeyUsage.Validate(); err != nil {
			invalidParams.AddNested("KeyUsage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationPolicies sets the ApplicationPolicies field's value.
func (s *ExtensionsV2) SetApplicationPolicies(v *ApplicationPolicies) *ExtensionsV2 {
	s.ApplicationPolicies = v
	return s
}

// SetKeyUsage sets the KeyUsage field's value.
func (s *ExtensionsV2) SetKeyUsage(v *KeyUsage) *ExtensionsV2 {
	s.KeyUsage = v
	return s
}

// Certificate extensions for v3 template schema
type ExtensionsV3 struct {
	_ struct{} `type:"structure"`

	// Application policies specify what the certificate is used for and its purpose.
	ApplicationPolicies *ApplicationPolicies `type:"structure"`

	// The key usage extension defines the purpose (e.g., encipherment, signature,
	// certificate signing) of the key contained in the certificate.
	//
	// KeyUsage is a required field
	KeyUsage *KeyUsage `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtensionsV3) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtensionsV3) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExtensionsV3) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExtensionsV3"}
	if s.KeyUsage == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyUsage"))
	}
	if s.ApplicationPolicies != nil {
		if err := s.ApplicationPolicies.Validate(); err != nil {
			invalidParams.AddNested("ApplicationPolicies", err.(request.ErrInvalidParams))
		}
	}
	if s.KeyUsage != nil {
		if err := s.KeyUsage.Validate(); err != nil {
			invalidParams.AddNested("KeyUsage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationPolicies sets the ApplicationPolicies field's value.
func (s *ExtensionsV3) SetApplicationPolicies(v *ApplicationPolicies) *ExtensionsV3 {
	s.ApplicationPolicies = v
	return s
}

// SetKeyUsage sets the KeyUsage field's value.
func (s *ExtensionsV3) SetKeyUsage(v *KeyUsage) *ExtensionsV3 {
	s.KeyUsage = v
	return s
}

// Certificate extensions for v4 template schema
type ExtensionsV4 struct {
	_ struct{} `type:"structure"`

	// Application policies specify what the certificate is used for and its purpose.
	ApplicationPolicies *ApplicationPolicies `type:"structure"`

	// The key usage extension defines the purpose (e.g., encipherment, signature)
	// of the key contained in the certificate.
	//
	// KeyUsage is a required field
	KeyUsage *KeyUsage `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtensionsV4) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtensionsV4) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExtensionsV4) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExtensionsV4"}
	if s.KeyUsage == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyUsage"))
	}
	if s.ApplicationPolicies != nil {
		if err := s.ApplicationPolicies.Validate(); err != nil {
			invalidParams.AddNested("ApplicationPolicies", err.(request.ErrInvalidParams))
		}
	}
	if s.KeyUsage != nil {
		if err := s.KeyUsage.Validate(); err != nil {
			invalidParams.AddNested("KeyUsage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationPolicies sets the ApplicationPolicies field's value.
func (s *ExtensionsV4) SetApplicationPolicies(v *ApplicationPolicies) *ExtensionsV4 {
	s.ApplicationPolicies = v
	return s
}

// SetKeyUsage sets the KeyUsage field's value.
func (s *ExtensionsV4) SetKeyUsage(v *KeyUsage) *ExtensionsV4 {
	s.KeyUsage = v
	return s
}

// General flags for v2 template schema that defines if the template is for
// a machine or a user and if the template can be issued using autoenrollment.
type GeneralFlagsV2 struct {
	_ struct{} `type:"structure"`

	// Allows certificate issuance using autoenrollment. Set to TRUE to allow autoenrollment.
	AutoEnrollment *bool `type:"boolean"`

	// Defines if the template is for machines or users. Set to TRUE if the template
	// is for machines. Set to FALSE if the template is for users.
	MachineType *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneralFlagsV2) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneralFlagsV2) GoString() string {
	return s.String()
}

// SetAutoEnrollment sets the AutoEnrollment field's value.
func (s *GeneralFlagsV2) SetAutoEnrollment(v bool) *GeneralFlagsV2 {
	s.AutoEnrollment = &v
	return s
}

// SetMachineType sets the MachineType field's value.
func (s *GeneralFlagsV2) SetMachineType(v bool) *GeneralFlagsV2 {
	s.MachineType = &v
	return s
}

// General flags for v3 template schema that defines if the template is for
// a machine or a user and if the template can be issued using autoenrollment.
type GeneralFlagsV3 struct {
	_ struct{} `type:"structure"`

	// Allows certificate issuance using autoenrollment. Set to TRUE to allow autoenrollment.
	AutoEnrollment *bool `type:"boolean"`

	// Defines if the template is for machines or users. Set to TRUE if the template
	// is for machines. Set to FALSE if the template is for users
	MachineType *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneralFlagsV3) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneralFlagsV3) GoString() string {
	return s.String()
}

// SetAutoEnrollment sets the AutoEnrollment field's value.
func (s *GeneralFlagsV3) SetAutoEnrollment(v bool) *GeneralFlagsV3 {
	s.AutoEnrollment = &v
	return s
}

// SetMachineType sets the MachineType field's value.
func (s *GeneralFlagsV3) SetMachineType(v bool) *GeneralFlagsV3 {
	s.MachineType = &v
	return s
}

// General flags for v4 template schema that defines if the template is for
// a machine or a user and if the template can be issued using autoenrollment.
type GeneralFlagsV4 struct {
	_ struct{} `type:"structure"`

	// Allows certificate issuance using autoenrollment. Set to TRUE to allow autoenrollment.
	AutoEnrollment *bool `type:"boolean"`

	// Defines if the template is for machines or users. Set to TRUE if the template
	// is for machines. Set to FALSE if the template is for users
	MachineType *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneralFlagsV4) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneralFlagsV4) GoString() string {
	return s.String()
}

// SetAutoEnrollment sets the AutoEnrollment field's value.
func (s *GeneralFlagsV4) SetAutoEnrollment(v bool) *GeneralFlagsV4 {
	s.AutoEnrollment = &v
	return s
}

// SetMachineType sets the MachineType field's value.
func (s *GeneralFlagsV4) SetMachineType(v bool) *GeneralFlagsV4 {
	s.MachineType = &v
	return s
}

type GetConnectorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateConnector
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html).
	//
	// ConnectorArn is a required field
	ConnectorArn *string `location:"uri" locationName:"ConnectorArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConnectorInput"}
	if s.ConnectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorArn"))
	}
	if s.ConnectorArn != nil && len(*s.ConnectorArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *GetConnectorInput) SetConnectorArn(v string) *GetConnectorInput {
	s.ConnectorArn = &v
	return s
}

type GetConnectorOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains information about your connector.
	Connector *Connector `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConnectorOutput) GoString() string {
	return s.String()
}

// SetConnector sets the Connector field's value.
func (s *GetConnectorOutput) SetConnector(v *Connector) *GetConnectorOutput {
	s.Connector = v
	return s
}

type GetDirectoryRegistrationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateDirectoryRegistration
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html).
	//
	// DirectoryRegistrationArn is a required field
	DirectoryRegistrationArn *string `location:"uri" locationName:"DirectoryRegistrationArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDirectoryRegistrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDirectoryRegistrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDirectoryRegistrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDirectoryRegistrationInput"}
	if s.DirectoryRegistrationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryRegistrationArn"))
	}
	if s.DirectoryRegistrationArn != nil && len(*s.DirectoryRegistrationArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryRegistrationArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryRegistrationArn sets the DirectoryRegistrationArn field's value.
func (s *GetDirectoryRegistrationInput) SetDirectoryRegistrationArn(v string) *GetDirectoryRegistrationInput {
	s.DirectoryRegistrationArn = &v
	return s
}

type GetDirectoryRegistrationOutput struct {
	_ struct{} `type:"structure"`

	// The directory registration represents the authorization of the connector
	// service with a directory.
	DirectoryRegistration *DirectoryRegistration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDirectoryRegistrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDirectoryRegistrationOutput) GoString() string {
	return s.String()
}

// SetDirectoryRegistration sets the DirectoryRegistration field's value.
func (s *GetDirectoryRegistrationOutput) SetDirectoryRegistration(v *DirectoryRegistration) *GetDirectoryRegistrationOutput {
	s.DirectoryRegistration = v
	return s
}

type GetServicePrincipalNameInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateConnector
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html).
	//
	// ConnectorArn is a required field
	ConnectorArn *string `location:"uri" locationName:"ConnectorArn" min:"5" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateDirectoryRegistration
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html).
	//
	// DirectoryRegistrationArn is a required field
	DirectoryRegistrationArn *string `location:"uri" locationName:"DirectoryRegistrationArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServicePrincipalNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServicePrincipalNameInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServicePrincipalNameInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServicePrincipalNameInput"}
	if s.ConnectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorArn"))
	}
	if s.ConnectorArn != nil && len(*s.ConnectorArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorArn", 5))
	}
	if s.DirectoryRegistrationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryRegistrationArn"))
	}
	if s.DirectoryRegistrationArn != nil && len(*s.DirectoryRegistrationArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryRegistrationArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *GetServicePrincipalNameInput) SetConnectorArn(v string) *GetServicePrincipalNameInput {
	s.ConnectorArn = &v
	return s
}

// SetDirectoryRegistrationArn sets the DirectoryRegistrationArn field's value.
func (s *GetServicePrincipalNameInput) SetDirectoryRegistrationArn(v string) *GetServicePrincipalNameInput {
	s.DirectoryRegistrationArn = &v
	return s
}

type GetServicePrincipalNameOutput struct {
	_ struct{} `type:"structure"`

	// The service principal name that the connector uses to authenticate with Active
	// Directory.
	ServicePrincipalName *ServicePrincipalName `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServicePrincipalNameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServicePrincipalNameOutput) GoString() string {
	return s.String()
}

// SetServicePrincipalName sets the ServicePrincipalName field's value.
func (s *GetServicePrincipalNameOutput) SetServicePrincipalName(v *ServicePrincipalName) *GetServicePrincipalNameOutput {
	s.ServicePrincipalName = v
	return s
}

type GetTemplateGroupAccessControlEntryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Security identifier (SID) of the group object from Active Directory. The
	// SID starts with "S-".
	//
	// GroupSecurityIdentifier is a required field
	GroupSecurityIdentifier *string `location:"uri" locationName:"GroupSecurityIdentifier" min:"7" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateTemplate
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html).
	//
	// TemplateArn is a required field
	TemplateArn *string `location:"uri" locationName:"TemplateArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateGroupAccessControlEntryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateGroupAccessControlEntryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTemplateGroupAccessControlEntryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTemplateGroupAccessControlEntryInput"}
	if s.GroupSecurityIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupSecurityIdentifier"))
	}
	if s.GroupSecurityIdentifier != nil && len(*s.GroupSecurityIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("GroupSecurityIdentifier", 7))
	}
	if s.TemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateArn"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupSecurityIdentifier sets the GroupSecurityIdentifier field's value.
func (s *GetTemplateGroupAccessControlEntryInput) SetGroupSecurityIdentifier(v string) *GetTemplateGroupAccessControlEntryInput {
	s.GroupSecurityIdentifier = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *GetTemplateGroupAccessControlEntryInput) SetTemplateArn(v string) *GetTemplateGroupAccessControlEntryInput {
	s.TemplateArn = &v
	return s
}

type GetTemplateGroupAccessControlEntryOutput struct {
	_ struct{} `type:"structure"`

	// An access control entry allows or denies an Active Directory group from enrolling
	// and/or autoenrolling with a template.
	AccessControlEntry *AccessControlEntry `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateGroupAccessControlEntryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateGroupAccessControlEntryOutput) GoString() string {
	return s.String()
}

// SetAccessControlEntry sets the AccessControlEntry field's value.
func (s *GetTemplateGroupAccessControlEntryOutput) SetAccessControlEntry(v *AccessControlEntry) *GetTemplateGroupAccessControlEntryOutput {
	s.AccessControlEntry = v
	return s
}

type GetTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateTemplate
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html).
	//
	// TemplateArn is a required field
	TemplateArn *string `location:"uri" locationName:"TemplateArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTemplateInput"}
	if s.TemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateArn"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *GetTemplateInput) SetTemplateArn(v string) *GetTemplateInput {
	s.TemplateArn = &v
	return s
}

type GetTemplateOutput struct {
	_ struct{} `type:"structure"`

	// A certificate template that the connector uses to issue certificates from
	// a private CA.
	Template *Template `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateOutput) GoString() string {
	return s.String()
}

// SetTemplate sets the Template field's value.
func (s *GetTemplateOutput) SetTemplate(v *Template) *GetTemplateOutput {
	s.Template = v
	return s
}

// The request processing has failed because of an unknown error, exception
// or failure with an internal server.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The key usage extension defines the purpose (e.g., encipherment, signature)
// of the key contained in the certificate.
type KeyUsage struct {
	_ struct{} `type:"structure"`

	// Sets the key usage extension to critical.
	Critical *bool `type:"boolean"`

	// The key usage flags represent the purpose (e.g., encipherment, signature)
	// of the key contained in the certificate.
	//
	// UsageFlags is a required field
	UsageFlags *KeyUsageFlags `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyUsage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyUsage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeyUsage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KeyUsage"}
	if s.UsageFlags == nil {
		invalidParams.Add(request.NewErrParamRequired("UsageFlags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCritical sets the Critical field's value.
func (s *KeyUsage) SetCritical(v bool) *KeyUsage {
	s.Critical = &v
	return s
}

// SetUsageFlags sets the UsageFlags field's value.
func (s *KeyUsage) SetUsageFlags(v *KeyUsageFlags) *KeyUsage {
	s.UsageFlags = v
	return s
}

// The key usage flags represent the purpose (e.g., encipherment, signature)
// of the key contained in the certificate.
type KeyUsageFlags struct {
	_ struct{} `type:"structure"`

	// DataEncipherment is asserted when the subject public key is used for directly
	// enciphering raw user data without the use of an intermediate symmetric cipher.
	DataEncipherment *bool `type:"boolean"`

	// The digitalSignature is asserted when the subject public key is used for
	// verifying digital signatures.
	DigitalSignature *bool `type:"boolean"`

	// KeyAgreement is asserted when the subject public key is used for key agreement.
	KeyAgreement *bool `type:"boolean"`

	// KeyEncipherment is asserted when the subject public key is used for enciphering
	// private or secret keys, i.e., for key transport.
	KeyEncipherment *bool `type:"boolean"`

	// NonRepudiation is asserted when the subject public key is used to verify
	// digital signatures.
	NonRepudiation *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyUsageFlags) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyUsageFlags) GoString() string {
	return s.String()
}

// SetDataEncipherment sets the DataEncipherment field's value.
func (s *KeyUsageFlags) SetDataEncipherment(v bool) *KeyUsageFlags {
	s.DataEncipherment = &v
	return s
}

// SetDigitalSignature sets the DigitalSignature field's value.
func (s *KeyUsageFlags) SetDigitalSignature(v bool) *KeyUsageFlags {
	s.DigitalSignature = &v
	return s
}

// SetKeyAgreement sets the KeyAgreement field's value.
func (s *KeyUsageFlags) SetKeyAgreement(v bool) *KeyUsageFlags {
	s.KeyAgreement = &v
	return s
}

// SetKeyEncipherment sets the KeyEncipherment field's value.
func (s *KeyUsageFlags) SetKeyEncipherment(v bool) *KeyUsageFlags {
	s.KeyEncipherment = &v
	return s
}

// SetNonRepudiation sets the NonRepudiation field's value.
func (s *KeyUsageFlags) SetNonRepudiation(v bool) *KeyUsageFlags {
	s.NonRepudiation = &v
	return s
}

// The key usage property defines the purpose of the private key contained in
// the certificate. You can specify specific purposes using property flags or
// all by using property type ALL.
type KeyUsageProperty struct {
	_ struct{} `type:"structure"`

	// You can specify key usage for encryption, key agreement, and signature. You
	// can use property flags or property type but not both.
	PropertyFlags *KeyUsagePropertyFlags `type:"structure"`

	// You can specify all key usages using property type ALL. You can use property
	// type or property flags but not both.
	PropertyType *string `type:"string" enum:"KeyUsagePropertyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyUsageProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyUsageProperty) GoString() string {
	return s.String()
}

// SetPropertyFlags sets the PropertyFlags field's value.
func (s *KeyUsageProperty) SetPropertyFlags(v *KeyUsagePropertyFlags) *KeyUsageProperty {
	s.PropertyFlags = v
	return s
}

// SetPropertyType sets the PropertyType field's value.
func (s *KeyUsageProperty) SetPropertyType(v string) *KeyUsageProperty {
	s.PropertyType = &v
	return s
}

// Specifies key usage.
type KeyUsagePropertyFlags struct {
	_ struct{} `type:"structure"`

	// Allows key for encryption and decryption.
	Decrypt *bool `type:"boolean"`

	// Allows key exchange without encryption.
	KeyAgreement *bool `type:"boolean"`

	// Allow key use for digital signature.
	Sign *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyUsagePropertyFlags) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyUsagePropertyFlags) GoString() string {
	return s.String()
}

// SetDecrypt sets the Decrypt field's value.
func (s *KeyUsagePropertyFlags) SetDecrypt(v bool) *KeyUsagePropertyFlags {
	s.Decrypt = &v
	return s
}

// SetKeyAgreement sets the KeyAgreement field's value.
func (s *KeyUsagePropertyFlags) SetKeyAgreement(v bool) *KeyUsagePropertyFlags {
	s.KeyAgreement = &v
	return s
}

// SetSign sets the Sign field's value.
func (s *KeyUsagePropertyFlags) SetSign(v bool) *KeyUsagePropertyFlags {
	s.Sign = &v
	return s
}

type ListConnectorsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Use this parameter when paginating results to specify the maximum number
	// of items to return in the response on each page. If additional items exist
	// beyond the number you specify, the NextToken element is sent in the response.
	// Use this NextToken value in a subsequent request to retrieve additional items.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// Use this parameter when paginating results in a subsequent request after
	// you receive a response with truncated results. Set it to the value of the
	// NextToken parameter from the response you just received.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConnectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConnectorsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConnectorsInput) SetMaxResults(v int64) *ListConnectorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConnectorsInput) SetNextToken(v string) *ListConnectorsInput {
	s.NextToken = &v
	return s
}

type ListConnectorsOutput struct {
	_ struct{} `type:"structure"`

	// Summary information about each connector you have created.
	Connectors []*ConnectorSummary `type:"list"`

	// Use this parameter when paginating results in a subsequent request after
	// you receive a response with truncated results. Set it to the value of the
	// NextToken parameter from the response you just received.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectorsOutput) GoString() string {
	return s.String()
}

// SetConnectors sets the Connectors field's value.
func (s *ListConnectorsOutput) SetConnectors(v []*ConnectorSummary) *ListConnectorsOutput {
	s.Connectors = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConnectorsOutput) SetNextToken(v string) *ListConnectorsOutput {
	s.NextToken = &v
	return s
}

type ListDirectoryRegistrationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Use this parameter when paginating results to specify the maximum number
	// of items to return in the response on each page. If additional items exist
	// beyond the number you specify, the NextToken element is sent in the response.
	// Use this NextToken value in a subsequent request to retrieve additional items.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// Use this parameter when paginating results in a subsequent request after
	// you receive a response with truncated results. Set it to the value of the
	// NextToken parameter from the response you just received.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDirectoryRegistrationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDirectoryRegistrationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDirectoryRegistrationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDirectoryRegistrationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDirectoryRegistrationsInput) SetMaxResults(v int64) *ListDirectoryRegistrationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDirectoryRegistrationsInput) SetNextToken(v string) *ListDirectoryRegistrationsInput {
	s.NextToken = &v
	return s
}

type ListDirectoryRegistrationsOutput struct {
	_ struct{} `type:"structure"`

	// Summary information about each directory registration you have created.
	DirectoryRegistrations []*DirectoryRegistrationSummary `type:"list"`

	// Use this parameter when paginating results in a subsequent request after
	// you receive a response with truncated results. Set it to the value of the
	// NextToken parameter from the response you just received.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDirectoryRegistrationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDirectoryRegistrationsOutput) GoString() string {
	return s.String()
}

// SetDirectoryRegistrations sets the DirectoryRegistrations field's value.
func (s *ListDirectoryRegistrationsOutput) SetDirectoryRegistrations(v []*DirectoryRegistrationSummary) *ListDirectoryRegistrationsOutput {
	s.DirectoryRegistrations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDirectoryRegistrationsOutput) SetNextToken(v string) *ListDirectoryRegistrationsOutput {
	s.NextToken = &v
	return s
}

type ListServicePrincipalNamesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateDirectoryRegistration
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html).
	//
	// DirectoryRegistrationArn is a required field
	DirectoryRegistrationArn *string `location:"uri" locationName:"DirectoryRegistrationArn" min:"5" type:"string" required:"true"`

	// Use this parameter when paginating results to specify the maximum number
	// of items to return in the response on each page. If additional items exist
	// beyond the number you specify, the NextToken element is sent in the response.
	// Use this NextToken value in a subsequent request to retrieve additional items.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// Use this parameter when paginating results in a subsequent request after
	// you receive a response with truncated results. Set it to the value of the
	// NextToken parameter from the response you just received.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicePrincipalNamesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicePrincipalNamesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServicePrincipalNamesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServicePrincipalNamesInput"}
	if s.DirectoryRegistrationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryRegistrationArn"))
	}
	if s.DirectoryRegistrationArn != nil && len(*s.DirectoryRegistrationArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryRegistrationArn", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryRegistrationArn sets the DirectoryRegistrationArn field's value.
func (s *ListServicePrincipalNamesInput) SetDirectoryRegistrationArn(v string) *ListServicePrincipalNamesInput {
	s.DirectoryRegistrationArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServicePrincipalNamesInput) SetMaxResults(v int64) *ListServicePrincipalNamesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicePrincipalNamesInput) SetNextToken(v string) *ListServicePrincipalNamesInput {
	s.NextToken = &v
	return s
}

type ListServicePrincipalNamesOutput struct {
	_ struct{} `type:"structure"`

	// Use this parameter when paginating results in a subsequent request after
	// you receive a response with truncated results. Set it to the value of the
	// NextToken parameter from the response you just received.
	NextToken *string `min:"1" type:"string"`

	// The service principal name, if any, that the connector uses to authenticate
	// with Active Directory.
	ServicePrincipalNames []*ServicePrincipalNameSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicePrincipalNamesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicePrincipalNamesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicePrincipalNamesOutput) SetNextToken(v string) *ListServicePrincipalNamesOutput {
	s.NextToken = &v
	return s
}

// SetServicePrincipalNames sets the ServicePrincipalNames field's value.
func (s *ListServicePrincipalNamesOutput) SetServicePrincipalNames(v []*ServicePrincipalNameSummary) *ListServicePrincipalNamesOutput {
	s.ServicePrincipalNames = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) that was returned when you created the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags, if any, that are associated with your resource.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTemplateGroupAccessControlEntriesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Use this parameter when paginating results to specify the maximum number
	// of items to return in the response on each page. If additional items exist
	// beyond the number you specify, the NextToken element is sent in the response.
	// Use this NextToken value in a subsequent request to retrieve additional items.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// Use this parameter when paginating results in a subsequent request after
	// you receive a response with truncated results. Set it to the value of the
	// NextToken parameter from the response you just received.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateTemplate
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html).
	//
	// TemplateArn is a required field
	TemplateArn *string `location:"uri" locationName:"TemplateArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplateGroupAccessControlEntriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplateGroupAccessControlEntriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTemplateGroupAccessControlEntriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTemplateGroupAccessControlEntriesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.TemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateArn"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTemplateGroupAccessControlEntriesInput) SetMaxResults(v int64) *ListTemplateGroupAccessControlEntriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplateGroupAccessControlEntriesInput) SetNextToken(v string) *ListTemplateGroupAccessControlEntriesInput {
	s.NextToken = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *ListTemplateGroupAccessControlEntriesInput) SetTemplateArn(v string) *ListTemplateGroupAccessControlEntriesInput {
	s.TemplateArn = &v
	return s
}

type ListTemplateGroupAccessControlEntriesOutput struct {
	_ struct{} `type:"structure"`

	// An access control entry grants or denies permission to an Active Directory
	// group to enroll certificates for a template.
	AccessControlEntries []*AccessControlEntrySummary `type:"list"`

	// Use this parameter when paginating results in a subsequent request after
	// you receive a response with truncated results. Set it to the value of the
	// NextToken parameter from the response you just received.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplateGroupAccessControlEntriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplateGroupAccessControlEntriesOutput) GoString() string {
	return s.String()
}

// SetAccessControlEntries sets the AccessControlEntries field's value.
func (s *ListTemplateGroupAccessControlEntriesOutput) SetAccessControlEntries(v []*AccessControlEntrySummary) *ListTemplateGroupAccessControlEntriesOutput {
	s.AccessControlEntries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplateGroupAccessControlEntriesOutput) SetNextToken(v string) *ListTemplateGroupAccessControlEntriesOutput {
	s.NextToken = &v
	return s
}

type ListTemplatesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateConnector
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html).
	//
	// ConnectorArn is a required field
	ConnectorArn *string `location:"querystring" locationName:"ConnectorArn" min:"5" type:"string" required:"true"`

	// Use this parameter when paginating results to specify the maximum number
	// of items to return in the response on each page. If additional items exist
	// beyond the number you specify, the NextToken element is sent in the response.
	// Use this NextToken value in a subsequent request to retrieve additional items.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// Use this parameter when paginating results in a subsequent request after
	// you receive a response with truncated results. Set it to the value of the
	// NextToken parameter from the response you just received.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTemplatesInput"}
	if s.ConnectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorArn"))
	}
	if s.ConnectorArn != nil && len(*s.ConnectorArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorArn", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *ListTemplatesInput) SetConnectorArn(v string) *ListTemplatesInput {
	s.ConnectorArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTemplatesInput) SetMaxResults(v int64) *ListTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplatesInput) SetNextToken(v string) *ListTemplatesInput {
	s.NextToken = &v
	return s
}

type ListTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// Use this parameter when paginating results in a subsequent request after
	// you receive a response with truncated results. Set it to the value of the
	// NextToken parameter from the response you just received.
	NextToken *string `min:"1" type:"string"`

	// Custom configuration templates used when issuing a certificate.
	Templates []*TemplateSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplatesOutput) SetNextToken(v string) *ListTemplatesOutput {
	s.NextToken = &v
	return s
}

// SetTemplates sets the Templates field's value.
func (s *ListTemplatesOutput) SetTemplates(v []*TemplateSummary) *ListTemplatesOutput {
	s.Templates = v
	return s
}

// Defines the attributes of the private key.
type PrivateKeyAttributesV2 struct {
	_ struct{} `type:"structure"`

	// Defines the cryptographic providers used to generate the private key.
	CryptoProviders []*string `min:"1" type:"list"`

	// Defines the purpose of the private key. Set it to "KEY_EXCHANGE" or "SIGNATURE"
	// value.
	//
	// KeySpec is a required field
	KeySpec *string `type:"string" required:"true" enum:"KeySpec"`

	// Set the minimum key length of the private key.
	//
	// MinimalKeyLength is a required field
	MinimalKeyLength *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivateKeyAttributesV2) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivateKeyAttributesV2) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrivateKeyAttributesV2) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrivateKeyAttributesV2"}
	if s.CryptoProviders != nil && len(s.CryptoProviders) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CryptoProviders", 1))
	}
	if s.KeySpec == nil {
		invalidParams.Add(request.NewErrParamRequired("KeySpec"))
	}
	if s.MinimalKeyLength == nil {
		invalidParams.Add(request.NewErrParamRequired("MinimalKeyLength"))
	}
	if s.MinimalKeyLength != nil && *s.MinimalKeyLength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinimalKeyLength", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCryptoProviders sets the CryptoProviders field's value.
func (s *PrivateKeyAttributesV2) SetCryptoProviders(v []*string) *PrivateKeyAttributesV2 {
	s.CryptoProviders = v
	return s
}

// SetKeySpec sets the KeySpec field's value.
func (s *PrivateKeyAttributesV2) SetKeySpec(v string) *PrivateKeyAttributesV2 {
	s.KeySpec = &v
	return s
}

// SetMinimalKeyLength sets the MinimalKeyLength field's value.
func (s *PrivateKeyAttributesV2) SetMinimalKeyLength(v int64) *PrivateKeyAttributesV2 {
	s.MinimalKeyLength = &v
	return s
}

// Defines the attributes of the private key.
type PrivateKeyAttributesV3 struct {
	_ struct{} `type:"structure"`

	// Defines the algorithm used to generate the private key.
	//
	// Algorithm is a required field
	Algorithm *string `type:"string" required:"true" enum:"PrivateKeyAlgorithm"`

	// Defines the cryptographic providers used to generate the private key.
	CryptoProviders []*string `min:"1" type:"list"`

	// Defines the purpose of the private key. Set it to "KEY_EXCHANGE" or "SIGNATURE"
	// value.
	//
	// KeySpec is a required field
	KeySpec *string `type:"string" required:"true" enum:"KeySpec"`

	// The key usage property defines the purpose of the private key contained in
	// the certificate. You can specify specific purposes using property flags or
	// all by using property type ALL.
	//
	// KeyUsageProperty is a required field
	KeyUsageProperty *KeyUsageProperty `type:"structure" required:"true"`

	// Set the minimum key length of the private key.
	//
	// MinimalKeyLength is a required field
	MinimalKeyLength *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivateKeyAttributesV3) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivateKeyAttributesV3) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrivateKeyAttributesV3) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrivateKeyAttributesV3"}
	if s.Algorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("Algorithm"))
	}
	if s.CryptoProviders != nil && len(s.CryptoProviders) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CryptoProviders", 1))
	}
	if s.KeySpec == nil {
		invalidParams.Add(request.NewErrParamRequired("KeySpec"))
	}
	if s.KeyUsageProperty == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyUsageProperty"))
	}
	if s.MinimalKeyLength == nil {
		invalidParams.Add(request.NewErrParamRequired("MinimalKeyLength"))
	}
	if s.MinimalKeyLength != nil && *s.MinimalKeyLength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinimalKeyLength", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithm sets the Algorithm field's value.
func (s *PrivateKeyAttributesV3) SetAlgorithm(v string) *PrivateKeyAttributesV3 {
	s.Algorithm = &v
	return s
}

// SetCryptoProviders sets the CryptoProviders field's value.
func (s *PrivateKeyAttributesV3) SetCryptoProviders(v []*string) *PrivateKeyAttributesV3 {
	s.CryptoProviders = v
	return s
}

// SetKeySpec sets the KeySpec field's value.
func (s *PrivateKeyAttributesV3) SetKeySpec(v string) *PrivateKeyAttributesV3 {
	s.KeySpec = &v
	return s
}

// SetKeyUsageProperty sets the KeyUsageProperty field's value.
func (s *PrivateKeyAttributesV3) SetKeyUsageProperty(v *KeyUsageProperty) *PrivateKeyAttributesV3 {
	s.KeyUsageProperty = v
	return s
}

// SetMinimalKeyLength sets the MinimalKeyLength field's value.
func (s *PrivateKeyAttributesV3) SetMinimalKeyLength(v int64) *PrivateKeyAttributesV3 {
	s.MinimalKeyLength = &v
	return s
}

// Defines the attributes of the private key.
type PrivateKeyAttributesV4 struct {
	_ struct{} `type:"structure"`

	// Defines the algorithm used to generate the private key.
	Algorithm *string `type:"string" enum:"PrivateKeyAlgorithm"`

	// Defines the cryptographic providers used to generate the private key.
	CryptoProviders []*string `min:"1" type:"list"`

	// Defines the purpose of the private key. Set it to "KEY_EXCHANGE" or "SIGNATURE"
	// value.
	//
	// KeySpec is a required field
	KeySpec *string `type:"string" required:"true" enum:"KeySpec"`

	// The key usage property defines the purpose of the private key contained in
	// the certificate. You can specify specific purposes using property flags or
	// all by using property type ALL.
	KeyUsageProperty *KeyUsageProperty `type:"structure"`

	// Set the minimum key length of the private key.
	//
	// MinimalKeyLength is a required field
	MinimalKeyLength *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivateKeyAttributesV4) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivateKeyAttributesV4) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrivateKeyAttributesV4) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrivateKeyAttributesV4"}
	if s.CryptoProviders != nil && len(s.CryptoProviders) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CryptoProviders", 1))
	}
	if s.KeySpec == nil {
		invalidParams.Add(request.NewErrParamRequired("KeySpec"))
	}
	if s.MinimalKeyLength == nil {
		invalidParams.Add(request.NewErrParamRequired("MinimalKeyLength"))
	}
	if s.MinimalKeyLength != nil && *s.MinimalKeyLength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinimalKeyLength", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithm sets the Algorithm field's value.
func (s *PrivateKeyAttributesV4) SetAlgorithm(v string) *PrivateKeyAttributesV4 {
	s.Algorithm = &v
	return s
}

// SetCryptoProviders sets the CryptoProviders field's value.
func (s *PrivateKeyAttributesV4) SetCryptoProviders(v []*string) *PrivateKeyAttributesV4 {
	s.CryptoProviders = v
	return s
}

// SetKeySpec sets the KeySpec field's value.
func (s *PrivateKeyAttributesV4) SetKeySpec(v string) *PrivateKeyAttributesV4 {
	s.KeySpec = &v
	return s
}

// SetKeyUsageProperty sets the KeyUsageProperty field's value.
func (s *PrivateKeyAttributesV4) SetKeyUsageProperty(v *KeyUsageProperty) *PrivateKeyAttributesV4 {
	s.KeyUsageProperty = v
	return s
}

// SetMinimalKeyLength sets the MinimalKeyLength field's value.
func (s *PrivateKeyAttributesV4) SetMinimalKeyLength(v int64) *PrivateKeyAttributesV4 {
	s.MinimalKeyLength = &v
	return s
}

// Private key flags for v2 templates specify the client compatibility, if the
// private key can be exported, and if user input is required when using a private
// key.
type PrivateKeyFlagsV2 struct {
	_ struct{} `type:"structure"`

	// Defines the minimum client compatibility.
	//
	// ClientVersion is a required field
	ClientVersion *string `type:"string" required:"true" enum:"ClientCompatibilityV2"`

	// Allows the private key to be exported.
	ExportableKey *bool `type:"boolean"`

	// Require user input when using the private key for enrollment.
	StrongKeyProtectionRequired *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivateKeyFlagsV2) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivateKeyFlagsV2) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrivateKeyFlagsV2) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrivateKeyFlagsV2"}
	if s.ClientVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientVersion sets the ClientVersion field's value.
func (s *PrivateKeyFlagsV2) SetClientVersion(v string) *PrivateKeyFlagsV2 {
	s.ClientVersion = &v
	return s
}

// SetExportableKey sets the ExportableKey field's value.
func (s *PrivateKeyFlagsV2) SetExportableKey(v bool) *PrivateKeyFlagsV2 {
	s.ExportableKey = &v
	return s
}

// SetStrongKeyProtectionRequired sets the StrongKeyProtectionRequired field's value.
func (s *PrivateKeyFlagsV2) SetStrongKeyProtectionRequired(v bool) *PrivateKeyFlagsV2 {
	s.StrongKeyProtectionRequired = &v
	return s
}

// Private key flags for v3 templates specify the client compatibility, if the
// private key can be exported, if user input is required when using a private
// key, and if an alternate signature algorithm should be used.
type PrivateKeyFlagsV3 struct {
	_ struct{} `type:"structure"`

	// Defines the minimum client compatibility.
	//
	// ClientVersion is a required field
	ClientVersion *string `type:"string" required:"true" enum:"ClientCompatibilityV3"`

	// Allows the private key to be exported.
	ExportableKey *bool `type:"boolean"`

	// Reguires the PKCS #1 v2.1 signature format for certificates. You should verify
	// that your CA, objects, and applications can accept this signature format.
	RequireAlternateSignatureAlgorithm *bool `type:"boolean"`

	// Requirer user input when using the private key for enrollment.
	StrongKeyProtectionRequired *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivateKeyFlagsV3) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivateKeyFlagsV3) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrivateKeyFlagsV3) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrivateKeyFlagsV3"}
	if s.ClientVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientVersion sets the ClientVersion field's value.
func (s *PrivateKeyFlagsV3) SetClientVersion(v string) *PrivateKeyFlagsV3 {
	s.ClientVersion = &v
	return s
}

// SetExportableKey sets the ExportableKey field's value.
func (s *PrivateKeyFlagsV3) SetExportableKey(v bool) *PrivateKeyFlagsV3 {
	s.ExportableKey = &v
	return s
}

// SetRequireAlternateSignatureAlgorithm sets the RequireAlternateSignatureAlgorithm field's value.
func (s *PrivateKeyFlagsV3) SetRequireAlternateSignatureAlgorithm(v bool) *PrivateKeyFlagsV3 {
	s.RequireAlternateSignatureAlgorithm = &v
	return s
}

// SetStrongKeyProtectionRequired sets the StrongKeyProtectionRequired field's value.
func (s *PrivateKeyFlagsV3) SetStrongKeyProtectionRequired(v bool) *PrivateKeyFlagsV3 {
	s.StrongKeyProtectionRequired = &v
	return s
}

// Private key flags for v4 templates specify the client compatibility, if the
// private key can be exported, if user input is required when using a private
// key, if an alternate signature algorithm should be used, and if certificates
// are renewed using the same private key.
type PrivateKeyFlagsV4 struct {
	_ struct{} `type:"structure"`

	// Defines the minimum client compatibility.
	//
	// ClientVersion is a required field
	ClientVersion *string `type:"string" required:"true" enum:"ClientCompatibilityV4"`

	// Allows the private key to be exported.
	ExportableKey *bool `type:"boolean"`

	// Requires the PKCS #1 v2.1 signature format for certificates. You should verify
	// that your CA, objects, and applications can accept this signature format.
	RequireAlternateSignatureAlgorithm *bool `type:"boolean"`

	// Renew certificate using the same private key.
	RequireSameKeyRenewal *bool `type:"boolean"`

	// Require user input when using the private key for enrollment.
	StrongKeyProtectionRequired *bool `type:"boolean"`

	// Specifies the cryptographic service provider category used to generate private
	// keys. Set to TRUE to use Legacy Cryptographic Service Providers and FALSE
	// to use Key Storage Providers.
	UseLegacyProvider *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivateKeyFlagsV4) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrivateKeyFlagsV4) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrivateKeyFlagsV4) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrivateKeyFlagsV4"}
	if s.ClientVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientVersion sets the ClientVersion field's value.
func (s *PrivateKeyFlagsV4) SetClientVersion(v string) *PrivateKeyFlagsV4 {
	s.ClientVersion = &v
	return s
}

// SetExportableKey sets the ExportableKey field's value.
func (s *PrivateKeyFlagsV4) SetExportableKey(v bool) *PrivateKeyFlagsV4 {
	s.ExportableKey = &v
	return s
}

// SetRequireAlternateSignatureAlgorithm sets the RequireAlternateSignatureAlgorithm field's value.
func (s *PrivateKeyFlagsV4) SetRequireAlternateSignatureAlgorithm(v bool) *PrivateKeyFlagsV4 {
	s.RequireAlternateSignatureAlgorithm = &v
	return s
}

// SetRequireSameKeyRenewal sets the RequireSameKeyRenewal field's value.
func (s *PrivateKeyFlagsV4) SetRequireSameKeyRenewal(v bool) *PrivateKeyFlagsV4 {
	s.RequireSameKeyRenewal = &v
	return s
}

// SetStrongKeyProtectionRequired sets the StrongKeyProtectionRequired field's value.
func (s *PrivateKeyFlagsV4) SetStrongKeyProtectionRequired(v bool) *PrivateKeyFlagsV4 {
	s.StrongKeyProtectionRequired = &v
	return s
}

// SetUseLegacyProvider sets the UseLegacyProvider field's value.
func (s *PrivateKeyFlagsV4) SetUseLegacyProvider(v bool) *PrivateKeyFlagsV4 {
	s.UseLegacyProvider = &v
	return s
}

// The operation tried to access a nonexistent resource. The resource might
// not be specified correctly, or its status might not be ACTIVE.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The identifier of the Amazon Web Services resource.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The resource type, which can be one of Connector, Template, TemplateGroupAccessControlEntry,
	// ServicePrincipalName, or DirectoryRegistration.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service principal name that the connector uses to authenticate with Active
// Directory.
type ServicePrincipalName struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateConnector.html
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html).
	ConnectorArn *string `min:"5" type:"string"`

	// The date and time that the service principal name was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateDirectoryRegistration
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html).
	DirectoryRegistrationArn *string `min:"5" type:"string"`

	// The status of a service principal name.
	Status *string `type:"string" enum:"ServicePrincipalNameStatus"`

	// Additional information for the status of a service principal name if the
	// status is failed.
	StatusReason *string `type:"string" enum:"ServicePrincipalNameStatusReason"`

	// The date and time that the service principal name was updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServicePrincipalName) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServicePrincipalName) GoString() string {
	return s.String()
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *ServicePrincipalName) SetConnectorArn(v string) *ServicePrincipalName {
	s.ConnectorArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ServicePrincipalName) SetCreatedAt(v time.Time) *ServicePrincipalName {
	s.CreatedAt = &v
	return s
}

// SetDirectoryRegistrationArn sets the DirectoryRegistrationArn field's value.
func (s *ServicePrincipalName) SetDirectoryRegistrationArn(v string) *ServicePrincipalName {
	s.DirectoryRegistrationArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ServicePrincipalName) SetStatus(v string) *ServicePrincipalName {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *ServicePrincipalName) SetStatusReason(v string) *ServicePrincipalName {
	s.StatusReason = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ServicePrincipalName) SetUpdatedAt(v time.Time) *ServicePrincipalName {
	s.UpdatedAt = &v
	return s
}

// The service principal name that the connector uses to authenticate with Active
// Directory.
type ServicePrincipalNameSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateConnector
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html).
	ConnectorArn *string `min:"5" type:"string"`

	// The date and time that the service principal name was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateDirectoryRegistration
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html).
	DirectoryRegistrationArn *string `min:"5" type:"string"`

	// The status of a service principal name.
	Status *string `type:"string" enum:"ServicePrincipalNameStatus"`

	// Additional information for the status of a service principal name if the
	// status is failed.
	StatusReason *string `type:"string" enum:"ServicePrincipalNameStatusReason"`

	// Time when the service principal name was updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServicePrincipalNameSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServicePrincipalNameSummary) GoString() string {
	return s.String()
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *ServicePrincipalNameSummary) SetConnectorArn(v string) *ServicePrincipalNameSummary {
	s.ConnectorArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ServicePrincipalNameSummary) SetCreatedAt(v time.Time) *ServicePrincipalNameSummary {
	s.CreatedAt = &v
	return s
}

// SetDirectoryRegistrationArn sets the DirectoryRegistrationArn field's value.
func (s *ServicePrincipalNameSummary) SetDirectoryRegistrationArn(v string) *ServicePrincipalNameSummary {
	s.DirectoryRegistrationArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ServicePrincipalNameSummary) SetStatus(v string) *ServicePrincipalNameSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *ServicePrincipalNameSummary) SetStatusReason(v string) *ServicePrincipalNameSummary {
	s.StatusReason = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ServicePrincipalNameSummary) SetUpdatedAt(v time.Time) *ServicePrincipalNameSummary {
	s.UpdatedAt = &v
	return s
}

// Request would cause a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The code associated with the service quota.
	//
	// QuotaCode is a required field
	QuotaCode *string `type:"string" required:"true"`

	// The identifier of the Amazon Web Services resource.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The resource type, which can be one of Connector, Template, TemplateGroupAccessControlEntry,
	// ServicePrincipalName, or DirectoryRegistration.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`

	// Identifies the originating service.
	//
	// ServiceCode is a required field
	ServiceCode *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information to include in the subject name and alternate subject name of
// the certificate. The subject name can be common name, directory path, DNS
// as common name, or left blank. You can optionally include email to the subject
// name for user templates. If you leave the subject name blank then you must
// set a subject alternate name. The subject alternate name (SAN) can include
// globally unique identifier (GUID), DNS, domain DNS, email, service principal
// name (SPN), and user principal name (UPN). You can leave the SAN blank. If
// you leave the SAN blank, then you must set a subject name.
type SubjectNameFlagsV2 struct {
	_ struct{} `type:"structure"`

	// Include the common name in the subject name.
	RequireCommonName *bool `type:"boolean"`

	// Include the directory path in the subject name.
	RequireDirectoryPath *bool `type:"boolean"`

	// Include the DNS as common name in the subject name.
	RequireDnsAsCn *bool `type:"boolean"`

	// Include the subject's email in the subject name.
	RequireEmail *bool `type:"boolean"`

	// Include the globally unique identifier (GUID) in the subject alternate name.
	SanRequireDirectoryGuid *bool `type:"boolean"`

	// Include the DNS in the subject alternate name.
	SanRequireDns *bool `type:"boolean"`

	// Include the domain DNS in the subject alternate name.
	SanRequireDomainDns *bool `type:"boolean"`

	// Include the subject's email in the subject alternate name.
	SanRequireEmail *bool `type:"boolean"`

	// Include the service principal name (SPN) in the subject alternate name.
	SanRequireSpn *bool `type:"boolean"`

	// Include the user principal name (UPN) in the subject alternate name.
	SanRequireUpn *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubjectNameFlagsV2) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubjectNameFlagsV2) GoString() string {
	return s.String()
}

// SetRequireCommonName sets the RequireCommonName field's value.
func (s *SubjectNameFlagsV2) SetRequireCommonName(v bool) *SubjectNameFlagsV2 {
	s.RequireCommonName = &v
	return s
}

// SetRequireDirectoryPath sets the RequireDirectoryPath field's value.
func (s *SubjectNameFlagsV2) SetRequireDirectoryPath(v bool) *SubjectNameFlagsV2 {
	s.RequireDirectoryPath = &v
	return s
}

// SetRequireDnsAsCn sets the RequireDnsAsCn field's value.
func (s *SubjectNameFlagsV2) SetRequireDnsAsCn(v bool) *SubjectNameFlagsV2 {
	s.RequireDnsAsCn = &v
	return s
}

// SetRequireEmail sets the RequireEmail field's value.
func (s *SubjectNameFlagsV2) SetRequireEmail(v bool) *SubjectNameFlagsV2 {
	s.RequireEmail = &v
	return s
}

// SetSanRequireDirectoryGuid sets the SanRequireDirectoryGuid field's value.
func (s *SubjectNameFlagsV2) SetSanRequireDirectoryGuid(v bool) *SubjectNameFlagsV2 {
	s.SanRequireDirectoryGuid = &v
	return s
}

// SetSanRequireDns sets the SanRequireDns field's value.
func (s *SubjectNameFlagsV2) SetSanRequireDns(v bool) *SubjectNameFlagsV2 {
	s.SanRequireDns = &v
	return s
}

// SetSanRequireDomainDns sets the SanRequireDomainDns field's value.
func (s *SubjectNameFlagsV2) SetSanRequireDomainDns(v bool) *SubjectNameFlagsV2 {
	s.SanRequireDomainDns = &v
	return s
}

// SetSanRequireEmail sets the SanRequireEmail field's value.
func (s *SubjectNameFlagsV2) SetSanRequireEmail(v bool) *SubjectNameFlagsV2 {
	s.SanRequireEmail = &v
	return s
}

// SetSanRequireSpn sets the SanRequireSpn field's value.
func (s *SubjectNameFlagsV2) SetSanRequireSpn(v bool) *SubjectNameFlagsV2 {
	s.SanRequireSpn = &v
	return s
}

// SetSanRequireUpn sets the SanRequireUpn field's value.
func (s *SubjectNameFlagsV2) SetSanRequireUpn(v bool) *SubjectNameFlagsV2 {
	s.SanRequireUpn = &v
	return s
}

// Information to include in the subject name and alternate subject name of
// the certificate. The subject name can be common name, directory path, DNS
// as common name, or left blank. You can optionally include email to the subject
// name for user templates. If you leave the subject name blank then you must
// set a subject alternate name. The subject alternate name (SAN) can include
// globally unique identifier (GUID), DNS, domain DNS, email, service principal
// name (SPN), and user principal name (UPN). You can leave the SAN blank. If
// you leave the SAN blank, then you must set a subject name.
type SubjectNameFlagsV3 struct {
	_ struct{} `type:"structure"`

	// Include the common name in the subject name.
	RequireCommonName *bool `type:"boolean"`

	// Include the directory path in the subject name.
	RequireDirectoryPath *bool `type:"boolean"`

	// Include the DNS as common name in the subject name.
	RequireDnsAsCn *bool `type:"boolean"`

	// Include the subject's email in the subject name.
	RequireEmail *bool `type:"boolean"`

	// Include the globally unique identifier (GUID) in the subject alternate name.
	SanRequireDirectoryGuid *bool `type:"boolean"`

	// Include the DNS in the subject alternate name.
	SanRequireDns *bool `type:"boolean"`

	// Include the domain DNS in the subject alternate name.
	SanRequireDomainDns *bool `type:"boolean"`

	// Include the subject's email in the subject alternate name.
	SanRequireEmail *bool `type:"boolean"`

	// Include the service principal name (SPN) in the subject alternate name.
	SanRequireSpn *bool `type:"boolean"`

	// Include the user principal name (UPN) in the subject alternate name.
	SanRequireUpn *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubjectNameFlagsV3) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubjectNameFlagsV3) GoString() string {
	return s.String()
}

// SetRequireCommonName sets the RequireCommonName field's value.
func (s *SubjectNameFlagsV3) SetRequireCommonName(v bool) *SubjectNameFlagsV3 {
	s.RequireCommonName = &v
	return s
}

// SetRequireDirectoryPath sets the RequireDirectoryPath field's value.
func (s *SubjectNameFlagsV3) SetRequireDirectoryPath(v bool) *SubjectNameFlagsV3 {
	s.RequireDirectoryPath = &v
	return s
}

// SetRequireDnsAsCn sets the RequireDnsAsCn field's value.
func (s *SubjectNameFlagsV3) SetRequireDnsAsCn(v bool) *SubjectNameFlagsV3 {
	s.RequireDnsAsCn = &v
	return s
}

// SetRequireEmail sets the RequireEmail field's value.
func (s *SubjectNameFlagsV3) SetRequireEmail(v bool) *SubjectNameFlagsV3 {
	s.RequireEmail = &v
	return s
}

// SetSanRequireDirectoryGuid sets the SanRequireDirectoryGuid field's value.
func (s *SubjectNameFlagsV3) SetSanRequireDirectoryGuid(v bool) *SubjectNameFlagsV3 {
	s.SanRequireDirectoryGuid = &v
	return s
}

// SetSanRequireDns sets the SanRequireDns field's value.
func (s *SubjectNameFlagsV3) SetSanRequireDns(v bool) *SubjectNameFlagsV3 {
	s.SanRequireDns = &v
	return s
}

// SetSanRequireDomainDns sets the SanRequireDomainDns field's value.
func (s *SubjectNameFlagsV3) SetSanRequireDomainDns(v bool) *SubjectNameFlagsV3 {
	s.SanRequireDomainDns = &v
	return s
}

// SetSanRequireEmail sets the SanRequireEmail field's value.
func (s *SubjectNameFlagsV3) SetSanRequireEmail(v bool) *SubjectNameFlagsV3 {
	s.SanRequireEmail = &v
	return s
}

// SetSanRequireSpn sets the SanRequireSpn field's value.
func (s *SubjectNameFlagsV3) SetSanRequireSpn(v bool) *SubjectNameFlagsV3 {
	s.SanRequireSpn = &v
	return s
}

// SetSanRequireUpn sets the SanRequireUpn field's value.
func (s *SubjectNameFlagsV3) SetSanRequireUpn(v bool) *SubjectNameFlagsV3 {
	s.SanRequireUpn = &v
	return s
}

// Information to include in the subject name and alternate subject name of
// the certificate. The subject name can be common name, directory path, DNS
// as common name, or left blank. You can optionally include email to the subject
// name for user templates. If you leave the subject name blank then you must
// set a subject alternate name. The subject alternate name (SAN) can include
// globally unique identifier (GUID), DNS, domain DNS, email, service principal
// name (SPN), and user principal name (UPN). You can leave the SAN blank. If
// you leave the SAN blank, then you must set a subject name.
type SubjectNameFlagsV4 struct {
	_ struct{} `type:"structure"`

	// Include the common name in the subject name.
	RequireCommonName *bool `type:"boolean"`

	// Include the directory path in the subject name.
	RequireDirectoryPath *bool `type:"boolean"`

	// Include the DNS as common name in the subject name.
	RequireDnsAsCn *bool `type:"boolean"`

	// Include the subject's email in the subject name.
	RequireEmail *bool `type:"boolean"`

	// Include the globally unique identifier (GUID) in the subject alternate name.
	SanRequireDirectoryGuid *bool `type:"boolean"`

	// Include the DNS in the subject alternate name.
	SanRequireDns *bool `type:"boolean"`

	// Include the domain DNS in the subject alternate name.
	SanRequireDomainDns *bool `type:"boolean"`

	// Include the subject's email in the subject alternate name.
	SanRequireEmail *bool `type:"boolean"`

	// Include the service principal name (SPN) in the subject alternate name.
	SanRequireSpn *bool `type:"boolean"`

	// Include the user principal name (UPN) in the subject alternate name.
	SanRequireUpn *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubjectNameFlagsV4) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubjectNameFlagsV4) GoString() string {
	return s.String()
}

// SetRequireCommonName sets the RequireCommonName field's value.
func (s *SubjectNameFlagsV4) SetRequireCommonName(v bool) *SubjectNameFlagsV4 {
	s.RequireCommonName = &v
	return s
}

// SetRequireDirectoryPath sets the RequireDirectoryPath field's value.
func (s *SubjectNameFlagsV4) SetRequireDirectoryPath(v bool) *SubjectNameFlagsV4 {
	s.RequireDirectoryPath = &v
	return s
}

// SetRequireDnsAsCn sets the RequireDnsAsCn field's value.
func (s *SubjectNameFlagsV4) SetRequireDnsAsCn(v bool) *SubjectNameFlagsV4 {
	s.RequireDnsAsCn = &v
	return s
}

// SetRequireEmail sets the RequireEmail field's value.
func (s *SubjectNameFlagsV4) SetRequireEmail(v bool) *SubjectNameFlagsV4 {
	s.RequireEmail = &v
	return s
}

// SetSanRequireDirectoryGuid sets the SanRequireDirectoryGuid field's value.
func (s *SubjectNameFlagsV4) SetSanRequireDirectoryGuid(v bool) *SubjectNameFlagsV4 {
	s.SanRequireDirectoryGuid = &v
	return s
}

// SetSanRequireDns sets the SanRequireDns field's value.
func (s *SubjectNameFlagsV4) SetSanRequireDns(v bool) *SubjectNameFlagsV4 {
	s.SanRequireDns = &v
	return s
}

// SetSanRequireDomainDns sets the SanRequireDomainDns field's value.
func (s *SubjectNameFlagsV4) SetSanRequireDomainDns(v bool) *SubjectNameFlagsV4 {
	s.SanRequireDomainDns = &v
	return s
}

// SetSanRequireEmail sets the SanRequireEmail field's value.
func (s *SubjectNameFlagsV4) SetSanRequireEmail(v bool) *SubjectNameFlagsV4 {
	s.SanRequireEmail = &v
	return s
}

// SetSanRequireSpn sets the SanRequireSpn field's value.
func (s *SubjectNameFlagsV4) SetSanRequireSpn(v bool) *SubjectNameFlagsV4 {
	s.SanRequireSpn = &v
	return s
}

// SetSanRequireUpn sets the SanRequireUpn field's value.
func (s *SubjectNameFlagsV4) SetSanRequireUpn(v bool) *SubjectNameFlagsV4 {
	s.SanRequireUpn = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you created the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// Metadata assigned to a directory registration consisting of a key-value pair.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// An Active Directory compatible certificate template. Connectors issue certificates
// against these templates based on the requestor's Active Directory group membership.
type Template struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateTemplate
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html).
	Arn *string `min:"5" type:"string"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateConnector
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html).
	ConnectorArn *string `min:"5" type:"string"`

	// The date and time that the template was created.
	CreatedAt *time.Time `type:"timestamp"`

	// Template configuration to define the information included in certificates.
	// Define certificate validity and renewal periods, certificate request handling
	// and enrollment options, key usage extensions, application policies, and cryptography
	// settings.
	Definition *TemplateDefinition `type:"structure"`

	// Name of the templates. Template names must be unique.
	Name *string `min:"1" type:"string"`

	// Object identifier of a template.
	ObjectIdentifier *string `min:"1" type:"string"`

	// The template schema version. Template schema versions can be v2, v3, or v4.
	// The template configuration options change based on the template schema version.
	PolicySchema *int64 `type:"integer"`

	// The version of the template. Template updates will increment the minor revision.
	// Re-enrolling all certificate holders will increment the major revision.
	Revision *TemplateRevision `type:"structure"`

	// Status of the template. Status can be creating, active, deleting, or failed.
	Status *string `type:"string" enum:"TemplateStatus"`

	// The date and time that the template was updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Template) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Template) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Template) SetArn(v string) *Template {
	s.Arn = &v
	return s
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *Template) SetConnectorArn(v string) *Template {
	s.ConnectorArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Template) SetCreatedAt(v time.Time) *Template {
	s.CreatedAt = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *Template) SetDefinition(v *TemplateDefinition) *Template {
	s.Definition = v
	return s
}

// SetName sets the Name field's value.
func (s *Template) SetName(v string) *Template {
	s.Name = &v
	return s
}

// SetObjectIdentifier sets the ObjectIdentifier field's value.
func (s *Template) SetObjectIdentifier(v string) *Template {
	s.ObjectIdentifier = &v
	return s
}

// SetPolicySchema sets the PolicySchema field's value.
func (s *Template) SetPolicySchema(v int64) *Template {
	s.PolicySchema = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *Template) SetRevision(v *TemplateRevision) *Template {
	s.Revision = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Template) SetStatus(v string) *Template {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Template) SetUpdatedAt(v time.Time) *Template {
	s.UpdatedAt = &v
	return s
}

// Template configuration to define the information included in certificates.
// Define certificate validity and renewal periods, certificate request handling
// and enrollment options, key usage extensions, application policies, and cryptography
// settings.
type TemplateDefinition struct {
	_ struct{} `type:"structure"`

	// Template configuration to define the information included in certificates.
	// Define certificate validity and renewal periods, certificate request handling
	// and enrollment options, key usage extensions, application policies, and cryptography
	// settings.
	TemplateV2 *TemplateV2 `type:"structure"`

	// Template configuration to define the information included in certificates.
	// Define certificate validity and renewal periods, certificate request handling
	// and enrollment options, key usage extensions, application policies, and cryptography
	// settings.
	TemplateV3 *TemplateV3 `type:"structure"`

	// Template configuration to define the information included in certificates.
	// Define certificate validity and renewal periods, certificate request handling
	// and enrollment options, key usage extensions, application policies, and cryptography
	// settings.
	TemplateV4 *TemplateV4 `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TemplateDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TemplateDefinition"}
	if s.TemplateV2 != nil {
		if err := s.TemplateV2.Validate(); err != nil {
			invalidParams.AddNested("TemplateV2", err.(request.ErrInvalidParams))
		}
	}
	if s.TemplateV3 != nil {
		if err := s.TemplateV3.Validate(); err != nil {
			invalidParams.AddNested("TemplateV3", err.(request.ErrInvalidParams))
		}
	}
	if s.TemplateV4 != nil {
		if err := s.TemplateV4.Validate(); err != nil {
			invalidParams.AddNested("TemplateV4", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateV2 sets the TemplateV2 field's value.
func (s *TemplateDefinition) SetTemplateV2(v *TemplateV2) *TemplateDefinition {
	s.TemplateV2 = v
	return s
}

// SetTemplateV3 sets the TemplateV3 field's value.
func (s *TemplateDefinition) SetTemplateV3(v *TemplateV3) *TemplateDefinition {
	s.TemplateV3 = v
	return s
}

// SetTemplateV4 sets the TemplateV4 field's value.
func (s *TemplateDefinition) SetTemplateV4(v *TemplateV4) *TemplateDefinition {
	s.TemplateV4 = v
	return s
}

// The revision version of the template. Template updates will increment the
// minor revision. Re-enrolling all certificate holders will increment the major
// revision.
type TemplateRevision struct {
	_ struct{} `type:"structure"`

	// The revision version of the template. Re-enrolling all certificate holders
	// will increment the major revision.
	//
	// MajorRevision is a required field
	MajorRevision *int64 `type:"integer" required:"true"`

	// The revision version of the template. Re-enrolling all certificate holders
	// will increment the major revision.
	//
	// MinorRevision is a required field
	MinorRevision *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateRevision) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateRevision) GoString() string {
	return s.String()
}

// SetMajorRevision sets the MajorRevision field's value.
func (s *TemplateRevision) SetMajorRevision(v int64) *TemplateRevision {
	s.MajorRevision = &v
	return s
}

// SetMinorRevision sets the MinorRevision field's value.
func (s *TemplateRevision) SetMinorRevision(v int64) *TemplateRevision {
	s.MinorRevision = &v
	return s
}

// An Active Directory compatible certificate template. Connectors issue certificates
// against these templates based on the requestor's Active Directory group membership.
type TemplateSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateTemplate
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html).
	Arn *string `min:"5" type:"string"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateConnector
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html).
	ConnectorArn *string `min:"5" type:"string"`

	// The date and time that the template was created.
	CreatedAt *time.Time `type:"timestamp"`

	// Template configuration to define the information included in certificates.
	// Define certificate validity and renewal periods, certificate request handling
	// and enrollment options, key usage extensions, application policies, and cryptography
	// settings.
	Definition *TemplateDefinition `type:"structure"`

	// Name of the template. The template name must be unique.
	Name *string `min:"1" type:"string"`

	// Object identifier of a template.
	ObjectIdentifier *string `min:"1" type:"string"`

	// The template schema version. Template schema versions can be v2, v3, or v4.
	// The template configuration options change based on the template schema version.
	PolicySchema *int64 `type:"integer"`

	// The revision version of the template. Template updates will increment the
	// minor revision. Re-enrolling all certificate holders will increment the major
	// revision.
	Revision *TemplateRevision `type:"structure"`

	// Status of the template. Status can be creating, active, deleting, or failed.
	Status *string `type:"string" enum:"TemplateStatus"`

	// The date and time that the template was updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *TemplateSummary) SetArn(v string) *TemplateSummary {
	s.Arn = &v
	return s
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *TemplateSummary) SetConnectorArn(v string) *TemplateSummary {
	s.ConnectorArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *TemplateSummary) SetCreatedAt(v time.Time) *TemplateSummary {
	s.CreatedAt = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *TemplateSummary) SetDefinition(v *TemplateDefinition) *TemplateSummary {
	s.Definition = v
	return s
}

// SetName sets the Name field's value.
func (s *TemplateSummary) SetName(v string) *TemplateSummary {
	s.Name = &v
	return s
}

// SetObjectIdentifier sets the ObjectIdentifier field's value.
func (s *TemplateSummary) SetObjectIdentifier(v string) *TemplateSummary {
	s.ObjectIdentifier = &v
	return s
}

// SetPolicySchema sets the PolicySchema field's value.
func (s *TemplateSummary) SetPolicySchema(v int64) *TemplateSummary {
	s.PolicySchema = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *TemplateSummary) SetRevision(v *TemplateRevision) *TemplateSummary {
	s.Revision = v
	return s
}

// SetStatus sets the Status field's value.
func (s *TemplateSummary) SetStatus(v string) *TemplateSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *TemplateSummary) SetUpdatedAt(v time.Time) *TemplateSummary {
	s.UpdatedAt = &v
	return s
}

// v2 template schema that uses Legacy Cryptographic Providers.
type TemplateV2 struct {
	_ struct{} `type:"structure"`

	// Certificate validity describes the validity and renewal periods of a certificate.
	//
	// CertificateValidity is a required field
	CertificateValidity *CertificateValidity `type:"structure" required:"true"`

	// Enrollment flags describe the enrollment settings for certificates such as
	// using the existing private key and deleting expired or revoked certificates.
	//
	// EnrollmentFlags is a required field
	EnrollmentFlags *EnrollmentFlagsV2 `type:"structure" required:"true"`

	// Extensions describe the key usage extensions and application policies for
	// a template.
	//
	// Extensions is a required field
	Extensions *ExtensionsV2 `type:"structure" required:"true"`

	// General flags describe whether the template is used for computers or users
	// and if the template can be used with autoenrollment.
	//
	// GeneralFlags is a required field
	GeneralFlags *GeneralFlagsV2 `type:"structure" required:"true"`

	// Private key attributes allow you to specify the minimal key length, key spec,
	// and cryptographic providers for the private key of a certificate for v2 templates.
	// V2 templates allow you to use Legacy Cryptographic Service Providers.
	//
	// PrivateKeyAttributes is a required field
	PrivateKeyAttributes *PrivateKeyAttributesV2 `type:"structure" required:"true"`

	// Private key flags for v2 templates specify the client compatibility, if the
	// private key can be exported, and if user input is required when using a private
	// key.
	//
	// PrivateKeyFlags is a required field
	PrivateKeyFlags *PrivateKeyFlagsV2 `type:"structure" required:"true"`

	// Subject name flags describe the subject name and subject alternate name that
	// is included in a certificate.
	//
	// SubjectNameFlags is a required field
	SubjectNameFlags *SubjectNameFlagsV2 `type:"structure" required:"true"`

	// List of templates in Active Directory that are superseded by this template.
	SupersededTemplates []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateV2) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateV2) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TemplateV2) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TemplateV2"}
	if s.CertificateValidity == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateValidity"))
	}
	if s.EnrollmentFlags == nil {
		invalidParams.Add(request.NewErrParamRequired("EnrollmentFlags"))
	}
	if s.Extensions == nil {
		invalidParams.Add(request.NewErrParamRequired("Extensions"))
	}
	if s.GeneralFlags == nil {
		invalidParams.Add(request.NewErrParamRequired("GeneralFlags"))
	}
	if s.PrivateKeyAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivateKeyAttributes"))
	}
	if s.PrivateKeyFlags == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivateKeyFlags"))
	}
	if s.SubjectNameFlags == nil {
		invalidParams.Add(request.NewErrParamRequired("SubjectNameFlags"))
	}
	if s.SupersededTemplates != nil && len(s.SupersededTemplates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SupersededTemplates", 1))
	}
	if s.CertificateValidity != nil {
		if err := s.CertificateValidity.Validate(); err != nil {
			invalidParams.AddNested("CertificateValidity", err.(request.ErrInvalidParams))
		}
	}
	if s.Extensions != nil {
		if err := s.Extensions.Validate(); err != nil {
			invalidParams.AddNested("Extensions", err.(request.ErrInvalidParams))
		}
	}
	if s.PrivateKeyAttributes != nil {
		if err := s.PrivateKeyAttributes.Validate(); err != nil {
			invalidParams.AddNested("PrivateKeyAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.PrivateKeyFlags != nil {
		if err := s.PrivateKeyFlags.Validate(); err != nil {
			invalidParams.AddNested("PrivateKeyFlags", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateValidity sets the CertificateValidity field's value.
func (s *TemplateV2) SetCertificateValidity(v *CertificateValidity) *TemplateV2 {
	s.CertificateValidity = v
	return s
}

// SetEnrollmentFlags sets the EnrollmentFlags field's value.
func (s *TemplateV2) SetEnrollmentFlags(v *EnrollmentFlagsV2) *TemplateV2 {
	s.EnrollmentFlags = v
	return s
}

// SetExtensions sets the Extensions field's value.
func (s *TemplateV2) SetExtensions(v *ExtensionsV2) *TemplateV2 {
	s.Extensions = v
	return s
}

// SetGeneralFlags sets the GeneralFlags field's value.
func (s *TemplateV2) SetGeneralFlags(v *GeneralFlagsV2) *TemplateV2 {
	s.GeneralFlags = v
	return s
}

// SetPrivateKeyAttributes sets the PrivateKeyAttributes field's value.
func (s *TemplateV2) SetPrivateKeyAttributes(v *PrivateKeyAttributesV2) *TemplateV2 {
	s.PrivateKeyAttributes = v
	return s
}

// SetPrivateKeyFlags sets the PrivateKeyFlags field's value.
func (s *TemplateV2) SetPrivateKeyFlags(v *PrivateKeyFlagsV2) *TemplateV2 {
	s.PrivateKeyFlags = v
	return s
}

// SetSubjectNameFlags sets the SubjectNameFlags field's value.
func (s *TemplateV2) SetSubjectNameFlags(v *SubjectNameFlagsV2) *TemplateV2 {
	s.SubjectNameFlags = v
	return s
}

// SetSupersededTemplates sets the SupersededTemplates field's value.
func (s *TemplateV2) SetSupersededTemplates(v []*string) *TemplateV2 {
	s.SupersededTemplates = v
	return s
}

// v3 template schema that uses Key Storage Providers.
type TemplateV3 struct {
	_ struct{} `type:"structure"`

	// Certificate validity describes the validity and renewal periods of a certificate.
	//
	// CertificateValidity is a required field
	CertificateValidity *CertificateValidity `type:"structure" required:"true"`

	// Enrollment flags describe the enrollment settings for certificates such as
	// using the existing private key and deleting expired or revoked certificates.
	//
	// EnrollmentFlags is a required field
	EnrollmentFlags *EnrollmentFlagsV3 `type:"structure" required:"true"`

	// Extensions describe the key usage extensions and application policies for
	// a template.
	//
	// Extensions is a required field
	Extensions *ExtensionsV3 `type:"structure" required:"true"`

	// General flags describe whether the template is used for computers or users
	// and if the template can be used with autoenrollment.
	//
	// GeneralFlags is a required field
	GeneralFlags *GeneralFlagsV3 `type:"structure" required:"true"`

	// Specifies the hash algorithm used to hash the private key.
	//
	// HashAlgorithm is a required field
	HashAlgorithm *string `type:"string" required:"true" enum:"HashAlgorithm"`

	// Private key attributes allow you to specify the algorithm, minimal key length,
	// key spec, key usage, and cryptographic providers for the private key of a
	// certificate for v3 templates. V3 templates allow you to use Key Storage Providers.
	//
	// PrivateKeyAttributes is a required field
	PrivateKeyAttributes *PrivateKeyAttributesV3 `type:"structure" required:"true"`

	// Private key flags for v3 templates specify the client compatibility, if the
	// private key can be exported, if user input is required when using a private
	// key, and if an alternate signature algorithm should be used.
	//
	// PrivateKeyFlags is a required field
	PrivateKeyFlags *PrivateKeyFlagsV3 `type:"structure" required:"true"`

	// Subject name flags describe the subject name and subject alternate name that
	// is included in a certificate.
	//
	// SubjectNameFlags is a required field
	SubjectNameFlags *SubjectNameFlagsV3 `type:"structure" required:"true"`

	// List of templates in Active Directory that are superseded by this template.
	SupersededTemplates []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateV3) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateV3) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TemplateV3) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TemplateV3"}
	if s.CertificateValidity == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateValidity"))
	}
	if s.EnrollmentFlags == nil {
		invalidParams.Add(request.NewErrParamRequired("EnrollmentFlags"))
	}
	if s.Extensions == nil {
		invalidParams.Add(request.NewErrParamRequired("Extensions"))
	}
	if s.GeneralFlags == nil {
		invalidParams.Add(request.NewErrParamRequired("GeneralFlags"))
	}
	if s.HashAlgorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("HashAlgorithm"))
	}
	if s.PrivateKeyAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivateKeyAttributes"))
	}
	if s.PrivateKeyFlags == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivateKeyFlags"))
	}
	if s.SubjectNameFlags == nil {
		invalidParams.Add(request.NewErrParamRequired("SubjectNameFlags"))
	}
	if s.SupersededTemplates != nil && len(s.SupersededTemplates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SupersededTemplates", 1))
	}
	if s.CertificateValidity != nil {
		if err := s.CertificateValidity.Validate(); err != nil {
			invalidParams.AddNested("CertificateValidity", err.(request.ErrInvalidParams))
		}
	}
	if s.Extensions != nil {
		if err := s.Extensions.Validate(); err != nil {
			invalidParams.AddNested("Extensions", err.(request.ErrInvalidParams))
		}
	}
	if s.PrivateKeyAttributes != nil {
		if err := s.PrivateKeyAttributes.Validate(); err != nil {
			invalidParams.AddNested("PrivateKeyAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.PrivateKeyFlags != nil {
		if err := s.PrivateKeyFlags.Validate(); err != nil {
			invalidParams.AddNested("PrivateKeyFlags", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateValidity sets the CertificateValidity field's value.
func (s *TemplateV3) SetCertificateValidity(v *CertificateValidity) *TemplateV3 {
	s.CertificateValidity = v
	return s
}

// SetEnrollmentFlags sets the EnrollmentFlags field's value.
func (s *TemplateV3) SetEnrollmentFlags(v *EnrollmentFlagsV3) *TemplateV3 {
	s.EnrollmentFlags = v
	return s
}

// SetExtensions sets the Extensions field's value.
func (s *TemplateV3) SetExtensions(v *ExtensionsV3) *TemplateV3 {
	s.Extensions = v
	return s
}

// SetGeneralFlags sets the GeneralFlags field's value.
func (s *TemplateV3) SetGeneralFlags(v *GeneralFlagsV3) *TemplateV3 {
	s.GeneralFlags = v
	return s
}

// SetHashAlgorithm sets the HashAlgorithm field's value.
func (s *TemplateV3) SetHashAlgorithm(v string) *TemplateV3 {
	s.HashAlgorithm = &v
	return s
}

// SetPrivateKeyAttributes sets the PrivateKeyAttributes field's value.
func (s *TemplateV3) SetPrivateKeyAttributes(v *PrivateKeyAttributesV3) *TemplateV3 {
	s.PrivateKeyAttributes = v
	return s
}

// SetPrivateKeyFlags sets the PrivateKeyFlags field's value.
func (s *TemplateV3) SetPrivateKeyFlags(v *PrivateKeyFlagsV3) *TemplateV3 {
	s.PrivateKeyFlags = v
	return s
}

// SetSubjectNameFlags sets the SubjectNameFlags field's value.
func (s *TemplateV3) SetSubjectNameFlags(v *SubjectNameFlagsV3) *TemplateV3 {
	s.SubjectNameFlags = v
	return s
}

// SetSupersededTemplates sets the SupersededTemplates field's value.
func (s *TemplateV3) SetSupersededTemplates(v []*string) *TemplateV3 {
	s.SupersededTemplates = v
	return s
}

// v4 template schema that can use either Legacy Cryptographic Providers or
// Key Storage Providers.
type TemplateV4 struct {
	_ struct{} `type:"structure"`

	// Certificate validity describes the validity and renewal periods of a certificate.
	//
	// CertificateValidity is a required field
	CertificateValidity *CertificateValidity `type:"structure" required:"true"`

	// Enrollment flags describe the enrollment settings for certificates using
	// the existing private key and deleting expired or revoked certificates.
	//
	// EnrollmentFlags is a required field
	EnrollmentFlags *EnrollmentFlagsV4 `type:"structure" required:"true"`

	// Extensions describe the key usage extensions and application policies for
	// a template.
	//
	// Extensions is a required field
	Extensions *ExtensionsV4 `type:"structure" required:"true"`

	// General flags describe whether the template is used for computers or users
	// and if the template can be used with autoenrollment.
	//
	// GeneralFlags is a required field
	GeneralFlags *GeneralFlagsV4 `type:"structure" required:"true"`

	// Specifies the hash algorithm used to hash the private key. Hash algorithm
	// can only be specified when using Key Storage Providers.
	HashAlgorithm *string `type:"string" enum:"HashAlgorithm"`

	// Private key attributes allow you to specify the minimal key length, key spec,
	// key usage, and cryptographic providers for the private key of a certificate
	// for v4 templates. V4 templates allow you to use either Key Storage Providers
	// or Legacy Cryptographic Service Providers. You specify the cryptography provider
	// category in private key flags.
	//
	// PrivateKeyAttributes is a required field
	PrivateKeyAttributes *PrivateKeyAttributesV4 `type:"structure" required:"true"`

	// Private key flags for v4 templates specify the client compatibility, if the
	// private key can be exported, if user input is required when using a private
	// key, if an alternate signature algorithm should be used, and if certificates
	// are renewed using the same private key.
	//
	// PrivateKeyFlags is a required field
	PrivateKeyFlags *PrivateKeyFlagsV4 `type:"structure" required:"true"`

	// Subject name flags describe the subject name and subject alternate name that
	// is included in a certificate.
	//
	// SubjectNameFlags is a required field
	SubjectNameFlags *SubjectNameFlagsV4 `type:"structure" required:"true"`

	// List of templates in Active Directory that are superseded by this template.
	SupersededTemplates []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateV4) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateV4) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TemplateV4) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TemplateV4"}
	if s.CertificateValidity == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateValidity"))
	}
	if s.EnrollmentFlags == nil {
		invalidParams.Add(request.NewErrParamRequired("EnrollmentFlags"))
	}
	if s.Extensions == nil {
		invalidParams.Add(request.NewErrParamRequired("Extensions"))
	}
	if s.GeneralFlags == nil {
		invalidParams.Add(request.NewErrParamRequired("GeneralFlags"))
	}
	if s.PrivateKeyAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivateKeyAttributes"))
	}
	if s.PrivateKeyFlags == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivateKeyFlags"))
	}
	if s.SubjectNameFlags == nil {
		invalidParams.Add(request.NewErrParamRequired("SubjectNameFlags"))
	}
	if s.SupersededTemplates != nil && len(s.SupersededTemplates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SupersededTemplates", 1))
	}
	if s.CertificateValidity != nil {
		if err := s.CertificateValidity.Validate(); err != nil {
			invalidParams.AddNested("CertificateValidity", err.(request.ErrInvalidParams))
		}
	}
	if s.Extensions != nil {
		if err := s.Extensions.Validate(); err != nil {
			invalidParams.AddNested("Extensions", err.(request.ErrInvalidParams))
		}
	}
	if s.PrivateKeyAttributes != nil {
		if err := s.PrivateKeyAttributes.Validate(); err != nil {
			invalidParams.AddNested("PrivateKeyAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.PrivateKeyFlags != nil {
		if err := s.PrivateKeyFlags.Validate(); err != nil {
			invalidParams.AddNested("PrivateKeyFlags", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateValidity sets the CertificateValidity field's value.
func (s *TemplateV4) SetCertificateValidity(v *CertificateValidity) *TemplateV4 {
	s.CertificateValidity = v
	return s
}

// SetEnrollmentFlags sets the EnrollmentFlags field's value.
func (s *TemplateV4) SetEnrollmentFlags(v *EnrollmentFlagsV4) *TemplateV4 {
	s.EnrollmentFlags = v
	return s
}

// SetExtensions sets the Extensions field's value.
func (s *TemplateV4) SetExtensions(v *ExtensionsV4) *TemplateV4 {
	s.Extensions = v
	return s
}

// SetGeneralFlags sets the GeneralFlags field's value.
func (s *TemplateV4) SetGeneralFlags(v *GeneralFlagsV4) *TemplateV4 {
	s.GeneralFlags = v
	return s
}

// SetHashAlgorithm sets the HashAlgorithm field's value.
func (s *TemplateV4) SetHashAlgorithm(v string) *TemplateV4 {
	s.HashAlgorithm = &v
	return s
}

// SetPrivateKeyAttributes sets the PrivateKeyAttributes field's value.
func (s *TemplateV4) SetPrivateKeyAttributes(v *PrivateKeyAttributesV4) *TemplateV4 {
	s.PrivateKeyAttributes = v
	return s
}

// SetPrivateKeyFlags sets the PrivateKeyFlags field's value.
func (s *TemplateV4) SetPrivateKeyFlags(v *PrivateKeyFlagsV4) *TemplateV4 {
	s.PrivateKeyFlags = v
	return s
}

// SetSubjectNameFlags sets the SubjectNameFlags field's value.
func (s *TemplateV4) SetSubjectNameFlags(v *SubjectNameFlagsV4) *TemplateV4 {
	s.SubjectNameFlags = v
	return s
}

// SetSupersededTemplates sets the SupersededTemplates field's value.
func (s *TemplateV4) SetSupersededTemplates(v []*string) *TemplateV4 {
	s.SupersededTemplates = v
	return s
}

// The limit on the number of requests per second was exceeded.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The code associated with the quota.
	QuotaCode *string `type:"string"`

	// Identifies the originating service.
	ServiceCode *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) that was returned when you created the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// Specifies a list of tag keys that you want to remove from the specified resources.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateTemplateGroupAccessControlEntryInput struct {
	_ struct{} `type:"structure"`

	// Allow or deny permissions for an Active Directory group to enroll or autoenroll
	// certificates for a template.
	AccessRights *AccessRights `type:"structure"`

	// Name of the Active Directory group. This name does not need to match the
	// group name in Active Directory.
	GroupDisplayName *string `type:"string"`

	// Security identifier (SID) of the group object from Active Directory. The
	// SID starts with "S-".
	//
	// GroupSecurityIdentifier is a required field
	GroupSecurityIdentifier *string `location:"uri" locationName:"GroupSecurityIdentifier" min:"7" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateTemplate
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html).
	//
	// TemplateArn is a required field
	TemplateArn *string `location:"uri" locationName:"TemplateArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateGroupAccessControlEntryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateGroupAccessControlEntryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTemplateGroupAccessControlEntryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTemplateGroupAccessControlEntryInput"}
	if s.GroupSecurityIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupSecurityIdentifier"))
	}
	if s.GroupSecurityIdentifier != nil && len(*s.GroupSecurityIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("GroupSecurityIdentifier", 7))
	}
	if s.TemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateArn"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessRights sets the AccessRights field's value.
func (s *UpdateTemplateGroupAccessControlEntryInput) SetAccessRights(v *AccessRights) *UpdateTemplateGroupAccessControlEntryInput {
	s.AccessRights = v
	return s
}

// SetGroupDisplayName sets the GroupDisplayName field's value.
func (s *UpdateTemplateGroupAccessControlEntryInput) SetGroupDisplayName(v string) *UpdateTemplateGroupAccessControlEntryInput {
	s.GroupDisplayName = &v
	return s
}

// SetGroupSecurityIdentifier sets the GroupSecurityIdentifier field's value.
func (s *UpdateTemplateGroupAccessControlEntryInput) SetGroupSecurityIdentifier(v string) *UpdateTemplateGroupAccessControlEntryInput {
	s.GroupSecurityIdentifier = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *UpdateTemplateGroupAccessControlEntryInput) SetTemplateArn(v string) *UpdateTemplateGroupAccessControlEntryInput {
	s.TemplateArn = &v
	return s
}

type UpdateTemplateGroupAccessControlEntryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateGroupAccessControlEntryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateGroupAccessControlEntryOutput) GoString() string {
	return s.String()
}

type UpdateTemplateInput struct {
	_ struct{} `type:"structure"`

	// Template configuration to define the information included in certificates.
	// Define certificate validity and renewal periods, certificate request handling
	// and enrollment options, key usage extensions, application policies, and cryptography
	// settings.
	Definition *TemplateDefinition `type:"structure"`

	// This setting allows the major version of a template to be increased automatically.
	// All members of Active Directory groups that are allowed to enroll with a
	// template will receive a new certificate issued using that template.
	ReenrollAllCertificateHolders *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateTemplate
	// (https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html).
	//
	// TemplateArn is a required field
	TemplateArn *string `location:"uri" locationName:"TemplateArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTemplateInput"}
	if s.TemplateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateArn"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 5))
	}
	if s.Definition != nil {
		if err := s.Definition.Validate(); err != nil {
			invalidParams.AddNested("Definition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefinition sets the Definition field's value.
func (s *UpdateTemplateInput) SetDefinition(v *TemplateDefinition) *UpdateTemplateInput {
	s.Definition = v
	return s
}

// SetReenrollAllCertificateHolders sets the ReenrollAllCertificateHolders field's value.
func (s *UpdateTemplateInput) SetReenrollAllCertificateHolders(v bool) *UpdateTemplateInput {
	s.ReenrollAllCertificateHolders = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *UpdateTemplateInput) SetTemplateArn(v string) *UpdateTemplateInput {
	s.TemplateArn = &v
	return s
}

type UpdateTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateOutput) GoString() string {
	return s.String()
}

// An input validation error occurred. For example, invalid characters in a
// template name, or if a pagination token is invalid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The reason for the validation error. This won't be return for every validation
	// exception.
	Reason *string `type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information describing the end of the validity period of the certificate.
// This parameter sets the “Not After” date for the certificate. Certificate
// validity is the period of time during which a certificate is valid. Validity
// can be expressed as an explicit date and time when the certificate expires,
// or as a span of time after issuance, stated in hours, days, months, or years.
// For more information, see Validity in RFC 5280. This value is unaffected
// when ValidityNotBefore is also specified. For example, if Validity is set
// to 20 days in the future, the certificate will expire 20 days from issuance
// time regardless of the ValidityNotBefore value.
type ValidityPeriod struct {
	_ struct{} `type:"structure"`

	// The numeric value for the validity period.
	//
	// Period is a required field
	Period *int64 `min:"1" type:"long" required:"true"`

	// The unit of time. You can select hours, days, weeks, months, and years.
	//
	// PeriodType is a required field
	PeriodType *string `type:"string" required:"true" enum:"ValidityPeriodType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidityPeriod) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidityPeriod) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidityPeriod) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ValidityPeriod"}
	if s.Period == nil {
		invalidParams.Add(request.NewErrParamRequired("Period"))
	}
	if s.Period != nil && *s.Period < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 1))
	}
	if s.PeriodType == nil {
		invalidParams.Add(request.NewErrParamRequired("PeriodType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPeriod sets the Period field's value.
func (s *ValidityPeriod) SetPeriod(v int64) *ValidityPeriod {
	s.Period = &v
	return s
}

// SetPeriodType sets the PeriodType field's value.
func (s *ValidityPeriod) SetPeriodType(v string) *ValidityPeriod {
	s.PeriodType = &v
	return s
}

// Information about your VPC and security groups used with the connector.
type VpcInformation struct {
	_ struct{} `type:"structure"`

	// The security groups used with the connector. You can use a maximum of 4 security
	// groups with a connector.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcInformation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcInformation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VpcInformation"}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcInformation) SetSecurityGroupIds(v []*string) *VpcInformation {
	s.SecurityGroupIds = v
	return s
}

const (
	// AccessRightAllow is a AccessRight enum value
	AccessRightAllow = "ALLOW"

	// AccessRightDeny is a AccessRight enum value
	AccessRightDeny = "DENY"
)

// AccessRight_Values returns all elements of the AccessRight enum
func AccessRight_Values() []string {
	return []string{
		AccessRightAllow,
		AccessRightDeny,
	}
}

const (
	// ApplicationPolicyTypeAllApplicationPolicies is a ApplicationPolicyType enum value
	ApplicationPolicyTypeAllApplicationPolicies = "ALL_APPLICATION_POLICIES"

	// ApplicationPolicyTypeAnyPurpose is a ApplicationPolicyType enum value
	ApplicationPolicyTypeAnyPurpose = "ANY_PURPOSE"

	// ApplicationPolicyTypeAttestationIdentityKeyCertificate is a ApplicationPolicyType enum value
	ApplicationPolicyTypeAttestationIdentityKeyCertificate = "ATTESTATION_IDENTITY_KEY_CERTIFICATE"

	// ApplicationPolicyTypeCertificateRequestAgent is a ApplicationPolicyType enum value
	ApplicationPolicyTypeCertificateRequestAgent = "CERTIFICATE_REQUEST_AGENT"

	// ApplicationPolicyTypeClientAuthentication is a ApplicationPolicyType enum value
	ApplicationPolicyTypeClientAuthentication = "CLIENT_AUTHENTICATION"

	// ApplicationPolicyTypeCodeSigning is a ApplicationPolicyType enum value
	ApplicationPolicyTypeCodeSigning = "CODE_SIGNING"

	// ApplicationPolicyTypeCtlUsage is a ApplicationPolicyType enum value
	ApplicationPolicyTypeCtlUsage = "CTL_USAGE"

	// ApplicationPolicyTypeDigitalRights is a ApplicationPolicyType enum value
	ApplicationPolicyTypeDigitalRights = "DIGITAL_RIGHTS"

	// ApplicationPolicyTypeDirectoryServiceEmailReplication is a ApplicationPolicyType enum value
	ApplicationPolicyTypeDirectoryServiceEmailReplication = "DIRECTORY_SERVICE_EMAIL_REPLICATION"

	// ApplicationPolicyTypeDisallowedList is a ApplicationPolicyType enum value
	ApplicationPolicyTypeDisallowedList = "DISALLOWED_LIST"

	// ApplicationPolicyTypeDnsServerTrust is a ApplicationPolicyType enum value
	ApplicationPolicyTypeDnsServerTrust = "DNS_SERVER_TRUST"

	// ApplicationPolicyTypeDocumentEncryption is a ApplicationPolicyType enum value
	ApplicationPolicyTypeDocumentEncryption = "DOCUMENT_ENCRYPTION"

	// ApplicationPolicyTypeDocumentSigning is a ApplicationPolicyType enum value
	ApplicationPolicyTypeDocumentSigning = "DOCUMENT_SIGNING"

	// ApplicationPolicyTypeDynamicCodeGenerator is a ApplicationPolicyType enum value
	ApplicationPolicyTypeDynamicCodeGenerator = "DYNAMIC_CODE_GENERATOR"

	// ApplicationPolicyTypeEarlyLaunchAntimalwareDriver is a ApplicationPolicyType enum value
	ApplicationPolicyTypeEarlyLaunchAntimalwareDriver = "EARLY_LAUNCH_ANTIMALWARE_DRIVER"

	// ApplicationPolicyTypeEmbeddedWindowsSystemComponentVerification is a ApplicationPolicyType enum value
	ApplicationPolicyTypeEmbeddedWindowsSystemComponentVerification = "EMBEDDED_WINDOWS_SYSTEM_COMPONENT_VERIFICATION"

	// ApplicationPolicyTypeEnclave is a ApplicationPolicyType enum value
	ApplicationPolicyTypeEnclave = "ENCLAVE"

	// ApplicationPolicyTypeEncryptingFileSystem is a ApplicationPolicyType enum value
	ApplicationPolicyTypeEncryptingFileSystem = "ENCRYPTING_FILE_SYSTEM"

	// ApplicationPolicyTypeEndorsementKeyCertificate is a ApplicationPolicyType enum value
	ApplicationPolicyTypeEndorsementKeyCertificate = "ENDORSEMENT_KEY_CERTIFICATE"

	// ApplicationPolicyTypeFileRecovery is a ApplicationPolicyType enum value
	ApplicationPolicyTypeFileRecovery = "FILE_RECOVERY"

	// ApplicationPolicyTypeHalExtension is a ApplicationPolicyType enum value
	ApplicationPolicyTypeHalExtension = "HAL_EXTENSION"

	// ApplicationPolicyTypeIpSecurityEndSystem is a ApplicationPolicyType enum value
	ApplicationPolicyTypeIpSecurityEndSystem = "IP_SECURITY_END_SYSTEM"

	// ApplicationPolicyTypeIpSecurityIkeIntermediate is a ApplicationPolicyType enum value
	ApplicationPolicyTypeIpSecurityIkeIntermediate = "IP_SECURITY_IKE_INTERMEDIATE"

	// ApplicationPolicyTypeIpSecurityTunnelTermination is a ApplicationPolicyType enum value
	ApplicationPolicyTypeIpSecurityTunnelTermination = "IP_SECURITY_TUNNEL_TERMINATION"

	// ApplicationPolicyTypeIpSecurityUser is a ApplicationPolicyType enum value
	ApplicationPolicyTypeIpSecurityUser = "IP_SECURITY_USER"

	// ApplicationPolicyTypeIsolatedUserMode is a ApplicationPolicyType enum value
	ApplicationPolicyTypeIsolatedUserMode = "ISOLATED_USER_MODE"

	// ApplicationPolicyTypeKdcAuthentication is a ApplicationPolicyType enum value
	ApplicationPolicyTypeKdcAuthentication = "KDC_AUTHENTICATION"

	// ApplicationPolicyTypeKernelModeCodeSigning is a ApplicationPolicyType enum value
	ApplicationPolicyTypeKernelModeCodeSigning = "KERNEL_MODE_CODE_SIGNING"

	// ApplicationPolicyTypeKeyPackLicenses is a ApplicationPolicyType enum value
	ApplicationPolicyTypeKeyPackLicenses = "KEY_PACK_LICENSES"

	// ApplicationPolicyTypeKeyRecovery is a ApplicationPolicyType enum value
	ApplicationPolicyTypeKeyRecovery = "KEY_RECOVERY"

	// ApplicationPolicyTypeKeyRecoveryAgent is a ApplicationPolicyType enum value
	ApplicationPolicyTypeKeyRecoveryAgent = "KEY_RECOVERY_AGENT"

	// ApplicationPolicyTypeLicenseServerVerification is a ApplicationPolicyType enum value
	ApplicationPolicyTypeLicenseServerVerification = "LICENSE_SERVER_VERIFICATION"

	// ApplicationPolicyTypeLifetimeSigning is a ApplicationPolicyType enum value
	ApplicationPolicyTypeLifetimeSigning = "LIFETIME_SIGNING"

	// ApplicationPolicyTypeMicrosoftPublisher is a ApplicationPolicyType enum value
	ApplicationPolicyTypeMicrosoftPublisher = "MICROSOFT_PUBLISHER"

	// ApplicationPolicyTypeMicrosoftTimeStamping is a ApplicationPolicyType enum value
	ApplicationPolicyTypeMicrosoftTimeStamping = "MICROSOFT_TIME_STAMPING"

	// ApplicationPolicyTypeMicrosoftTrustListSigning is a ApplicationPolicyType enum value
	ApplicationPolicyTypeMicrosoftTrustListSigning = "MICROSOFT_TRUST_LIST_SIGNING"

	// ApplicationPolicyTypeOcspSigning is a ApplicationPolicyType enum value
	ApplicationPolicyTypeOcspSigning = "OCSP_SIGNING"

	// ApplicationPolicyTypeOemWindowsSystemComponentVerification is a ApplicationPolicyType enum value
	ApplicationPolicyTypeOemWindowsSystemComponentVerification = "OEM_WINDOWS_SYSTEM_COMPONENT_VERIFICATION"

	// ApplicationPolicyTypePlatformCertificate is a ApplicationPolicyType enum value
	ApplicationPolicyTypePlatformCertificate = "PLATFORM_CERTIFICATE"

	// ApplicationPolicyTypePreviewBuildSigning is a ApplicationPolicyType enum value
	ApplicationPolicyTypePreviewBuildSigning = "PREVIEW_BUILD_SIGNING"

	// ApplicationPolicyTypePrivateKeyArchival is a ApplicationPolicyType enum value
	ApplicationPolicyTypePrivateKeyArchival = "PRIVATE_KEY_ARCHIVAL"

	// ApplicationPolicyTypeProtectedProcessLightVerification is a ApplicationPolicyType enum value
	ApplicationPolicyTypeProtectedProcessLightVerification = "PROTECTED_PROCESS_LIGHT_VERIFICATION"

	// ApplicationPolicyTypeProtectedProcessVerification is a ApplicationPolicyType enum value
	ApplicationPolicyTypeProtectedProcessVerification = "PROTECTED_PROCESS_VERIFICATION"

	// ApplicationPolicyTypeQualifiedSubordination is a ApplicationPolicyType enum value
	ApplicationPolicyTypeQualifiedSubordination = "QUALIFIED_SUBORDINATION"

	// ApplicationPolicyTypeRevokedListSigner is a ApplicationPolicyType enum value
	ApplicationPolicyTypeRevokedListSigner = "REVOKED_LIST_SIGNER"

	// ApplicationPolicyTypeRootProgramAutoUpdateCaRevocation is a ApplicationPolicyType enum value
	ApplicationPolicyTypeRootProgramAutoUpdateCaRevocation = "ROOT_PROGRAM_AUTO_UPDATE_CA_REVOCATION"

	// ApplicationPolicyTypeRootProgramAutoUpdateEndRevocation is a ApplicationPolicyType enum value
	ApplicationPolicyTypeRootProgramAutoUpdateEndRevocation = "ROOT_PROGRAM_AUTO_UPDATE_END_REVOCATION"

	// ApplicationPolicyTypeRootProgramNoOscpFailoverToCrl is a ApplicationPolicyType enum value
	ApplicationPolicyTypeRootProgramNoOscpFailoverToCrl = "ROOT_PROGRAM_NO_OSCP_FAILOVER_TO_CRL"

	// ApplicationPolicyTypeRootListSigner is a ApplicationPolicyType enum value
	ApplicationPolicyTypeRootListSigner = "ROOT_LIST_SIGNER"

	// ApplicationPolicyTypeSecureEmail is a ApplicationPolicyType enum value
	ApplicationPolicyTypeSecureEmail = "SECURE_EMAIL"

	// ApplicationPolicyTypeServerAuthentication is a ApplicationPolicyType enum value
	ApplicationPolicyTypeServerAuthentication = "SERVER_AUTHENTICATION"

	// ApplicationPolicyTypeSmartCardLogin is a ApplicationPolicyType enum value
	ApplicationPolicyTypeSmartCardLogin = "SMART_CARD_LOGIN"

	// ApplicationPolicyTypeSpcEncryptedDigestRetryCount is a ApplicationPolicyType enum value
	ApplicationPolicyTypeSpcEncryptedDigestRetryCount = "SPC_ENCRYPTED_DIGEST_RETRY_COUNT"

	// ApplicationPolicyTypeSpcRelaxedPeMarkerCheck is a ApplicationPolicyType enum value
	ApplicationPolicyTypeSpcRelaxedPeMarkerCheck = "SPC_RELAXED_PE_MARKER_CHECK"

	// ApplicationPolicyTypeTimeStamping is a ApplicationPolicyType enum value
	ApplicationPolicyTypeTimeStamping = "TIME_STAMPING"

	// ApplicationPolicyTypeWindowsHardwareDriverAttestedVerification is a ApplicationPolicyType enum value
	ApplicationPolicyTypeWindowsHardwareDriverAttestedVerification = "WINDOWS_HARDWARE_DRIVER_ATTESTED_VERIFICATION"

	// ApplicationPolicyTypeWindowsHardwareDriverExtendedVerification is a ApplicationPolicyType enum value
	ApplicationPolicyTypeWindowsHardwareDriverExtendedVerification = "WINDOWS_HARDWARE_DRIVER_EXTENDED_VERIFICATION"

	// ApplicationPolicyTypeWindowsHardwareDriverVerification is a ApplicationPolicyType enum value
	ApplicationPolicyTypeWindowsHardwareDriverVerification = "WINDOWS_HARDWARE_DRIVER_VERIFICATION"

	// ApplicationPolicyTypeWindowsHelloRecoveryKeyEncryption is a ApplicationPolicyType enum value
	ApplicationPolicyTypeWindowsHelloRecoveryKeyEncryption = "WINDOWS_HELLO_RECOVERY_KEY_ENCRYPTION"

	// ApplicationPolicyTypeWindowsKitsComponent is a ApplicationPolicyType enum value
	ApplicationPolicyTypeWindowsKitsComponent = "WINDOWS_KITS_COMPONENT"

	// ApplicationPolicyTypeWindowsRtVerification is a ApplicationPolicyType enum value
	ApplicationPolicyTypeWindowsRtVerification = "WINDOWS_RT_VERIFICATION"

	// ApplicationPolicyTypeWindowsSoftwareExtensionVerification is a ApplicationPolicyType enum value
	ApplicationPolicyTypeWindowsSoftwareExtensionVerification = "WINDOWS_SOFTWARE_EXTENSION_VERIFICATION"

	// ApplicationPolicyTypeWindowsStore is a ApplicationPolicyType enum value
	ApplicationPolicyTypeWindowsStore = "WINDOWS_STORE"

	// ApplicationPolicyTypeWindowsSystemComponentVerification is a ApplicationPolicyType enum value
	ApplicationPolicyTypeWindowsSystemComponentVerification = "WINDOWS_SYSTEM_COMPONENT_VERIFICATION"

	// ApplicationPolicyTypeWindowsTcbComponent is a ApplicationPolicyType enum value
	ApplicationPolicyTypeWindowsTcbComponent = "WINDOWS_TCB_COMPONENT"

	// ApplicationPolicyTypeWindowsThirdPartyApplicationComponent is a ApplicationPolicyType enum value
	ApplicationPolicyTypeWindowsThirdPartyApplicationComponent = "WINDOWS_THIRD_PARTY_APPLICATION_COMPONENT"

	// ApplicationPolicyTypeWindowsUpdate is a ApplicationPolicyType enum value
	ApplicationPolicyTypeWindowsUpdate = "WINDOWS_UPDATE"
)

// ApplicationPolicyType_Values returns all elements of the ApplicationPolicyType enum
func ApplicationPolicyType_Values() []string {
	return []string{
		ApplicationPolicyTypeAllApplicationPolicies,
		ApplicationPolicyTypeAnyPurpose,
		ApplicationPolicyTypeAttestationIdentityKeyCertificate,
		ApplicationPolicyTypeCertificateRequestAgent,
		ApplicationPolicyTypeClientAuthentication,
		ApplicationPolicyTypeCodeSigning,
		ApplicationPolicyTypeCtlUsage,
		ApplicationPolicyTypeDigitalRights,
		ApplicationPolicyTypeDirectoryServiceEmailReplication,
		ApplicationPolicyTypeDisallowedList,
		ApplicationPolicyTypeDnsServerTrust,
		ApplicationPolicyTypeDocumentEncryption,
		ApplicationPolicyTypeDocumentSigning,
		ApplicationPolicyTypeDynamicCodeGenerator,
		ApplicationPolicyTypeEarlyLaunchAntimalwareDriver,
		ApplicationPolicyTypeEmbeddedWindowsSystemComponentVerification,
		ApplicationPolicyTypeEnclave,
		ApplicationPolicyTypeEncryptingFileSystem,
		ApplicationPolicyTypeEndorsementKeyCertificate,
		ApplicationPolicyTypeFileRecovery,
		ApplicationPolicyTypeHalExtension,
		ApplicationPolicyTypeIpSecurityEndSystem,
		ApplicationPolicyTypeIpSecurityIkeIntermediate,
		ApplicationPolicyTypeIpSecurityTunnelTermination,
		ApplicationPolicyTypeIpSecurityUser,
		ApplicationPolicyTypeIsolatedUserMode,
		ApplicationPolicyTypeKdcAuthentication,
		ApplicationPolicyTypeKernelModeCodeSigning,
		ApplicationPolicyTypeKeyPackLicenses,
		ApplicationPolicyTypeKeyRecovery,
		ApplicationPolicyTypeKeyRecoveryAgent,
		ApplicationPolicyTypeLicenseServerVerification,
		ApplicationPolicyTypeLifetimeSigning,
		ApplicationPolicyTypeMicrosoftPublisher,
		ApplicationPolicyTypeMicrosoftTimeStamping,
		ApplicationPolicyTypeMicrosoftTrustListSigning,
		ApplicationPolicyTypeOcspSigning,
		ApplicationPolicyTypeOemWindowsSystemComponentVerification,
		ApplicationPolicyTypePlatformCertificate,
		ApplicationPolicyTypePreviewBuildSigning,
		ApplicationPolicyTypePrivateKeyArchival,
		ApplicationPolicyTypeProtectedProcessLightVerification,
		ApplicationPolicyTypeProtectedProcessVerification,
		ApplicationPolicyTypeQualifiedSubordination,
		ApplicationPolicyTypeRevokedListSigner,
		ApplicationPolicyTypeRootProgramAutoUpdateCaRevocation,
		ApplicationPolicyTypeRootProgramAutoUpdateEndRevocation,
		ApplicationPolicyTypeRootProgramNoOscpFailoverToCrl,
		ApplicationPolicyTypeRootListSigner,
		ApplicationPolicyTypeSecureEmail,
		ApplicationPolicyTypeServerAuthentication,
		ApplicationPolicyTypeSmartCardLogin,
		ApplicationPolicyTypeSpcEncryptedDigestRetryCount,
		ApplicationPolicyTypeSpcRelaxedPeMarkerCheck,
		ApplicationPolicyTypeTimeStamping,
		ApplicationPolicyTypeWindowsHardwareDriverAttestedVerification,
		ApplicationPolicyTypeWindowsHardwareDriverExtendedVerification,
		ApplicationPolicyTypeWindowsHardwareDriverVerification,
		ApplicationPolicyTypeWindowsHelloRecoveryKeyEncryption,
		ApplicationPolicyTypeWindowsKitsComponent,
		ApplicationPolicyTypeWindowsRtVerification,
		ApplicationPolicyTypeWindowsSoftwareExtensionVerification,
		ApplicationPolicyTypeWindowsStore,
		ApplicationPolicyTypeWindowsSystemComponentVerification,
		ApplicationPolicyTypeWindowsTcbComponent,
		ApplicationPolicyTypeWindowsThirdPartyApplicationComponent,
		ApplicationPolicyTypeWindowsUpdate,
	}
}

const (
	// ClientCompatibilityV2WindowsServer2003 is a ClientCompatibilityV2 enum value
	ClientCompatibilityV2WindowsServer2003 = "WINDOWS_SERVER_2003"

	// ClientCompatibilityV2WindowsServer2008 is a ClientCompatibilityV2 enum value
	ClientCompatibilityV2WindowsServer2008 = "WINDOWS_SERVER_2008"

	// ClientCompatibilityV2WindowsServer2008R2 is a ClientCompatibilityV2 enum value
	ClientCompatibilityV2WindowsServer2008R2 = "WINDOWS_SERVER_2008_R2"

	// ClientCompatibilityV2WindowsServer2012 is a ClientCompatibilityV2 enum value
	ClientCompatibilityV2WindowsServer2012 = "WINDOWS_SERVER_2012"

	// ClientCompatibilityV2WindowsServer2012R2 is a ClientCompatibilityV2 enum value
	ClientCompatibilityV2WindowsServer2012R2 = "WINDOWS_SERVER_2012_R2"

	// ClientCompatibilityV2WindowsServer2016 is a ClientCompatibilityV2 enum value
	ClientCompatibilityV2WindowsServer2016 = "WINDOWS_SERVER_2016"
)

// ClientCompatibilityV2_Values returns all elements of the ClientCompatibilityV2 enum
func ClientCompatibilityV2_Values() []string {
	return []string{
		ClientCompatibilityV2WindowsServer2003,
		ClientCompatibilityV2WindowsServer2008,
		ClientCompatibilityV2WindowsServer2008R2,
		ClientCompatibilityV2WindowsServer2012,
		ClientCompatibilityV2WindowsServer2012R2,
		ClientCompatibilityV2WindowsServer2016,
	}
}

const (
	// ClientCompatibilityV3WindowsServer2008 is a ClientCompatibilityV3 enum value
	ClientCompatibilityV3WindowsServer2008 = "WINDOWS_SERVER_2008"

	// ClientCompatibilityV3WindowsServer2008R2 is a ClientCompatibilityV3 enum value
	ClientCompatibilityV3WindowsServer2008R2 = "WINDOWS_SERVER_2008_R2"

	// ClientCompatibilityV3WindowsServer2012 is a ClientCompatibilityV3 enum value
	ClientCompatibilityV3WindowsServer2012 = "WINDOWS_SERVER_2012"

	// ClientCompatibilityV3WindowsServer2012R2 is a ClientCompatibilityV3 enum value
	ClientCompatibilityV3WindowsServer2012R2 = "WINDOWS_SERVER_2012_R2"

	// ClientCompatibilityV3WindowsServer2016 is a ClientCompatibilityV3 enum value
	ClientCompatibilityV3WindowsServer2016 = "WINDOWS_SERVER_2016"
)

// ClientCompatibilityV3_Values returns all elements of the ClientCompatibilityV3 enum
func ClientCompatibilityV3_Values() []string {
	return []string{
		ClientCompatibilityV3WindowsServer2008,
		ClientCompatibilityV3WindowsServer2008R2,
		ClientCompatibilityV3WindowsServer2012,
		ClientCompatibilityV3WindowsServer2012R2,
		ClientCompatibilityV3WindowsServer2016,
	}
}

const (
	// ClientCompatibilityV4WindowsServer2012 is a ClientCompatibilityV4 enum value
	ClientCompatibilityV4WindowsServer2012 = "WINDOWS_SERVER_2012"

	// ClientCompatibilityV4WindowsServer2012R2 is a ClientCompatibilityV4 enum value
	ClientCompatibilityV4WindowsServer2012R2 = "WINDOWS_SERVER_2012_R2"

	// ClientCompatibilityV4WindowsServer2016 is a ClientCompatibilityV4 enum value
	ClientCompatibilityV4WindowsServer2016 = "WINDOWS_SERVER_2016"
)

// ClientCompatibilityV4_Values returns all elements of the ClientCompatibilityV4 enum
func ClientCompatibilityV4_Values() []string {
	return []string{
		ClientCompatibilityV4WindowsServer2012,
		ClientCompatibilityV4WindowsServer2012R2,
		ClientCompatibilityV4WindowsServer2016,
	}
}

const (
	// ConnectorStatusCreating is a ConnectorStatus enum value
	ConnectorStatusCreating = "CREATING"

	// ConnectorStatusActive is a ConnectorStatus enum value
	ConnectorStatusActive = "ACTIVE"

	// ConnectorStatusDeleting is a ConnectorStatus enum value
	ConnectorStatusDeleting = "DELETING"

	// ConnectorStatusFailed is a ConnectorStatus enum value
	ConnectorStatusFailed = "FAILED"
)

// ConnectorStatus_Values returns all elements of the ConnectorStatus enum
func ConnectorStatus_Values() []string {
	return []string{
		ConnectorStatusCreating,
		ConnectorStatusActive,
		ConnectorStatusDeleting,
		ConnectorStatusFailed,
	}
}

const (
	// ConnectorStatusReasonDirectoryAccessDenied is a ConnectorStatusReason enum value
	ConnectorStatusReasonDirectoryAccessDenied = "DIRECTORY_ACCESS_DENIED"

	// ConnectorStatusReasonInternalFailure is a ConnectorStatusReason enum value
	ConnectorStatusReasonInternalFailure = "INTERNAL_FAILURE"

	// ConnectorStatusReasonPrivatecaAccessDenied is a ConnectorStatusReason enum value
	ConnectorStatusReasonPrivatecaAccessDenied = "PRIVATECA_ACCESS_DENIED"

	// ConnectorStatusReasonPrivatecaResourceNotFound is a ConnectorStatusReason enum value
	ConnectorStatusReasonPrivatecaResourceNotFound = "PRIVATECA_RESOURCE_NOT_FOUND"

	// ConnectorStatusReasonSecurityGroupNotInVpc is a ConnectorStatusReason enum value
	ConnectorStatusReasonSecurityGroupNotInVpc = "SECURITY_GROUP_NOT_IN_VPC"

	// ConnectorStatusReasonVpcAccessDenied is a ConnectorStatusReason enum value
	ConnectorStatusReasonVpcAccessDenied = "VPC_ACCESS_DENIED"

	// ConnectorStatusReasonVpcEndpointLimitExceeded is a ConnectorStatusReason enum value
	ConnectorStatusReasonVpcEndpointLimitExceeded = "VPC_ENDPOINT_LIMIT_EXCEEDED"

	// ConnectorStatusReasonVpcResourceNotFound is a ConnectorStatusReason enum value
	ConnectorStatusReasonVpcResourceNotFound = "VPC_RESOURCE_NOT_FOUND"
)

// ConnectorStatusReason_Values returns all elements of the ConnectorStatusReason enum
func ConnectorStatusReason_Values() []string {
	return []string{
		ConnectorStatusReasonDirectoryAccessDenied,
		ConnectorStatusReasonInternalFailure,
		ConnectorStatusReasonPrivatecaAccessDenied,
		ConnectorStatusReasonPrivatecaResourceNotFound,
		ConnectorStatusReasonSecurityGroupNotInVpc,
		ConnectorStatusReasonVpcAccessDenied,
		ConnectorStatusReasonVpcEndpointLimitExceeded,
		ConnectorStatusReasonVpcResourceNotFound,
	}
}

const (
	// DirectoryRegistrationStatusCreating is a DirectoryRegistrationStatus enum value
	DirectoryRegistrationStatusCreating = "CREATING"

	// DirectoryRegistrationStatusActive is a DirectoryRegistrationStatus enum value
	DirectoryRegistrationStatusActive = "ACTIVE"

	// DirectoryRegistrationStatusDeleting is a DirectoryRegistrationStatus enum value
	DirectoryRegistrationStatusDeleting = "DELETING"

	// DirectoryRegistrationStatusFailed is a DirectoryRegistrationStatus enum value
	DirectoryRegistrationStatusFailed = "FAILED"
)

// DirectoryRegistrationStatus_Values returns all elements of the DirectoryRegistrationStatus enum
func DirectoryRegistrationStatus_Values() []string {
	return []string{
		DirectoryRegistrationStatusCreating,
		DirectoryRegistrationStatusActive,
		DirectoryRegistrationStatusDeleting,
		DirectoryRegistrationStatusFailed,
	}
}

const (
	// DirectoryRegistrationStatusReasonDirectoryAccessDenied is a DirectoryRegistrationStatusReason enum value
	DirectoryRegistrationStatusReasonDirectoryAccessDenied = "DIRECTORY_ACCESS_DENIED"

	// DirectoryRegistrationStatusReasonDirectoryResourceNotFound is a DirectoryRegistrationStatusReason enum value
	DirectoryRegistrationStatusReasonDirectoryResourceNotFound = "DIRECTORY_RESOURCE_NOT_FOUND"

	// DirectoryRegistrationStatusReasonDirectoryNotActive is a DirectoryRegistrationStatusReason enum value
	DirectoryRegistrationStatusReasonDirectoryNotActive = "DIRECTORY_NOT_ACTIVE"

	// DirectoryRegistrationStatusReasonDirectoryNotReachable is a DirectoryRegistrationStatusReason enum value
	DirectoryRegistrationStatusReasonDirectoryNotReachable = "DIRECTORY_NOT_REACHABLE"

	// DirectoryRegistrationStatusReasonDirectoryTypeNotSupported is a DirectoryRegistrationStatusReason enum value
	DirectoryRegistrationStatusReasonDirectoryTypeNotSupported = "DIRECTORY_TYPE_NOT_SUPPORTED"

	// DirectoryRegistrationStatusReasonInternalFailure is a DirectoryRegistrationStatusReason enum value
	DirectoryRegistrationStatusReasonInternalFailure = "INTERNAL_FAILURE"
)

// DirectoryRegistrationStatusReason_Values returns all elements of the DirectoryRegistrationStatusReason enum
func DirectoryRegistrationStatusReason_Values() []string {
	return []string{
		DirectoryRegistrationStatusReasonDirectoryAccessDenied,
		DirectoryRegistrationStatusReasonDirectoryResourceNotFound,
		DirectoryRegistrationStatusReasonDirectoryNotActive,
		DirectoryRegistrationStatusReasonDirectoryNotReachable,
		DirectoryRegistrationStatusReasonDirectoryTypeNotSupported,
		DirectoryRegistrationStatusReasonInternalFailure,
	}
}

const (
	// HashAlgorithmSha256 is a HashAlgorithm enum value
	HashAlgorithmSha256 = "SHA256"

	// HashAlgorithmSha384 is a HashAlgorithm enum value
	HashAlgorithmSha384 = "SHA384"

	// HashAlgorithmSha512 is a HashAlgorithm enum value
	HashAlgorithmSha512 = "SHA512"
)

// HashAlgorithm_Values returns all elements of the HashAlgorithm enum
func HashAlgorithm_Values() []string {
	return []string{
		HashAlgorithmSha256,
		HashAlgorithmSha384,
		HashAlgorithmSha512,
	}
}

const (
	// KeySpecKeyExchange is a KeySpec enum value
	KeySpecKeyExchange = "KEY_EXCHANGE"

	// KeySpecSignature is a KeySpec enum value
	KeySpecSignature = "SIGNATURE"
)

// KeySpec_Values returns all elements of the KeySpec enum
func KeySpec_Values() []string {
	return []string{
		KeySpecKeyExchange,
		KeySpecSignature,
	}
}

const (
	// KeyUsagePropertyTypeAll is a KeyUsagePropertyType enum value
	KeyUsagePropertyTypeAll = "ALL"
)

// KeyUsagePropertyType_Values returns all elements of the KeyUsagePropertyType enum
func KeyUsagePropertyType_Values() []string {
	return []string{
		KeyUsagePropertyTypeAll,
	}
}

const (
	// PrivateKeyAlgorithmRsa is a PrivateKeyAlgorithm enum value
	PrivateKeyAlgorithmRsa = "RSA"

	// PrivateKeyAlgorithmEcdhP256 is a PrivateKeyAlgorithm enum value
	PrivateKeyAlgorithmEcdhP256 = "ECDH_P256"

	// PrivateKeyAlgorithmEcdhP384 is a PrivateKeyAlgorithm enum value
	PrivateKeyAlgorithmEcdhP384 = "ECDH_P384"

	// PrivateKeyAlgorithmEcdhP521 is a PrivateKeyAlgorithm enum value
	PrivateKeyAlgorithmEcdhP521 = "ECDH_P521"
)

// PrivateKeyAlgorithm_Values returns all elements of the PrivateKeyAlgorithm enum
func PrivateKeyAlgorithm_Values() []string {
	return []string{
		PrivateKeyAlgorithmRsa,
		PrivateKeyAlgorithmEcdhP256,
		PrivateKeyAlgorithmEcdhP384,
		PrivateKeyAlgorithmEcdhP521,
	}
}

const (
	// ServicePrincipalNameStatusCreating is a ServicePrincipalNameStatus enum value
	ServicePrincipalNameStatusCreating = "CREATING"

	// ServicePrincipalNameStatusActive is a ServicePrincipalNameStatus enum value
	ServicePrincipalNameStatusActive = "ACTIVE"

	// ServicePrincipalNameStatusDeleting is a ServicePrincipalNameStatus enum value
	ServicePrincipalNameStatusDeleting = "DELETING"

	// ServicePrincipalNameStatusFailed is a ServicePrincipalNameStatus enum value
	ServicePrincipalNameStatusFailed = "FAILED"
)

// ServicePrincipalNameStatus_Values returns all elements of the ServicePrincipalNameStatus enum
func ServicePrincipalNameStatus_Values() []string {
	return []string{
		ServicePrincipalNameStatusCreating,
		ServicePrincipalNameStatusActive,
		ServicePrincipalNameStatusDeleting,
		ServicePrincipalNameStatusFailed,
	}
}

const (
	// ServicePrincipalNameStatusReasonDirectoryAccessDenied is a ServicePrincipalNameStatusReason enum value
	ServicePrincipalNameStatusReasonDirectoryAccessDenied = "DIRECTORY_ACCESS_DENIED"

	// ServicePrincipalNameStatusReasonDirectoryNotReachable is a ServicePrincipalNameStatusReason enum value
	ServicePrincipalNameStatusReasonDirectoryNotReachable = "DIRECTORY_NOT_REACHABLE"

	// ServicePrincipalNameStatusReasonDirectoryResourceNotFound is a ServicePrincipalNameStatusReason enum value
	ServicePrincipalNameStatusReasonDirectoryResourceNotFound = "DIRECTORY_RESOURCE_NOT_FOUND"

	// ServicePrincipalNameStatusReasonSpnExistsOnDifferentAdObject is a ServicePrincipalNameStatusReason enum value
	ServicePrincipalNameStatusReasonSpnExistsOnDifferentAdObject = "SPN_EXISTS_ON_DIFFERENT_AD_OBJECT"

	// ServicePrincipalNameStatusReasonInternalFailure is a ServicePrincipalNameStatusReason enum value
	ServicePrincipalNameStatusReasonInternalFailure = "INTERNAL_FAILURE"
)

// ServicePrincipalNameStatusReason_Values returns all elements of the ServicePrincipalNameStatusReason enum
func ServicePrincipalNameStatusReason_Values() []string {
	return []string{
		ServicePrincipalNameStatusReasonDirectoryAccessDenied,
		ServicePrincipalNameStatusReasonDirectoryNotReachable,
		ServicePrincipalNameStatusReasonDirectoryResourceNotFound,
		ServicePrincipalNameStatusReasonSpnExistsOnDifferentAdObject,
		ServicePrincipalNameStatusReasonInternalFailure,
	}
}

const (
	// TemplateStatusActive is a TemplateStatus enum value
	TemplateStatusActive = "ACTIVE"

	// TemplateStatusDeleting is a TemplateStatus enum value
	TemplateStatusDeleting = "DELETING"
)

// TemplateStatus_Values returns all elements of the TemplateStatus enum
func TemplateStatus_Values() []string {
	return []string{
		TemplateStatusActive,
		TemplateStatusDeleting,
	}
}

const (
	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonInvalidPermission is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidPermission = "INVALID_PERMISSION"

	// ValidationExceptionReasonInvalidState is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidState = "INVALID_STATE"

	// ValidationExceptionReasonMismatchedConnector is a ValidationExceptionReason enum value
	ValidationExceptionReasonMismatchedConnector = "MISMATCHED_CONNECTOR"

	// ValidationExceptionReasonMismatchedVpc is a ValidationExceptionReason enum value
	ValidationExceptionReasonMismatchedVpc = "MISMATCHED_VPC"

	// ValidationExceptionReasonNoClientToken is a ValidationExceptionReason enum value
	ValidationExceptionReasonNoClientToken = "NO_CLIENT_TOKEN"

	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UNKNOWN_OPERATION"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonInvalidPermission,
		ValidationExceptionReasonInvalidState,
		ValidationExceptionReasonMismatchedConnector,
		ValidationExceptionReasonMismatchedVpc,
		ValidationExceptionReasonNoClientToken,
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonOther,
	}
}

const (
	// ValidityPeriodTypeHours is a ValidityPeriodType enum value
	ValidityPeriodTypeHours = "HOURS"

	// ValidityPeriodTypeDays is a ValidityPeriodType enum value
	ValidityPeriodTypeDays = "DAYS"

	// ValidityPeriodTypeWeeks is a ValidityPeriodType enum value
	ValidityPeriodTypeWeeks = "WEEKS"

	// ValidityPeriodTypeMonths is a ValidityPeriodType enum value
	ValidityPeriodTypeMonths = "MONTHS"

	// ValidityPeriodTypeYears is a ValidityPeriodType enum value
	ValidityPeriodTypeYears = "YEARS"
)

// ValidityPeriodType_Values returns all elements of the ValidityPeriodType enum
func ValidityPeriodType_Values() []string {
	return []string{
		ValidityPeriodTypeHours,
		ValidityPeriodTypeDays,
		ValidityPeriodTypeWeeks,
		ValidityPeriodTypeMonths,
		ValidityPeriodTypeYears,
	}
}
