// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) Go Code Generator. DO NOT EDIT.

package fake

import (
	"context"
	"errors"
	"fmt"
	"net/http"
	"net/url"
	"regexp"

	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/security/keyvault/azkeys"
)

// Server is a fake server for instances of the azkeys.Client type.
type Server struct {
	// BackupKey is the fake for method Client.BackupKey
	// HTTP status codes to indicate success: http.StatusOK
	BackupKey func(ctx context.Context, name string, options *azkeys.BackupKeyOptions) (resp azfake.Responder[azkeys.BackupKeyResponse], errResp azfake.ErrorResponder)

	// CreateKey is the fake for method Client.CreateKey
	// HTTP status codes to indicate success: http.StatusOK
	CreateKey func(ctx context.Context, name string, parameters azkeys.CreateKeyParameters, options *azkeys.CreateKeyOptions) (resp azfake.Responder[azkeys.CreateKeyResponse], errResp azfake.ErrorResponder)

	// Decrypt is the fake for method Client.Decrypt
	// HTTP status codes to indicate success: http.StatusOK
	Decrypt func(ctx context.Context, name string, version string, parameters azkeys.KeyOperationParameters, options *azkeys.DecryptOptions) (resp azfake.Responder[azkeys.DecryptResponse], errResp azfake.ErrorResponder)

	// DeleteKey is the fake for method Client.DeleteKey
	// HTTP status codes to indicate success: http.StatusOK
	DeleteKey func(ctx context.Context, name string, options *azkeys.DeleteKeyOptions) (resp azfake.Responder[azkeys.DeleteKeyResponse], errResp azfake.ErrorResponder)

	// Encrypt is the fake for method Client.Encrypt
	// HTTP status codes to indicate success: http.StatusOK
	Encrypt func(ctx context.Context, name string, version string, parameters azkeys.KeyOperationParameters, options *azkeys.EncryptOptions) (resp azfake.Responder[azkeys.EncryptResponse], errResp azfake.ErrorResponder)

	// GetDeletedKey is the fake for method Client.GetDeletedKey
	// HTTP status codes to indicate success: http.StatusOK
	GetDeletedKey func(ctx context.Context, name string, options *azkeys.GetDeletedKeyOptions) (resp azfake.Responder[azkeys.GetDeletedKeyResponse], errResp azfake.ErrorResponder)

	// GetKey is the fake for method Client.GetKey
	// HTTP status codes to indicate success: http.StatusOK
	GetKey func(ctx context.Context, name string, version string, options *azkeys.GetKeyOptions) (resp azfake.Responder[azkeys.GetKeyResponse], errResp azfake.ErrorResponder)

	// GetKeyAttestation is the fake for method Client.GetKeyAttestation
	// HTTP status codes to indicate success: http.StatusOK
	GetKeyAttestation func(ctx context.Context, name string, version string, options *azkeys.GetKeyAttestationOptions) (resp azfake.Responder[azkeys.GetKeyAttestationResponse], errResp azfake.ErrorResponder)

	// GetKeyRotationPolicy is the fake for method Client.GetKeyRotationPolicy
	// HTTP status codes to indicate success: http.StatusOK
	GetKeyRotationPolicy func(ctx context.Context, name string, options *azkeys.GetKeyRotationPolicyOptions) (resp azfake.Responder[azkeys.GetKeyRotationPolicyResponse], errResp azfake.ErrorResponder)

	// GetRandomBytes is the fake for method Client.GetRandomBytes
	// HTTP status codes to indicate success: http.StatusOK
	GetRandomBytes func(ctx context.Context, parameters azkeys.GetRandomBytesParameters, options *azkeys.GetRandomBytesOptions) (resp azfake.Responder[azkeys.GetRandomBytesResponse], errResp azfake.ErrorResponder)

	// ImportKey is the fake for method Client.ImportKey
	// HTTP status codes to indicate success: http.StatusOK
	ImportKey func(ctx context.Context, name string, parameters azkeys.ImportKeyParameters, options *azkeys.ImportKeyOptions) (resp azfake.Responder[azkeys.ImportKeyResponse], errResp azfake.ErrorResponder)

	// NewListDeletedKeyPropertiesPager is the fake for method Client.NewListDeletedKeyPropertiesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListDeletedKeyPropertiesPager func(options *azkeys.ListDeletedKeyPropertiesOptions) (resp azfake.PagerResponder[azkeys.ListDeletedKeyPropertiesResponse])

	// NewListKeyPropertiesPager is the fake for method Client.NewListKeyPropertiesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListKeyPropertiesPager func(options *azkeys.ListKeyPropertiesOptions) (resp azfake.PagerResponder[azkeys.ListKeyPropertiesResponse])

	// NewListKeyPropertiesVersionsPager is the fake for method Client.NewListKeyPropertiesVersionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListKeyPropertiesVersionsPager func(name string, options *azkeys.ListKeyPropertiesVersionsOptions) (resp azfake.PagerResponder[azkeys.ListKeyPropertiesVersionsResponse])

	// PurgeDeletedKey is the fake for method Client.PurgeDeletedKey
	// HTTP status codes to indicate success: http.StatusNoContent
	PurgeDeletedKey func(ctx context.Context, name string, options *azkeys.PurgeDeletedKeyOptions) (resp azfake.Responder[azkeys.PurgeDeletedKeyResponse], errResp azfake.ErrorResponder)

	// RecoverDeletedKey is the fake for method Client.RecoverDeletedKey
	// HTTP status codes to indicate success: http.StatusOK
	RecoverDeletedKey func(ctx context.Context, name string, options *azkeys.RecoverDeletedKeyOptions) (resp azfake.Responder[azkeys.RecoverDeletedKeyResponse], errResp azfake.ErrorResponder)

	// Release is the fake for method Client.Release
	// HTTP status codes to indicate success: http.StatusOK
	Release func(ctx context.Context, name string, version string, parameters azkeys.ReleaseParameters, options *azkeys.ReleaseOptions) (resp azfake.Responder[azkeys.ReleaseResponse], errResp azfake.ErrorResponder)

	// RestoreKey is the fake for method Client.RestoreKey
	// HTTP status codes to indicate success: http.StatusOK
	RestoreKey func(ctx context.Context, parameters azkeys.RestoreKeyParameters, options *azkeys.RestoreKeyOptions) (resp azfake.Responder[azkeys.RestoreKeyResponse], errResp azfake.ErrorResponder)

	// RotateKey is the fake for method Client.RotateKey
	// HTTP status codes to indicate success: http.StatusOK
	RotateKey func(ctx context.Context, name string, options *azkeys.RotateKeyOptions) (resp azfake.Responder[azkeys.RotateKeyResponse], errResp azfake.ErrorResponder)

	// Sign is the fake for method Client.Sign
	// HTTP status codes to indicate success: http.StatusOK
	Sign func(ctx context.Context, name string, version string, parameters azkeys.SignParameters, options *azkeys.SignOptions) (resp azfake.Responder[azkeys.SignResponse], errResp azfake.ErrorResponder)

	// UnwrapKey is the fake for method Client.UnwrapKey
	// HTTP status codes to indicate success: http.StatusOK
	UnwrapKey func(ctx context.Context, name string, version string, parameters azkeys.KeyOperationParameters, options *azkeys.UnwrapKeyOptions) (resp azfake.Responder[azkeys.UnwrapKeyResponse], errResp azfake.ErrorResponder)

	// UpdateKey is the fake for method Client.UpdateKey
	// HTTP status codes to indicate success: http.StatusOK
	UpdateKey func(ctx context.Context, name string, version string, parameters azkeys.UpdateKeyParameters, options *azkeys.UpdateKeyOptions) (resp azfake.Responder[azkeys.UpdateKeyResponse], errResp azfake.ErrorResponder)

	// UpdateKeyRotationPolicy is the fake for method Client.UpdateKeyRotationPolicy
	// HTTP status codes to indicate success: http.StatusOK
	UpdateKeyRotationPolicy func(ctx context.Context, name string, keyRotationPolicy azkeys.KeyRotationPolicy, options *azkeys.UpdateKeyRotationPolicyOptions) (resp azfake.Responder[azkeys.UpdateKeyRotationPolicyResponse], errResp azfake.ErrorResponder)

	// Verify is the fake for method Client.Verify
	// HTTP status codes to indicate success: http.StatusOK
	Verify func(ctx context.Context, name string, version string, parameters azkeys.VerifyParameters, options *azkeys.VerifyOptions) (resp azfake.Responder[azkeys.VerifyResponse], errResp azfake.ErrorResponder)

	// WrapKey is the fake for method Client.WrapKey
	// HTTP status codes to indicate success: http.StatusOK
	WrapKey func(ctx context.Context, name string, version string, parameters azkeys.KeyOperationParameters, options *azkeys.WrapKeyOptions) (resp azfake.Responder[azkeys.WrapKeyResponse], errResp azfake.ErrorResponder)
}

// NewServerTransport creates a new instance of ServerTransport with the provided implementation.
// The returned ServerTransport instance is connected to an instance of azkeys.Client via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerTransport(srv *Server) *ServerTransport {
	return &ServerTransport{
		srv:                               srv,
		newListDeletedKeyPropertiesPager:  newTracker[azfake.PagerResponder[azkeys.ListDeletedKeyPropertiesResponse]](),
		newListKeyPropertiesPager:         newTracker[azfake.PagerResponder[azkeys.ListKeyPropertiesResponse]](),
		newListKeyPropertiesVersionsPager: newTracker[azfake.PagerResponder[azkeys.ListKeyPropertiesVersionsResponse]](),
	}
}

// ServerTransport connects instances of azkeys.Client to instances of Server.
// Don't use this type directly, use NewServerTransport instead.
type ServerTransport struct {
	srv                               *Server
	newListDeletedKeyPropertiesPager  *tracker[azfake.PagerResponder[azkeys.ListDeletedKeyPropertiesResponse]]
	newListKeyPropertiesPager         *tracker[azfake.PagerResponder[azkeys.ListKeyPropertiesResponse]]
	newListKeyPropertiesVersionsPager *tracker[azfake.PagerResponder[azkeys.ListKeyPropertiesVersionsResponse]]
}

// Do implements the policy.Transporter interface for ServerTransport.
func (s *ServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	return s.dispatchToMethodFake(req, method)
}

func (s *ServerTransport) dispatchToMethodFake(req *http.Request, method string) (*http.Response, error) {
	resultChan := make(chan result)
	defer close(resultChan)

	go func() {
		var intercepted bool
		var res result
		if serverTransportInterceptor != nil {
			res.resp, res.err, intercepted = serverTransportInterceptor.Do(req)
		}
		if !intercepted {
			switch method {
			case "Client.BackupKey":
				res.resp, res.err = s.dispatchBackupKey(req)
			case "Client.CreateKey":
				res.resp, res.err = s.dispatchCreateKey(req)
			case "Client.Decrypt":
				res.resp, res.err = s.dispatchDecrypt(req)
			case "Client.DeleteKey":
				res.resp, res.err = s.dispatchDeleteKey(req)
			case "Client.Encrypt":
				res.resp, res.err = s.dispatchEncrypt(req)
			case "Client.GetDeletedKey":
				res.resp, res.err = s.dispatchGetDeletedKey(req)
			case "Client.GetKey":
				res.resp, res.err = s.dispatchGetKey(req)
			case "Client.GetKeyAttestation":
				res.resp, res.err = s.dispatchGetKeyAttestation(req)
			case "Client.GetKeyRotationPolicy":
				res.resp, res.err = s.dispatchGetKeyRotationPolicy(req)
			case "Client.GetRandomBytes":
				res.resp, res.err = s.dispatchGetRandomBytes(req)
			case "Client.ImportKey":
				res.resp, res.err = s.dispatchImportKey(req)
			case "Client.NewListDeletedKeyPropertiesPager":
				res.resp, res.err = s.dispatchNewListDeletedKeyPropertiesPager(req)
			case "Client.NewListKeyPropertiesPager":
				res.resp, res.err = s.dispatchNewListKeyPropertiesPager(req)
			case "Client.NewListKeyPropertiesVersionsPager":
				res.resp, res.err = s.dispatchNewListKeyPropertiesVersionsPager(req)
			case "Client.PurgeDeletedKey":
				res.resp, res.err = s.dispatchPurgeDeletedKey(req)
			case "Client.RecoverDeletedKey":
				res.resp, res.err = s.dispatchRecoverDeletedKey(req)
			case "Client.Release":
				res.resp, res.err = s.dispatchRelease(req)
			case "Client.RestoreKey":
				res.resp, res.err = s.dispatchRestoreKey(req)
			case "Client.RotateKey":
				res.resp, res.err = s.dispatchRotateKey(req)
			case "Client.Sign":
				res.resp, res.err = s.dispatchSign(req)
			case "Client.UnwrapKey":
				res.resp, res.err = s.dispatchUnwrapKey(req)
			case "Client.UpdateKey":
				res.resp, res.err = s.dispatchUpdateKey(req)
			case "Client.UpdateKeyRotationPolicy":
				res.resp, res.err = s.dispatchUpdateKeyRotationPolicy(req)
			case "Client.Verify":
				res.resp, res.err = s.dispatchVerify(req)
			case "Client.WrapKey":
				res.resp, res.err = s.dispatchWrapKey(req)
			default:
				res.err = fmt.Errorf("unhandled API %s", method)
			}

		}
		select {
		case resultChan <- res:
		case <-req.Context().Done():
		}
	}()

	select {
	case <-req.Context().Done():
		return nil, req.Context().Err()
	case res := <-resultChan:
		return res.resp, res.err
	}
}

func (s *ServerTransport) dispatchBackupKey(req *http.Request) (*http.Response, error) {
	if s.srv.BackupKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method BackupKey not implemented")}
	}
	const regexStr = `/keys/(?P<key_name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backup`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.BackupKey(req.Context(), nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BackupKeyResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchCreateKey(req *http.Request) (*http.Response, error) {
	if s.srv.CreateKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateKey not implemented")}
	}
	const regexStr = `/keys/(?P<key_name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/create`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[azkeys.CreateKeyParameters](req)
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateKey(req.Context(), nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KeyBundle, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchDecrypt(req *http.Request) (*http.Response, error) {
	if s.srv.Decrypt == nil {
		return nil, &nonRetriableError{errors.New("fake for method Decrypt not implemented")}
	}
	const regexStr = `/keys/(?P<key_name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/?(?P<key_version>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)?/decrypt`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[azkeys.KeyOperationParameters](req)
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_name")])
	if err != nil {
		return nil, err
	}
	versionParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_version")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Decrypt(req.Context(), nameParam, versionParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KeyOperationResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchDeleteKey(req *http.Request) (*http.Response, error) {
	if s.srv.DeleteKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteKey not implemented")}
	}
	const regexStr = `/keys/(?P<key_name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.DeleteKey(req.Context(), nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeletedKey, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchEncrypt(req *http.Request) (*http.Response, error) {
	if s.srv.Encrypt == nil {
		return nil, &nonRetriableError{errors.New("fake for method Encrypt not implemented")}
	}
	const regexStr = `/keys/(?P<key_name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/?(?P<key_version>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)?/encrypt`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[azkeys.KeyOperationParameters](req)
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_name")])
	if err != nil {
		return nil, err
	}
	versionParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_version")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Encrypt(req.Context(), nameParam, versionParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KeyOperationResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchGetDeletedKey(req *http.Request) (*http.Response, error) {
	if s.srv.GetDeletedKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDeletedKey not implemented")}
	}
	const regexStr = `/deletedkeys/(?P<key_name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetDeletedKey(req.Context(), nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeletedKey, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchGetKey(req *http.Request) (*http.Response, error) {
	if s.srv.GetKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetKey not implemented")}
	}
	const regexStr = `/keys/(?P<key_name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/?(?P<key_version>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)?`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_name")])
	if err != nil {
		return nil, err
	}
	versionParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_version")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetKey(req.Context(), nameParam, versionParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KeyBundle, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchGetKeyAttestation(req *http.Request) (*http.Response, error) {
	if s.srv.GetKeyAttestation == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetKeyAttestation not implemented")}
	}
	const regexStr = `/keys/(?P<key_name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/?(?P<key_version>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)?/attestation`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_name")])
	if err != nil {
		return nil, err
	}
	versionParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_version")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetKeyAttestation(req.Context(), nameParam, versionParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KeyBundle, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchGetKeyRotationPolicy(req *http.Request) (*http.Response, error) {
	if s.srv.GetKeyRotationPolicy == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetKeyRotationPolicy not implemented")}
	}
	const regexStr = `/keys/(?P<key_name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/rotationpolicy`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetKeyRotationPolicy(req.Context(), nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KeyRotationPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchGetRandomBytes(req *http.Request) (*http.Response, error) {
	if s.srv.GetRandomBytes == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetRandomBytes not implemented")}
	}
	body, err := server.UnmarshalRequestAsJSON[azkeys.GetRandomBytesParameters](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetRandomBytes(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RandomBytes, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchImportKey(req *http.Request) (*http.Response, error) {
	if s.srv.ImportKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method ImportKey not implemented")}
	}
	const regexStr = `/keys/(?P<key_name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[azkeys.ImportKeyParameters](req)
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ImportKey(req.Context(), nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KeyBundle, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchNewListDeletedKeyPropertiesPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListDeletedKeyPropertiesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListDeletedKeyPropertiesPager not implemented")}
	}
	newListDeletedKeyPropertiesPager := s.newListDeletedKeyPropertiesPager.get(req)
	if newListDeletedKeyPropertiesPager == nil {
		resp := s.srv.NewListDeletedKeyPropertiesPager(nil)
		newListDeletedKeyPropertiesPager = &resp
		s.newListDeletedKeyPropertiesPager.add(req, newListDeletedKeyPropertiesPager)
		server.PagerResponderInjectNextLinks(newListDeletedKeyPropertiesPager, req, func(page *azkeys.ListDeletedKeyPropertiesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListDeletedKeyPropertiesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListDeletedKeyPropertiesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListDeletedKeyPropertiesPager) {
		s.newListDeletedKeyPropertiesPager.remove(req)
	}
	return resp, nil
}

func (s *ServerTransport) dispatchNewListKeyPropertiesPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListKeyPropertiesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListKeyPropertiesPager not implemented")}
	}
	newListKeyPropertiesPager := s.newListKeyPropertiesPager.get(req)
	if newListKeyPropertiesPager == nil {
		resp := s.srv.NewListKeyPropertiesPager(nil)
		newListKeyPropertiesPager = &resp
		s.newListKeyPropertiesPager.add(req, newListKeyPropertiesPager)
		server.PagerResponderInjectNextLinks(newListKeyPropertiesPager, req, func(page *azkeys.ListKeyPropertiesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListKeyPropertiesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListKeyPropertiesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListKeyPropertiesPager) {
		s.newListKeyPropertiesPager.remove(req)
	}
	return resp, nil
}

func (s *ServerTransport) dispatchNewListKeyPropertiesVersionsPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListKeyPropertiesVersionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListKeyPropertiesVersionsPager not implemented")}
	}
	newListKeyPropertiesVersionsPager := s.newListKeyPropertiesVersionsPager.get(req)
	if newListKeyPropertiesVersionsPager == nil {
		const regexStr = `/keys/(?P<key_name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/versions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_name")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListKeyPropertiesVersionsPager(nameParam, nil)
		newListKeyPropertiesVersionsPager = &resp
		s.newListKeyPropertiesVersionsPager.add(req, newListKeyPropertiesVersionsPager)
		server.PagerResponderInjectNextLinks(newListKeyPropertiesVersionsPager, req, func(page *azkeys.ListKeyPropertiesVersionsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListKeyPropertiesVersionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListKeyPropertiesVersionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListKeyPropertiesVersionsPager) {
		s.newListKeyPropertiesVersionsPager.remove(req)
	}
	return resp, nil
}

func (s *ServerTransport) dispatchPurgeDeletedKey(req *http.Request) (*http.Response, error) {
	if s.srv.PurgeDeletedKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method PurgeDeletedKey not implemented")}
	}
	const regexStr = `/deletedkeys/(?P<key_name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.PurgeDeletedKey(req.Context(), nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchRecoverDeletedKey(req *http.Request) (*http.Response, error) {
	if s.srv.RecoverDeletedKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method RecoverDeletedKey not implemented")}
	}
	const regexStr = `/deletedkeys/(?P<key_name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recover`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.RecoverDeletedKey(req.Context(), nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KeyBundle, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchRelease(req *http.Request) (*http.Response, error) {
	if s.srv.Release == nil {
		return nil, &nonRetriableError{errors.New("fake for method Release not implemented")}
	}
	const regexStr = `/keys/(?P<key_name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/?(?P<key_version>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)?/release`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[azkeys.ReleaseParameters](req)
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_name")])
	if err != nil {
		return nil, err
	}
	versionParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_version")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Release(req.Context(), nameParam, versionParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KeyReleaseResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchRestoreKey(req *http.Request) (*http.Response, error) {
	if s.srv.RestoreKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method RestoreKey not implemented")}
	}
	body, err := server.UnmarshalRequestAsJSON[azkeys.RestoreKeyParameters](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.RestoreKey(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KeyBundle, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchRotateKey(req *http.Request) (*http.Response, error) {
	if s.srv.RotateKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method RotateKey not implemented")}
	}
	const regexStr = `/keys/(?P<key_name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/rotate`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.RotateKey(req.Context(), nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KeyBundle, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchSign(req *http.Request) (*http.Response, error) {
	if s.srv.Sign == nil {
		return nil, &nonRetriableError{errors.New("fake for method Sign not implemented")}
	}
	const regexStr = `/keys/(?P<key_name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/?(?P<key_version>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)?/sign`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[azkeys.SignParameters](req)
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_name")])
	if err != nil {
		return nil, err
	}
	versionParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_version")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Sign(req.Context(), nameParam, versionParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KeyOperationResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchUnwrapKey(req *http.Request) (*http.Response, error) {
	if s.srv.UnwrapKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method UnwrapKey not implemented")}
	}
	const regexStr = `/keys/(?P<key_name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/?(?P<key_version>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)?/unwrapkey`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[azkeys.KeyOperationParameters](req)
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_name")])
	if err != nil {
		return nil, err
	}
	versionParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_version")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.UnwrapKey(req.Context(), nameParam, versionParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KeyOperationResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchUpdateKey(req *http.Request) (*http.Response, error) {
	if s.srv.UpdateKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateKey not implemented")}
	}
	const regexStr = `/keys/(?P<key_name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/?(?P<key_version>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)?`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[azkeys.UpdateKeyParameters](req)
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_name")])
	if err != nil {
		return nil, err
	}
	versionParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_version")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.UpdateKey(req.Context(), nameParam, versionParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KeyBundle, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchUpdateKeyRotationPolicy(req *http.Request) (*http.Response, error) {
	if s.srv.UpdateKeyRotationPolicy == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateKeyRotationPolicy not implemented")}
	}
	const regexStr = `/keys/(?P<key_name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/rotationpolicy`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[azkeys.KeyRotationPolicy](req)
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.UpdateKeyRotationPolicy(req.Context(), nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KeyRotationPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchVerify(req *http.Request) (*http.Response, error) {
	if s.srv.Verify == nil {
		return nil, &nonRetriableError{errors.New("fake for method Verify not implemented")}
	}
	const regexStr = `/keys/(?P<key_name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/?(?P<key_version>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)?/verify`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[azkeys.VerifyParameters](req)
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_name")])
	if err != nil {
		return nil, err
	}
	versionParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_version")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Verify(req.Context(), nameParam, versionParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KeyVerifyResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchWrapKey(req *http.Request) (*http.Response, error) {
	if s.srv.WrapKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method WrapKey not implemented")}
	}
	const regexStr = `/keys/(?P<key_name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/?(?P<key_version>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)?/wrapkey`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[azkeys.KeyOperationParameters](req)
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_name")])
	if err != nil {
		return nil, err
	}
	versionParam, err := url.PathUnescape(matches[regex.SubexpIndex("key_version")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.WrapKey(req.Context(), nameParam, versionParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KeyOperationResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// set this to conditionally intercept incoming requests to ServerTransport
var serverTransportInterceptor interface {
	// Do returns true if the server transport should use the returned response/error
	Do(*http.Request) (*http.Response, error, bool)
}
