#!/bin/sh

# This test ensures that CLI arguments are handled correctly in script mode,
# both when invoking rq directly and via shebang.

set -e
set -u
set -x

rm -f ./script.rq actual.1 actual.2
trap "rm -f ./script.rq actual.1 actual.2" EXIT

printf '{"shebang": "%s"}' "$RQ" | "$RQ" \
	--output ./script.rq \
	--output-format raw \
	'rq.template(rq.read({"file_path": "./script.rq.template", "format": "raw"}), input)'

chmod +x ./script.rq

# script invoked via shebang
./script.rq foo bar baz > actual.1
diff expect actual.1

# script invoked directly, this also tests that we can specify options to rq
# itself when invoking scripts in this way
"$RQ" script --output actual.2 ./script.rq foo bar baz
diff expect actual.2

