#!/bin/sh

# This test makes sure that we can load a previously saved bundle.
#
# The bundle is the .tgz, it is generated by the make_bundle.sh script, which
# requires `opa` to be in PATH.

set -e
set -u
set -x

if [ ! -f ./a.tar.gz ] ; then
	echo "no ./a.tar.gz, maybe you need to run make_bundle.sh?" 1>&2
	exit 1
fi

if [ ! -f ./b.tar.gz ] ; then
	echo "no ./b.tar.gz, maybe you need to run make_bundle.sh?" 1>&2
	exit 1
fi

rm -f ./actual.txt out.tar.gz
trap "rm -f ./actual.json out.tar.gz" EXIT

"$RQ" --v0-compatible --data ./extras.toml --bundle ./a.tar.gz --bundle b.tar.gz --save-bundle out.tar.gz

"$RQ" --v0-compatible --bundle ./out.tar.gz 'data' > actual.json

diff expect.json actual.json
