/* gtkcolormapbutton.h
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2001 DindinX <David@dindinx.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU  
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GTK_COLOR_MAP_BUTTON_H__
#define __GTK_COLOR_MAP_BUTTON_H__

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_TYPE_COLOR_MAP_BUTTON            (gtk_color_map_button_get_type ())
#define GTK_COLOR_MAP_BUTTON(obj)            (GTK_CHECK_CAST ((obj), GTK_TYPE_COLOR_MAP_BUTTON, GtkColorMapButton))
#define GTK_COLOR_MAP_BUTTON_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_COLOR_MAP_BUTTON, GtkColorMapButtonClass))
#define GTK_IS_COLOR_MAP_BUTTON(obj)         (GTK_CHECK_TYPE ((obj), GTK_TYPE_COLOR_MAP_BUTTON))
#define GTK_IS_COLOR_MAP_BUTTON_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_COLOR_MAP_BUTTON))

typedef struct _GtkColorMapButton       GtkColorMapButton;
typedef struct _GtkColorMapButtonClass  GtkColorMapButtonClass;


struct _GtkColorMapButton
{
  GtkButton  button;
  
  GtkWidget *gcme;
  gint       width;
  gint       height;
  
  GList     *color_map;
  GtkWidget *preview;
};

struct _GtkColorMapButtonClass
{
  GtkButtonClass parent_class;

  void (* color_map_changed) (GtkColorMapButton *gcmb);
};


GtkType    gtk_color_map_button_get_type      (void);
GtkWidget* gtk_color_map_button_new           (gint   width,
                                               gint   height,
                                               GList *color_map);
void       gtk_color_map_button_update        (GtkColorMapButton *gcmb);
void       gtk_color_map_button_set_color_map (GtkColorMapButton *gcmb,
                                               GList             *color_map);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GTK_COLOR_MAP_BUTTON_H__ */
