/* gtkcolormapbutton.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#undef GTK_DISABLE_DEPRECATED
#warning GTK_DISABLE_DEPRECATED
#include "giram.h"
#include "color_map.h"

#include "giramintl.h"

#include "gtkcolormapbutton.h"
#include "gtkcolormapeditor.h"

static void  gtk_color_map_button_destroy(GtkObject *object);
static void  gtk_color_map_button_clicked(GtkButton *button);
static void  gtk_color_map_button_paint(GtkColorMapButton *gcb);
static void  gtk_color_map_button_state_changed(GtkWidget *widget, GtkStateType previous_state);
/*static void  gtk_color_map_button_color_map_changed(GtkColorMapButton *gcb);*/

enum
{
  COLOR_MAP_CHANGED,
  LAST_SIGNAL
};

static guint gtk_color_map_button_signals[LAST_SIGNAL] = { 0 };

static GtkWidgetClass *parent_class = NULL;

/*************************************************************************
*  gtk_color_map_button_destroy
**************************************************************************/
static void gtk_color_map_button_destroy(GtkObject *object)
{
/*  GtkColorMapButton *gcmb;

  g_return_if_fail(gcb = GTK_COLOR_BUTTON(object));

  g_free(gcb->title);

  if (gcb->gcs)
    gtk_widget_destroy(gcb->gcs);

  g_free(gcb->color);
*/
  if (GTK_OBJECT_CLASS(parent_class)->destroy)
    (* GTK_OBJECT_CLASS(parent_class)->destroy)(object);
}

/*************************************************************************
*  gtk_color_map_button_class_init
**************************************************************************/
static void gtk_color_map_button_class_init(GtkColorMapButtonClass *class)
{
  GtkObjectClass *object_class;
  GtkButtonClass *button_class;
  GtkWidgetClass *widget_class;

  object_class = (GtkObjectClass*)class;
  button_class = (GtkButtonClass*)class;
  widget_class = (GtkWidgetClass*)class;

  parent_class = gtk_type_class(gtk_button_get_type());

  gtk_color_map_button_signals[COLOR_MAP_CHANGED] =
          g_signal_new("color_map_changed",
                       G_TYPE_FROM_CLASS(class),
                       G_SIGNAL_RUN_FIRST,
                       G_STRUCT_OFFSET(GtkColorMapButtonClass, color_map_changed),
                       NULL, NULL,
                       gtk_signal_default_marshaller, GTK_TYPE_NONE, 0);
  //gtk_object_class_add_signals(object_class, gtk_color_map_button_signals, LAST_SIGNAL);
  class->color_map_changed = NULL;

  object_class->destroy       = gtk_color_map_button_destroy;
  button_class->clicked       = gtk_color_map_button_clicked;
  widget_class->state_changed = gtk_color_map_button_state_changed;
}

/*************************************************************************
*  gtk_color_map_button_init
**************************************************************************/
static void gtk_color_map_button_init(GtkColorMapButton *gcmb)
{
/*  gcb->title    = NULL;

  gcb->color    = NULL;
  gcb->preview  = NULL;
  gcb->gcs      = NULL;*/
  gcmb->color_map = NULL;
}

/*************************************************************************
*  gtk_color_map_button_get_type
**************************************************************************/
GtkType gtk_color_map_button_get_type(void)
{
  static guint gcmb_type = 0;

  if (!gcmb_type)
    {
      GtkTypeInfo gcmb_info =
      {
        "GtkColorMapButton",
        sizeof(GtkColorMapButton),
        sizeof(GtkColorMapButtonClass),
        (GtkClassInitFunc)gtk_color_map_button_class_init,
        (GtkObjectInitFunc)gtk_color_map_button_init,
        /* reserved_1 */ NULL,
        /* reserved_2 */ NULL,
        (GtkClassInitFunc) NULL
      };

      gcmb_type = gtk_type_unique(gtk_button_get_type(), &gcmb_info);
    }

  return gcmb_type;
}
/**
 * gtk_color_map_button_new:
 * @title: String that wil be used as title for the color_selector.
 * @width: Width of the colorpreview in pixels.
 * @height: Height of the colorpreview in pixels.
 * @color: An array of guchar holding the color (RGB or RGBA)
 * @bpp: May be 3 for RGB or 4 for RGBA.
 *
 * Creates a new GtkColorbutton widget. This returns a button with
 * a preview showing the color. When the button is clicked a
 * GtkColorSelectionDialog is opened. If the user changes the color
 * the new color is written into the array that was used to pass
 * the initial color and the "color_changed" signal is emitted.
 *
 * Returns: Pointer to the new GtkColorButton widget.
 */

GtkWidget *gtk_color_map_button_new(gint width, gint height,
                                    GList *color_map)
{
  GtkColorMapButton *gcmb;

  g_return_val_if_fail(width > 0 && height > 0, NULL);

  gcmb = gtk_type_new(gtk_color_map_button_get_type());

  gcmb->width  = width;
  gcmb->height = height;

  gcmb->color_map = NULL;

  {
    gdouble color[3];
    color[0] = 0.0; color[1] = 0.0; color[2] = 0.0;
    gcmb->color_map = color_map_add_point(gcmb->color_map, 0.0, color);
    color[0] = 1.0; color[1] = 0.0; color[2] = 0.0;
    gcmb->color_map = color_map_add_point(gcmb->color_map, 0.3, color);
    color[0] = 1.0; color[1] = 1.0; color[2] = 0.0;
    gcmb->color_map = color_map_add_point(gcmb->color_map, 0.6, color);
    color[0] = 1.0; color[1] = 1.0; color[2] = 1.0;
    gcmb->color_map = color_map_add_point(gcmb->color_map, 1.0, color);
  }
  
  gcmb->preview = gtk_preview_new(GTK_PREVIEW_COLOR);
  gtk_signal_connect(GTK_OBJECT(gcmb->preview), "destroy",
                     (GtkSignalFunc)gtk_widget_destroyed, &gcmb->preview);

  gtk_preview_size(GTK_PREVIEW(gcmb->preview), width, height);
  gtk_container_add(GTK_CONTAINER(gcmb), gcmb->preview);
  gtk_widget_show(gcmb->preview);
  gtk_color_map_button_paint(gcmb);

  return (GTK_WIDGET(gcmb));
}

/*
 * gtk_color_button_update:
 * @gcb: Pointer to a #GimpColorButton.
 *
 * Should be used after the color controlled by a #GimpColorButton
 * was changed. The color is then reread and the change is propagated
 * to the preview and the GtkColorSelectionDialog if one is open.
 */
void gtk_color_map_button_update(GtkColorMapButton *gcmb)
{
  g_return_if_fail(GTK_IS_COLOR_MAP_BUTTON(gcmb));

  gtk_color_map_button_paint(gcmb);

/*  if (gcb->gcs)
    gtk_color_selection_set_color(GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(gcb->gcs)->colorsel), gcb->color);*/
}

static void gtk_color_map_button_state_changed(GtkWidget *widget,
                                               GtkStateType previous_state)
{
  g_return_if_fail (GTK_IS_COLOR_MAP_BUTTON (widget));

/*  if (!GTK_WIDGET_IS_SENSITIVE(widget) && GTK_COLOR_BUTTON(widget)->gcs)
    gtk_widget_hide(GTK_COLOR_BUTTON(widget)->gcs);*/

  if (GTK_WIDGET_CLASS(parent_class)->state_changed)
    (* GTK_WIDGET_CLASS(parent_class)->state_changed)(widget, previous_state);
}

static void gtk_color_map_button_clicked(GtkButton *button)
{
  GtkColorMapButton *gcmb;

  g_return_if_fail (GTK_IS_COLOR_MAP_BUTTON(button));
  gcmb = GTK_COLOR_MAP_BUTTON(button);

  if (!gcmb->gcme)
  {
/*    GtkWidget *label;*/
    gcmb->gcme = gtk_color_map_editor_new(NULL);
/*    gtk_signal_connect(GTK_OBJECT(gcb->gcs), "delete_event",
                       (GtkSignalFunc)gtk_widget_destroy, NULL);
    gtk_signal_connect(GTK_OBJECT(gcb->gcs), "destroy",
                       (GtkSignalFunc)gtk_widget_destroyed, &gcb->gcs);
    gtk_signal_connect_object(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(gcb->gcs)->colorsel),
                              "color_changed",
                              (GtkSignalFunc)gtk_color_button_color_changed,
                              GTK_OBJECT(gcb));
    gtk_window_position(GTK_WINDOW(gcb->gcs), GTK_WIN_POS_MOUSE);
    gtk_widget_hide(GTK_COLOR_SELECTION_DIALOG(gcb->gcs)->help_button);
    gtk_widget_hide(GTK_COLOR_SELECTION_DIALOG(gcb->gcs)->cancel_button);
    label = GTK_BIN(GTK_COLOR_SELECTION_DIALOG(gcb->gcs)->ok_button)->child;
    gtk_label_set_text(GTK_LABEL(label), _("Close"));
    gtk_signal_connect_object(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(gcb->gcs)->ok_button),
                              "clicked", (GtkSignalFunc)gtk_widget_destroy,
                              GTK_OBJECT(gcb->gcs));*/
  }
/*  gtk_color_selection_set_color(GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(gcb->gcs)->colorsel), gcb->color);*/
  gtk_widget_show(gcmb->gcme);
}

/*************************************************************************
*  gtk_color_map_button_paint
**************************************************************************/
static void gtk_color_map_button_paint(GtkColorMapButton *gcmb)
{
  gint x, y, i;
  guchar *p0, *row;
  gdouble color[3];

  g_return_if_fail(GTK_IS_COLOR_MAP_BUTTON(gcmb));

  p0 = row = g_new(guchar, 3*gcmb->width);
  for (x = 0; x < gcmb->width; x++)
  {
    color_map_evaluate(gcmb->color_map,
                       (gdouble)x/(gdouble)gcmb->width, color);
          
    for (i = 0; i < 3; i++)
      *p0++ = color[i] * 255.0;
  }
  for (y = 0; y < gcmb->height; y++)
    gtk_preview_draw_row(GTK_PREVIEW(gcmb->preview), row, 0, y,
                         gcmb->width);
  gtk_widget_queue_draw (gcmb->preview);
  g_free(row);
}

/*************************************************************************
*  gtk_color_map_button_color_map_changed
**************************************************************************/
#if 0
static void gtk_color_map_button_color_map_changed(GtkColorMapButton *gcmb)
{
/*  gint               i;
  GtkColorSelection *colorsel;
  gdouble            color[5];

  colorsel = GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(gcb->gcs)->colorsel);
  gtk_color_selection_get_color(colorsel, color);
  for (i=0 ; i<5 ; i++)
    gcb->color[i] = color[i];*/
  gtk_color_map_button_paint(gcmb);
  gtk_signal_emit(GTK_OBJECT(gcmb),  gtk_color_map_button_signals[COLOR_MAP_CHANGED]);
}
#endif

/*************************************************************************
*  gtk_color_map_button_set_color_map
**************************************************************************/
void gtk_color_map_button_set_color_map(GtkColorMapButton *gcmb,
                                        GList             *color_map)
{
/*  GtkColorSelection *colorsel;
  gint               i;

          GList    *color_map_copy(GList *color_map);
  for (i=0 ; i<5 ; i++)
       gcb->color[i] = color[i];
  gtk_color_button_paint(gcb);
  if (gcb->gcs)
  {
    colorsel = GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(gcb->gcs)->colorsel);
    gtk_color_selection_set_color(colorsel, color);
  }*/
}

