/* gtkcolorbutton.h
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This file is heavily inspired from the same one from the Gimp:
 * Gimp Color Button
 * Copyright (C) 1999 Sven Neumann
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU  
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* This provides a button with a color preview. The preview
 * can handle transparency by showing the checkerboard.
 * On click, a color selector is opened, which is already
 * fully functional wired to the preview button.
 */

#ifndef __GTK_COLOR_BUTTON_H__
#define __GTK_COLOR_BUTTON_H__

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_TYPE_COLOR_BUTTON            (gtk_color_button_get_type ())
#define GTK_COLOR_BUTTON(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_COLOR_BUTTON, GtkColorButton))
#define GTK_COLOR_BUTTON_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_COLOR_BUTTON, GtkColorButtonClass))
#define GTK_IS_COLOR_BUTTON(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_COLOR_BUTTON))
#define GTK_IS_COLOR_BUTTON_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_COLOR_BUTTON))
#define GTK_COLOR_BUTTON_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_COLOR_BUTTON, GtkColorButtonClass))

typedef struct _GtkColorButton       GtkColorButton;
typedef struct _GtkColorButtonClass  GtkColorButtonClass;


struct _GtkColorButton
{
  GtkButton  button;
  
  gchar     *title;
/*  guchar         *color;*/
  gint       width;
  gint       height;
  
  gdouble   *color;
  GtkWidget *preview;
  GtkWidget *gcs;
};

struct _GtkColorButtonClass
{
  GtkButtonClass parent_class;

  void (* color_changed) (GtkColorButton *gcb);
};


GtkType    gtk_color_button_get_type   (void);
GtkWidget* gtk_color_button_new        (gchar   *title,
					 gint     width,
					 gint     height,
					 gdouble *color);
void       gtk_color_button_update     (GtkColorButton *gcb);
void       gtk_color_button_set_color  (GtkColorButton *gcb,
                                        gdouble        *color);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __COLOR_BUTTON_H__ */












