/* Giram: a simple 3D modeller
 * Copyright (C) 2001 DindinX <David@dindinx.org>
 *
 * LIBGIMP - The GIMP Library
 * Copyright (C) 1995-1997 Peter Mattis and Spencer Kimball
 *
 * giramwidgets.h
 * Copyright (C) 2000 Michael Natterer <mitch@gimp.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GIRAM_WIDGETS_H__
#define __GIRAM_WIDGETS_H__

#include "giramwidgetstypes.h"
#include "giramdialog.h"
#include "girampixmap.h"
#include "giramquerybox.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

GtkWidget *giram_spin_button_new(/* return value: */
                                 GtkObject **adjustment,
                                 gfloat      value,
                                 gfloat      lower,
                                 gfloat      upper,
                                 gfloat      step_increment,
                                 gfloat      page_increment,
                                 gfloat      page_size,
                                 gfloat      climb_rate,
                                 guint       digits);

GtkWidget *giram_pixmap_button_new(gchar       **xpm_data,
                                   const gchar  *text);

/*
 *  Helper Functions
 */

void giram_table_attach_aligned(GtkTable    *table,
                                gint         column,
                                gint         row,
                                const gchar *label_text,
                                gfloat       xalign,
                                gfloat       yalign,
                                GtkWidget   *widget,
                                gint         colspan,
                                gboolean     left_align);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GIRAM_WIDGETS_H__ */

