/* giramviewshell.h
 *
 * Giram, a GPLed 3D modeller.
 * Copyright (C) 2002 DindinX <David@dindinx.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GIRAM_VIEW_SHELL_H__
#define __GIRAM_VIEW_SHELL_H__

#include <gtk/gtkwindow.h>

#include "view.h"

G_BEGIN_DECLS

#define GIRAM_TYPE_VIEW_SHELL                  (giram_view_shell_get_type ())
#define GIRAM_VIEW_SHELL(obj)                  (G_TYPE_CHECK_INSTANCE_CAST((obj), GIRAM_TYPE_VIEW_SHELL, GiramViewShell))
#define GIRAM_VIEW_SHELL_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST((klass), GIRAM_TYPE_VIEW_SHELL, GiramViewShellClass))
#define GIRAM_IS_VIEW_SHELL(obj)               (G_TYPE_CHECK_INSTANCE_TYPE((obj), GIRAM_TYPE_VIEW_SHELL))
#define GIRAM_IS_VIEW_SHELL_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE((klass), GIRAM_TYPE_VIEW_SHELL))
#define GIRAM_VIEW_SHELL_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS((obj), GIRAM_TYPE_VIEW_SHELL, GiramViewShellClass))


typedef struct _GiramViewShell      GiramViewShell;
typedef struct _GiramViewShellClass GiramViewShellClass;

struct _GiramViewShell
{
  GtkWindow  window;

  GtkWidget *vbox;
  GtkWidget *statusbar;
  GList     *all_views;
};
 
struct _GiramViewShellClass
{
  GtkWindowClass parent_class;

};

GType      giram_view_shell_get_type(void) G_GNUC_CONST;

GtkWidget *giram_view_shell_new(void);
void       giram_view_shell_add_view(GiramViewShell *shell, ViewStruct *view_data);

G_END_DECLS

#endif /* __GIRAM_VIEW_SHELL_H__ */
