/* giramviewshell.c
 *
 * Giram, a GPLed 3D modeller.
 * Copyright (C) 2002 DindinX <David@dindinx.org>
 *     
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "giram.h"
#include "view.h"

#include "giramviewshell.h"

#include "giramintl.h"

static void     giram_view_shell_class_init (GiramViewShellClass *klass);
static void     giram_view_shell_init       (GiramViewShell      *paned);
static gboolean giram_view_shell_delete_callback(GiramViewShell *shell);

static GtkWindowClass *parent_class = NULL;

/*************************************************************************
*  giram_view_shell_get_type
**************************************************************************/
GType giram_view_shell_get_type(void)
{
  static GType giram_view_shell_type = 0;

  if (!giram_view_shell_type)
  {
    static const GTypeInfo giram_view_shell_info =
    {
      sizeof(GiramViewShellClass),
      NULL,  /* base_init */
      NULL,  /* base_finalize */
      (GClassInitFunc)giram_view_shell_class_init,
      NULL,  /* class_finalize */
      NULL,  /* class_data */
      sizeof(GiramViewShell),
      0,     /* n_preallocs */
      (GInstanceInitFunc)giram_view_shell_init,
    };

    giram_view_shell_type = g_type_register_static(GTK_TYPE_WINDOW,
                                                   "GiramViewShell",
                                                   &giram_view_shell_info, 0);
  }

  return giram_view_shell_type;
}

/*************************************************************************
*  giram_view_shell_class_init
**************************************************************************/
static void giram_view_shell_class_init(GiramViewShellClass *class)
{
  parent_class = g_type_class_peek_parent(class);
}

/*************************************************************************
*  giram_view_shell_delete_callback
**************************************************************************/
static gboolean giram_view_shell_delete_callback(GiramViewShell *shell)
{
  GList *tmp_list;
  g_print("The deletion of an XYZ view has been catched!\n");
  for (tmp_list = shell->all_views ; tmp_list ; tmp_list=tmp_list->next)
  {
    ViewStruct *view_data = tmp_list->data;
    view_data->frame->all_views = g_slist_remove(view_data->frame->all_views, view_data);
    g_free(view_data);
  }
  return FALSE;
}

/*************************************************************************
*  giram_view_shell_init
**************************************************************************/
static void giram_view_shell_init(GiramViewShell *shell)
{
  gint contextid;

  gtk_window_set_wmclass(GTK_WINDOW(shell), "view_shell", "Giram");
  g_signal_connect(G_OBJECT(shell), "delete_event",
                   G_CALLBACK(giram_view_shell_delete_callback), NULL);
      
  shell->vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(shell), shell->vbox);
  gtk_widget_show(shell->vbox);

  shell->statusbar = gtk_statusbar_new();
  gtk_widget_set_size_request(shell->statusbar, 1, -1);
  gtk_container_set_resize_mode(GTK_CONTAINER(shell->statusbar),
                                GTK_RESIZE_QUEUE);
  contextid = gtk_statusbar_get_context_id(GTK_STATUSBAR(shell->statusbar),
                                           "title");
  gtk_statusbar_push(GTK_STATUSBAR(shell->statusbar), contextid, "");
  gtk_box_pack_end(GTK_BOX(shell->vbox), shell->statusbar, FALSE, TRUE, 0);
  gtk_widget_show(shell->statusbar);

  shell->all_views = NULL;
}

/*************************************************************************
*  giram_view_shell_new
**************************************************************************/
GtkWidget *giram_view_shell_new(void)
{
  return g_object_new(GIRAM_TYPE_VIEW_SHELL, NULL);
}

/*************************************************************************
*  giram_view_shell_add_view
**************************************************************************/
void giram_view_shell_add_view(GiramViewShell *shell, ViewStruct *view_data)
{
  view_data->shell = GTK_WIDGET(shell);
  shell->all_views = g_list_append(shell->all_views, view_data);
}

