/* Giram: a simple 3D modeller
 * Copyright (C) 2001-2002 DindinX <David@dindinx.org>
 *
 * giramvectorframe.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>

#undef GTK_DISABLE_DEPRECATED
#warning GTK_DISABLE_DEPRECATED
#include <gtk/gtk.h>

#include "giramvectorframe.h"

enum
{
  VECTOR_CHANGED,
  LAST_SIGNAL
};

static guint giram_vector_frame_signals[LAST_SIGNAL] = { 0 };


static GtkFrameClass *parent_class = NULL;

static void giram_vector_frame_class_init(GiramVectorFrameClass *class)
{
  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;

  object_class = (GtkObjectClass*) class;
  widget_class = (GtkWidgetClass*) class;

  parent_class = gtk_type_class(gtk_frame_get_type());

  giram_vector_frame_signals[VECTOR_CHANGED] =
                         g_signal_new("vector_changed",
                                      G_TYPE_FROM_CLASS(class),
                                      G_SIGNAL_RUN_FIRST,
                                      G_STRUCT_OFFSET(GiramVectorFrameClass, vector_changed),
                                      NULL, NULL,
                                      gtk_signal_default_marshaller, GTK_TYPE_NONE, 0);
//  gtk_object_class_add_signals(object_class, giram_vector_frame_signals, LAST_SIGNAL);
  class->vector_changed = NULL;
                            
/*  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;

  object_class = (GtkObjectClass *)class;
  widget_class = (GtkWidgetClass *)class;
*/
  parent_class = gtk_type_class(gtk_frame_get_type());
/*
  object_class->destroy = giram_pixmap_destroy;
  widget_class->realize = giram_pixmap_realize;*/
}

static void giram_vector_frame_init(GiramVectorFrame *vf)
{
  GtkWidget *vbox, *hbox, *label;

  vbox = gtk_vbox_new(TRUE, 4);
  gtk_container_add(GTK_CONTAINER(vf), vbox);
  gtk_widget_show(vbox);

  /* X */
  hbox = gtk_hbox_new(FALSE, 4);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 2);
  gtk_widget_show(hbox);
  label = gtk_label_new("x:");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
  gtk_widget_show(label);
  vf->entry_x = gtk_entry_new();
  gtk_box_pack_start(GTK_BOX(hbox), vf->entry_x, FALSE, FALSE, 2);
  gtk_widget_show(vf->entry_x);

  /* Y */
  hbox = gtk_hbox_new(FALSE, 4);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 2);
  gtk_widget_show(hbox);
  label = gtk_label_new("y:");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
  gtk_widget_show(label);
  vf->entry_y = gtk_entry_new();
  gtk_box_pack_start(GTK_BOX(hbox), vf->entry_y, FALSE, FALSE, 2);
  gtk_widget_show(vf->entry_y);

  /* Z */
  hbox = gtk_hbox_new(FALSE, 4);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 2);
  gtk_widget_show(hbox);
  label = gtk_label_new("z:");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
  gtk_widget_show(label);
  vf->entry_z = gtk_entry_new();
  gtk_box_pack_start(GTK_BOX(hbox), vf->entry_z, FALSE, FALSE, 2);
  gtk_widget_show(vf->entry_z);
}

GtkType giram_vector_frame_get_type(void)
{
  static guint vector_frame_type = 0;

  if (!vector_frame_type)
  {
    GtkTypeInfo vector_frame_info =
    {
      "GiramVectorFrame",
      sizeof(GiramVectorFrame),
      sizeof(GiramVectorFrameClass),
      (GtkClassInitFunc)giram_vector_frame_class_init,
      (GtkObjectInitFunc)giram_vector_frame_init,
      /* reserved_1 */NULL,
      /* reserved_2 */NULL,
      (GtkClassInitFunc)NULL
    };

    vector_frame_type = gtk_type_unique(gtk_frame_get_type(), &vector_frame_info);
  }

  return vector_frame_type;
}

/*************************************************************************
 * giram_vector_frame_new:
 *
 * Creates a new #GiramVectorFrame widget.
 *
 * Returns: A pointer to the new #GiramVectorFrame widget.
 *************************************************************************/
GtkWidget *giram_vector_frame_new(const gchar *label)
{
  GiramVectorFrame *vf;

  vf = gtk_type_new(giram_vector_frame_get_type());

  gtk_frame_set_label(GTK_FRAME(vf), label);
  return GTK_WIDGET(vf);
}

void giram_vector_frame_get_value(GiramVectorFrame *vf, Vector vector)
{
  vector[0] = strtod(gtk_entry_get_text(GTK_ENTRY(vf->entry_x)), NULL);
  vector[1] = strtod(gtk_entry_get_text(GTK_ENTRY(vf->entry_y)), NULL);
  vector[2] = strtod(gtk_entry_get_text(GTK_ENTRY(vf->entry_z)), NULL);
}

void giram_vector_frame_set_value(GiramVectorFrame *vf, Vector vector)
{
  gchar *tmp;

  tmp = g_strdup_printf("%g", vector[0]);
  gtk_entry_set_text(GTK_ENTRY(vf->entry_x), tmp);
  g_free(tmp);
  tmp = g_strdup_printf("%g", vector[1]);
  gtk_entry_set_text(GTK_ENTRY(vf->entry_y), tmp);
  g_free(tmp);
  tmp = g_strdup_printf("%g", vector[2]);
  gtk_entry_set_text(GTK_ENTRY(vf->entry_z), tmp);
  g_free(tmp);
}
