/* Giram: a simple 3D modeller
 * Copyright (C) 2001 DindinX <David@dindinx.org>
 *  
 * LIBGIMP - The GIMP Library
 * Copyright (C) 1995-1997 Peter Mattis and Spencer Kimball
 *
 * girampixmap.h
 * Copyright (C) 2000 Michael Natterer <mitch@gimp.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GIRAM_PIXMAP_H__
#define __GIRAM_PIXMAP_H__

#undef GTK_DISABLE_DEPRECATED
#warning GTK_DISABLE_DEPRECATED

#include <gtk/gtkpixmap.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* For information look into the C source or the html documentation */

#define GIRAM_TYPE_PIXMAP            (giram_pixmap_get_type())
#define GIRAM_PIXMAP(obj)            (GTK_CHECK_CAST((obj), GIRAM_TYPE_PIXMAP, GiramPixmap))
#define GIRAM_PIXMAP_CLASS(klass)    (GTK_CHECK_CLASS_CAST((klass), GIRAM_TYPE_PIXMAP, GiramPixmapClass))
#define GIRAM_IS_PIXMAP(obj)         (GTK_CHECK_TYPE ((obj), GIRAM_TYPE_PIXMAP))
#define GIRAM_IS_PIXMAP_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GIRAM_TYPE_PIXMAP))

typedef struct _GiramPixmap       GiramPixmap;
typedef struct _GiramPixmapClass  GiramPixmapClass;

struct _GiramPixmap
{
  GtkPixmap   pixmap;

  gchar **xpm_data;
};

struct _GiramPixmapClass
{
  GtkPixmapClass parent_class;
};

GtkType     giram_pixmap_get_type(void);
GtkWidget * giram_pixmap_new(gchar **xpm_data);

void giram_pixmap_set(GiramPixmap  *pixmap,
                      gchar       **xpm_data);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GIRAM_PIXMAP_H__ */

