/* Giram: a simple 3D modeller
 * Copyright (C) 2001 DindinX <David@dindinx.org>
 *
 * giramcolorlist.h
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GIRAM_COLOR_LIST_H__
#define __GIRAM_COLOR_LIST_H__

#include <gtk/gtkwindow.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GIRAM_TYPE_COLOR_LIST            (giram_color_list_get_type())
#define GIRAM_COLOR_LIST(obj)            (GTK_CHECK_CAST((obj), GIRAM_TYPE_COLOR_LIST, GiramColorList))
#define GIRAM_COLOR_LIST_CLASS(klass)    (GTK_CHECK_CLASS_CAST((klass), GIRAM_TYPE_COLOR_LIST, GiramColorListClass))
#define GIRAM_IS_COLOR_LIST(obj)         (GTK_CHECK_TYPE(obj, GIRAM_TYPE_COLOR_LIST))
#define GIRAM_IS_COLOR_LIST_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GIRAM_TYPE_COLOR_LIST))

typedef struct _GiramColorList       GiramColorList;
typedef struct _GiramColorListClass  GiramColorListClass;

struct _GiramColorList
{
  GtkWindow   gtk_window;

  GtkWidget  *color_sel;
  GHashTable *hash;
  GtkWidget  *clist;
  GtkWidget  *new_button;
  GtkWidget  *duplicate_button;
  GtkWidget  *edit_button;
  GtkWidget  *delete_button;
  GtkWidget  *refresh_button;
};

struct _GiramColorListClass
{
  GtkWindowClass parent_class;

  void (* color_changed)(GiramColorList *gcl, gdouble *color);
};

GtkType giram_color_list_get_type(void);

GtkWidget *giram_color_list_new(GHashTable *hash);

void giram_color_list_set_color(GiramColorList *gcl,
                                gdouble *color);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GIRAM_COLOR_LIST_H__ */
