/* tool_zoom.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "giram.h"
#include "view.h"
#include "giramcursor.h"


#include "pixmaps/zoom.xpm"

#include "tool_zoom.h"

#include "giramintl.h"

/*****************************************************************************
*  tool_zoom_button_press
******************************************************************************/
static void tool_zoom_button_press(GtkWidget *DrawingArea, GdkEventButton *bevent)
{
  if (bevent->state & 1)
    ZoomOut();
  else
    ZoomIn();
}

/****************************************************************************
*  tool_zoom_cursor_update
*****************************************************************************/
static void tool_zoom_cursor_update(GtkWidget *canvas, guint state)
{
  GdkCursor *cursor;

  if (state & GDK_SHIFT_MASK)
  {
    cursor = giram_cursor_new(GIRAM_ZOOM_CURSOR,
                              GIRAM_TOOL_CURSOR_NONE,
                              GIRAM_CURSOR_MODIFIER_MINUS);
  } else
  {
    cursor = giram_cursor_new(GIRAM_ZOOM_CURSOR,
                              GIRAM_TOOL_CURSOR_NONE,
                              GIRAM_CURSOR_MODIFIER_PLUS);
  }
  gdk_window_set_cursor(canvas->window, cursor);
  gdk_cursor_unref(cursor);
}

/****************************************************************************
*  giram_tool_zoom_register
*****************************************************************************/
GiramTool *giram_tool_zoom_register(void)
{
  GiramTool *tool;

  tool = g_new(GiramTool, 1);
  tool->ToolTip        = _("Zoom");
  tool->Icon           = zoom_icon;
  tool->Path           = "<ToolBar>";
  tool->ID             = MT_ZOOM;
  tool->OptionsFunc    = NULL;
  tool->button_press   = tool_zoom_button_press;
  tool->motion         = NULL;
  tool->button_release = NULL;
  tool->cursor_update  = tool_zoom_cursor_update;

  return tool;
}

