/* tool_triangle.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "giram.h"
#include "giramcursor.h"
#include "tool_triangle.h"

#include "pixmaps/triangle.xpm"

#include "giramintl.h"

/*****************************************************************************
*  tool_triangle_button_press FIXME
******************************************************************************/
static void tool_triangle_button_press(GtkWidget *DrawingArea, GdkEventButton *bevent)
{
  g_message(_("Sorry, the New Triangle function\n"
              "hasn't been implemented yet"));
}

/****************************************************************************
*  tool_triangle_cursor_update
 * *****************************************************************************/
static void tool_triangle_cursor_update(GtkWidget *canvas, guint state)
{
  GdkCursor *cursor;

  cursor = giram_cursor_new(GIRAM_MOUSE_CURSOR,
                            GIRAM_TOOL_CURSOR_NONE,
                            GIRAM_CURSOR_MODIFIER_NONE);
  gdk_window_set_cursor(canvas->window, cursor);
  gdk_cursor_unref(cursor);
}

/****************************************************************************
*  giram_tool_triangle_register
*****************************************************************************/
GiramTool *giram_tool_triangle_register(void)
{
  GiramTool *tool;

  tool = g_new(GiramTool, 1);
  tool->ToolTip        = _("New Triangle");
  tool->Icon           = triangle_icon;
  tool->Path           = "<ToolBar/Shape2D>";
  tool->ID             = MT_NEW_TRIANGLE;
  tool->OptionsFunc    = NULL;
  tool->button_press   = tool_triangle_button_press;
  tool->motion         = NULL;
  tool->button_release = NULL;
  tool->cursor_update  = tool_triangle_cursor_update;

  return tool;
}

