/* tool_plane.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "giram.h"
#include "primitives/plane.h"
#include "csgtree.h"
#include "utils.h"
#include "giramcursor.h"

#include "pixmaps/plane.xpm"

#include "tool_plane.h"

#include "giramintl.h"

/*****************************************************************************
*  tool_plane_button_press
******************************************************************************/
static void tool_plane_button_press(GtkWidget *canvas, GdkEventButton *bevent)
{
  ObjectStruct *Plane;
  Vector        Normal;
  ViewStruct   *view_data;
  GSList       *tmp_list;
  ViewStruct   *TmpView;

  view_data = get_current_view_data();
  switch (view_data->camera_style)
  {
    case ORTHO_XY_CAMERA:
      V3Deq(Normal, 0.0, 0.0, 1.0);
      break;

    case ORTHO_XZ_CAMERA:
      V3Deq(Normal, 0.0, 1.0, 0.0);
      break;

    case ORTHO_ZY_CAMERA:
      V3Deq(Normal, 1.0, 0.0, 0.0);
      break;
  }
  Plane = giram_plane_new(Normal, 0.0);
  Plane->name = create_uniq_object_name(view_data->frame, _("plane"));
  view_data->frame->all_objects = g_slist_append(view_data->frame->all_objects,
                                                 Plane);
  Plane->frame = view_data->frame;
  giram_object_build_triangle_mesh(Plane);
  for (tmp_list = view_data->frame->all_views ;
       tmp_list ;
       tmp_list = tmp_list->next)
  {
    TmpView = tmp_list->data;
    gtk_widget_queue_draw(TmpView->canvas);
  }
  giram_create_tree_model(view_data->frame);
}

/****************************************************************************
*  tool_plane_cursor_update
*****************************************************************************/
static void tool_plane_cursor_update(GtkWidget *canvas, guint state)
{
  GdkCursor *cursor;

  cursor = giram_cursor_new(GIRAM_MOUSE_CURSOR,
                            GIRAM_TOOL_CURSOR_NONE,
                            GIRAM_CURSOR_MODIFIER_NONE);
  gdk_window_set_cursor(canvas->window, cursor);
  gdk_cursor_unref(cursor);
}

/****************************************************************************
*  giram_tool_plane_register
*****************************************************************************/
GiramTool *giram_tool_plane_register(void)
{
  GiramTool *tool;

  tool = g_new(GiramTool, 1);
  tool->ToolTip        = _("New Plane");
  tool->Icon           = plane_icon;
  tool->Path           = "<ToolBar/Shape2D>";
  tool->ID             = MT_NEW_PLANE;
  tool->OptionsFunc    = NULL;
  tool->button_press   = tool_plane_button_press;
  tool->motion         = NULL;
  tool->button_release = NULL;
  tool->cursor_update  = tool_plane_cursor_update;

  return tool;
}

