/* quadric.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "giram.h"
//#include "trimesh.h"

#include "quadric.h"

//static void giram_quadric_build_triangle_mesh(ObjectStruct *heightfield);
static gboolean giram_quadric_inside(ObjectStruct *heightfield, double x, double y, double z);
static gboolean giram_quadric_is_intersection(ObjectStruct *heightfield, Vector org, Vector dir);
static gboolean giram_quadric_find_intersection_segment(ObjectStruct *heightfield,
                                                        Vector in_point, Vector out_point,
                                                        Vector inter_point, Vector inter_norm);
static gboolean giram_quadric_find_intersection(ObjectStruct *heightfield,
                                                Vector        origin,
                                                Vector        direction,
                                                Vector        intersection,
                                                Vector        normal);

/*************************************************************************
*  giram_quadric_inside
**************************************************************************/
static gboolean giram_quadric_inside(ObjectStruct *quadric, double x, double y, double z)
{
  return FALSE;
}

/*************************************************************************
*  giram_quadric_is_intersection
**************************************************************************/
static gboolean giram_quadric_is_intersection(ObjectStruct *quadric, Vector org, Vector dir)
{
  return FALSE;
}

/*************************************************************************
*  giram_quadric_find_intersection_segment
**************************************************************************/
static gboolean giram_quadric_find_intersection_segment(ObjectStruct *quadric,
                                                        Vector in_point, Vector out_point,
                                                        Vector inter_point, Vector inter_norm)
{
  return FALSE;
}

/*************************************************************************
*  giram_quadric_find_intersection
**************************************************************************/
static gboolean giram_quadric_find_intersection(ObjectStruct *quadric,
                                                Vector        origin,
                                                Vector        direction,
                                                Vector        intersection,
                                                Vector        normal)
{
  return FALSE;
}

/*****************************************************************************
*  giram_quadric_new
******************************************************************************/
ObjectStruct *giram_quadric_new(gdouble A, gdouble B, gdouble C,
                                gdouble D, gdouble E, gdouble F,
                                gdouble G, gdouble H, gdouble I,
                                gdouble J)
{
  ObjectStruct *quadric;
  QuadricStruct *qquadric;
  static GiramObjectClass *quadric_klass = NULL;

  if (quadric_klass == NULL)
  {
    quadric_klass = giram_object_class_new();

    quadric_klass->name                      = "quadric";
    //quadric_klass->build_triangle_mesh       = giram_quadric_build_triangle_mesh;
    quadric_klass->inside                    = giram_quadric_inside;
    quadric_klass->is_intersection           = giram_quadric_is_intersection;
    quadric_klass->find_intersection_segment = giram_quadric_find_intersection_segment;
    quadric_klass->find_intersection         = giram_quadric_find_intersection;
  }
  qquadric = g_new(QuadricStruct, 1);
  quadric = (ObjectStruct *)qquadric;
  InitObject(quadric);
  quadric->Type = QUADRIC_OBJECT;
  quadric->klass = quadric_klass;

  qquadric->A = A; qquadric->B = B; qquadric->C = C;
  qquadric->D = D; qquadric->E = E; qquadric->F = F;
  qquadric->G = G; qquadric->H = H; qquadric->I = I;
  qquadric->J = J;

  return quadric;
}

