/* help_dialog.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2003 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include "giram.h"
#include "help_dialog.h"

#include "widgets/giramwidgets.h"

#include "giramintl.h"

/*****************************************************************************
*  ShowHelpDialog
******************************************************************************/
void ShowHelpDialog(void)
{
  static GtkWidget *HelpDialog = NULL;
  GtkWidget        *scr, *text;
  GtkTextBuffer    *text_buffer;
  FILE             *HelpFile;

  if (HelpDialog)
  {
    gtk_window_present(GTK_WINDOW(HelpDialog));
    return;
  }

  HelpDialog = giram_dialog_new(_("Help Giram"), "giram_dialog",
                                NULL /* FIXME */,
                                "dialogs/help.html",
                                GTK_WIN_POS_NONE,
                                TRUE, TRUE, FALSE,

                                _("Close"), gtk_widget_destroy,
                                NULL, 1, NULL, TRUE, TRUE,
                                NULL);
  gtk_widget_set_size_request(HelpDialog, 500, 500);

  g_signal_connect(G_OBJECT(HelpDialog), "destroy",
                   G_CALLBACK(gtk_widget_destroyed), &HelpDialog);

  /* The Scrolled window */
  scr = gtk_scrolled_window_new(NULL, NULL);
  gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(HelpDialog)->vbox),
                              scr);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scr),
                                 GTK_POLICY_AUTOMATIC,
                                 GTK_POLICY_AUTOMATIC);
  /* The text widget */
  text = gtk_text_view_new();
  gtk_text_view_set_editable(GTK_TEXT_VIEW(text), FALSE);
  gtk_container_add(GTK_CONTAINER(scr), text);
  gtk_widget_grab_focus(text);

  text_buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));

  HelpFile = fopen(HELPFILE, "r");
  if (HelpFile)
  {
    char *buffer;
    int nbytes_read, nbytes_alloc;

    nbytes_read = 0;
    nbytes_alloc = 1024;
    buffer = g_new(char, nbytes_alloc);
    while (1)
    {
      int len;

      if (nbytes_alloc < nbytes_read+1024)
      {
        nbytes_alloc *= 2;
        buffer = g_realloc(buffer, nbytes_alloc);
      }
      len = fread(buffer+nbytes_read, 1, 1024, HelpFile);
      nbytes_read += len;
      if (len < 1024)
        break;
    }
    gtk_text_buffer_insert_at_cursor(text_buffer, buffer, -1);
    g_free(buffer);
    fclose (HelpFile);
  } else
  {
    char *buffer = "The help file was not found\n\n"
                   "Please do a 'make install' from the Giram directory\n";
    gtk_text_buffer_insert_at_cursor(text_buffer, buffer, -1);
  }
  gtk_widget_show_all(HelpDialog);
}

