/* Giram: a simple 3D modeller
 * Copyright (C) 2001 DindinX <David@dindinx.org>
 *
 * LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2000 Peter Mattis and Spencer Kimball
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GIRAM_SIGNAL_H__
#define __GIRAM_SIGNAL_H__

#include <signal.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* For information look into the C source or the html documentation */

/* A giram-level interface to a Posix.1-compliant signal package lives here
 * This giram-level interface mostly passes through to posix calls
 * without modification. Certain calls manipulate struct sigaction in
 * ways useful to Giram.
 */

/* GiramSignalHandlerFunc is a reference to a (signal handler) function
 * that takes a signal ID and returns void.
 * signal(2) returns such references; so does giram_signal_private.
 */
typedef void (* GiramSignalHandlerFunc)(gint signum);

/* Internal implementation that can be DEFINEd into various flavors of
 * signal(2) lookalikes.
 */
GiramSignalHandlerFunc giram_signal_private(gint                   signum,
                                            GiramSignalHandlerFunc handler,
                                            gint                   flags);

/* the giram_signal_syscallrestart() lookalike looks like signal(2) but
 * quietly requests the restarting of system calls. Addresses #2742
 */
#define giram_signal_syscallrestart(signum,handler) giram_signal_private((signum), (handler), SA_RESTART)

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GIRAM_SIGNAL_H__ */

