/* Giram: a simple 3D modeller
 * Copyright (C) 2001 DindinX <David@dindinx.org>
 *
 * giramcursor.h
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GIRAM_CURSOR_H__
#define __GIRAM_CURSOR_H__

typedef enum
{
  GIRAM_MOUSE_CURSOR = (GDK_LAST_CURSOR + 2),
  GIRAM_ZOOM_CURSOR,
  GIRAM_LAST_CURSOR_ENTRY
} GiramCursorType;

typedef enum
{
  GIRAM_TOOL_CURSOR_NONE,
  GIRAM_ZOOM_TOOL_CURSOR,
  GIRAM_LAST_STOCK_TOOL_CURSOR_ENTRY
} GiramToolCursorType;

typedef enum
{
  GIRAM_CURSOR_MODIFIER_NONE,
  GIRAM_CURSOR_MODIFIER_PLUS,
  GIRAM_CURSOR_MODIFIER_MINUS,
  GIRAM_LAST_CURSOR_MODIFIER_ENTRY
} GiramCursorModifier;

GdkCursor *giram_cursor_new(GiramCursorType      curtype,
                            GiramToolCursorType  tool_cursor,
                            GiramCursorModifier  modifier);

#endif /*  __GIRAM_CURSOR_H__  */

