/* s3d_write.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 * Copyright (C) 1999 Noah Davis of VIEWS Net, Inc. <noah@viewsnet.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * This file is from Joseph Turian.
 * Based on dxf_write.c by Noah Davis.
 */

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include "giram.h"
#ifdef WITH_S3D
#include "object.h"
#include "csgtree.h"
#include "view.h"
#include "camera.h"
#include "frame.h"

#include "s3d.h"

/* Dumps out Giram triangle data in an ASCII (for now) S3D file */
int s3d_save_file(FrameStruct *frame, char *fname, int binary, int SelectedOnly)
{
  FILE         *fp;
  ObjectStruct *iterObject;
  GSList       *tmp_list;
  GList        *selection;

  if (binary)
  {
    fprintf (stderr, "S3D_SAVE: Binary writes not implemented yet.\n");
    return 1;
  }

  if (SelectedOnly)
  {
    if (frame->selection == NULL)
    {
      fprintf(stderr, "S3D_SAVE: Nothing to write!\n");
      return 1;
    }
  } else
  {
    if (frame->all_objects == NULL)
    {
      fprintf(stderr, "S3D_SAVE: Nothing to write!\n");
      return 1;
    }
  }
  fp = fopen(fname,"w");

  if (fp == NULL)
  {
    fprintf(stderr, "S3D_SAVE: Couldn't open %s for writing.\n", fname);
    return 1;
  }

  /* Okay, we have an open file, and at least one thing to write to it.
   * Lets start dumping...
   */

  if (SelectedOnly)
  {
    for (selection = frame->selection ;
         selection ;
         selection = g_list_next(selection) )
    {
      iterObject = selection->data;
      if (!s3d_write_object(fp, iterObject))
      {
        fclose(fp);
        return 1;
      }
    }
  } else
  {
    for (tmp_list = frame->all_objects ;
         tmp_list ;
         tmp_list = g_slist_next(tmp_list))
    {
      iterObject = tmp_list->data;
      if (!s3d_write_object(fp, iterObject))
      {
        fclose(fp);
        return 1;
      }
    }
  }

  fclose (fp);
  return 1;
}

int s3d_write_object(FILE *fp, ObjectStruct *obj)
{
  TriangleListStruct *tri;

  if ((tri=obj->FirstTriangle) == NULL)
    return TRUE;   /* Nothing to write */

  for ( ; tri ; tri=tri->Next)
  {
    fprintf(fp, "{TYPE = POLY; POINTS = (%f, %f, %f), (%f, %f, %f), (%f, %f, %f);}\n",
      tri->P1[0], tri->P1[1], tri->P1[2], tri->P2[0], tri->P2[1],
      tri->P2[2], tri->P3[0], tri->P3[1], tri->P3[2]);
  }
  return TRUE;
}

/*****************************************************************************
*  SaveS3D
******************************************************************************/
void SaveS3D(GtkWidget *w, GtkFileSelection *FS)
{
  FrameStruct *LocalFrame;
  char        *FileName;

  FileName = gtk_file_selection_get_filename(GTK_FILE_SELECTION(FS));
  LocalFrame = g_object_get_data(G_OBJECT(FS), "frame");
  s3d_save_file(LocalFrame, FileName, 0, FALSE);
}

/*****************************************************************************
*  SaveSelectedS3D
******************************************************************************/
void SaveSelectedS3D(GtkWidget *w, GtkFileSelection *FS)
{
  FrameStruct *LocalFrame;
  char        *FileName;

  FileName = gtk_file_selection_get_filename(GTK_FILE_SELECTION(FS));
  LocalFrame = g_object_get_data(G_OBJECT(FS), "frame");
  s3d_save_file(LocalFrame, FileName, 0, TRUE);
}
#endif
