/* s3d.h
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2001 DindinX <David@dindinx.org>
 * Copyright (C) 1999 Noah Davis of VIEWS Net, Inc. <noah@viewsnet.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * This file is from Joseph Turian.
 * Based on dxf.h by Noah Davis.
 */

#ifndef __S3D_H__
#define __S3D_H__

/*      s3d_write.c           */
#ifdef WITH_S3D
int s3d_save_file(FrameStruct *frame, char *fname, int binary, int SelectedOnly);
int s3d_write_header(FILE *fp, int bin);
int s3d_write_object(FILE *fp, ObjectStruct *obj);
int s3d_write_end(FILE *fp, int bin);

#ifndef S3D_STANDALONE
void SaveS3D(GtkWidget *w, GtkFileSelection *FS);
void SaveSelectedS3D(GtkWidget *w, GtkFileSelection *FS);
#endif
#endif

#endif /* __S3D_H__ */
