/* LoadPov.h 
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __LOAD_POV_H__
#define __LOAD_POV_H__

#include <stdio.h>

/* The Tokens */
typedef enum TOKEN_IDS
{
  Tabs = 0,
  Tatan,
  Tatan2,
  Tceil,
  Tclock_on,
  Tclock,
  Tcos,
  Tdegrees,
  Tdiv,
  Texp,
  TFloatID,
  TFloatLiteral,
  Tfloor,
  Tfinalclock,
  Tfinalframe,
  Tframenumber,
  Timage_width,
  Timage_height,
  Tinitialframe,
  Tinitialclock,
  Tinside,
  Tint,
  Tln,
  Tlog,
  Tmax,
  Tmin,
  Tmod,
  Tpi,
  Tpow,
  Tradians,
  Tselect,
  Tsin,
  Tsqrt,
  Tvdot,
  Tvlength,
  Tversion,
  Ton,
  Toff,
  Ttrue,
  Tfalse,
  Tyes,
  Tno,
  Tacos,
  Tasin,
  Ttan,
  Tasc,
  Tstrlen,
  Tval,
  Tfile_exists,
  Tstrcmp,
  Tseed,
  Trand,
  Tclock_delta,
  Tdimensions,
  Tdimension_size,
  Tdefined,
  Tcosh,
  Tsinh,
  Ttanh,
  Tatanh,
  Tacosh,
  Tasinh,
  Tsum,
  Tprod,
  Tfloat_funct,
  /* WARNING:
   * All new functions returning a float value must be placed before FLOAT_FUNCT_TOKEN or the parser won't work right.*/
  Tvaxis_rotate,
  Tvcross,
  TVectorID,
  Tvnormalize,
  Tvrotate,
  Tvturbulence,
  Tx,
  Ty,
  Tz,
  Ttrace,
  Tmin_extent,
  Tmax_extent,
  Tvector_funct,
  /* WARNING:
   * All new functions returning a vector value must be placed before VECTOR_FUNCT_TOKEN or the parser won't work right. */
  Talpha,
  Tblue,
  Tfilter,
  Ttransmit,
  Tgray,
  Tgreen,
  Tred,
  Trgbf,
  Trgbft,
  Trgbt,
  Trgb,
  Tcolour_key,
  /* WARNING:
   * All new keywords which may preceed a COLOUR must be placed  before COLOUR_KEY_TOKEN or the parser won't work right. */
  Tcolor,
  Tcolour,
  TColorID, /*Note: Not 100% sure about the above tokens.  May move them up later. */
  Tcharset,
  Tascii,
  Tutf8,
  Tadaptive,
  Tagate,
  Tall,
  Taltitude,
  Tambient,
  Tampersand,
  Tarea_light,
  Tat,
  Tback_quote,
  Tback_slash,
  Tbar,
  Tbicubic_patch,
  Tblob,
  Tbounded_by,
  Tbox,
  Tbozo,
  Tbrick,
  Tbrilliance,
  Tbumps,
  Tbump_map,
  Tbump_size,
  TCameraID,
  Tcamera,
  Tcells,
  Tchecker,
  Tclipped_by,
  Tcolon,
  Tcolor_map,
  TColor_mapID,
  Tcolour_map,
  Tcomma,
  Tcomponent,
  Tcomposite,
  Tcone,
  Tcrand,
  Tcubic,
  Tcylinder,
  Tdash,
  Tdeclare,
  Tdefault,
  Tdents,
  Tdifference,
  Tdiffuse,
  Tdirection,
  Tdisc,
  Tdistance,
  Tdollar,
  TEOF,
  Tequals,
  Texclamation,
  Texponent,
  Tfalloff,
  TFinishID,
  Tfinish,
  Tflatness,
  Tfog,
  Tfrequency,
  Tfresnel,
  Tgif,
  Tgradient,
  Tgranite,
  Thash,
  That,
  Theight_field,
  Thexagon,
  TIdentifier,
  Tiff,
  Timage_map,
  Tinclude,
  Tinterpolate,
  Tintersection,
  Tinverse,
  Tior,
  Tjitter,
  Tlambda,
  Tleft_angle,
  Tleft_curly,
  Tleft_paren,
  Tleft_square,
  Tleopard,
  Tlight_source,
  Tlocation,
  Tlooks_like,
  Tlook_at,
  Tmandel,
  Tmap_type,
  Tmarble,
  Tmaterial_map,
  Tmax_intersections,
  Tmax_trace_level,
  Tmerge,
  Tmetallic,
  Tmortar,
  Tno_shadow,
  TObjectID,
  Tobject,
  Toctaves,
  Tomega,
  Tonce,
  Tonion,
  Tpercent,
  Tphase,
  Tphong_size,
  Tphong,
  TPigmentID,
  Tpigment,
  Tplane,
  Tplus,
  Tpoint_at,
  Tpoly,
  Tpot,
  Tquadric,
  Tquartic,
  Tquestion,
  Tquick_color,
  Tquick_colour,
  Tradial,
  Tradius,
  Tbrick_size,
  Treflection,
  Trefraction,
  Tright_angle,
  Tright_curly,
  Tright_paren,
  Tright_square,
  Tright,
  Tripples,
  Trotate,
  Troughness,
  Tscale,
  Tsemi_colon,
  Tsingle_quote,
  Tsky,
  Tslash,
  Tsmooth,
  Tsmooth_triangle,
  Tspecular,
  Tsphere,
  Tspotlight,
  Tspotted,
  Tstar,
  TStringLiteral,
  Tsturm,
  TTextureID,
  Ttexture,
  Tinterior_texture,
  Ttga,
  Tthreshold,
  Ttiff,
  Ttightness,
  Ttilde,
  Ttile2,
  Ttiles,
  TNormalID,
  Tnormal,
  Ttorus,
  TTransformID,
  Ttransform,
  Ttranslate,
  Ttriangle,
  Tturbulence,
  Ttype,
  Tunion,
  Tup,
  Tuse_color,
  Tuse_colour,
  Tuse_index,
  Tu_steps,
  Tv_steps,
  Twater_level,
  Twaves,
  Twood,
  Twrinkles,
  Tbackground,
  Topen,
  Tagate_turb,
  Tirid,
  Tthickness,
  Tirid_wavelength,
  Tcrackle,
  Tadc_bailout,
  Tfill_light,
  Tnumber_of_waves,
  Tfog_type,
  Tfog_alt,
  Tfog_offset,
  Ttext,
  Tttf,
  Trel_ge,
  Trel_le,
  Trel_ne,
  Taperture,
  Tblur_samples,
  Tfocal_point,
  Tquilted,
  Tcontrol0,
  Tcontrol1,
  Trainbow,
  Tskysphere,
  Tangle,
  Twidth,
  Tarc_angle,
  Tperspective,
  Torthographic,
  Tfisheye,
  Tultra_wide_angle,
  Tomnimax,
  Tpanoramic,
  Tlathe,
  Tlinear_spline,
  Tquadratic_spline,
  Tcubic_spline,
  Tbezier_spline,
  Tpolygon,
  Tprism,
  Tlinear_sweep,
  Tconic_sweep,
  Tsor,
  Tspiral1,
  Tspiral2,
  Tstrength,
  Thierarchy,
  Tramp_wave,
  Ttriangle_wave,
  Tsine_wave,
  Tscallop_wave,
  Tpigment_map,
  Tnormal_map,
  Tslope_map,
  Ttexture_map,
  TPigmentMapID,
  TNormalMapID,
  TSlopeMapID,
  TTextureMapID,
  Tsuperellipsoid,
  Tquaternion,
  Tcube,
  Tmax_iteration,
  Thypercomplex,
  TRainbowID,
  TFogID,
  TSkysphereID,
  Tfade_power,
  Tfade_colour,
  Tfade_color,
  Tfade_distance,
  Tturb_depth,
  Tppm,
  Tpgm,
  Taverage,
  Tmesh,
  Twarp,
  Toffset,
  Trepeat,
  Tblack_hole,
  Tflip,
  Tambient_light,
  Tif,
  Telse,
  Tend,
  Tswitch,
  Tcase,
  Trange,
  Twhile,
  Tbreak,
  Tfalloff_angle,
  Tcaustics,
  Tjulia_fractal,
  Tsqr,
  Treciprocal,
  Tstr,
  Tvstr,
  Tconcat,
  Tchr,
  Tsubstr,
  TStringID,
  Twarning,
  Terror,
  Trender,
  Tstatistics,
  Tdebug,
  Tvariance,
  Tconfidence,
  Tradiosity,
  Tbrightness,
  Tcount,
  Tdistance_maximum,
  Terror_bound,
  Tgray_threshold,
  Tlow_error_factor,
  Tminimum_reuse,
  Tnearest_count,
  Trecursion_limit,
  Thf_gray_16,
  Tglobal_settings,
  Teccentricity,
  Thollow,
  Tmedia_attenuation,
  Tmedia_interaction,
  Tmatrix,
  Tperiod,
  Tsys,
  Tstrupr,
  Tstrlwr,
  Tu,
  Tv,
  Tifdef,
  Tpng,
  Tprecision,
  Tslice,
  Tassumed_gamma,
  Tpwr,
  Tt,
  Tifndef,
  Tmedia, /* Media stuff. */
  TMediaID,
  TDensityID,
  Tdensity,
  Tdensity_file,
  Tratio,
  Tscattering,
  Temission,
  Tabsorption,
  Tsamples,
  Tintervals,
  Tinterior,
  TInteriorID,
  Texterior,
  Tlocal,
  Tundef,
  Tmacro,
  TMacroID,
  TTemporaryMacroID,
  TParameterID,
  Tarray,
  TArrayID,
  TEmptyArray,
  TFileID,
  Tfopen,
  Tfclose,
  Twrite,
  Tread,
  Tappend,
  Tplanar,
  Tspherical,
  Tboxed,
  Tcylindrical,
  Tcubic_wave,
  Tpoly_wave,
  Tdensity_map,
  TDensity_mapID,
  Treflection_exponent,
  Tdf3,
  Textinction,
  Tmaterial,
  TMaterialID,
  TuvID,
  TVector4DID,
  Tuv_mapping,
  Tuv_vectors,
  Tmesh2,
  Tvertex_vectors,
  Tnormal_vectors,
  Tface_indices,
  Tnormal_indices,
  Tuv_indices,
  Ttexture_list,
  Timage_pattern,
  Tuse_alpha,
  Tdouble_illuminate,
  Tinside_vector,
  Tphotons,
  Tsteps,
  Tpass_through,
  Tcollect,
  Tautostop,
  Tgather,
  Tsplit_union,
  Texpand_thresholds,
  Tspacing,
  Ttarget,
  Tparametric,
  Tprecompute,
  Tcontained_by,
  Tisosurface,
  Tmethod,
  Taccuracy,
  Tmax_gradient,
  Tmax_trace,
  Tfunction,
  Tevaluate,
  TFunctID,
  TVectFunctID,
  Tall_intersections,
  Tdispersion,
  Tdispersion_samples,
  Torient,
  Tcircular,
  Tno_image,
  Tno_reflection,
  Tlight_group,
  Tnatural_spline,
  Tb_spline,
  Ttolerance,
  Tprojected_through,
  Tparallel,
  Tsphere_sweep,
  Tspline,
  TSplineID,
  Tpattern,
  Tfacets,
  Tslope,
  Tsolid,
  Tcoords,
  Tsize,
  Tmetric,
  Tform,
  Torientation,
  Ttoroidal,
  Tdist_exp,
  Tmajor_radius,
  Tjpeg,
  Taa_threshold,
  Taa_level,
  Tload_file,
  Tsave_file,
  Talways_sample,
  Tpretrace_start,
  Tpretrace_end,
  Tmax_sample,
  Tglobal_lights,
  Tcutaway_textures,
  Tno_bump_scale,
  Tconserve_energy,
  Tpigment_pattern,
  Tinternal,
  Tnoise_generator,
  Tjulia,
  Tmagnet,
  LAST_TOKEN
#ifdef GLOBAL_PHOTONS
  GLOBAL_TOKEN,
#endif
#if 0
  TRIMMED_BY_ID_TOKEN,
  RATIONAL_TOKEN,
  FIRST_TOKEN,
  PREVIOUS_TOKEN,
  TRIMMED_BY_TOKEN,
#endif
#if 0
  BEZIER_PATCH_TOKEN,
#endif

} TOKEN_IDS;

typedef struct ListFile
{
  int              Line;
  FILE            *handle;
  char            *Name;
  struct ListFile *Prev;
  struct ListFile *Next;
} ListFile;

void LoadPov(GtkWidget *w, GtkFileSelection *fs);
void load_pov_by_name(gchar *name);

gboolean show_xy_view, show_xz_view, show_zy_view, show_camera_view;

#endif /* __LOAD_POV_H__ */
