#version 3.0
#version abs(1.0-5.0*(strlen("blabla")-vdot(<1,2,5>,<3,1,0>)))
global_settings
{
  
  assumed_gamma 2.2 
  #version 15
  ambient_light color red 1.0 green 1.5 
  #version 23
  max_intersections 5
}


camera {
   location  <0, 3,-10>
   direction <0, 0,  1>
   up        <0, 1,  0>
   right   <4/3, 0,  0>
   look_at   <0, 2, 0>
}

light_source {<10, 20, -30> color 1.0}

sky_sphere { pigment { blue 1.0} }

// Floor
plane
{
  z, 0
  pigment
  {
    color red 0.2 green 0.95 blue 1.0
  }
  finish
  {
    ambient 0.15
    diffuse 0.8
  }
}

intersection
{
  // Sphere object
  sphere
  {
    <1, 3, 0>, 3
    pigment
    {
      color red 1.0 green 0.7
    }
    finish
    {
      ambient 0.2
      diffuse 0.7
      phong 1
      phong_size 80
      brilliance 2
    }
  }

  // Sphere object
  sphere
  {
    <-1, 3, 0>, 3
    pigment
    {
      color red 1.0 green 0.7
    }
    finish
    {
      ambient 0.2
      diffuse 0.7
      phong 1
      phong_size 80
      brilliance 2
    }
  }
}

// Box object
box 
{ 
  <-4,0,-4>, <4,1,4>
  rotate -45*z
  pigment
  {
    color green 0.4 blue 1.0
  }
  finish
  {
    ambient 0.2
    diffuse 0.7
    phong 1
    phong_size 80
    brilliance 2
  }
}
