/* giramobject.h
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2000 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GIRAM_GIRAM_OBJECT_H__
#define __GIRAM_GIRAM_OBJECT_H__
int giramlib_box_create(Vector Vect1, Vector Vect2);
int giramlib_cone_create(Vector Base, double BaseRadius,
                         Vector Apex, double ApexRadius);
int giramlib_cylinder_create(Vector Base, Vector Apex, double Radius);
int giramlib_sphere_create(Vector Center, double Radius);
int giramlib_triangle_create(Vector V1, Vector V2, Vector V3);
void giramlib_object_realize(int ObjectId);
void giramlib_object_realize_all(void);
int giramlib_object_translate(int ObjectId, Vector TranslateVector);
int giramlib_object_rotate(int ObjectId, Vector RotateVector);
int giramlib_object_scale(int ObjectId, Vector ScaleVector);
#endif /* __GIRAM_GIRAM_OBJECT_H__ */
