/* giramlibprivate.h
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999 David Odin <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

typedef enum
{
  BicubicPatchType,
  BlobType,
  BoxType,
  ConeType,
  CSGType,
  CubicType,
  CylinderType,
  DiscType,
  HeightFieldType,
  JuliaFractalType,
  LatheType,
  MeshType,
  PlaneType,
  PolyType,
  PolygonType,
  PrismType,
  QuadricType,
  QuarticType,
  SorType,
  SphereType,
  SuperEllipsoidType,
  TextType,
  TorusType,
  TriangleType
} GiramObjectType; 

typedef struct GiramObject
{
  GiramObjectType Type;
  int Id;
  int Realised;
  TransformStruct *Trans;
  struct GiramObject *Next;
} GiramObject;

typedef struct GiramBicubicPatch
{
  GiramObject Object;

  int Type;
  double Flatness;
  double USteps, VSteps;
  Vector ControlPoint[4][4];
} GiramBicubicPatch;

typedef struct GiramBlob
{
  GiramObject Object;

  double Threshold;
} GiramBlob;

typedef struct GiramBox
{
  GiramObject Object;

  Vector MinCorner, MaxCorner;
} GiramBox;

typedef struct GiramCone
{
  GiramObject Object;

  Vector Base, Apex;
  double BaseRadius, ApexRadius;
} GiramCone;

typedef struct GiramCSG
{
  GiramObject Object;
} GiramCSG;

typedef struct GiramCubic
{
  GiramObject Object;

  double T[20];
} GiramCubic;

typedef struct GiramCylinder
{
  GiramObject Object;

  Vector Base, Apex;
  double Radius;
} GiramCylinder;

typedef struct GiramDisc
{
  GiramObject Object;

  Vector Center, Normal;
  double Radius, HoleRadius;
} GiramDisc;

typedef struct GiramHeightField
{
  GiramObject Object;
} GiramHeightField;

typedef struct GiramJuliaFractal
{
  GiramObject Object;
} GiramJuliaFractal;

typedef struct GiramLathe
{
  GiramObject Object;
} GiramLathe;

typedef struct GiramMesh
{
  GiramObject Object;
} GiramMesh;

typedef struct GiramPlane
{
  GiramObject Object;

  Vector Normal;
  double Distance;
} GiramPlane;

typedef struct GiramPoly
{
  GiramObject Object;
} GiramPoly;

typedef struct GiramPolygon
{
  GiramObject Object;
} GiramPolygon;

typedef struct GiramPrism
{
  GiramObject Object;
} GiramPrism;

typedef struct GiramQuadric
{
  GiramObject Object;
} GiramQuadric;

typedef struct GiramQuartic
{
  GiramObject Object;
} GiramQuartic;

typedef struct GiramSor
{
  GiramObject Object;
} GiramSor;

typedef struct GiramSphere
{
  GiramObject Object;

  Vector Center;
  double Radius;
} GiramSphere;

typedef struct GiramSuperEllipsoid
{
  GiramObject Object;

  double E, N;
} GiramSuperEllipsoid;

typedef struct GiramText
{
  GiramObject Object;
} GiramText;

typedef struct GiramTorus
{
  GiramObject Object;

  double Major, Minor;
} GiramTorus;

typedef struct GiramTriangle
{
  GiramObject Object;

  Vector P1, P2, P3;
} GiramTriangle;

int NextObjectId = 1;

GiramObject *GiramFirstObject = NULL;

