 /* The GIMP -- an image manipulation program
 * Copyright (C) 1995-1997 Spencer Kimball and Peter Mattis
 *
 * GIMP Color Manager Plug-In
 * Copyright (C) 2000, 2001  Karl Heinz Kreme <khk@khk.net>
 * Gimp 2.x Port 2004 Jordi Cantón <jordinitrox@virtual-sub.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __MAIN_H__
#define __MAIN_H__

#ifndef MAXPATHLEN
#define MAXPATHLEN (1024)
#endif

#define INPUT_PROFILE	(0)
#define OUTPUT_PROFILE  (1)
#define WS_PROFILE  (2)


typedef struct
{
  gint cm_direction;		/* input or output profile */
  guchar cm_directory[MAXPATHLEN];	/* directory for profile lookup */
  guchar cm_input_profile[MAXPATHLEN];	/* input profile name */
  guchar cm_output_profile[MAXPATHLEN];	/* output profile name */
  guchar cm_display_profile[MAXPATHLEN];	/* display profile name */
  guchar cm_work_space[MAXPATHLEN];	/* name of to work space profile */
  gint cm_rendering_intent;	/* rendering intent */
  gint cm_preview;		/* preview */
  gint cm_use_embedded;		/* use embedded profiles */
  gint cm_gamut_check;		/* perform gamut check? */

} PlugInVals;


typedef struct
{
  gint32    image_id;
} PlugInImageVals;

typedef struct
{
  gint32    drawable_id;
} PlugInDrawableVals;

typedef struct
{
  gboolean  chain_active;
  gint cm_have_embedded;
} PlugInUIVals;


/*  Default values  */

extern  PlugInVals         default_vals;
extern const PlugInImageVals    default_image_vals;
extern const PlugInDrawableVals default_drawable_vals;
extern const PlugInUIVals       default_ui_vals;


#endif /* __MAIN_H__ */
