/*******************************************************************************

  Copyright(c) 2003-2004 Aurelien Reynaud.

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  The full GNU General Public License is included in this distribution in the
  file called COPYING.

*******************************************************************************/

#include <limits.h> /*for INT_MAX */

#define MAX_PARAM_NUM 9
#define MAX_PARAM_VALUE INT_MAX
#define MAX_PARAM_SIZE 20	/* enough to hold UINT64_MAX */

/* Internal buffer size:
   Must be able to hold the longest string that can be put into the internal
   buffer, plus the trailing \0. The longest possible character is MB_CUR_MAX
   bytes long. The longest sequence is sent by the "get cursor position"
   capability: \033[%d;%dR and is always bigger
 */
#define BUFFER_SIZE (MAX_PARAM_SIZE*2+5+3)


/* Colors */
#define BLACK	0
#define RED	1
#define GREEN	2
#define YELLOW	3
#define BLUE	4
#define MAGENTA	5
#define CYAN	6
#define WHITE	7

/* cursor */
#define CURSOR_HIDE		(1 << 0)
#define CURSOR_INVISIBLE	(1 << 1)
void cursor_set_autowrap ();
void cursor_unset_autowrap ();
void cursor_set_mode (int);
void cursor_unset_mode (int);
void cursor_get_position (int *, int *);
void cursor_move (int, int);
void cursor_advance ();

/* misc */
void save_state ();
void restore_state ();

/* text */
#define MODE_BLINK		(1 << 0)
#define MODE_BOLD		(1 << 1)
#define MODE_INVISIBLE		(1 << 2)
#define MODE_REVERSE		(1 << 3)
#define MODE_UNDERLINE		(1 << 4)
#define MODE_ALTCHARSET		(1 << 5)
#define MODE_CURSORSTATUS	(1 << 6)
void text_set_mode (int);
void text_unset_mode (int);
void text_set_bgcolor (unsigned int);
void text_set_fgcolor (unsigned int);
void text_write_char (wchar_t);
void text_write_area (int, int, int, int);
void text_repeat_char (unsigned int);

/* scroll */
void scroll_up (int);
void scroll_down (int);
void scroll_change_region (int, int);

/* internal buffer */
int buffer_send_char (wchar_t);
int buffer_send_string (char*);
void buffer_get_and_reset (unsigned char **, size_t *);

/* screen caps */
extern int ignore_keypad_num;
void screen_flash ();
void screen_erase_from ();
void screen_erase ();
void screen_erase_to ();

/* line caps */
void line_erase ();
void line_erase_from ();
void line_erase_to ();

/* cell caps */
void cell_erase (unsigned int);
void cell_insert (unsigned int);
void cell_delete (unsigned int);

/* internal caps */
void internal_page_up ();
void internal_page_down ();
void internal_page_last ();

/* tab stops */
void tabstop_prev ();
void tabstop_next ();
void tabstop_set ();
void tabstop_clear_all ();
void tabstop_clear ();

/* blink */
int blink ();
