/*******************************************************************************

  Copyright(c) 2003-2004 Aurelien Reynaud.

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  The full GNU General Public License is included in this distribution in the
  file called COPYING.

*******************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "ggiterm.h"
#include "debug.h"
#include "terminal.h"
#include "history.h"
#include "lowlevel/lowlevel.h"


extern int terminal_width, terminal_height;

void cursor_set_mode (int);
void cursor_unset_mode (int);
void text_write_area (int, int, int, int);


int current_page = 0;
int ignore_keypad_num = 0;
  
  
void internal_page_up ()
{
	int page;
	
	debug (DEBUG_FUNCTION, "called with no args");
	page = current_page;
	/* before history_page_up() to prevent glitches at cursor position */
	cursor_set_mode (CURSOR_HIDE);
	current_page = history_page_up ();
	if (current_page != page) {
		text_write_area (0, 0, terminal_width, terminal_height);
		render_flush ();
	}
	if (current_page == 0) {
		cursor_unset_mode (CURSOR_HIDE);
	}
	debug (DEBUG_FUNCTION, "Leaving");
}

void internal_page_down ()
{
	int page;

	debug (DEBUG_FUNCTION, "called with no args");
	page = current_page;
	current_page = history_page_down ();
	if (current_page != page) {
		text_write_area (0, 0, terminal_width, terminal_height);
		render_flush ();
		if (current_page == 0) {
			cursor_unset_mode (CURSOR_HIDE);
		}
	}
	debug (DEBUG_FUNCTION, "Leaving");
}

void internal_page_last ()
{
	debug (DEBUG_FUNCTION, "called with no args");
	if (current_page == 0) return;
	do {
		current_page = history_page_down ();
	} while (current_page != 0);
	text_write_area (0, 0, terminal_width, terminal_height);
	render_flush ();
	debug (DEBUG_FUNCTION, "Leaving");
}
