/*******************************************************************************

  Copyright(c) 2003-2004 Aurelien Reynaud.

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  The full GNU General Public License is included in this distribution in the
  file called COPYING.

*******************************************************************************/

#include <stdio.h>

#define DEBUG_NONE	0
#define DEBUG_INIT	1
#define DEBUG_INPUT	2
#define DEBUG_OUTPUT	4
#define DEBUG_FT	8
#define DEBUG_HISTORY	16
#define DEBUG_FUNCTION	32


#define error(...) { fprintf (stderr, "%s: ", __func__);            \
                            fprintf (stderr, __VA_ARGS__);          \
                            fprintf (stderr, "\n"); }

#ifdef DEBUG
			    
#ifdef MULTIBYTE
# ifdef HAVE_ISWPRINT
#  include <wctype.h>
# else
#  define wint_t unsigned int
int iswprint (wint_t wc);
# endif
#else /* MULTIBYTE */
# include <ctype.h> /* for isprint */
#endif /* MULTIBYTE */
			    
extern int debuglevel;
# define debug(level, ...) { if (level & debuglevel) {              \
                             	fprintf (stderr, "%s: ", __func__); \
                             	fprintf (stderr, __VA_ARGS__);      \
                             	fprintf (stderr, "\n");             \
                             }}
#else /* DEBUG */
			     
# define debug(level, ...) {}
	
#endif /* DEBUG */

char* binary_to_printable (unsigned char*, int);
