/*******************************************************************************

  Copyright(c) 2003-2004 Aurelien Reynaud.

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  The full GNU General Public License is included in this distribution in the
  file called COPYING.

*******************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "ggiterm.h"
#include "debug.h"
#include "lowlevel/lowlevel.h"
#include "history.h"


extern int cursor_x, cursor_y;
extern int terminal_height;
extern int terminal_width;

void text_write_area(int, int, int, int);

#ifdef JUMP_SCROLL
void scroll_up_resync();
#endif


void screen_flash ()
{
	debug (DEBUG_FUNCTION, "called with no args");
#ifdef JUMP_SCROLL
	scroll_up_resync();
#endif
	render_flash ();
	text_write_area(0, 0,
	                terminal_width, terminal_height);
	render_flush_area(0, 0,
	                  terminal_width, terminal_height);
	debug (DEBUG_FUNCTION, "Leaving");
}

void screen_erase_from ()
{
	int i;
	
	debug (DEBUG_FUNCTION, "called with no args");
	history_erase_line_from (cursor_x, cursor_y);
	for (i=cursor_y+1; i<terminal_height; i++) {
		history_erase_line (i);
	}
	render_erase_screen_from (cursor_x, cursor_y);
	debug (DEBUG_FUNCTION, "Leaving");
}

/* Erase entire screen */
void screen_erase ()
{
	int i;
	
	debug (DEBUG_FUNCTION, "called with no args");
#ifdef JUMP_SCROLL
	scroll_up_resync();
#endif
	for (i=0; i<terminal_height; i++) {
		history_erase_line (i);
	}
	debug (DEBUG_FUNCTION, "Leaving");
}

/* Erase from beginning of screen to cursor */
void screen_erase_to ()
{
	int i;
	
	debug (DEBUG_FUNCTION, "called with no args");
#ifdef JUMP_SCROLL
	scroll_up_resync();
#endif
	for (i=0; i<cursor_y-1; i++) {
		history_erase_line (i);
	}
	history_erase_line_to (cursor_x, cursor_y);
	render_erase_screen_to (cursor_x, cursor_y);
	debug (DEBUG_FUNCTION, "Leaving");
}

void line_erase_from ()
{
	debug (DEBUG_FUNCTION, "called with no args");
	history_erase_line_from (cursor_x, cursor_y);
	render_erase_line_from (cursor_x, cursor_y);
	debug (DEBUG_FUNCTION, "Leaving");
}

void line_erase_to ()
{
	debug (DEBUG_FUNCTION, "called with no args");
	history_erase_line_to (cursor_x, cursor_y);
	render_erase_line_to (cursor_x, cursor_y);
	debug (DEBUG_FUNCTION, "Leaving");
}

/* Erase entire line containing cursor */
void line_erase ()
{
	debug (DEBUG_FUNCTION, "called with no args");
	history_erase_line (cursor_y);
	render_erase_line (cursor_y);
	debug (DEBUG_FUNCTION, "Leaving");
}

/* Insert p1 characters at current position */
void cell_insert (unsigned int p1)
{
	debug (DEBUG_FUNCTION, "called with args (p1=%d)", p1);
	history_insert_chars (cursor_x, cursor_y, p1);
	render_insert_chars (cursor_x, cursor_y, p1);
	debug (DEBUG_FUNCTION, "Leaving");
}

/* Delete p1 characters */
void cell_delete (unsigned int p1)
{
	debug (DEBUG_FUNCTION, "called with args (p1=%d)", p1);
	history_delete_chars (cursor_x, cursor_y, p1);
	render_delete_chars (cursor_x, cursor_y, p1);
	debug (DEBUG_FUNCTION, "Leaving");
}

/* Erase p1 characters, starting at current position */
void cell_erase (unsigned int p1)
{
	debug (DEBUG_FUNCTION, "called with args (p1=%d)", p1);
	history_erase_chars (cursor_x, cursor_y, p1);
	render_erase_chars (cursor_x, cursor_y, p1);
	debug (DEBUG_FUNCTION, "Leaving");
}
