/* gethost uses gethostbyname2(3) and gethostbyaddr(3) for name
   and address lookups */
/* Version 0.03 */
/* 05/Jul/2002 reed@reedmedia.net */
/* 29/Mar/2002 reed@reedmedia.net */
/* This is partially based on a program sent to me
   from Bruce Ediger on 20 Apr 2001 */

#include <errno.h>
#include <string.h>
#include <stdio.h>
#include <netdb.h>       /* gethostbyname() and related */
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>  /* AF_INET manifest constant */
#include <sys/time.h>    /* struct timeval */
#include <stdlib.h>

int resolve_it(int addrtype, int reverse, char *hostname, int time_it);

float elapsed_time(struct timeval before, struct timeval after);

int main(argc, argv)
  int argc;
  char *argv[];
{
  char *hostname = NULL;
  int addrtype = AF_INET;
  int rval = 0, time_it = 0, reverse = 0;

  if (argc == 1) {
    fprintf (stderr, "gethost: neither action flags nor hostname given.\n");
    exit(1);
  }

  while (*++argv) {
    if (*argv[0] == '-') {
      if (!strcmp(*argv, "-x")) {
        reverse = 1;
        continue;
      }
      else if (!strcmp(*argv, "-6")) {
	addrtype = AF_INET6;
        continue;
      }
      else if (!strcmp(*argv, "-t")) {
        time_it = 1;
        continue;
      }
      else {
        fprintf (stderr, "gethost: invalid action flag.\n");
        exit(1);
      }
    }

    hostname = (char *)malloc(strlen(*argv) + 1);
    if (hostname) {
      strncpy(hostname, *argv, strlen(*argv));
      hostname[strlen(*argv)] = '\0';

      if (strchr(hostname, ':')) {
         addrtype = AF_INET6;
         reverse = 1; /* assume they want a reverse lookup */
      }

      rval = resolve_it(addrtype, reverse, hostname, time_it);

      free(hostname);

      printf("\n");
      /* reset to defaults */
      addrtype = AF_INET;
      reverse = 0;
      time_it = 0;
    }
    else {
      fprintf(stderr, "No memory\n");
      exit (1);
    }
  }

  return(rval);
}


int
resolve_it(int addrtype, int reverse, char *hostname, int time_it)
{

  union {
    struct in6_addr in6;
    struct in_addr in;
  } addrbuf;
  char buf[128];
  struct hostent *h;
  int rval;
  struct timeval before, after;
  float et;

  rval = 0; /* last error is lost -- and return value reflects last lookup */

  if (reverse && 1 != inet_pton(addrtype, hostname, &addrbuf)) {
    fprintf(stderr,
            "Invalid address: \"%s\" : %s\n", hostname, strerror(errno));
    rval = 2;
  }
  else {

    if (time_it) gettimeofday(&before, NULL);

    if (reverse)
      h = gethostbyaddr(
        addrtype == AF_INET ? (char *)&addrbuf.in : (char *)&addrbuf.in6,
        addrtype == AF_INET ? sizeof(addrbuf.in) : sizeof(addrbuf.in6),
        addrtype);
    else h = gethostbyname2(hostname, addrtype);

    if (time_it) gettimeofday(&after, NULL);

    if (h) {
      int idx = 0;

      printf("Hostname: %s\n", h->h_name);
      while (h->h_aliases[idx])
        printf("Alias: %s\n", h->h_aliases[idx++]);
      switch (h->h_addrtype) {
        case AF_INET:
        case AF_INET6:
          for (idx = 0; h->h_addr_list[idx]; ++idx) {
            if (inet_ntop(addrtype, h->h_addr_list[idx], buf, sizeof(buf)))
              printf("Address: %s\n", buf);
            else { /* does this really matter? */
              fprintf(stderr,
                "inet_ntop() system error: %s\n", strerror(errno));
              rval = 4;
            }
          }
          break;
        default:
          break;
      }
    } else {
      /* not all OSes have h_errno & hstrerror() - Solaris doesn't */
       fprintf(stderr,
             "Problem looking up \"%s\": %s\n", hostname, hstrerror(h_errno));
       rval = 3;
    }

    if (time_it) {
      et = elapsed_time(before, after);
      if (reverse) fprintf(stderr, "gethostbyaddr");
      else fprintf(stderr, "gethostbyname2");
      fprintf(stderr, "() took %.3f seconds\n", et);
    }

  }

  return(rval);

}


float
elapsed_time(struct timeval before, struct timeval after)
{
	float r = -1.0;

	if (before.tv_usec > after.tv_usec)
	{
		after.tv_usec += 1000000;
		--after.tv_sec;
	}

	r = (float)(after.tv_sec - before.tv_sec)
		+ ((float)(after.tv_usec - before.tv_usec))/1000000.0;

	return r;
}

