/*
 *  $Id: a_graf_growbox.c,v 1.5 2004/09/28 20:12:31 a_bercegeay Exp $
 */

#include "gem_aesP.h"

/** shows animation an outline of a box from one set of
 *  coordinates to another. It is the complement function
 *  to mt_graf_shrinkbox().
 *
 *  @param sx x-coordinate of the starting rectangle
 *  @param sy y-coordinate of the starting rectangle
 *  @param sw width  of the starting rectangle
 *  @param sh height of the starting rectangle (where the outline will grow from).
 *  @param fx x-coordinate of the ending rectangle
 *  @param fy y-coordinate of the ending rectangle
 *  @param fw width of the ending rectangle
 *  @param fh height of the ending rectangle (where the outline will grow to).
 *  @param global_aes global AES array
 *
 *  @return 0 if an error occured or non-zero otherwise.
 *
 *  @since All AES versions.
 *
 *  @sa mt_form_dial(), mt_graf_shrinkbox()
 *
 *  It is used to provide a visual 'clue' to a user.
 *
 *  @note This function is what is called by GEM's
 *        mt_form_dial() with #FMD_GROW mode.
 *  @note There is currently no defined method of handling an error
 *        generated by this function.
 *
 */

short
mt_graf_growbox(short sx, short sy, short sw, short sh,
				short fx, short fy, short fw, short fh, short *global_aes)
{
	AES_PARAMS(73,8,1,0,0);

	aes_intin[0] = sx;
	aes_intin[1] = sy;
	aes_intin[2] = sw;
	aes_intin[3] = sh;
	aes_intin[4] = fx;
	aes_intin[5] = fy;
	aes_intin[6] = fw;
	aes_intin[7] = fh;

	AES_TRAP(aes_params);

	return aes_intout[0];
}
